/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.transform.TransformerException;
import org.apache.axis.client.Call;
import org.apache.axis.encoding.Base64;
import org.apache.axis.message.MessageElement;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.biomoby.client.AsyncClient;
import org.biomoby.client.MobyRequestEvent;
import org.biomoby.client.MobyRequestEventHandler;
import org.biomoby.shared.Central;
import org.biomoby.shared.MobyException;
import org.biomoby.shared.MobyPrefixResolver;
import org.biomoby.shared.MobyPrimaryData;
import org.biomoby.shared.MobySecondaryData;
import org.biomoby.shared.MobyService;
import org.biomoby.shared.NoSuccessException;
import org.biomoby.shared.SOAPException;
import org.biomoby.shared.data.MobyContentInstance;
import org.biomoby.shared.data.MobyDataInstance;
import org.biomoby.shared.data.MobyDataJob;
import org.biomoby.shared.data.MobyDataSecondaryInstance;
import org.biomoby.shared.data.MobyDataUtils;
import org.biomoby.w3c.addressing.EndpointReference;
import org.omg.lsae.notifications.AnalysisEvent;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class MobyRequest {
    protected MobyService mobyService = null;
    protected MobyContentInstance inputData = null;
    protected MobyContentInstance outputData = null;
    protected Central mobyCentral = null;
    protected PrefixResolver mobyPrefixResolver = null;
    protected Hashtable wsdlCache = null;
    protected String lastWsdlCacheKey = null;
    protected DocumentBuilder docBuilder = null;
    protected Service service = null;
    protected Class stringType;
    protected static boolean debug = false;
    protected PrintStream debugPS = System.err;
    protected XPathContext xpath_context;
    protected String responseString = null;
    private XPath stringEncodedXPath;
    private XPath base64EncodedXPath;
    private XPath simpleChildXPath;
    private XPath collectionChildXPath;
    private int autoID = 0;
    private Vector<MobyRequestEventHandler> eventHandlers;

    public MobyRequest(Central central) throws ParserConfigurationException {
        this.mobyCentral = central;
        this.wsdlCache = new Hashtable();
        this.eventHandlers = new Vector();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        this.docBuilder = dbf.newDocumentBuilder();
        try {
            this.stringType = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classe) {
            this.debugPS.println("WARNING: Something is very wrong, could not find Class definition of String: " + classe);
        }
        this.xpath_context = new XPathContext();
        this.mobyPrefixResolver = new MobyPrefixResolver();
        try {
            this.base64EncodedXPath = new XPath("//*[starts-with(substring-after(@xsi1999:type, ':'), \"base64\") or starts-with(substring-after(@xsi2001:type, ':'), \"base64\")]", null, this.mobyPrefixResolver, 0);
            this.stringEncodedXPath = new XPath("//*[substring-after(@xsi1999:type, ':')=\"string\" or substring-after(@xsi2001:type, ':')=\"string\"] | //soap-enc:string", null, this.mobyPrefixResolver, 0);
            this.simpleChildXPath = new XPath("moby:Simple | Simple", null, this.mobyPrefixResolver, 0);
            this.collectionChildXPath = new XPath("moby:Collection | Collection", null, this.mobyPrefixResolver, 0);
        }
        catch (TransformerException te) {
            this.debugPS.println("Syntax error encountered while compiling XPath statements for internal use (code bug?): " + te);
        }
        this.setDebugMode(System.getProperty("moby.debug") != null);
    }

    public void setDebugMode(boolean mode) {
        debug = mode;
    }

    public void setDebugPrintStream(PrintStream ps) throws IllegalArgumentException {
        if (ps == null) {
            throw new IllegalArgumentException("The OutputStream specified to MobyRequest was null");
        }
        this.debugPS = ps;
    }

    public Central getCentralImpl() {
        return this.mobyCentral;
    }

    public void setService(MobyService mobyservice) {
        if (mobyservice == null) {
            this.mobyService = null;
        } else if (this.mobyService == null || !mobyservice.equals(this.mobyService)) {
            this.mobyService = mobyservice;
        }
    }

    public MobyService getService() {
        return this.mobyService;
    }

    public String getResponseXML() {
        return this.responseString;
    }

    public void setInput(MobyContentInstance data) throws MobyException {
        this.inputData = data;
    }

    public void setInput(MobyDataInstance[] data) throws MobyException {
        MobyDataJob job = new MobyDataJob();
        for (MobyDataInstance param : data) {
            System.err.println("Adding job param " + param.getName());
            job.put(param.getName(), param);
        }
        this.inputData = new MobyContentInstance();
        this.inputData.put(job);
    }

    public void setInput(MobyDataInstance datum) throws MobyException {
        this.setInput(datum, "");
    }

    public void setInput(MobyDataInstance datum, String paramName) throws MobyException {
        this.inputData = new MobyContentInstance(datum, paramName);
    }

    public MobyContentInstance getInput() {
        return this.inputData;
    }

    public void setSecondaryInput(MobyDataSecondaryInstance[] secondaryData) {
        Iterator<String> queryNames = this.inputData.keySet().iterator();
        while (queryNames.hasNext()) {
            MobyDataJob queryParams = this.inputData.get(queryNames.next());
            for (int i = 0; i < secondaryData.length; ++i) {
                queryParams.put(secondaryData[i].getName(), secondaryData[i]);
            }
        }
    }

    public MobyContentInstance getOutput() throws MobyException {
        if (this.outputData == null) {
            throw new MobyException("Trying to access MOBY service results before the service is invoked");
        }
        return this.outputData;
    }

    public MobyContentInstance invokeService() throws Exception, MobyException, SOAPException, NoSuccessException {
        return this.invokeService(this.inputData, null);
    }

    private MobyContentInstance invokeService(MobyContentInstance inData, StringBuffer contentsXML) throws Exception, MobyException, SOAPException, NoSuccessException {
        return this.invokeService(inData, contentsXML, null, 0);
    }

    private MobyContentInstance invokeService(MobyContentInstance inData, StringBuffer contentsXML, MobyRequestEventHandler handler, int requestId) throws Exception, MobyException, SOAPException, NoSuccessException {
        if (this.mobyService == null) {
            throw new MobyException("Tried to invoke null service from MobyRequest (call setService first)");
        }
        Element mobyDOM = null;
        if (this.mobyService.isAsynchronous()) {
            MobyContentInstance mci = this.performAsyncSOAPRequest(this.mobyService, inData, handler, requestId);
            StringWriter writer = new StringWriter();
            MobyDataUtils.toXMLDocument(writer, mci);
            contentsXML.append(writer.toString());
            return mci;
        }
        String mobyXML = this.convertMOBYDataToMOBYRequest(inData);
        Call call = this.getServiceFromWSDL();
        mobyDOM = this.performSOAPRequest(call, mobyXML, contentsXML);
        return MobyDataUtils.fromXMLDocument(mobyDOM, this.mobyService.getServiceType().getRegistry());
    }

    protected MobyContentInstance performAsyncSOAPRequest(MobyService mservice, MobyContentInstance inData, MobyRequestEventHandler handler, int requestId) throws Exception {
        String mobyXML = this.convertMOBYDataToMOBYRequest(inData);
        EndpointReference epr = AsyncClient.sendRequest(mservice, mobyXML);
        MobyContentInstance finalContents = new MobyContentInstance();
        HashSet<String> queryIDs = new HashSet<String>(inData.keySet());
        try {
            while (!queryIDs.isEmpty()) {
                Thread.sleep(5000L);
                AnalysisEvent[] events = AsyncClient.poll(epr, queryIDs);
                Vector<String> newDataAvailable = new Vector<String>();
                for (AnalysisEvent event : events) {
                    if (event == null || !event.isCompleted()) continue;
                    queryIDs.remove(event.getQueryId());
                    newDataAvailable.add(event.getQueryId());
                }
                if (newDataAvailable.size() <= 0 || handler == null) continue;
                InputStream resultStream = AsyncClient.getResultStream(epr, newDataAvailable);
                Element mobyDOM = this.asyncSoapTextToMobyDOM(resultStream);
                MobyContentInstance newResults = MobyDataUtils.fromXMLDocument(mobyDOM, mservice.getServiceType().getRegistry());
                for (String jobid : newResults.keySet()) {
                    finalContents.put(jobid, newResults.get(jobid));
                }
                MobyRequestEvent mre = new MobyRequestEvent(finalContents, this, mservice, null, requestId);
                StringWriter xmlWriter = new StringWriter();
                MobyDataUtils.toXMLDocument(xmlWriter, finalContents);
                mre.setContentsXML(xmlWriter.toString());
                if (queryIDs.isEmpty()) continue;
                handler.processEvent(mre);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AsyncClient.destroy(epr);
            throw new Exception("Exception occured while polling the service invocation: " + e);
        }
        return finalContents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element asyncSoapTextToMobyDOM(InputStream inStream) throws Exception {
        Element soapDOM = null;
        DocumentBuilder documentBuilder = this.docBuilder;
        synchronized (documentBuilder) {
            soapDOM = this.docBuilder.parse(inStream).getDocumentElement();
        }
        boolean IS_ASYNC_SERVICE_CALL = true;
        return this.decodeSOAPMessage(soapDOM, null, null, true);
    }

    public synchronized int invokeService(MobyRequestEventHandler handler) {
        int id = this.autoID++;
        InvocationThread t = new InvocationThread(this, this.inputData, handler, id);
        t.start();
        return id;
    }

    public void addEventHandler(MobyRequestEventHandler h) {
        this.eventHandlers.add(h);
    }

    public void removeEventHandler(MobyRequestEventHandler h) {
        this.eventHandlers.remove(h);
    }

    public void sendResponse(MobyRequestEvent mre) {
    }

    protected Call getServiceFromWSDL() throws MobyException, NoSuccessException {
        return this.setCallFromWSDL(null);
    }

    protected Call setCallFromWSDL(String wsdl) throws MobyException, SOAPException {
        Call soapCall;
        if (this.service == null) {
            this.service = new org.apache.axis.client.Service();
        }
        try {
            soapCall = (Call)this.service.createCall();
        }
        catch (ServiceException se) {
            throw new SOAPException("Could not instatiate call to SOAP Service: " + se);
        }
        soapCall.removeAllParameters();
        soapCall.setTargetEndpointAddress(this.mobyService.getURL());
        soapCall.setPortName(new QName("http://biomoby.org/", this.mobyService.getName() + "PortType"));
        soapCall.setSOAPActionURI("http://biomoby.org/#" + this.mobyService.getName());
        return soapCall;
    }

    protected Element performSOAPRequest(Call soapCall, String mobyInputXML, StringBuffer contentsXMLOutput) throws SOAPException {
        Object[] mobyXMLInputData = new String[]{mobyInputXML};
        if (debug) {
            this.debugPS.println("returnType just before invoke call is " + soapCall.getReturnType());
        }
        Object returnedObject = null;
        try {
            returnedObject = soapCall.invoke(new QName("http://biomoby.org/", this.mobyService.getName()), mobyXMLInputData);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SOAPException("While invoking SOAP Call: " + e);
        }
        try {
            if (debug) {
                this.debugPS.println("SOAP Response was:\n");
                this.debugPS.println(soapCall.getResponseMessage().getSOAPPart().getEnvelope());
            }
            Element resultDom = ((MessageElement)((Object)soapCall.getResponseMessage().getSOAPPart().getEnvelope())).getAsDOM();
            return this.decodeSOAPMessage(resultDom, contentsXMLOutput, mobyInputXML);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SOAPException("Could not get SOAP response as DOM Element: " + e);
        }
    }

    public Element decodeSOAPMessage(Element n, StringBuffer contentsXMLOutput, String inputXML) throws SOAPException, MobyException {
        return this.decodeSOAPMessage(n, contentsXMLOutput, inputXML, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element decodeSOAPMessage(Element n, StringBuffer contentsXMLOutput, String inputXML, boolean async) throws SOAPException, MobyException {
        if (n == null) {
            throw new SOAPException("SOAP Message given to decode is null");
        }
        NodeList node_list = null;
        XPath responseElementXPath = null;
        try {
            responseElementXPath = async ? new XPath("//wsrp:GetMultipleResourcePropertiesResponse", null, this.mobyPrefixResolver, 0) : new XPath("//mobyt:" + this.mobyService.getName() + "Response | //" + this.mobyService.getName() + "Response | " + "//" + "mobyt" + ":" + this.mobyService.getName() + " | //" + this.mobyService.getName(), null, this.mobyPrefixResolver, 0);
        }
        catch (TransformerException te) {
            throw new SOAPException("Cannot select SOAP nodes due to exception while compiling XPath statement (code bug?):" + te);
        }
        try {
            node_list = this.runXPath(responseElementXPath, n);
        }
        catch (TransformerException te) {
            throw new SOAPException("Cannot select SOAP nodes due to exception while executing XPath statement:" + te);
        }
        if (node_list == null || node_list.getLength() == 0) {
            throw new SOAPException("Could not find a response element in SOAP payload");
        }
        if (node_list.getLength() > 1) {
            throw new SOAPException("Found more than one response element in SOAP payload, unable to resolve ambiguity of the payload (service provider error?)");
        }
        Node[] responseNodes = null;
        if (async) {
            Vector<Element> nodes = new Vector<Element>();
            NodeList resultNodeList = node_list.item(0).getChildNodes();
            for (int i = 0; resultNodeList != null && i < resultNodeList.getLength(); ++i) {
                Element resultElement;
                if (!(resultNodeList.item(i) instanceof Element) || !(resultElement = (Element)resultNodeList.item(i)).getLocalName().startsWith("result_")) continue;
                nodes.add(resultElement);
            }
            responseNodes = nodes.toArray(new Node[nodes.size()]);
        } else {
            responseNodes = new Node[]{node_list.item(0)};
        }
        Element domRoot = null;
        for (Node responseNode : responseNodes) {
            String localResponseString;
            block51: {
                Object child;
                Node change;
                int i;
                node_list = null;
                try {
                    node_list = this.runXPath(this.base64EncodedXPath, responseNode);
                }
                catch (TransformerException te) {
                    throw new SOAPException("Cannot select base64 encoded SOAP nodes due to exception while executing XPath statement:" + te);
                }
                if (debug && node_list != null) {
                    this.debugPS.println("There were " + node_list.getLength() + " base64 encoded elements in the data");
                }
                for (i = 0; node_list != null && i < node_list.getLength(); ++i) {
                    change = node_list.item(i);
                    change.normalize();
                    byte[] decodedBytes = Base64.decode(change.getFirstChild().getNodeValue());
                    String newText = new String(decodedBytes);
                    if (debug) {
                        this.debugPS.println("New decoded text is" + newText);
                    }
                    change.getParentNode().replaceChild(n.getOwnerDocument().createTextNode(new String(decodedBytes)), change);
                }
                node_list = null;
                try {
                    node_list = this.runXPath(this.stringEncodedXPath, responseNode);
                }
                catch (TransformerException te) {
                    throw new SOAPException("Cannot select string encoded SOAP nodes due to exception while executing XPath statement:" + te);
                }
                for (i = 0; node_list != null && i < node_list.getLength(); ++i) {
                    change = node_list.item(i);
                    change.normalize();
                    String plainString = "";
                    NodeList children = change.getChildNodes();
                    for (int j = 0; children != null && j < children.getLength(); ++j) {
                        Node child2 = children.item(j);
                        if (!(child2 instanceof CDATASection) && !(child2 instanceof Text)) continue;
                        plainString = plainString + child2.getNodeValue();
                        if (!debug) continue;
                        this.debugPS.println("Plain string is now " + plainString);
                    }
                    change.getParentNode().replaceChild(n.getOwnerDocument().createCDATASection(plainString), change);
                }
                if (debug && node_list != null) {
                    this.debugPS.println("There were " + node_list.getLength() + " XML Schema string encoded elements in the data");
                }
                responseNode.normalize();
                NodeList children = responseNode.getChildNodes();
                if (children == null) {
                    throw new MobyException("The MOBY payload has no contents at all");
                }
                if (children.getLength() != 1 && debug) {
                    this.debugPS.println("Warning: MOBY Payload appears to have more than just text in it, skipping the non-text sections");
                }
                Element predefinedDOM = null;
                localResponseString = "";
                for (int j = 0; j < children.getLength(); ++j) {
                    child = children.item(j);
                    if (child instanceof CDATASection || child instanceof Text) {
                        if (child.getNodeValue().matches("^\\s+$")) continue;
                        if (debug) {
                            this.debugPS.println("Concatenating text in response " + child.getNodeValue());
                        }
                        localResponseString = localResponseString + child.getNodeValue();
                    }
                    if (!(child instanceof Element) || !child.getLocalName().equals("MOBY")) continue;
                    this.debugPS.println("Warning: The MOBY contents was found as raw XML inside the SOAP response!\nThis is illegal according to the MOBY-API, please inform the service\n  provider, as parsing such text may not be supported in the future");
                    localResponseString = null;
                    predefinedDOM = (Element)child;
                    break;
                }
                if (localResponseString != null && localResponseString.length() == 0) {
                    throw new MobyException("The MOBY payload has no text contents at all");
                }
                if (Character.isWhitespace(localResponseString.charAt(0))) {
                    localResponseString = localResponseString.trim();
                }
                if (localResponseString != null && !localResponseString.startsWith("<?xml")) {
                    if (localResponseString.startsWith("<moby:MOBY") || localResponseString.startsWith("<MOBY")) {
                        localResponseString = "<?xml version=\"1.0\"?>\n" + localResponseString;
                        this.debugPS.println("Warning: The MOBY contents was missing an XML declaration, but it is required by the MOBY API, and may stop working in the future without it.  Please contact the client's provider to correct this.");
                    } else {
                        String oldResponse = localResponseString;
                        if (!(localResponseString = new String(Base64.decode(localResponseString))).startsWith("<?xml")) {
                            throw new MobyException("The SOAP payload defining the MOBY contents does not start with the xml processing instruction, and is therefore not an XML document, as specified in the MOBY API. Please contact the service provider.  Contents was: " + oldResponse);
                        }
                        this.debugPS.println("Warning: The MOBY contents was needlessly base64 encoded (the SOAP envelope does this for you).  It has been decoded, but this is not part of the MOBY API, and may stop working in the future.  Please contact the service provider to correct this.");
                    }
                }
                if (localResponseString != null && localResponseString.indexOf("xml:space=\"preserve\"") == -1) {
                    localResponseString = localResponseString.replaceAll("<String", "<String xml:space=\"preserve\"");
                }
                try {
                    if (async && domRoot != null) {
                        Element newContentsTag = null;
                        if (predefinedDOM != null) {
                            newContentsTag = MobyPrefixResolver.getChildElement(predefinedDOM, "mobyContent");
                        } else {
                            child = this.docBuilder;
                            synchronized (child) {
                                Document newDoc = this.docBuilder.parse(new ByteArrayInputStream(localResponseString.getBytes()));
                                newContentsTag = MobyPrefixResolver.getChildElement(newDoc.getDocumentElement(), "mobyContent");
                            }
                        }
                        Element existingContentsTag = MobyPrefixResolver.getChildElement(domRoot, "mobyContent");
                        NodeList newJobTags = newContentsTag.getChildNodes();
                        for (int i2 = 0; newJobTags != null && i2 < newJobTags.getLength(); ++i2) {
                            if (newJobTags.item(i2) instanceof Element && newJobTags.item(i2).getLocalName().equals("serviceNotes")) {
                                Element existingServiceNotes = MobyPrefixResolver.getChildElement(existingContentsTag, "serviceNotes");
                                if (existingServiceNotes == null) {
                                    existingContentsTag.appendChild(newJobTags.item(i2));
                                    continue;
                                }
                                NodeList newServiceData = newJobTags.item(i2).getChildNodes();
                                for (int j = 0; newServiceData != null && j < newServiceData.getLength(); ++j) {
                                    existingServiceNotes.appendChild(newServiceData.item(j));
                                }
                                continue;
                            }
                            existingContentsTag.appendChild(newJobTags.item(i2));
                        }
                        break block51;
                    }
                    if (predefinedDOM != null) {
                        domRoot = predefinedDOM;
                        break block51;
                    }
                    DocumentBuilder newContentsTag = this.docBuilder;
                    synchronized (newContentsTag) {
                        domRoot = this.docBuilder.parse(new ByteArrayInputStream(localResponseString.getBytes())).getDocumentElement();
                    }
                }
                catch (SAXException saxe) {
                    throw new MobyException("The SOAP payload defining the MOBY Result could not be parsed: " + saxe);
                }
                catch (IOException ioe) {
                    throw new MobyException("The SOAP payload defining the MOBY Result  could not be read (from a String!)" + ioe);
                }
            }
            if (contentsXMLOutput != null) {
                contentsXMLOutput.append(localResponseString);
                continue;
            }
            this.responseString = localResponseString;
        }
        this.releaseXPath(n);
        return domRoot;
    }

    public String convertMOBYDataToMOBYRequest(MobyDataInstance data) throws MobyException {
        return this.convertMOBYDataToMOBYRequest(new MobyContentInstance(data, ""));
    }

    public String convertMOBYDataToMOBYRequest(MobyContentInstance data) throws MobyException {
        MobyPrimaryData[] inputs = this.mobyService.getPrimaryInputs();
        MobySecondaryData[] secondaries = this.mobyService.getSecondaryInputs();
        for (String queryName : data.keySet()) {
            String serviceParamName;
            MobyDataJob query = data.get(queryName);
            HashMap<String, MobyPrimaryData> primaryParams = new HashMap<String, MobyPrimaryData>();
            HashMap<String, MobySecondaryData> secondaryParams = new HashMap<String, MobySecondaryData>();
            Iterator params = query.keySet().iterator();
            String primaryParamName = null;
            while (params.hasNext()) {
                String name = (String)params.next();
                Object param = query.get(name);
                if (param == null) {
                    throw new MobyException("Query " + queryName + " contained a null input parameter (" + name + ")");
                }
                if (!(param instanceof MobyDataInstance)) {
                    System.err.println("Input parameter " + name + " (query " + queryName + ") was not a MobyDataInstance " + "as expected, but rather was of class " + param.getClass().getName());
                    continue;
                }
                if (param instanceof MobyPrimaryData) {
                    primaryParams.put(name, (MobyPrimaryData)param);
                    primaryParamName = name;
                    continue;
                }
                if (param instanceof MobySecondaryData) {
                    secondaryParams.put(name, (MobySecondaryData)param);
                    continue;
                }
                System.err.println("Input parameter " + name + " (query " + queryName + ") was not a MobyPrimaryData or MobySecondaryData " + "as expected, but rather was of class " + param.getClass().getName());
            }
            if (inputs != null && inputs.length != primaryParams.size()) {
                throw new MobyException("Service " + this.mobyService.getName() + " was provided " + primaryParams.size() + " primary input parameter(s), but takes " + inputs.length + " (query " + queryName + ")");
            }
            if (secondaries != null && secondaries.length != secondaryParams.size()) {
                throw new MobyException("Service " + this.mobyService.getName() + " was provided " + secondaryParams.size() + " secondary input parameter(s), but takes " + secondaries.length + " (query " + queryName + ")");
            }
            if (inputs.length != 1 || (serviceParamName = inputs[0].getName()) == null || serviceParamName.length() <= 0 || serviceParamName.equals(primaryParamName)) continue;
            MobyPrimaryData theInputToRename = (MobyPrimaryData)query.remove(primaryParamName);
            query.put(serviceParamName, (MobyDataInstance)((Object)theInputToRename));
        }
        ByteArrayOutputStream mobyRequest = new ByteArrayOutputStream();
        try {
            MobyDataUtils.toXMLDocument(mobyRequest, data);
        }
        catch (MobyException me) {
            throw me;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MobyException("Could not create MOBY payload XML from input data: " + e);
        }
        if (debug) {
            this.debugPS.println("Input to MOBY Service is:");
            this.debugPS.print(mobyRequest.toString());
        }
        return mobyRequest.toString();
    }

    protected NodeList runXPath(XPath xpath, Node n) throws TransformerException {
        NodeList result = null;
        int dtm_node_handle = this.xpath_context.getDTMHandleFromNode(n);
        PrefixResolverDefault node_prefix_resolver = new PrefixResolverDefault(n);
        XObject xobject = xpath.execute(this.xpath_context, n, (PrefixResolver)node_prefix_resolver);
        if (xobject instanceof XNodeSet) {
            result = ((XNodeSet)xobject).nodelist();
        } else if (debug && xobject != null) {
            this.debugPS.println("Output of XPath was not a XNodeSet as expected, found " + xobject.getClass().getName());
            this.debugPS.flush();
        }
        return result;
    }

    protected void releaseXPath(Node n) {
        this.xpath_context.release(this.xpath_context.getDTM(this.xpath_context.getDTMHandleFromNode(n)), false);
    }

    class InvocationThread
    extends Thread {
        MobyContentInstance data;
        MobyService mservice;
        MobyRequest mobyRequest;
        MobyRequestEventHandler handler;
        int requestId;

        InvocationThread(MobyRequest mr, MobyContentInstance inData, MobyRequestEventHandler h, int id) {
            this.data = inData;
            this.mobyRequest = mr;
            this.mservice = this.mobyRequest.getService();
            this.handler = h;
            this.requestId = id;
            this.setName(this.mservice.getName() + this.requestId);
        }

        public void run() {
            MobyRequestEvent requestEvent = new MobyRequestEvent(this.data, this.mobyRequest, this.mservice, null, this.requestId);
            this.handler.start(requestEvent);
            MobyRequestEvent responseEvent = null;
            MobyContentInstance content = null;
            StringBuffer contentsXML = new StringBuffer();
            try {
                content = this.mobyRequest.invokeService(this.data, contentsXML, this.handler, this.requestId);
            }
            catch (Exception e) {
                responseEvent = new MobyRequestEvent(content, this.mobyRequest, this.mservice, e, this.requestId);
            }
            catch (Error err) {
                responseEvent = new MobyRequestEvent(content, this.mobyRequest, this.mservice, err, this.requestId);
            }
            if (responseEvent == null) {
                responseEvent = new MobyRequestEvent(content, this.mobyRequest, this.mservice, null, this.requestId);
            }
            responseEvent.setContentsXML(contentsXML.toString());
            this.handler.processEvent(responseEvent);
            this.handler.stop(this.mobyRequest, this.requestId);
        }
    }
}

