/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared.data;

import org.biomoby.registry.meta.Registry;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyNamespace;
import org.biomoby.shared.data.MobyDataObject;
import org.w3c.dom.Element;

public class MobyDataBoolean
extends MobyDataObject {
    private Boolean value;

    public MobyDataBoolean(Element element) throws IllegalArgumentException {
        this(element, null);
    }

    public MobyDataBoolean(Element element, Registry registry) throws IllegalArgumentException {
        this(MobyDataBoolean.getName(element), MobyDataBoolean.getTextContents(element), registry);
        this.setId(MobyDataBoolean.getId(element));
        this.addNamespace(MobyDataBoolean.getNamespace(element, registry));
    }

    public MobyDataBoolean(String articleName, Boolean b) {
        this(articleName, b, (Registry)null);
    }

    public MobyDataBoolean(String articleName, Boolean b, Registry registry) {
        super(articleName, registry);
        this.setDataType(MobyDataType.getDataType("Boolean", registry));
        this.value = b;
    }

    public MobyDataBoolean(String articleName, boolean b) {
        this(articleName, (Boolean)b, (Registry)null);
    }

    public MobyDataBoolean(String articleName, boolean b, Registry registry) {
        this(articleName, (Boolean)b, registry);
    }

    public MobyDataBoolean(String articleName, String booleanString) {
        this(articleName, Boolean.valueOf(booleanString.trim()), (Registry)null);
    }

    public MobyDataBoolean(String articleName, String booleanString, Registry registry) {
        this(articleName, Boolean.valueOf(booleanString.trim()), registry);
    }

    public MobyDataBoolean(Boolean b) {
        this("", b);
    }

    public MobyDataBoolean(Boolean b, Registry r) {
        this("", b, r);
    }

    public MobyDataBoolean(boolean b) {
        this("", b);
    }

    public MobyDataBoolean(boolean b, Registry r) {
        this("", b, r);
    }

    public MobyDataBoolean(String booleanString) {
        this("", booleanString);
    }

    public MobyDataBoolean(String booleanString, Registry r) {
        this("", booleanString, r);
    }

    public String toString() {
        return this.value.toString();
    }

    public Object clone() {
        MobyDataBoolean copy = new MobyDataBoolean(this.getName(), this.value, this.getDataType().getRegistry());
        copy.setDataType(this.getDataType());
        copy.setId(this.getId());
        copy.setNamespaces(this.getNamespaces());
        return copy;
    }

    public Object getObject() {
        return this.value;
    }

    public boolean booleanValue() {
        return this.value;
    }

    public void setValue(boolean b) {
        this.value = b;
    }

    public void setValue(Boolean b) {
        this.value = b;
    }

    public void setValue(String booleanValue) {
        this.value = Boolean.valueOf(booleanValue);
    }

    public String getValue() {
        return this.value.toString();
    }

    public String toXML() {
        MobyNamespace[] ns = this.getNamespaces();
        if (this.xmlMode == 891) {
            return "<Boolean " + this.getAttrXML() + ">" + this.value + "</" + "Boolean" + ">";
        }
        return super.toXML();
    }
}

