/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared.data;

import org.biomoby.registry.meta.Registry;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyNamespace;
import org.biomoby.shared.data.MobyDataObject;
import org.w3c.dom.Element;

public class MobyDataString
extends MobyDataObject {
    private StringBuffer value;

    public MobyDataString(Element element) throws IllegalArgumentException {
        this(element, null);
    }

    public MobyDataString(Element element, Registry registry) throws IllegalArgumentException {
        this(MobyDataString.getName(element), (CharSequence)MobyDataString.getTextContents(element), registry);
        this.setId(MobyDataString.getId(element));
        this.addNamespace(MobyDataString.getNamespace(element, registry));
    }

    public MobyDataString(String articleName, CharSequence stringValue) {
        this(articleName, stringValue, null);
    }

    public MobyDataString(String articleName, CharSequence stringValue, Registry registry) {
        super(articleName, registry);
        this.setDataType(MobyDataType.getDataType("String", registry));
        this.value = stringValue == null ? null : new StringBuffer(((Object)stringValue).toString());
    }

    public MobyDataString(CharSequence stringValue) {
        this("", stringValue, null);
    }

    public MobyDataString(CharSequence stringValue, Registry registry) {
        this("", stringValue, registry);
    }

    public String toString() {
        return this.value.toString();
    }

    public Object clone() {
        MobyDataString copy = new MobyDataString(this.getName(), this.value, this.getDataType().getRegistry());
        copy.setDataType(this.getDataType());
        copy.setId(this.getId());
        copy.setNamespaces(this.getNamespaces());
        return copy;
    }

    public Object getObject() {
        return this.value;
    }

    public String getValue() {
        return this.value.toString();
    }

    public void setValue(CharSequence str) {
        this.value.setLength(0);
        this.value.append(str);
    }

    public String toXML() {
        MobyNamespace[] ns = this.getNamespaces();
        if (this.xmlMode == 891) {
            String tmpValue = this.value.toString();
            if (tmpValue != null) {
                tmpValue = tmpValue.replaceAll("&(?!(amp|#x\\d+);)", "&amp;");
                tmpValue = tmpValue.replaceAll("<", "&lt;");
            } else {
                tmpValue = "";
            }
            return "<String " + this.getAttrXML() + " xml:space=\"preserve\">" + tmpValue + "</" + "String" + ">";
        }
        return super.toXML();
    }
}

