/*
 * Decompiled with CFR 0.152.
 */
package org.biomoby.shared.extended;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.biomoby.client.rdf.vocabulary.DC_PROTEGE;
import org.biomoby.client.rdf.vocabulary.Predicates;
import org.biomoby.shared.MobyDataType;
import org.biomoby.shared.MobyException;

public class DataTypeParser {
    private URL url = null;

    public DataTypeParser() {
        this.url = null;
    }

    public DataTypeParser(String url) throws MobyException {
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException e) {
            this.url = null;
            throw new MobyException("Invalid url specified by " + url + ".\n" + e.getLocalizedMessage());
        }
    }

    public DataTypeParser(URL url) throws MobyException {
        if (url == null) {
            this.url = null;
            throw new MobyException("Invalid url specified by " + url.toExternalForm() + ".");
        }
        this.url = url;
    }

    public void setUrl(URL url) throws MobyException {
        if (url == null) {
            this.url = null;
            throw new MobyException("Invalid url specified by " + url.toExternalForm() + ".");
        }
        this.url = url;
    }

    public void setUrl(String url) throws MobyException {
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException e) {
            this.url = null;
            throw new MobyException("Invalid url specified by " + url + ".\n" + e.getLocalizedMessage());
        }
    }

    public URL getUrl() {
        return this.url;
    }

    public MobyDataType[] getMobyDataTypesFromRDF() throws MobyException {
        if (this.url == null) {
            throw new MobyException("Invalid url specified for the location of the RDF document that describes the Data Type ontology: " + this.url);
        }
        ArrayList<MobyDataType> list = new ArrayList<MobyDataType>();
        Model model = ModelFactory.createDefaultModel();
        RDFReader reader = model.getReader();
        reader.read(model, new StringReader(this.getRdfAsString()), null);
        ResIterator iterator = model.listSubjects();
        while (iterator.hasNext()) {
            String type;
            String articleName;
            Resource hasa;
            Statement statement;
            String[] stringArray;
            String uri;
            Resource resource = iterator.nextResource();
            if (resource.getLocalName() == null || resource.getURI().equals(RDFS.comment.getURI()) || resource.getURI().equals(RDFS.label.getURI()) || (uri = resource.getURI()).indexOf("/MOBY_SUB_COMPONENT/") > 0) continue;
            String name = "";
            if (uri.indexOf("#") > 0) {
                name = uri.substring(uri.indexOf("#") + 1);
            } else if (uri.lastIndexOf("/Objects/") > 0) {
                name = uri.substring(uri.lastIndexOf("/Objects/") + "/Objects/".length());
            }
            String parent = null;
            if (resource.hasProperty(RDFS.subClassOf)) {
                parent = ((Resource)resource.getProperty(RDFS.subClassOf).getObject()).getURI();
                if (parent.indexOf("#") > 0) {
                    parent = parent.substring(parent.indexOf("#") + 1);
                } else if (parent.lastIndexOf("/Objects/") > 0) {
                    parent = parent.substring(parent.lastIndexOf("/Objects/") + "/Objects/".length());
                }
            }
            String description = resource.getProperty(RDFS.comment).getLiteral().getString();
            MobyDataType datatype = new MobyDataType(name);
            if (resource.hasProperty(DC_PROTEGE.identifier)) {
                datatype.setLSID(((Object)resource.getProperty(DC_PROTEGE.identifier).getObject()).toString());
            }
            datatype.setComment(description);
            if (parent == null) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = parent;
            }
            datatype.setParentNames(stringArray);
            if (resource.hasProperty(DC_PROTEGE.creator)) {
                datatype.setEmailContact(((Object)resource.getProperty(DC_PROTEGE.creator).getObject()).toString());
            }
            if (resource.hasProperty(DC_PROTEGE.publisher)) {
                datatype.setAuthority(((Object)resource.getProperty(DC_PROTEGE.publisher).getObject()).toString());
            }
            StmtIterator stIter = resource.listProperties(Predicates.hasa);
            while (stIter.hasNext()) {
                statement = stIter.nextStatement();
                hasa = (Resource)statement.getObject();
                articleName = hasa.getProperty(Predicates.articleName).getLiteral().getString();
                type = ((Resource)hasa.getProperty(RDF.type).getObject()).getLocalName();
                datatype.addChild(articleName, type, 2);
            }
            stIter = resource.listProperties(Predicates.has);
            while (stIter.hasNext()) {
                statement = stIter.nextStatement();
                hasa = (Resource)statement.getObject();
                articleName = hasa.getProperty(Predicates.articleName).getLiteral().getString();
                type = ((Resource)hasa.getProperty(RDF.type).getObject()).getLocalName();
                datatype.addChild(articleName, type, 3);
            }
            list.add(datatype);
        }
        return list.toArray(new MobyDataType[list.size()]);
    }

    private String getRdfAsString() {
        String s = null;
        StringBuffer sb = new StringBuffer();
        try {
            BufferedReader in = null;
            in = new BufferedReader(new InputStreamReader(this.url.openStream()));
            while ((s = in.readLine()) != null) {
                sb.append(s);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return sb.toString();
    }

    public static void main(String[] args) throws MobyException {
        DataTypeParser d = new DataTypeParser("http://biomoby.org/RESOURCES/MOBY-S/Objects");
        MobyDataType[] types = d.getMobyDataTypesFromRDF();
        for (int i = 0; i < types.length; ++i) {
            System.out.println(types[i]);
        }
    }
}

