/*
 * Decompiled with CFR 0.152.
 */
package org.omg.lsae.sax;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.biomoby.shared.MobyException;
import org.omg.lsae.notifications.AnalysisEvent;
import org.omg.lsae.notifications.HeartBeatEvent;
import org.omg.lsae.notifications.PercentEvent;
import org.omg.lsae.notifications.StateEvent;
import org.omg.lsae.notifications.StepEvent;
import org.omg.lsae.notifications.TimeProgressEvent;
import org.omg.lsae.sax.LsaeTags;
import org.tulsoft.shared.GException;
import org.tulsoft.tools.debug.DGUtils;
import org.tulsoft.tools.xml.XMLUtils2;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class EventParser
extends DefaultHandler
implements LsaeTags {
    private static String[] eventNamesArray = new String[]{"heartbeat_progress", "percent_progress", "state_changed", "step_progress", "time_progress"};
    private static HashSet<String> eventNames = new HashSet();
    private boolean inAnalysisEvent = false;
    private boolean parsingChild = false;
    private boolean parsingMessage = false;
    private Locator locator;
    private XMLReader parser = null;
    private AnalysisEvent[] result = null;
    private List<AnalysisEvent> events = new ArrayList<AnalysisEvent>();
    private String timestamp = "";
    private String eventId = "";
    private int index = 0;
    private StringBuffer msgBuffer = new StringBuffer();

    public void startDocument() throws SAXException {
        this.inAnalysisEvent = false;
        this.parsingChild = false;
        this.parsingMessage = false;
        this.events = new ArrayList<AnalysisEvent>();
    }

    public void endDocument() throws SAXException {
        this.eventId = null;
        this.timestamp = null;
        this.msgBuffer = null;
        this.result = this.events.toArray(new AnalysisEvent[0]);
    }

    public void startElement(String namespaceURI, String name, String qName, Attributes attrs) throws SAXException {
        if (name.equals("analysis_event")) {
            this.inAnalysisEvent = true;
            for (int x = 0; x < attrs.getLength(); ++x) {
                if (attrs.getLocalName(x).equals("timestamp")) {
                    this.timestamp = attrs.getValue(x);
                    continue;
                }
                if (!attrs.getLocalName(x).equals("id")) continue;
                this.eventId = attrs.getValue(x);
            }
            return;
        }
        if (this.inAnalysisEvent) {
            if (eventNames.contains(name)) {
                if (name.equals("heartbeat_progress")) {
                    this.events.add(this.index, (AnalysisEvent)new HeartBeatEvent());
                    this.parsingChild = true;
                } else if (name.equals("percent_progress")) {
                    this.events.add(this.index, (AnalysisEvent)new PercentEvent());
                    this.parsingChild = true;
                    for (int x = 0; x < attrs.getLength(); ++x) {
                        if (!attrs.getLocalName(x).equals("percentage")) continue;
                        try {
                            ((PercentEvent)this.events.get(this.index)).setPercentCompleted(Integer.parseInt(attrs.getValue(x)));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        return;
                    }
                } else if (name.equals("state_changed")) {
                    this.events.add(this.index, new StateEvent());
                    this.parsingChild = true;
                    for (int x = 0; x < attrs.getLength(); ++x) {
                        if (attrs.getLocalName(x).equals("new_state")) {
                            ((StateEvent)this.events.get(this.index)).setNewState(((StateEvent)this.events.get(this.index)).getState(attrs.getValue(x)));
                            continue;
                        }
                        if (!attrs.getLocalName(x).equals("previous_state")) continue;
                        ((StateEvent)this.events.get(this.index)).setPreviousState(((StateEvent)this.events.get(this.index)).getState(attrs.getValue(x)));
                    }
                } else if (name.equals("step_progress")) {
                    this.events.add(this.index, (AnalysisEvent)new StepEvent());
                    this.parsingChild = true;
                    for (int x = 0; x < attrs.getLength(); ++x) {
                        if (attrs.getLocalName(x).equals("steps_completed")) {
                            ((StepEvent)this.events.get(this.index)).setCompletedSteps(Integer.parseInt(attrs.getValue(x)));
                            continue;
                        }
                        if (!attrs.getLocalName(x).equals("total_steps")) continue;
                        ((StepEvent)this.events.get(this.index)).setTotalSteps(Integer.parseInt(attrs.getValue(x)));
                    }
                } else if (name.equals("time_progress")) {
                    this.events.add(this.index, (AnalysisEvent)new TimeProgressEvent());
                    this.parsingChild = true;
                    for (int x = 0; x < attrs.getLength(); ++x) {
                        if (!attrs.getLocalName(x).equals("remaining")) continue;
                        try {
                            ((TimeProgressEvent)this.events.get(this.index)).setRemaining(Long.parseLong(attrs.getValue(x)));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        return;
                    }
                }
                return;
            }
            if (!this.parsingChild && this.inAnalysisEvent && name.equals("message")) {
                this.parsingMessage = true;
                this.msgBuffer = new StringBuffer();
                return;
            }
        }
    }

    public void endElement(String namespaceURI, String name, String qName) throws SAXException {
        if (this.inAnalysisEvent && name.equals("analysis_event")) {
            this.inAnalysisEvent = false;
            this.parsingChild = false;
            this.parsingMessage = false;
            if (this.events.get(this.index) != null) {
                this.events.get(this.index).setQueryId(this.eventId);
                this.events.get(this.index).setTimestamp(this.timestamp);
                this.events.get(this.index).setMessage(this.msgBuffer.toString());
                ++this.index;
            }
            return;
        }
        if (this.parsingChild && eventNames.contains(name)) {
            this.parsingChild = false;
            this.parsingMessage = false;
            return;
        }
        if (this.parsingMessage && name.equals("message")) {
            this.parsingMessage = false;
            this.parsingChild = false;
            return;
        }
    }

    public void setDocumentLocator(Locator l) {
        this.locator = l;
    }

    public void characters(char[] ch, int start, int length) {
        if (this.parsingMessage) {
            this.msgBuffer.append(ch, start, length);
        }
    }

    protected SAXParseException error(String message) {
        return new SAXParseException("", this.locator, new MobyException(message));
    }

    public AnalysisEvent[] parse(String xmlFilename) throws MobyException {
        return this._parse(new InputSource(xmlFilename));
    }

    public AnalysisEvent[] parse(InputStream xml) throws MobyException {
        return this._parse(new InputSource(xml));
    }

    public AnalysisEvent[] parse(Reader xmlReader) throws MobyException {
        return this._parse(new InputSource(xmlReader));
    }

    private synchronized AnalysisEvent[] _parse(InputSource xmlSource) throws MobyException {
        try {
            if (this.parser == null) {
                this.parser = XMLUtils2.makeXMLParser(this);
            }
            this.parser.parse(xmlSource);
            if (this.result == null) {
                throw new MobyException("Parsing XML failed, and I do not know why. \nPanic... (or send the XML to a jMoby developer)\n");
            }
            return this.result;
        }
        catch (GException e) {
            throw new MobyException("Error in creating XML parser " + e.getMessage());
        }
        catch (SAXException e) {
            throw new MobyException("Error in the XML input.\n" + XMLUtils2.getFormattedError(e));
        }
        catch (IOException e) {
            throw new MobyException("Error by reading XML input: " + e.toString());
        }
        catch (Error e) {
            throw new MobyException("Serious or unexpected error!\n" + e.toString() + "\n" + DGUtils.stackTraceToString((Throwable)e));
        }
    }

    static {
        for (int i = 0; i < eventNamesArray.length; ++i) {
            eventNames.add(eventNamesArray[i]);
        }
    }
}

