/*
 * Decompiled with CFR 0.152.
 */
package org.tulsoft.tools.xml;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import org.tulsoft.shared.GException;
import org.tulsoft.shared.UUtils;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class XMLUtils2 {
    public static final String VERSION = "$Id: XMLUtils2.java,v 1.1.1.1 2005/09/03 07:32:13 marsenger Exp $";
    public static final String DEFAULT_PROP_FOR_PARSER = "org.xml.sax.driver";

    public static XMLReader makeXMLParser(DefaultHandler outputHandler) throws GException {
        return XMLUtils2.makeXMLParser(null, outputHandler);
    }

    public static XMLReader makeXMLParser(String parserClass, DefaultHandler outputHandler) throws GException {
        XMLReader parser = null;
        try {
            if (parserClass == null) {
                parserClass = System.getProperty(DEFAULT_PROP_FOR_PARSER);
            }
            if (parserClass == null) {
                parserClass = "org.apache.xerces.parsers.SAXParser";
            }
            parser = XMLReaderFactory.createXMLReader(parserClass);
            parser.setContentHandler(outputHandler);
            parser.setErrorHandler(outputHandler);
        }
        catch (Exception e) {
            throw new GException("Parser class: " + parserClass + '(' + e.getMessage() + ')', e);
        }
        return parser;
    }

    public static String getLocationString(SAXParseException ex) {
        StringBuffer str = new StringBuffer();
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            str.append(systemId);
        }
        str.append(':');
        str.append(ex.getLineNumber());
        str.append(':');
        str.append(ex.getColumnNumber());
        return str.toString();
    }

    public static String getFormattedError(SAXException ex) {
        Exception inner;
        StringBuffer buf = new StringBuffer();
        if (ex instanceof SAXParseException) {
            int column;
            int line;
            SAXParseException pex = (SAXParseException)ex;
            buf.append("SystemID: " + pex.getSystemId() + '\n');
            String publicId = pex.getPublicId();
            if (publicId != null) {
                buf.append("PublicID: " + publicId + '\n');
            }
            if ((line = pex.getLineNumber()) > 0) {
                buf.append("Line (perhaps): " + line + '\n');
            }
            if ((column = pex.getColumnNumber()) > 0) {
                buf.append("Column: " + column + '\n');
            }
        }
        if ((inner = ex.getException()) != null) {
            String msg = inner.getMessage();
            if (!UUtils.isEmpty((String)msg)) {
                buf.append("Message: " + msg + '\n');
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
            PrintWriter out = new PrintWriter(bout, true);
            inner.printStackTrace(out);
            buf.append(bout.toString());
        }
        return new String(buf);
    }
}

