/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.Complex;
import JSci.maths.ComplexMapping;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.ComplexVector;
import JSci.maths.DimensionException;
import JSci.maths.DoubleMatrix;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;
import JSci.maths.algebras.ModuleMember;
import JSci.maths.algebras.VectorSpaceMember;
import JSci.maths.fields.FieldMember;
import JSci.maths.fields.RingMember;
import JSci.maths.groups.AbelianGroupMember;

public class ComplexMatrix
extends Matrix {
    protected static final int ARRAY_2D = 1;
    protected double[][] matrixRe;
    protected double[][] matrixIm;

    protected ComplexMatrix() {
    }

    public ComplexMatrix(int n, int n2) {
        this();
        this.storageFormat = 1;
        this.matrixRe = new double[n][n2];
        this.matrixIm = new double[n][n2];
    }

    public ComplexMatrix(double[][] dArray, double[][] dArray2) {
        this();
        this.storageFormat = 1;
        this.matrixRe = dArray;
        this.matrixIm = dArray2;
    }

    public ComplexMatrix(Complex[][] complexArray) {
        this(complexArray.length, complexArray[0].length);
        int n = 0;
        while (n < complexArray.length) {
            int n2 = 0;
            while (n2 < complexArray[0].length) {
                this.matrixRe[n][n2] = complexArray[n][n2].real();
                this.matrixIm[n][n2] = complexArray[n][n2].imag();
                ++n2;
            }
            ++n;
        }
    }

    public ComplexMatrix(ComplexVector[] complexVectorArray) {
        this(complexVectorArray[0].dimension(), complexVectorArray.length);
        int n = 0;
        while (n < this.matrixRe.length) {
            int n2 = 0;
            while (n2 < this.matrixRe[0].length) {
                this.matrixRe[n][n2] = complexVectorArray[n2].getComponent(n).real();
                this.matrixIm[n][n2] = complexVectorArray[n2].getComponent(n).imag();
                ++n2;
            }
            ++n;
        }
    }

    protected void finalize() throws Throwable {
        this.matrixRe = null;
        this.matrixIm = null;
        super.finalize();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ComplexMatrix && this.matrixRe.length == ((ComplexMatrix)object).rows() && this.matrixRe[0].length == ((ComplexMatrix)object).columns()) {
            ComplexMatrix complexMatrix = (ComplexMatrix)object;
            int n = 0;
            while (n < this.matrixRe.length) {
                int n2 = 0;
                while (n2 < this.matrixRe[0].length) {
                    if (!complexMatrix.getElement(n, n2).equals(this.matrixRe[n][n2], this.matrixIm[n][n2])) {
                        return false;
                    }
                    ++n2;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.matrixRe.length * this.matrixRe[0].length);
        int n = 0;
        while (n < this.matrixRe.length) {
            int n2 = 0;
            while (n2 < this.matrixRe[0].length) {
                stringBuffer.append(Complex.toString(this.matrixRe[n][n2], this.matrixIm[n][n2]));
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.infNorm());
    }

    public DoubleMatrix real() {
        return new DoubleMatrix(this.matrixRe);
    }

    public DoubleMatrix imag() {
        return new DoubleMatrix(this.matrixIm);
    }

    public Complex getElement(int n, int n2) {
        if (n >= 0 && n < this.matrixRe.length && n2 >= 0 && n2 < this.matrixRe[0].length) {
            return new Complex(this.matrixRe[n][n2], this.matrixIm[n][n2]);
        }
        throw new MatrixDimensionException("Invalid element.");
    }

    public void setElement(int n, int n2, Complex complex) {
        if (n < 0 || n >= this.matrixRe.length || n2 < 0 || n2 >= this.matrixRe[0].length) {
            throw new MatrixDimensionException("Invalid element.");
        }
        this.matrixRe[n][n2] = complex.real();
        this.matrixIm[n][n2] = complex.imag();
    }

    public double infNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.matrixRe.length) {
            double d2 = 0.0;
            int n2 = 0;
            while (n2 < this.matrixRe[0].length) {
                d2 += Math.sqrt(this.matrixRe[n][n2] * this.matrixRe[n][n2] + this.matrixIm[n][n2] * this.matrixIm[n][n2]);
                ++n2;
            }
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.matrixRe.length) {
            int n2 = 0;
            while (n2 < this.matrixRe[0].length) {
                d += this.matrixRe[n][n2] * this.matrixRe[n][n2] + this.matrixIm[n][n2] * this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return Math.sqrt(d);
    }

    public int rows() {
        return this.matrixRe.length;
    }

    public int columns() {
        return this.matrixRe[0].length;
    }

    public AbelianGroupMember negate() {
        double[][] dArray = new double[this.matrixRe.length][this.matrixRe[0].length];
        double[][] dArray2 = new double[this.matrixIm.length][this.matrixIm[0].length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n][0] = -this.matrixRe[n][0];
            dArray2[n][0] = -this.matrixIm[n][0];
            int n2 = 1;
            while (n2 < dArray[0].length) {
                dArray[n][n2] = -this.matrixRe[n][n2];
                dArray2[n][n2] = -this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public AbelianGroupMember add(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof ComplexMatrix) {
            return this.add((ComplexMatrix)abelianGroupMember);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexMatrix add(ComplexMatrix complexMatrix) {
        switch (complexMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(complexMatrix);
            }
        }
        if (this.matrixRe.length == complexMatrix.rows() && this.matrixRe[0].length == complexMatrix.columns()) {
            double[][] dArray = new double[this.matrixRe.length][this.matrixRe[0].length];
            double[][] dArray2 = new double[this.matrixIm.length][this.matrixIm[0].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrixRe[n][0] + complexMatrix.getElement(n, 0).real();
                dArray2[n][0] = this.matrixIm[n][0] + complexMatrix.getElement(n, 0).imag();
                int n2 = 1;
                while (n2 < dArray[0].length) {
                    dArray[n][n2] = this.matrixRe[n][n2] + complexMatrix.getElement(n, n2).real();
                    dArray2[n][n2] = this.matrixIm[n][n2] + complexMatrix.getElement(n, n2).imag();
                    ++n2;
                }
                ++n;
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexMatrix rawAdd(ComplexMatrix complexMatrix) {
        if (this.matrixRe.length == complexMatrix.matrixRe.length && this.matrixRe[0].length == complexMatrix.matrixRe[0].length) {
            double[][] dArray = new double[this.matrixRe.length][this.matrixRe[0].length];
            double[][] dArray2 = new double[this.matrixIm.length][this.matrixIm[0].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrixRe[n][0] + complexMatrix.matrixRe[n][0];
                dArray2[n][0] = this.matrixIm[n][0] + complexMatrix.matrixIm[n][0];
                int n2 = 1;
                while (n2 < dArray[0].length) {
                    dArray[n][n2] = this.matrixRe[n][n2] + complexMatrix.matrixRe[n][n2];
                    dArray2[n][n2] = this.matrixIm[n][n2] + complexMatrix.matrixIm[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbelianGroupMember subtract(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof ComplexMatrix) {
            return this.subtract((ComplexMatrix)abelianGroupMember);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexMatrix subtract(ComplexMatrix complexMatrix) {
        switch (complexMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(complexMatrix);
            }
        }
        if (this.matrixRe.length == complexMatrix.rows() && this.matrixRe[0].length == complexMatrix.columns()) {
            double[][] dArray = new double[this.matrixRe.length][this.matrixRe[0].length];
            double[][] dArray2 = new double[this.matrixIm.length][this.matrixIm[0].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrixRe[n][0] - complexMatrix.getElement(n, 0).real();
                dArray2[n][0] = this.matrixIm[n][0] - complexMatrix.getElement(n, 0).imag();
                int n2 = 1;
                while (n2 < dArray[0].length) {
                    dArray[n][n2] = this.matrixRe[n][n2] - complexMatrix.getElement(n, n2).real();
                    dArray2[n][n2] = this.matrixIm[n][n2] - complexMatrix.getElement(n, n2).imag();
                    ++n2;
                }
                ++n;
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexMatrix rawSubtract(ComplexMatrix complexMatrix) {
        if (this.matrixRe.length == complexMatrix.matrixRe.length && this.matrixRe[0].length == complexMatrix.matrixRe[0].length) {
            double[][] dArray = new double[this.matrixRe.length][this.matrixRe[0].length];
            double[][] dArray2 = new double[this.matrixIm.length][this.matrixIm[0].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrixRe[n][0] - complexMatrix.matrixRe[n][0];
                dArray2[n][0] = this.matrixIm[n][0] - complexMatrix.matrixIm[n][0];
                int n2 = 1;
                while (n2 < dArray[0].length) {
                    dArray[n][n2] = this.matrixRe[n][n2] - complexMatrix.matrixRe[n][n2];
                    dArray2[n][n2] = this.matrixIm[n][n2] - complexMatrix.matrixIm[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ModuleMember scalarMultiply(RingMember ringMember) {
        if (ringMember instanceof Complex) {
            return this.scalarMultiply((Complex)ringMember);
        }
        if (ringMember instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)ringMember).value());
        }
        if (ringMember instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)ringMember).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexMatrix scalarMultiply(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        double[][] dArray = new double[this.matrixRe.length][this.matrixRe[0].length];
        double[][] dArray2 = new double[this.matrixIm.length][this.matrixIm[0].length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n][0] = d * this.matrixRe[n][0] - d2 * this.matrixIm[n][0];
            dArray2[n][0] = d2 * this.matrixRe[n][0] + d * this.matrixIm[n][0];
            int n2 = 1;
            while (n2 < dArray[0].length) {
                dArray[n][n2] = d * this.matrixRe[n][n2] - d2 * this.matrixIm[n][n2];
                dArray2[n][n2] = d2 * this.matrixRe[n][n2] + d * this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public ComplexMatrix scalarMultiply(double d) {
        double[][] dArray = new double[this.matrixRe.length][this.matrixRe[0].length];
        double[][] dArray2 = new double[this.matrixIm.length][this.matrixIm[0].length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n][0] = d * this.matrixRe[n][0];
            dArray2[n][0] = d * this.matrixIm[n][0];
            int n2 = 1;
            while (n2 < dArray[0].length) {
                dArray[n][n2] = d * this.matrixRe[n][n2];
                dArray2[n][n2] = d * this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public VectorSpaceMember scalarDivide(FieldMember fieldMember) {
        if (fieldMember instanceof Complex) {
            return this.scalarDivide((Complex)fieldMember);
        }
        if (fieldMember instanceof MathDouble) {
            return this.scalarDivide(((MathDouble)fieldMember).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexMatrix scalarDivide(Complex complex) {
        Complex[][] complexArray = new Complex[this.matrixRe.length][this.matrixRe[0].length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray[n][0] = new Complex(this.matrixRe[n][0], this.matrixIm[n][0]).divide(complex);
            int n2 = 1;
            while (n2 < complexArray[0].length) {
                complexArray[n][n2] = new Complex(this.matrixRe[n][n2], this.matrixIm[n][n2]).divide(complex);
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(complexArray);
    }

    public ComplexMatrix scalarDivide(double d) {
        double[][] dArray = new double[this.matrixRe.length][this.matrixRe[0].length];
        double[][] dArray2 = new double[this.matrixIm.length][this.matrixIm[0].length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n][0] = this.matrixRe[n][0] / d;
            dArray2[n][0] = this.matrixIm[n][0] / d;
            int n2 = 1;
            while (n2 < dArray[0].length) {
                dArray[n][n2] = this.matrixRe[n][n2] / d;
                dArray2[n][n2] = this.matrixIm[n][n2] / d;
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public ComplexVector multiply(ComplexVector complexVector) {
        if (this.matrixRe[0].length == complexVector.dimension()) {
            double[] dArray = new double[this.matrixRe.length];
            double[] dArray2 = new double[this.matrixIm.length];
            int n = 0;
            while (n < dArray.length) {
                Complex complex = complexVector.getComponent(0);
                dArray[n] = this.matrixRe[n][0] * complex.real() - this.matrixIm[n][0] * complex.imag();
                dArray2[n] = this.matrixIm[n][0] * complex.real() + this.matrixRe[n][0] * complex.imag();
                int n2 = 1;
                while (n2 < this.matrixRe[0].length) {
                    complex = complexVector.getComponent(n2);
                    int n3 = n;
                    dArray[n3] = dArray[n3] + (this.matrixRe[n][n2] * complex.real() - this.matrixIm[n][n2] * complex.imag());
                    int n4 = n;
                    dArray2[n4] = dArray2[n4] + (this.matrixIm[n][n2] * complex.real() + this.matrixRe[n][n2] * complex.imag());
                    ++n2;
                }
                ++n;
            }
            return new ComplexVector(dArray, dArray2);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public RingMember multiply(RingMember ringMember) {
        if (ringMember instanceof ComplexMatrix) {
            return this.multiply((ComplexMatrix)ringMember);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    public ComplexMatrix multiply(ComplexMatrix complexMatrix) {
        switch (complexMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(complexMatrix);
            }
        }
        if (this.matrixRe[0].length == complexMatrix.rows()) {
            double[][] dArray = new double[this.matrixRe.length][complexMatrix.columns()];
            double[][] dArray2 = new double[this.matrixIm.length][complexMatrix.columns()];
            int n = 0;
            while (n < dArray.length) {
                int n2 = 0;
                while (n2 < dArray[0].length) {
                    Complex complex = complexMatrix.getElement(0, n2);
                    dArray[n][n2] = this.matrixRe[n][0] * complex.real() - this.matrixIm[n][0] * complex.imag();
                    dArray2[n][n2] = this.matrixRe[n][0] * complex.imag() + this.matrixIm[n][0] * complex.real();
                    int n3 = 1;
                    while (n3 < this.matrixRe[0].length) {
                        complex = complexMatrix.getElement(n3, n2);
                        double[] dArray3 = dArray[n];
                        int n4 = n2;
                        dArray3[n4] = dArray3[n4] + (this.matrixRe[n][n3] * complex.real() - this.matrixIm[n][n3] * complex.imag());
                        double[] dArray4 = dArray2[n];
                        int n5 = n2;
                        dArray4[n5] = dArray4[n5] + (this.matrixRe[n][n3] * complex.imag() + this.matrixIm[n][n3] * complex.real());
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            if (dArray.length == dArray[0].length) {
                return new ComplexSquareMatrix(dArray, dArray2);
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private ComplexMatrix rawMultiply(ComplexMatrix complexMatrix) {
        if (this.matrixRe[0].length == complexMatrix.matrixRe.length) {
            double[][] dArray = new double[this.matrixRe.length][complexMatrix.matrixRe[0].length];
            double[][] dArray2 = new double[this.matrixIm.length][complexMatrix.matrixIm[0].length];
            int n = 0;
            while (n < dArray.length) {
                int n2 = 0;
                while (n2 < dArray[0].length) {
                    dArray[n][n2] = this.matrixRe[n][0] * complexMatrix.matrixRe[0][n2] - this.matrixIm[n][0] * complexMatrix.matrixIm[0][n2];
                    dArray2[n][n2] = this.matrixRe[n][0] * complexMatrix.matrixIm[0][n2] + this.matrixIm[n][0] * complexMatrix.matrixRe[0][n2];
                    int n3 = 1;
                    while (n3 < this.matrixRe[0].length) {
                        double[] dArray3 = dArray[n];
                        int n4 = n2;
                        dArray3[n4] = dArray3[n4] + (this.matrixRe[n][n3] * complexMatrix.matrixRe[n3][n2] - this.matrixIm[n][n3] * complexMatrix.matrixIm[n3][n2]);
                        double[] dArray4 = dArray2[n];
                        int n5 = n2;
                        dArray4[n5] = dArray4[n5] + (this.matrixRe[n][n3] * complexMatrix.matrixIm[n3][n2] + this.matrixIm[n][n3] * complexMatrix.matrixRe[n3][n2]);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            if (dArray.length == dArray[0].length) {
                return new ComplexSquareMatrix(dArray, dArray2);
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public ComplexMatrix hermitianAdjoint() {
        double[][] dArray = new double[this.matrixRe[0].length][this.matrixRe.length];
        double[][] dArray2 = new double[this.matrixIm[0].length][this.matrixIm.length];
        int n = 0;
        while (n < dArray[0].length) {
            dArray[0][n] = this.matrixRe[n][0];
            dArray2[0][n] = -this.matrixIm[n][0];
            int n2 = 1;
            while (n2 < dArray.length) {
                dArray[n2][n] = this.matrixRe[n][n2];
                dArray2[n2][n] = -this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public ComplexMatrix conjugate() {
        double[][] dArray = new double[this.matrixIm.length][this.matrixIm[0].length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n][0] = -this.matrixIm[n][0];
            int n2 = 1;
            while (n2 < dArray[0].length) {
                dArray[n][n2] = -this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(this.matrixRe, dArray);
    }

    public Matrix transpose() {
        double[][] dArray = new double[this.matrixRe[0].length][this.matrixRe.length];
        double[][] dArray2 = new double[this.matrixIm[0].length][this.matrixIm.length];
        int n = 0;
        while (n < dArray[0].length) {
            dArray[0][n] = this.matrixRe[n][0];
            dArray2[0][n] = this.matrixIm[n][0];
            int n2 = 1;
            while (n2 < dArray.length) {
                dArray[n2][n] = this.matrixRe[n][n2];
                dArray2[n2][n] = this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public ComplexMatrix mapElements(ComplexMapping complexMapping) {
        Complex[][] complexArray = new Complex[this.matrixRe.length][this.matrixRe[0].length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray[n][0] = complexMapping.map(this.matrixRe[n][0], this.matrixIm[n][0]);
            int n2 = 1;
            while (n2 < complexArray[0].length) {
                complexArray[n][n2] = complexMapping.map(this.matrixRe[n][n2], this.matrixIm[n][n2]);
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(complexArray);
    }
}

