/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.ArrayMath;
import JSci.maths.Complex;
import JSci.maths.ComplexDiagonalMatrix;
import JSci.maths.ComplexMapping;
import JSci.maths.ComplexMatrix;
import JSci.maths.ComplexVector;
import JSci.maths.DimensionException;
import JSci.maths.LinearMath;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;
import JSci.maths.MaximumIterationsExceededException;
import JSci.maths.algebras.CStarAlgebraMember;

public class ComplexSquareMatrix
extends ComplexMatrix
implements CStarAlgebraMember {
    protected transient ComplexSquareMatrix[] LU;
    protected transient int[] LUpivot;

    protected ComplexSquareMatrix() {
    }

    public ComplexSquareMatrix(int n) {
        super(n, n);
    }

    public ComplexSquareMatrix(double[][] dArray, double[][] dArray2) {
        super(dArray, dArray2);
        if (dArray.length != dArray[0].length && dArray2.length != dArray2[0].length) {
            this.matrixRe = null;
            this.matrixIm = null;
            throw new MatrixDimensionException("The arrays are not square.");
        }
    }

    public ComplexSquareMatrix(Complex[][] complexArray) {
        super(complexArray);
        if (complexArray.length != complexArray[0].length) {
            this.matrixRe = null;
            this.matrixIm = null;
            throw new MatrixDimensionException("The array is not square.");
        }
    }

    public ComplexSquareMatrix(ComplexVector[] complexVectorArray) {
        super(complexVectorArray);
        if (complexVectorArray.length != complexVectorArray[0].dimension()) {
            this.matrixRe = null;
            this.matrixIm = null;
            throw new MatrixDimensionException("The array does not form a square matrix.");
        }
    }

    public boolean isHermitian() {
        return this.equals(this.hermitianAdjoint());
    }

    public boolean isUnitary() {
        return this.multiply(this.hermitianAdjoint()).equals(ComplexDiagonalMatrix.identity(this.matrixRe[0].length));
    }

    public Complex det() {
        if (this.matrixRe.length == 2) {
            return new Complex(this.matrixRe[0][0] * this.matrixRe[1][1] - this.matrixIm[0][0] * this.matrixIm[1][1] - this.matrixRe[0][1] * this.matrixRe[1][0] + this.matrixIm[0][1] * this.matrixIm[1][0], this.matrixRe[0][0] * this.matrixIm[1][1] + this.matrixIm[0][0] * this.matrixRe[1][1] - this.matrixRe[0][1] * this.matrixIm[1][0] - this.matrixIm[0][1] * this.matrixRe[1][0]);
        }
        ComplexSquareMatrix[] complexSquareMatrixArray = this.luDecompose(null);
        double d = complexSquareMatrixArray[1].matrixRe[0][0];
        double d2 = complexSquareMatrixArray[1].matrixIm[0][0];
        int n = 1;
        while (n < this.matrixRe.length) {
            d = d * complexSquareMatrixArray[1].matrixRe[n][n] - d2 * complexSquareMatrixArray[1].matrixIm[n][n];
            d2 = d * complexSquareMatrixArray[1].matrixIm[n][n] + d2 * complexSquareMatrixArray[1].matrixRe[n][n];
            ++n;
        }
        return new Complex(d * (double)this.LUpivot[this.matrixRe.length], d2 * (double)this.LUpivot[this.matrixRe.length]);
    }

    public Complex trace() {
        double d = this.matrixRe[0][0];
        double d2 = this.matrixIm[0][0];
        int n = 1;
        while (n < this.matrixRe.length) {
            d += this.matrixRe[n][n];
            d2 += this.matrixIm[n][n];
            ++n;
        }
        return new Complex(d, d2);
    }

    public double norm() {
        try {
            return this.operatorNorm();
        }
        catch (MaximumIterationsExceededException maximumIterationsExceededException) {
            return 0.0;
        }
    }

    public double operatorNorm() throws MaximumIterationsExceededException {
        return Math.sqrt(ArrayMath.max(LinearMath.eigenvalueSolveHermitian((ComplexSquareMatrix)this.hermitianAdjoint().multiply(this))));
    }

    public ComplexMatrix add(ComplexMatrix complexMatrix) {
        switch (complexMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(complexMatrix);
            }
        }
        if (this.matrixRe.length == complexMatrix.rows() && this.matrixRe.length == complexMatrix.columns()) {
            double[][] dArray = new double[this.matrixRe.length][this.matrixRe.length];
            double[][] dArray2 = new double[this.matrixIm.length][this.matrixIm.length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrixRe[n][0] + complexMatrix.getElement(n, 0).real();
                dArray2[n][0] = this.matrixIm[n][0] + complexMatrix.getElement(n, 0).imag();
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.matrixRe[n][n2] + complexMatrix.getElement(n, n2).real();
                    dArray2[n][n2] = this.matrixIm[n][n2] + complexMatrix.getElement(n, n2).imag();
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexSquareMatrix rawAdd(ComplexMatrix complexMatrix) {
        if (this.matrixRe.length == complexMatrix.matrixRe.length && this.matrixRe.length == complexMatrix.matrixRe[0].length) {
            double[][] dArray = new double[this.matrixRe.length][this.matrixRe.length];
            double[][] dArray2 = new double[this.matrixIm.length][this.matrixIm.length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrixRe[n][0] + complexMatrix.matrixRe[n][0];
                dArray2[n][0] = this.matrixIm[n][0] + complexMatrix.matrixIm[n][0];
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.matrixRe[n][n2] + complexMatrix.matrixRe[n][n2];
                    dArray2[n][n2] = this.matrixIm[n][n2] + complexMatrix.matrixIm[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix add(ComplexSquareMatrix complexSquareMatrix) {
        switch (complexSquareMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(complexSquareMatrix);
            }
        }
        if (this.matrixRe.length == complexSquareMatrix.rows()) {
            double[][] dArray = new double[this.matrixRe.length][this.matrixRe.length];
            double[][] dArray2 = new double[this.matrixIm.length][this.matrixIm.length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrixRe[n][0] + complexSquareMatrix.getElement(n, 0).real();
                dArray2[n][0] = this.matrixIm[n][0] + complexSquareMatrix.getElement(n, 0).imag();
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.matrixRe[n][n2] + complexSquareMatrix.getElement(n, n2).real();
                    dArray2[n][n2] = this.matrixIm[n][n2] + complexSquareMatrix.getElement(n, n2).imag();
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexMatrix subtract(ComplexMatrix complexMatrix) {
        switch (complexMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(complexMatrix);
            }
        }
        if (this.matrixRe.length == complexMatrix.rows() && this.matrixRe.length == complexMatrix.columns()) {
            double[][] dArray = new double[this.matrixRe.length][this.matrixRe.length];
            double[][] dArray2 = new double[this.matrixIm.length][this.matrixIm.length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrixRe[n][0] - complexMatrix.getElement(n, 0).real();
                dArray2[n][0] = this.matrixIm[n][0] - complexMatrix.getElement(n, 0).imag();
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.matrixRe[n][n2] - complexMatrix.getElement(n, n2).real();
                    dArray2[n][n2] = this.matrixIm[n][n2] - complexMatrix.getElement(n, n2).imag();
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexSquareMatrix rawSubtract(ComplexMatrix complexMatrix) {
        if (this.matrixRe.length == complexMatrix.matrixRe.length && this.matrixRe.length == complexMatrix.matrixRe[0].length) {
            double[][] dArray = new double[this.matrixRe.length][this.matrixRe.length];
            double[][] dArray2 = new double[this.matrixIm.length][this.matrixIm.length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrixRe[n][0] - complexMatrix.matrixRe[n][0];
                dArray2[n][0] = this.matrixIm[n][0] - complexMatrix.matrixIm[n][0];
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.matrixRe[n][n2] - complexMatrix.matrixRe[n][n2];
                    dArray2[n][n2] = this.matrixIm[n][n2] - complexMatrix.matrixIm[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix subtract(ComplexSquareMatrix complexSquareMatrix) {
        switch (complexSquareMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(complexSquareMatrix);
            }
        }
        if (this.matrixRe.length == complexSquareMatrix.rows()) {
            double[][] dArray = new double[this.matrixRe.length][this.matrixRe.length];
            double[][] dArray2 = new double[this.matrixIm.length][this.matrixIm.length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrixRe[n][0] - complexSquareMatrix.getElement(n, 0).real();
                dArray2[n][0] = this.matrixIm[n][0] - complexSquareMatrix.getElement(n, 0).imag();
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.matrixRe[n][n2] - complexSquareMatrix.getElement(n, n2).real();
                    dArray2[n][n2] = this.matrixIm[n][n2] - complexSquareMatrix.getElement(n, n2).imag();
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexMatrix scalarMultiply(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        double[][] dArray = new double[this.matrixRe.length][this.matrixRe.length];
        double[][] dArray2 = new double[this.matrixIm.length][this.matrixIm.length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n][0] = this.matrixRe[n][0] * d - this.matrixIm[n][0] * d2;
            dArray2[n][0] = this.matrixRe[n][0] * d2 + this.matrixIm[n][0] * d;
            int n2 = 1;
            while (n2 < dArray.length) {
                dArray[n][n2] = this.matrixRe[n][n2] * d - this.matrixIm[n][n2] * d2;
                dArray2[n][n2] = this.matrixRe[n][n2] * d2 + this.matrixIm[n][n2] * d;
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public ComplexMatrix scalarMultiply(double d) {
        double[][] dArray = new double[this.matrixRe.length][this.matrixRe.length];
        double[][] dArray2 = new double[this.matrixIm.length][this.matrixIm.length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n][0] = d * this.matrixRe[n][0];
            dArray2[n][0] = d * this.matrixIm[n][0];
            int n2 = 1;
            while (n2 < dArray.length) {
                dArray[n][n2] = d * this.matrixRe[n][n2];
                dArray2[n][n2] = d * this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public ComplexVector multiply(ComplexVector complexVector) {
        if (this.matrixRe.length == complexVector.dimension()) {
            double[] dArray = new double[this.matrixRe.length];
            double[] dArray2 = new double[this.matrixIm.length];
            int n = 0;
            while (n < dArray.length) {
                Complex complex = complexVector.getComponent(0);
                dArray[n] = this.matrixRe[n][0] * complex.real() - this.matrixIm[n][0] * complex.imag();
                dArray2[n] = this.matrixIm[n][0] * complex.real() + this.matrixRe[n][0] * complex.imag();
                int n2 = 1;
                while (n2 < this.matrixRe.length) {
                    complex = complexVector.getComponent(n2);
                    int n3 = n;
                    dArray[n3] = dArray[n3] + (this.matrixRe[n][n2] * complex.real() - this.matrixIm[n][n2] * complex.imag());
                    int n4 = n;
                    dArray2[n4] = dArray2[n4] + (this.matrixIm[n][n2] * complex.real() + this.matrixRe[n][n2] * complex.imag());
                    ++n2;
                }
                ++n;
            }
            return new ComplexVector(dArray, dArray2);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public ComplexSquareMatrix multiply(ComplexSquareMatrix complexSquareMatrix) {
        switch (complexSquareMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(complexSquareMatrix);
            }
        }
        if (this.matrixRe.length == complexSquareMatrix.rows()) {
            double[][] dArray = new double[this.matrixRe.length][this.matrixRe.length];
            double[][] dArray2 = new double[this.matrixIm.length][this.matrixIm.length];
            int n = 0;
            while (n < dArray.length) {
                int n2 = 0;
                while (n2 < dArray.length) {
                    Complex complex = complexSquareMatrix.getElement(0, n2);
                    dArray[n][n2] = this.matrixRe[n][0] * complex.real() - this.matrixIm[n][0] * complex.imag();
                    dArray2[n][n2] = this.matrixIm[n][0] * complex.real() + this.matrixRe[n][0] * complex.imag();
                    int n3 = 1;
                    while (n3 < dArray.length) {
                        complex = complexSquareMatrix.getElement(n3, n2);
                        double[] dArray3 = dArray[n];
                        int n4 = n2;
                        dArray3[n4] = dArray3[n4] + (this.matrixRe[n][n3] * complex.real() - this.matrixIm[n][n3] * complex.imag());
                        double[] dArray4 = dArray2[n];
                        int n5 = n2;
                        dArray4[n5] = dArray4[n5] + (this.matrixIm[n][n3] * complex.real() + this.matrixRe[n][n3] * complex.imag());
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private ComplexSquareMatrix rawMultiply(ComplexSquareMatrix complexSquareMatrix) {
        if (this.matrixRe.length == complexSquareMatrix.matrixRe.length) {
            double[][] dArray = new double[this.matrixRe.length][this.matrixRe.length];
            double[][] dArray2 = new double[this.matrixIm.length][this.matrixIm.length];
            int n = 0;
            while (n < dArray.length) {
                int n2 = 0;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.matrixRe[n][0] * complexSquareMatrix.matrixRe[0][n2] - this.matrixIm[n][0] * complexSquareMatrix.matrixIm[0][n2];
                    dArray2[n][n2] = this.matrixIm[n][0] * complexSquareMatrix.matrixRe[0][n2] + this.matrixRe[n][0] * complexSquareMatrix.matrixIm[0][n2];
                    int n3 = 1;
                    while (n3 < dArray.length) {
                        double[] dArray3 = dArray[n];
                        int n4 = n2;
                        dArray3[n4] = dArray3[n4] + (this.matrixRe[n][n3] * complexSquareMatrix.matrixRe[n3][n2] - this.matrixIm[n][n3] * complexSquareMatrix.matrixIm[n3][n2]);
                        double[] dArray4 = dArray2[n];
                        int n5 = n2;
                        dArray4[n5] = dArray4[n5] + (this.matrixIm[n][n3] * complexSquareMatrix.matrixRe[n3][n2] + this.matrixRe[n][n3] * complexSquareMatrix.matrixIm[n3][n2]);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public CStarAlgebraMember involution() {
        return (ComplexSquareMatrix)this.hermitianAdjoint();
    }

    public ComplexMatrix hermitianAdjoint() {
        double[][] dArray = new double[this.matrixRe.length][this.matrixRe.length];
        double[][] dArray2 = new double[this.matrixIm.length][this.matrixIm.length];
        int n = 0;
        while (n < dArray.length) {
            dArray[0][n] = this.matrixRe[n][0];
            dArray2[0][n] = -this.matrixIm[n][0];
            int n2 = 1;
            while (n2 < dArray.length) {
                dArray[n2][n] = this.matrixRe[n][n2];
                dArray2[n2][n] = -this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public ComplexMatrix conjugate() {
        double[][] dArray = new double[this.matrixIm.length][this.matrixIm.length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n][0] = -this.matrixIm[n][0];
            int n2 = 1;
            while (n2 < dArray.length) {
                dArray[n][n2] = -this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(this.matrixRe, dArray);
    }

    public Matrix transpose() {
        double[][] dArray = new double[this.matrixRe.length][this.matrixRe.length];
        double[][] dArray2 = new double[this.matrixIm.length][this.matrixIm.length];
        int n = 0;
        while (n < dArray.length) {
            dArray[0][n] = this.matrixRe[n][0];
            dArray2[0][n] = this.matrixIm[n][0];
            int n2 = 1;
            while (n2 < dArray.length) {
                dArray[n2][n] = this.matrixRe[n][n2];
                dArray2[n2][n] = this.matrixIm[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(dArray, dArray2);
    }

    public ComplexSquareMatrix inverse() {
        int n;
        int n2;
        double[][] dArray = new double[this.matrixRe.length][this.matrixRe.length];
        double[][] dArray2 = new double[this.matrixIm.length][this.matrixIm.length];
        double[][] dArray3 = new double[this.matrixRe.length][this.matrixRe.length];
        double[][] dArray4 = new double[this.matrixIm.length][this.matrixIm.length];
        ComplexSquareMatrix[] complexSquareMatrixArray = this.luDecompose(null);
        double d = complexSquareMatrixArray[0].matrixRe[0][0] * complexSquareMatrixArray[0].matrixRe[0][0] + complexSquareMatrixArray[0].matrixIm[0][0] * complexSquareMatrixArray[0].matrixIm[0][0];
        dArray[0][0] = complexSquareMatrixArray[0].matrixRe[0][0] / d;
        dArray2[0][0] = -complexSquareMatrixArray[0].matrixIm[0][0] / d;
        d = complexSquareMatrixArray[1].matrixRe[0][0] * complexSquareMatrixArray[1].matrixRe[0][0] + complexSquareMatrixArray[1].matrixIm[0][0] * complexSquareMatrixArray[1].matrixIm[0][0];
        dArray3[0][0] = complexSquareMatrixArray[1].matrixRe[0][0] / d;
        dArray4[0][0] = -complexSquareMatrixArray[1].matrixIm[0][0] / d;
        int n3 = 1;
        while (n3 < this.matrixRe.length) {
            d = complexSquareMatrixArray[0].matrixRe[n3][n3] * complexSquareMatrixArray[0].matrixRe[n3][n3] + complexSquareMatrixArray[0].matrixIm[n3][n3] * complexSquareMatrixArray[0].matrixIm[n3][n3];
            dArray[n3][n3] = complexSquareMatrixArray[0].matrixRe[n3][n3] / d;
            dArray2[n3][n3] = -complexSquareMatrixArray[0].matrixIm[n3][n3] / d;
            d = complexSquareMatrixArray[1].matrixRe[n3][n3] * complexSquareMatrixArray[1].matrixRe[n3][n3] + complexSquareMatrixArray[1].matrixIm[n3][n3] * complexSquareMatrixArray[1].matrixIm[n3][n3];
            dArray3[n3][n3] = complexSquareMatrixArray[1].matrixRe[n3][n3] / d;
            dArray4[n3][n3] = -complexSquareMatrixArray[1].matrixIm[n3][n3] / d;
            ++n3;
        }
        n3 = 0;
        while (n3 < this.matrixRe.length - 1) {
            n2 = n3 + 1;
            while (n2 < this.matrixRe.length) {
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                n = n3;
                while (n < n2) {
                    d3 -= complexSquareMatrixArray[0].matrixRe[n2][n] * dArray[n][n3] - complexSquareMatrixArray[0].matrixIm[n2][n] * dArray2[n][n3];
                    d2 -= complexSquareMatrixArray[0].matrixIm[n2][n] * dArray[n][n3] + complexSquareMatrixArray[0].matrixRe[n2][n] * dArray2[n][n3];
                    d5 -= dArray3[n3][n] * complexSquareMatrixArray[1].matrixRe[n][n2] - dArray4[n3][n] * complexSquareMatrixArray[1].matrixIm[n][n2];
                    d4 -= dArray4[n3][n] * complexSquareMatrixArray[1].matrixRe[n][n2] + dArray3[n3][n] * complexSquareMatrixArray[1].matrixIm[n][n2];
                    ++n;
                }
                d = complexSquareMatrixArray[0].matrixRe[n2][n2] * complexSquareMatrixArray[0].matrixRe[n2][n2] + complexSquareMatrixArray[0].matrixIm[n2][n2] * complexSquareMatrixArray[0].matrixIm[n2][n2];
                dArray[n2][n3] = (d3 * complexSquareMatrixArray[0].matrixRe[n2][n2] + d2 * complexSquareMatrixArray[0].matrixIm[n2][n2]) / d;
                dArray2[n2][n3] = (d2 * complexSquareMatrixArray[0].matrixRe[n2][n2] - d3 * complexSquareMatrixArray[0].matrixIm[n2][n2]) / d;
                d = complexSquareMatrixArray[1].matrixRe[n2][n2] * complexSquareMatrixArray[1].matrixRe[n2][n2] + complexSquareMatrixArray[1].matrixIm[n2][n2] * complexSquareMatrixArray[1].matrixIm[n2][n2];
                dArray3[n3][n2] = (d5 * complexSquareMatrixArray[1].matrixRe[n2][n2] + d4 * complexSquareMatrixArray[1].matrixIm[n2][n2]) / d;
                dArray4[n3][n2] = (d4 * complexSquareMatrixArray[1].matrixRe[n2][n2] - d5 * complexSquareMatrixArray[1].matrixIm[n2][n2]) / d;
                ++n2;
            }
            ++n3;
        }
        double[][] dArray5 = new double[this.matrixRe.length][this.matrixRe.length];
        double[][] dArray6 = new double[this.matrixIm.length][this.matrixIm.length];
        n3 = 0;
        while (n3 < this.matrixRe.length) {
            n2 = 0;
            while (n2 < n3) {
                n = n3;
                while (n < this.matrixRe.length) {
                    double[] dArray7 = dArray5[n3];
                    int n4 = this.LUpivot[n2];
                    dArray7[n4] = dArray7[n4] + (dArray3[n3][n] * dArray[n][n2] - dArray4[n3][n] * dArray2[n][n2]);
                    double[] dArray8 = dArray6[n3];
                    int n5 = this.LUpivot[n2];
                    dArray8[n5] = dArray8[n5] + (dArray4[n3][n] * dArray[n][n2] + dArray3[n3][n] * dArray2[n][n2]);
                    ++n;
                }
                ++n2;
            }
            n2 = n3;
            while (n2 < this.matrixRe.length) {
                n = n2;
                while (n < this.matrixRe.length) {
                    double[] dArray9 = dArray5[n3];
                    int n6 = this.LUpivot[n2];
                    dArray9[n6] = dArray9[n6] + (dArray3[n3][n] * dArray[n][n2] - dArray4[n3][n] * dArray2[n][n2]);
                    double[] dArray10 = dArray6[n3];
                    int n7 = this.LUpivot[n2];
                    dArray10[n7] = dArray10[n7] + (dArray4[n3][n] * dArray[n][n2] + dArray3[n3][n] * dArray2[n][n2]);
                    ++n;
                }
                ++n2;
            }
            ++n3;
        }
        return new ComplexSquareMatrix(dArray5, dArray6);
    }

    public ComplexSquareMatrix[] luDecompose(int[] nArray) {
        if (this.LU != null) {
            if (nArray != null) {
                System.arraycopy(this.LUpivot, 0, nArray, 0, nArray.length);
            }
            return this.LU;
        }
        double[][] dArray = new double[this.matrixRe.length][this.matrixRe.length];
        double[][] dArray2 = new double[this.matrixIm.length][this.matrixIm.length];
        double[][] dArray3 = new double[this.matrixRe.length][this.matrixRe.length];
        double[][] dArray4 = new double[this.matrixIm.length][this.matrixIm.length];
        double[] dArray5 = new double[this.matrixRe.length];
        if (nArray == null) {
            nArray = new int[this.matrixRe.length + 1];
        }
        int n = 0;
        while (n < this.matrixRe.length) {
            nArray[n] = n;
            ++n;
        }
        nArray[this.matrixRe.length] = 1;
        int n2 = 0;
        while (n2 < this.matrixRe.length) {
            double d;
            double d2;
            int n3;
            double d3;
            double d4;
            n = 0;
            while (n < n2) {
                d4 = this.matrixRe[nArray[n]][n2];
                d3 = this.matrixIm[nArray[n]][n2];
                n3 = 0;
                while (n3 < n) {
                    d4 -= dArray3[n][n3] * dArray3[n3][n2] - dArray4[n][n3] * dArray4[n3][n2];
                    d3 -= dArray4[n][n3] * dArray3[n3][n2] + dArray3[n][n3] * dArray4[n3][n2];
                    ++n3;
                }
                dArray3[n][n2] = d4;
                dArray4[n][n2] = d3;
                ++n;
            }
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            int n4 = n2;
            n = n2;
            while (n < this.matrixRe.length) {
                d4 = this.matrixRe[nArray[n]][n2];
                d3 = this.matrixIm[nArray[n]][n2];
                n3 = 0;
                while (n3 < n2) {
                    d4 -= dArray3[n][n3] * dArray3[n3][n2] - dArray4[n][n3] * dArray4[n3][n2];
                    d3 -= dArray4[n][n3] * dArray3[n3][n2] + dArray3[n][n3] * dArray4[n3][n2];
                    ++n3;
                }
                dArray3[n][n2] = d4;
                dArray4[n][n2] = d3;
                double d8 = d4 * d4 + d3 * d3;
                if (d8 > d5) {
                    d5 = d8;
                    d6 = d4;
                    d7 = d3;
                    n4 = n;
                }
                ++n;
            }
            if (n4 != n2) {
                System.arraycopy(dArray3[n2], 0, dArray5, 0, n2 + 1);
                System.arraycopy(dArray3[n4], 0, dArray3[n2], 0, n2 + 1);
                System.arraycopy(dArray5, 0, dArray3[n4], 0, n2 + 1);
                System.arraycopy(dArray4[n2], 0, dArray5, 0, n2 + 1);
                System.arraycopy(dArray4[n4], 0, dArray4[n2], 0, n2 + 1);
                System.arraycopy(dArray5, 0, dArray4[n4], 0, n2 + 1);
                n3 = nArray[n2];
                nArray[n2] = nArray[n4];
                nArray[n4] = n3;
                nArray[this.matrixRe.length] = -nArray[this.matrixRe.length];
            }
            if (Math.abs(d6) < Math.abs(d7)) {
                d2 = d6 / d7;
                d = d6 * d2 + d7;
                n = n2 + 1;
                while (n < this.matrixRe.length) {
                    d4 = (dArray3[n][n2] * d2 + dArray4[n][n2]) / d;
                    dArray4[n][n2] = (dArray4[n][n2] * d2 - dArray3[n][n2]) / d;
                    dArray3[n][n2] = d4;
                    ++n;
                }
            } else {
                d2 = d7 / d6;
                d = d6 + d7 * d2;
                n = n2 + 1;
                while (n < this.matrixRe.length) {
                    d4 = (dArray3[n][n2] + dArray4[n][n2] * d2) / d;
                    dArray4[n][n2] = (dArray4[n][n2] - dArray3[n][n2] * d2) / d;
                    dArray3[n][n2] = d4;
                    ++n;
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.matrixRe.length) {
            dArray[n2][n2] = 1.0;
            n = n2 + 1;
            while (n < this.matrixRe.length) {
                dArray[n][n2] = dArray3[n][n2];
                dArray2[n][n2] = dArray4[n][n2];
                dArray3[n][n2] = 0.0;
                dArray4[n][n2] = 0.0;
                ++n;
            }
            ++n2;
        }
        this.LU = new ComplexSquareMatrix[2];
        this.LU[0] = new ComplexSquareMatrix(dArray, dArray2);
        this.LU[1] = new ComplexSquareMatrix(dArray3, dArray4);
        this.LUpivot = new int[nArray.length];
        System.arraycopy(nArray, 0, this.LUpivot, 0, nArray.length);
        return this.LU;
    }

    public ComplexSquareMatrix[] polarDecompose() {
        Complex complex;
        double[] dArray;
        ComplexVector[] complexVectorArray = new ComplexVector[this.matrixRe.length];
        try {
            dArray = LinearMath.eigenSolveHermitian(this, complexVectorArray);
        }
        catch (MaximumIterationsExceededException maximumIterationsExceededException) {
            return null;
        }
        double[][] dArray2 = new double[this.matrixRe.length][this.matrixRe.length];
        double[][] dArray3 = new double[this.matrixIm.length][this.matrixIm.length];
        double[][] dArray4 = new double[this.matrixRe.length][this.matrixRe.length];
        double[][] dArray5 = new double[this.matrixIm.length][this.matrixIm.length];
        int n = 0;
        while (n < this.matrixRe.length) {
            double d = Math.abs(dArray[n]);
            complex = complexVectorArray[n].getComponent(0).conjugate();
            dArray2[n][0] = dArray[n] * complex.real() / d;
            dArray3[n][0] = dArray[n] * complex.imag() / d;
            dArray4[n][0] = d * complex.real();
            dArray5[n][0] = d * complex.imag();
            int n2 = 1;
            while (n2 < this.matrixRe.length) {
                complex = complexVectorArray[n].getComponent(n2).conjugate();
                dArray2[n][n2] = dArray[n] * complex.real() / d;
                dArray3[n][n2] = dArray[n] * complex.imag() / d;
                dArray4[n][n2] = d * complex.real();
                dArray5[n][n2] = d * complex.imag();
                ++n2;
            }
            ++n;
        }
        double[][] dArray6 = new double[this.matrixRe.length][this.matrixRe.length];
        double[][] dArray7 = new double[this.matrixIm.length][this.matrixIm.length];
        double[][] dArray8 = new double[this.matrixRe.length][this.matrixRe.length];
        double[][] dArray9 = new double[this.matrixIm.length][this.matrixIm.length];
        int n3 = 0;
        while (n3 < this.matrixRe.length) {
            int n4 = 0;
            while (n4 < this.matrixRe.length) {
                complex = complexVectorArray[0].getComponent(n3);
                dArray6[n3][n4] = dArray2[0][n4] * complex.real() - dArray3[0][n4] * complex.imag();
                dArray7[n3][n4] = dArray3[0][n4] * complex.real() + dArray2[0][n4] * complex.imag();
                dArray8[n3][n4] = dArray4[0][n4] * complex.real() - dArray5[0][n4] * complex.imag();
                dArray9[n3][n4] = dArray5[0][n4] * complex.real() + dArray4[0][n4] * complex.imag();
                int n5 = 1;
                while (n5 < this.matrixRe.length) {
                    complex = complexVectorArray[n5].getComponent(n3);
                    double[] dArray10 = dArray6[n3];
                    int n6 = n4;
                    dArray10[n6] = dArray10[n6] + (dArray2[n5][n4] * complex.real() - dArray3[n5][n4] * complex.imag());
                    double[] dArray11 = dArray7[n3];
                    int n7 = n4;
                    dArray11[n7] = dArray11[n7] + (dArray3[n5][n4] * complex.real() + dArray2[n5][n4] * complex.imag());
                    double[] dArray12 = dArray8[n3];
                    int n8 = n4;
                    dArray12[n8] = dArray12[n8] + (dArray4[n5][n4] * complex.real() - dArray5[n5][n4] * complex.imag());
                    double[] dArray13 = dArray9[n3];
                    int n9 = n4;
                    dArray13[n9] = dArray13[n9] + (dArray5[n5][n4] * complex.real() + dArray4[n5][n4] * complex.imag());
                    ++n5;
                }
                ++n4;
            }
            ++n3;
        }
        ComplexSquareMatrix[] complexSquareMatrixArray = new ComplexSquareMatrix[]{new ComplexSquareMatrix(dArray6, dArray7), new ComplexSquareMatrix(dArray8, dArray9)};
        return complexSquareMatrixArray;
    }

    public ComplexMatrix mapElements(ComplexMapping complexMapping) {
        Complex[][] complexArray = new Complex[this.matrixRe.length][this.matrixRe.length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray[n][0] = complexMapping.map(this.matrixRe[n][0], this.matrixIm[n][0]);
            int n2 = 1;
            while (n2 < complexArray.length) {
                complexArray[n][n2] = complexMapping.map(this.matrixRe[n][n2], this.matrixIm[n][n2]);
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(complexArray);
    }
}

