/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.algebras;

import JSci.maths.Complex;
import JSci.maths.ComplexMatrix;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.algebras.LieAlgebra;
import JSci.maths.fields.ComplexField;

public final class so3_1Dim4
extends LieAlgebra {
    private static final Complex[][] t1 = new Complex[][]{{Complex.ZERO, Complex.ZERO, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, Complex.ZERO, ComplexField.MINUS_I}, {Complex.ZERO, Complex.ZERO, Complex.I, Complex.ZERO}};
    private static final Complex[][] t2 = new Complex[][]{{Complex.ZERO, Complex.ZERO, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, Complex.ZERO, Complex.I}, {Complex.ZERO, Complex.ZERO, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, ComplexField.MINUS_I, Complex.ZERO, Complex.ZERO}};
    private static final Complex[][] t3 = new Complex[][]{{Complex.ZERO, Complex.ZERO, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, ComplexField.MINUS_I, Complex.ZERO}, {Complex.ZERO, Complex.I, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, Complex.ZERO, Complex.ZERO}};
    private static final Complex[][] t4 = new Complex[][]{{Complex.ZERO, ComplexField.MINUS_I, Complex.ZERO, Complex.ZERO}, {ComplexField.MINUS_I, Complex.ZERO, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, Complex.ZERO, Complex.ZERO}};
    private static final Complex[][] t5 = new Complex[][]{{Complex.ZERO, Complex.ZERO, ComplexField.MINUS_I, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, Complex.ZERO, Complex.ZERO}, {ComplexField.MINUS_I, Complex.ZERO, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, Complex.ZERO, Complex.ZERO}};
    private static final Complex[][] t6 = new Complex[][]{{Complex.ZERO, Complex.ZERO, Complex.ZERO, ComplexField.MINUS_I}, {Complex.ZERO, Complex.ZERO, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, Complex.ZERO, Complex.ZERO}, {ComplexField.MINUS_I, Complex.ZERO, Complex.ZERO, Complex.ZERO}};
    private static final ComplexSquareMatrix[] basisMatrices = new ComplexSquareMatrix[]{new ComplexSquareMatrix(t1), new ComplexSquareMatrix(t2), new ComplexSquareMatrix(t3), new ComplexSquareMatrix(t4), new ComplexSquareMatrix(t5), new ComplexSquareMatrix(t6)};

    public so3_1Dim4() {
        super("so(3,1) [4]");
    }

    public ComplexSquareMatrix getElement(DoubleVector doubleVector) {
        ComplexMatrix complexMatrix = basisMatrices[0].scalarMultiply(doubleVector.getComponent(0));
        complexMatrix = complexMatrix.add(basisMatrices[1].scalarMultiply(doubleVector.getComponent(1)));
        complexMatrix = complexMatrix.add(basisMatrices[2].scalarMultiply(doubleVector.getComponent(2)));
        complexMatrix = complexMatrix.add(basisMatrices[3].scalarMultiply(doubleVector.getComponent(3)));
        complexMatrix = complexMatrix.add(basisMatrices[4].scalarMultiply(doubleVector.getComponent(4)));
        complexMatrix = complexMatrix.add(basisMatrices[5].scalarMultiply(doubleVector.getComponent(5)));
        return (ComplexSquareMatrix)complexMatrix.scalarMultiply(Complex.I);
    }

    public DoubleVector multiply(DoubleVector doubleVector, DoubleVector doubleVector2) {
        double[] dArray = new double[]{doubleVector.getComponent(2) * doubleVector2.getComponent(1) - doubleVector.getComponent(1) * doubleVector2.getComponent(2) + doubleVector.getComponent(4) * doubleVector2.getComponent(5) - doubleVector.getComponent(5) * doubleVector2.getComponent(4), doubleVector.getComponent(0) * doubleVector2.getComponent(2) - doubleVector.getComponent(2) * doubleVector2.getComponent(0) + doubleVector.getComponent(5) * doubleVector2.getComponent(3) - doubleVector.getComponent(3) * doubleVector2.getComponent(5), doubleVector.getComponent(1) * doubleVector2.getComponent(0) - doubleVector.getComponent(0) * doubleVector2.getComponent(1) + doubleVector.getComponent(3) * doubleVector2.getComponent(4) - doubleVector.getComponent(4) * doubleVector2.getComponent(3), doubleVector.getComponent(2) * doubleVector2.getComponent(4) - doubleVector.getComponent(1) * doubleVector2.getComponent(5) + doubleVector.getComponent(5) * doubleVector2.getComponent(1) - doubleVector.getComponent(4) * doubleVector2.getComponent(2), doubleVector.getComponent(0) * doubleVector2.getComponent(5) - doubleVector.getComponent(2) * doubleVector2.getComponent(3) + doubleVector.getComponent(3) * doubleVector2.getComponent(2) - doubleVector.getComponent(5) * doubleVector2.getComponent(0), doubleVector.getComponent(1) * doubleVector2.getComponent(3) - doubleVector.getComponent(0) * doubleVector2.getComponent(4) + doubleVector.getComponent(4) * doubleVector2.getComponent(0) - doubleVector.getComponent(3) * doubleVector2.getComponent(1)};
        return new DoubleVector(dArray);
    }

    public ComplexSquareMatrix[] basis() {
        return basisMatrices;
    }
}

