/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import org.biojava.bio.Annotatable;
import org.biojava.bio.Annotation;
import org.biojava.bio.search.SeqSimilaritySearchSubHit;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.Alignment;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ObjectUtil;

public class SimpleSeqSimilaritySearchSubHit
extends AbstractChangeable
implements SeqSimilaritySearchSubHit {
    protected transient Annotatable.AnnotationForwarder annotationForwarder;
    private double score;
    private double pValue;
    private double eValue;
    private int queryStart;
    private int queryEnd;
    private StrandedFeature.Strand queryStrand;
    private int subjectStart;
    private int subjectEnd;
    private StrandedFeature.Strand subjectStrand;
    private Alignment alignment;
    private Annotation annotation;
    private int hc;
    private boolean hcCalc;

    public SimpleSeqSimilaritySearchSubHit(double score, double eValue, double pValue, int queryStart, int queryEnd, StrandedFeature.Strand queryStrand, int subjectStart, int subjectEnd, StrandedFeature.Strand subjectStrand, Alignment alignment, Annotation annotation) {
        if (Double.isNaN(score)) {
            throw new IllegalArgumentException("score was NaN");
        }
        if (alignment == null) {
            throw new IllegalArgumentException("alignment was null");
        }
        if (annotation == null) {
            throw new IllegalArgumentException("annotation was null");
        }
        alignment.addChangeListener(ChangeListener.ALWAYS_VETO);
        annotation.addChangeListener(ChangeListener.ALWAYS_VETO);
        this.score = score;
        this.eValue = eValue;
        this.pValue = pValue;
        this.queryStart = queryStart;
        this.queryEnd = queryEnd;
        this.queryStrand = queryStrand;
        this.subjectStart = subjectStart;
        this.subjectEnd = subjectEnd;
        this.subjectStrand = subjectStrand;
        this.alignment = alignment;
        this.annotation = annotation;
        this.hcCalc = false;
    }

    public double getScore() {
        return this.score;
    }

    public double getPValue() {
        return this.pValue;
    }

    public double getEValue() {
        return this.eValue;
    }

    public int getQueryStart() {
        return this.queryStart;
    }

    public int getQueryEnd() {
        return this.queryEnd;
    }

    public StrandedFeature.Strand getQueryStrand() {
        return this.queryStrand;
    }

    public int getSubjectStart() {
        return this.subjectStart;
    }

    public int getSubjectEnd() {
        return this.subjectEnd;
    }

    public StrandedFeature.Strand getSubjectStrand() {
        return this.subjectStrand;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        SimpleSeqSimilaritySearchSubHit that = (SimpleSeqSimilaritySearchSubHit)other;
        if (!ObjectUtil.equals(this.score, that.score)) {
            return false;
        }
        if (!ObjectUtil.equals(this.pValue, that.pValue)) {
            return false;
        }
        if (!ObjectUtil.equals(this.eValue, that.eValue)) {
            return false;
        }
        if (!ObjectUtil.equals(this.queryStart, that.queryStart)) {
            return false;
        }
        if (!ObjectUtil.equals(this.queryEnd, that.queryEnd)) {
            return false;
        }
        if (!ObjectUtil.equals(this.queryStrand, that.queryStrand)) {
            return false;
        }
        if (!ObjectUtil.equals(this.subjectStart, that.subjectStart)) {
            return false;
        }
        if (!ObjectUtil.equals(this.subjectEnd, that.subjectEnd)) {
            return false;
        }
        if (!ObjectUtil.equals(this.subjectStrand, that.subjectStrand)) {
            return false;
        }
        return ObjectUtil.equals(this.annotation, that.annotation);
    }

    public int hashCode() {
        if (!this.hcCalc) {
            this.hc = ObjectUtil.hashCode(this.hc, this.score);
            this.hc = ObjectUtil.hashCode(this.hc, this.pValue);
            this.hc = ObjectUtil.hashCode(this.hc, this.eValue);
            this.hc = ObjectUtil.hashCode(this.hc, this.queryStart);
            this.hc = ObjectUtil.hashCode(this.hc, this.queryEnd);
            this.hc = ObjectUtil.hashCode(this.hc, this.queryStrand);
            this.hc = ObjectUtil.hashCode(this.hc, this.subjectStart);
            this.hc = ObjectUtil.hashCode(this.hc, this.subjectEnd);
            this.hc = ObjectUtil.hashCode(this.hc, this.subjectStrand);
            this.hc = ObjectUtil.hashCode(this.hc, this.annotation);
            this.hcCalc = true;
        }
        return this.hc;
    }

    public String toString() {
        return "SimpleSeqSimilaritySearchSubHit with score " + this.getScore();
    }

    protected ChangeSupport getChangeSupport(ChangeType ct) {
        ChangeSupport cs = super.getChangeSupport(ct);
        if (this.annotationForwarder == null && (ct.isMatchingType(Annotatable.ANNOTATION) || Annotatable.ANNOTATION.isMatchingType(ct))) {
            this.annotationForwarder = new Annotatable.AnnotationForwarder(this, cs);
            this.getAnnotation().addChangeListener(this.annotationForwarder, Annotatable.ANNOTATION);
        }
        return cs;
    }
}

