/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Symbol;

class SeqIOEventEmitter {
    private static Symbol[] symProto = new Symbol[0];
    private Comparator seqPropComparator;
    private Comparator featureComparator;

    SeqIOEventEmitter(Comparator seqPropComparator, Comparator featureComparator) {
        this.seqPropComparator = seqPropComparator;
        this.featureComparator = featureComparator;
    }

    void getSeqIOEvents(Sequence seq, SeqIOListener listener) {
        try {
            listener.startSequence();
            listener.setName(seq.getName());
            listener.setURI(seq.getURN());
            Annotation a = seq.getAnnotation();
            ArrayList sKeys = new ArrayList(a.keys());
            Collections.sort(sKeys, this.seqPropComparator);
            Iterator ki = sKeys.iterator();
            while (ki.hasNext()) {
                Object key = ki.next();
                listener.addSequenceProperty(key, a.getProperty(key));
            }
            List subs = SeqIOEventEmitter.getSubFeatures(seq);
            Collections.sort(subs, this.featureComparator);
            Iterator fi = subs.iterator();
            while (fi.hasNext()) {
                Feature.Template t = ((Feature)fi.next()).makeTemplate();
                listener.startFeature(t);
                ArrayList fKeys = new ArrayList(t.annotation.keys());
                Collections.sort(fKeys);
                Iterator ki2 = fKeys.iterator();
                while (ki2.hasNext()) {
                    Object key = ki2.next();
                    listener.addFeatureProperty(key, t.annotation.getProperty(key));
                }
                listener.endFeature();
            }
            listener.addSymbols(seq.getAlphabet(), seq.toList().toArray(symProto), 0, seq.length());
            listener.endSequence();
        }
        catch (IllegalAlphabetException iae) {
            throw new BioError(iae, "An internal error occurred processing symbols");
        }
        catch (ParseException pe) {
            throw new BioError(pe, "An internal error occurred creating SeqIO events");
        }
    }

    private static List getSubFeatures(FeatureHolder fh) {
        ArrayList<FeatureHolder> subfeat = new ArrayList<FeatureHolder>();
        Iterator fi = fh.features();
        while (fi.hasNext()) {
            FeatureHolder sfh = (FeatureHolder)fi.next();
            subfeat.addAll(SeqIOEventEmitter.getSubFeatures(sfh));
            subfeat.add(sfh);
        }
        return subfeat;
    }
}

