/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.projection;

import java.util.ArrayList;
import java.util.Iterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.projection.Projection;
import org.biojava.bio.seq.projection.ProjectionContext;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class ProjectedFeature
implements Feature,
Projection {
    private final Feature feature;
    private final ProjectionContext context;

    public ProjectedFeature(Feature f, ProjectionContext ctx) {
        this.feature = f;
        this.context = ctx;
    }

    public FeatureFilter getSchema() {
        return this.context.getSchema(this.feature);
    }

    public Feature getViewedFeature() {
        return this.feature;
    }

    public ProjectionContext getProjectionContext() {
        return this.context;
    }

    public Feature.Template makeTemplate() {
        Feature.Template ft = this.getViewedFeature().makeTemplate();
        ft.location = this.getLocation();
        ft.annotation = this.getAnnotation();
        return ft;
    }

    public Location getLocation() {
        return this.context.getLocation(this.feature);
    }

    public void setLocation(Location loc) throws ChangeVetoException {
        throw new ChangeVetoException(new ChangeEvent(this, Feature.LOCATION, this.getLocation(), loc));
    }

    public FeatureHolder getParent() {
        return this.context.getParent(this.feature);
    }

    public Sequence getSequence() {
        return this.context.getSequence(this.feature);
    }

    public String getType() {
        return this.feature.getType();
    }

    public void setType(String type) throws ChangeVetoException {
        this.feature.setType(type);
    }

    public String getSource() {
        return this.feature.getSource();
    }

    public void setSource(String source) throws ChangeVetoException {
        this.feature.setSource(source);
    }

    public Annotation getAnnotation() {
        return this.context.getAnnotation(this.feature);
    }

    public SymbolList getSymbols() {
        Location loc = this.getLocation();
        Sequence seq = this.context.getSequence(this);
        if (loc.isContiguous()) {
            return seq.subList(loc.getMin(), loc.getMax());
        }
        ArrayList<SymbolList> res = new ArrayList<SymbolList>();
        Iterator i = loc.blockIterator();
        while (i.hasNext()) {
            Location l = (Location)i.next();
            res.add(seq.subList(l.getMin(), l.getMax()));
        }
        try {
            return new SimpleSymbolList(seq.getAlphabet(), res);
        }
        catch (IllegalSymbolException ex) {
            throw new BioError(ex);
        }
    }

    public int countFeatures() {
        return this.feature.countFeatures();
    }

    public boolean containsFeature(Feature f) {
        if (this.countFeatures() > 0) {
            return this.getProjectedFeatures().containsFeature(f);
        }
        return false;
    }

    protected FeatureHolder getProjectedFeatures() {
        return this.context.projectChildFeatures(this.feature, this);
    }

    public Iterator features() {
        return this.getProjectedFeatures().features();
    }

    public FeatureHolder filter(FeatureFilter ff) {
        FeatureFilter.And membershipFilter = new FeatureFilter.And(new FeatureFilter.Not(FeatureFilter.top_level), new FeatureFilter.ContainedByLocation(this.getLocation()));
        if (FilterUtils.areDisjoint(ff, membershipFilter)) {
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        return this.getProjectedFeatures().filter(ff);
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        FeatureFilter.ContainedByLocation membershipFilter = new FeatureFilter.ContainedByLocation(this.getLocation());
        if (FilterUtils.areDisjoint(ff, membershipFilter)) {
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        return this.getProjectedFeatures().filter(ff, recurse);
    }

    public Feature createFeature(Feature.Template temp) throws ChangeVetoException, BioException {
        return this.context.createFeature(this.feature, temp);
    }

    public void removeFeature(Feature f) throws ChangeVetoException {
        this.context.removeFeature(this.feature, f);
    }

    public int hashCode() {
        return this.makeTemplate().hashCode();
    }

    public boolean equals(Object o) {
        Feature fo;
        if (o instanceof Feature && (fo = (Feature)o).getSequence().equals(this.getSequence())) {
            return this.makeTemplate().equals(fo.makeTemplate());
        }
        return false;
    }

    public void addChangeListener(ChangeListener cl) {
        this.addChangeListener(cl, ChangeType.UNKNOWN);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.removeChangeListener(cl, ChangeType.UNKNOWN);
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        this.context.addChangeListener(this.feature, cl, ChangeType.UNKNOWN);
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        this.context.removeChangeListener(this.feature, cl, ChangeType.UNKNOWN);
    }

    public boolean isUnchanging(ChangeType ct) {
        return this.feature.isUnchanging(ct);
    }
}

