/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.colourmap;

import java.awt.Color;
import java.awt.Graphics;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.gdesupport.canvas.textarea.BLTextArea;

public abstract class ColourMap {
    protected Color foreground = Color.BLACK;
    protected Color background = Color.WHITE;
    protected Color foregroundSelect = Color.WHITE;
    protected Color backgroundSelect = Color.BLUE;
    private String name = "";

    public abstract void regularDrawString(BLTextArea var1, Graphics var2, int var3, int var4, Sequence var5, int var6, int var7);

    public void selectDrawString(BLTextArea ta, Graphics gfx, int xstart, int ystart, Sequence seq, int pstart, int pend) {
        char[] drawArray = this.safesubstring(seq, pstart, pend).toCharArray();
        this.drawChars(ta, gfx, xstart, ystart, drawArray, 0, drawArray.length, this.foregroundSelect, this.backgroundSelect);
    }

    protected void drawChars(BLTextArea ta, Graphics gfx, int xstart, int ystart, char[] array, int index, int length, Color foreground, Color background) {
        int xstartMod = 0;
        int end = index + length;
        gfx.setColor(background);
        gfx.fillRect(xstart, ystart, length * ta.columnSize(), ta.rowSize());
        gfx.setFont(ta.getFont());
        gfx.setColor(foreground);
        if (end <= array.length) {
            for (int column = index; column < end; ++column) {
                xstartMod = (ta.columnSize() - ta.getFontMetrics(ta.getFont()).charWidth(array[column])) / 2;
                gfx.drawChars(array, column, 1, xstart + xstartMod, ystart + ta.rowSize() - 5);
                xstart += ta.columnSize();
            }
        }
    }

    public String safesubstring(Sequence seq, int pstart, int pend) {
        String sequencetxt = seq.get((Object)"sequence").toString();
        pstart = Math.max(0, Math.min(sequencetxt.length(), pstart));
        pend = Math.max(pstart, Math.min(sequencetxt.length(), pend));
        return sequencetxt.substring(pstart, pend);
    }

    public Color getForeground() {
        return this.background;
    }

    public void setForeground(Color c) {
        this.background = c;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color c) {
        this.background = c;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }
}

