/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.colourmask;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.LinkedList;
import org.biolegato.core.main.BLMain;
import org.biolegato.gdesupport.canvas.colourmap.ColourMap;
import org.biolegato.gdesupport.canvas.colourmap.PositionColourMap;
import org.biolegato.gdesupport.canvas.colourmask.ColourMaskReader;

public class GDEColourMaskFile
extends ColourMaskReader {
    public ColourMap[] readColourMapFile(File file) {
        boolean number = true;
        int length = 0;
        Color addColour = null;
        String name = "";
        boolean stopSequence = false;
        boolean nodash = false;
        BufferedReader reader = null;
        PositionColourMap mask = null;
        LinkedList<Color> colourList = new LinkedList<Color>();
        LinkedList<PositionColourMap> colourMapList = new LinkedList<PositionColourMap>();
        String line = "";
        if (file != null && file.exists() && file.isFile()) {
            try {
                reader = new BufferedReader(new FileReader(file.getPath()));
                do {
                    if ((line = reader.readLine()) == null) continue;
                    if ((line = line.trim().toLowerCase()).startsWith("name:")) {
                        name = line.substring(line.indexOf("name:") + 5);
                        continue;
                    }
                    if (line.startsWith("length:")) {
                        try {
                            length = Integer.parseInt(line.substring(line.indexOf("length:") + 7));
                        }
                        catch (Throwable nfe) {
                            nfe.printStackTrace();
                        }
                        continue;
                    }
                    if (line.startsWith("nodash:")) {
                        nodash = true;
                        continue;
                    }
                    if (!"".equals(name) && line.toLowerCase().startsWith("start:")) {
                        stopSequence = false;
                        while (!stopSequence && length > 0 && line != null) {
                            line = reader.readLine();
                            addColour = null;
                            if (line == null) continue;
                            if ((line = line.trim()).toLowerCase().startsWith("name:") || line.toLowerCase().startsWith("length:") || line.toLowerCase().startsWith("nodash:") || line.toLowerCase().startsWith("start:")) {
                                stopSequence = true;
                            } else if (BLMain.testNumber((char[])line.toCharArray())) {
                                addColour = GDEColourMaskFile.getDefaultColour(GDEColourMaskFile.stringToInt(line));
                            }
                            if (addColour == null) continue;
                            colourList.add(addColour);
                            --length;
                        }
                        if (length != 0) {
                            BLMain.error((String)"Reached end of file before end of colour", (String)"GDEColourMaskColourMap");
                        }
                        number = true;
                        mask = new PositionColourMap(name, colourList.toArray(new Color[0]), nodash);
                        colourMapList.add(mask);
                        colourList.clear();
                        nodash = false;
                        name = "";
                        continue;
                    }
                    if (!"".equals(name) || !line.toLowerCase().startsWith("start:")) continue;
                    BLMain.error((String)"Unnamed colour mask", (String)"GDEColourMaskColourMap");
                } while (line != null);
            }
            catch (Throwable exception) {
                exception.printStackTrace();
            }
        } else {
            BLMain.error((String)"Invalid colour map file", (String)"GDEColourMaskColourMap");
        }
        return colourMapList.toArray(new ColourMap[0]);
    }

    public boolean accept(File f) {
        return true;
    }

    public String getDescription() {
        return "GDE colour mask file";
    }

    public static Color getDefaultColour(int number) {
        return new Color(GDEColourMaskFile.stringToInt(BLMain.getProperty((String)("GDE.colour." + number + ".red"))), GDEColourMaskFile.stringToInt(BLMain.getProperty((String)("GDE.colour." + number + ".green"))), GDEColourMaskFile.stringToInt(BLMain.getProperty((String)("GDE.colour." + number + ".blue"))));
    }

    public static int stringToInt(String s) {
        int i = 0;
        if (BLMain.testNumber((char[])s.toCharArray())) {
            try {
                i = Integer.parseInt(s);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return i;
    }
}

