/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.list;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.core.main.BLMain;
import org.biolegato.gdesupport.canvas.colourmap.ColourMap;
import org.biolegato.gdesupport.canvas.colourmask.ImportFileAction;

public class GDESequenceWindow
extends JDialog
implements ActionListener,
ItemListener {
    private Sequence[] sequences;
    private JTextField name = new JTextField();
    private JCheckBox protectAlignmentCB = new JCheckBox("Alignment gaps");
    private JCheckBox protectAmbiguousCB = new JCheckBox("Ambiguous characters");
    private JCheckBox protectUnambiguousCB = new JCheckBox("Unambiguous characters");
    private JComboBox type = new JComboBox<Object>(new Object[]{Sequence.Type.DNA, Sequence.Type.RNA, Sequence.Type.PROTEIN, Sequence.Type.TEXT});
    private JComboBox direction = new JComboBox<Object>(new Object[]{Sequence.Direction.FROM5TO3, Sequence.Direction.FROM3TO5});
    private JComboBox topology = new JComboBox<Object>(new Object[]{Sequence.Topology.LINEAR, Sequence.Topology.CIRCULAR});
    private JComboBox strandedness = new JComboBox<Object>(new Object[]{Sequence.Strandedness.SINGLE, Sequence.Strandedness.MIXED, Sequence.Strandedness.DOUBLE});
    private ImportFileAction mask;
    private static final String MULTIPLE_SELECTED = "<multiple selected...>";
    private static final long serialVersionUID = 7526472295622777013L;

    public GDESequenceWindow(JFrame window, Sequence[] sequences) {
        super((Frame)window, "Sequence properties");
        this.sequences = sequences;
        Object currentMask = null;
        if (sequences.length >= 1) {
            if (sequences.length == 1) {
                this.name.setText(sequences[0].get((Object)"name").toString());
            }
            this.type.setSelectedItem(sequences[0].get((Object)"type"));
            this.direction.setSelectedItem(sequences[0].get((Object)"direction"));
            this.topology.setSelectedItem(sequences[0].get((Object)"topology"));
            this.strandedness.setSelectedItem(sequences[0].get((Object)"strandedness"));
            if (sequences[0].get((Object)"mask") != null && sequences[0].get((Object)"mask") instanceof ColourMap) {
                currentMask = (ColourMap)sequences[0].get((Object)"mask");
            } else if (sequences[0].get((Object)"mask") != null && !"".equals(sequences[0].get((Object)"mask"))) {
                BLMain.error((String)("current mask = " + sequences[0].get((Object)"mask") + "\twrong class: " + sequences[0].get((Object)"mask").getClass()));
            }
        }
        for (int count = 1; !(this.protectAlignmentCB.isSelected() && this.protectAmbiguousCB.isSelected() && this.protectUnambiguousCB.isSelected() || count >= sequences.length); ++count) {
            if (sequences[count] == null) continue;
            if (!MULTIPLE_SELECTED.equals(this.type.getSelectedItem())) {
                if (this.type.getSelectedItem().equals(sequences[count].get((Object)"type"))) {
                    this.type.setSelectedItem(sequences[count].get((Object)"type"));
                } else {
                    this.type.insertItemAt(MULTIPLE_SELECTED, 0);
                    this.type.setSelectedItem(MULTIPLE_SELECTED);
                }
            }
            if (!MULTIPLE_SELECTED.equals(this.direction.getSelectedItem())) {
                if (this.direction.getSelectedItem().equals(sequences[count].get((Object)"direction"))) {
                    this.direction.setSelectedItem(sequences[count].get((Object)"direction"));
                } else {
                    this.direction.insertItemAt(MULTIPLE_SELECTED, 0);
                    this.direction.setSelectedItem(MULTIPLE_SELECTED);
                }
            }
            if (!MULTIPLE_SELECTED.equals(this.topology.getSelectedItem())) {
                if (this.topology.getSelectedItem().equals(sequences[count].get((Object)"topology"))) {
                    this.topology.setSelectedItem(sequences[count].get((Object)"topology"));
                } else {
                    this.topology.insertItemAt(MULTIPLE_SELECTED, 0);
                    this.topology.setSelectedItem(MULTIPLE_SELECTED);
                }
            }
            if (!MULTIPLE_SELECTED.equals(this.strandedness.getSelectedItem())) {
                if (this.strandedness.getSelectedItem().equals(sequences[count].get((Object)"strandedness"))) {
                    this.strandedness.setSelectedItem(sequences[count].get((Object)"strandedness"));
                } else {
                    this.strandedness.insertItemAt(MULTIPLE_SELECTED, 0);
                    this.strandedness.setSelectedItem(MULTIPLE_SELECTED);
                }
            }
            if (!this.protectAlignmentCB.isSelected() && Boolean.TRUE.equals(sequences[count].get((Object)"protect_align"))) {
                this.protectAlignmentCB.setSelected(true);
            }
            if (!this.protectAmbiguousCB.isSelected() && Boolean.TRUE.equals(sequences[count].get((Object)"protect_ambig"))) {
                this.protectAmbiguousCB.setSelected(true);
            }
            if (!this.protectUnambiguousCB.isSelected() && Boolean.TRUE.equals(sequences[count].get((Object)"protect_unambig"))) {
                this.protectUnambiguousCB.setSelected(true);
            }
            if (MULTIPLE_SELECTED.equals(currentMask)) continue;
            currentMask = currentMask == null && (sequences[count].get((Object)"mask") == null || !(sequences[count].get((Object)"mask") instanceof ColourMap)) ? null : (sequences[count].get((Object)"mask") != null && currentMask != null && currentMask.equals(sequences[count].get((Object)"mask")) ? (ColourMap)sequences[count].get((Object)"mask") : MULTIPLE_SELECTED);
        }
        Box mainBox = new Box(3);
        Box nameBox = new Box(2);
        nameBox.add(new JLabel("Name:"));
        nameBox.add(this.name);
        mainBox.add(nameBox);
        Box typeBox = new Box(2);
        typeBox.add(new JLabel("Type:"));
        typeBox.add(this.type);
        this.type.addItemListener(this);
        mainBox.add(typeBox);
        Box directionBox = new Box(2);
        directionBox.add(new JLabel("Direction:"));
        directionBox.add(this.direction);
        mainBox.add(directionBox);
        Box topologyBox = new Box(2);
        topologyBox.add(new JLabel("Topology:"));
        topologyBox.add(this.topology);
        mainBox.add(topologyBox);
        Box strandednessBox = new Box(2);
        strandednessBox.add(new JLabel("Strandedness:"));
        strandednessBox.add(this.strandedness);
        mainBox.add(strandednessBox);
        Box protectionBox = new Box(3);
        protectionBox.add(this.protectAlignmentCB);
        protectionBox.add(this.protectAmbiguousCB);
        protectionBox.add(this.protectUnambiguousCB);
        protectionBox.setBorder(BorderFactory.createTitledBorder("Set character protections"));
        mainBox.add(protectionBox);
        Box maskBox = new Box(2);
        this.mask = new ImportFileAction(this, currentMask);
        maskBox.add(new JLabel("Colour mask:"));
        maskBox.add(this.mask);
        mainBox.add(maskBox);
        JButton update = new JButton("Update");
        update.setActionCommand("update");
        update.addActionListener(this);
        mainBox.add(update);
        this.itemStateChanged(new ItemEvent(this.type, this.type.getSelectedIndex(), this.type.getSelectedItem(), 1));
        this.add(mainBox);
        this.pack();
        this.setLocationRelativeTo(window);
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
    }

    public void actionPerformed(ActionEvent e) {
        if ("update".equals(e.getActionCommand())) {
            for (Sequence seq : this.sequences) {
                LinkedList group;
                if (!"".equals(this.name.getText())) {
                    seq.put("name", (Object)this.name.getText());
                }
                if (!MULTIPLE_SELECTED.equals(this.type.getSelectedItem())) {
                    seq.put("type", this.type.getSelectedItem());
                }
                if (!MULTIPLE_SELECTED.equals(this.direction.getSelectedItem())) {
                    seq.put("direction", this.direction.getSelectedItem());
                }
                if (!MULTIPLE_SELECTED.equals(this.topology.getSelectedItem())) {
                    seq.put("topology", this.topology.getSelectedItem());
                }
                if (!MULTIPLE_SELECTED.equals(this.strandedness.getSelectedItem())) {
                    seq.put("strandedness", this.strandedness.getSelectedItem());
                }
                if (this.mask.getSelectedItem() instanceof ColourMap) {
                    seq.put("mask", (Object)((ColourMap)this.mask.getSelectedItem()));
                } else if (!MULTIPLE_SELECTED.equals(this.mask.getSelectedItem())) {
                    seq.put("mask", null);
                }
                seq.put("protect_align", (Object)new Boolean(this.protectAlignmentCB.isSelected()));
                seq.put("protect_ambig", (Object)new Boolean(this.protectAmbiguousCB.isSelected()));
                seq.put("protect_unambig", (Object)new Boolean(this.protectUnambiguousCB.isSelected()));
                if (seq.get((Object)"group") instanceof Integer && (group = Sequence.getgroup((Integer)((Integer)seq.get((Object)"group")))) != null) {
                    for (Sequence groupseq : group) {
                        groupseq.put("protect_align", (Object)new Boolean(this.protectAlignmentCB.isSelected()));
                        groupseq.put("protect_ambig", (Object)new Boolean(this.protectAmbiguousCB.isSelected()));
                        groupseq.put("protect_unambig", (Object)new Boolean(this.protectUnambiguousCB.isSelected()));
                    }
                }
                this.dispose();
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (Sequence.Type.DNA.equals(this.type.getSelectedItem()) || Sequence.Type.RNA.equals(this.type.getSelectedItem())) {
            this.direction.setEnabled(true);
            this.topology.setEnabled(true);
            this.strandedness.setEnabled(true);
        } else if (Sequence.Type.PROTEIN.equals(this.type.getSelectedItem())) {
            this.direction.setEnabled(false);
            this.topology.setEnabled(false);
            this.strandedness.setEnabled(false);
        } else if (Sequence.Type.TEXT.equals(this.type.getSelectedItem())) {
            this.direction.setEnabled(false);
            this.topology.setEnabled(false);
            this.strandedness.setEnabled(false);
        }
    }
}

