/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.textarea;

import java.awt.event.KeyEvent;
import java.util.LinkedList;
import javax.swing.JMenuItem;
import org.biolegato.core.data.sequence.Sequence;
import org.biolegato.core.main.BLMain;
import org.biolegato.gdesupport.canvas.GDECanvas;
import org.biolegato.gdesupport.canvas.textarea.GDETextArea;
import org.biolegato.gdesupport.canvas.undo.UndoChangePosition;
import org.biolegato.gdesupport.canvas.undo.UndoDelete;
import org.biolegato.gdesupport.canvas.undo.UndoInsert;
import org.biolegato.gdesupport.canvas.undo.UndoMoveSelection;
import org.biolegato.gdesupport.canvas.undo.UndoMulti;
import org.biolegato.gdesupport.canvas.undo.UndoStretchSelection;
import org.biolegato.gdesupport.canvas.undo.Undoable;

public class UndoableGDETextArea
extends GDETextArea {
    private GDECanvas canvas = null;
    public final UndoableGDETextArea ugdeTextAreaSelf = this;
    private static final long serialVersionUID = 7526472295622777017L;

    public UndoableGDETextArea(GDECanvas canvas) {
        this.canvas = canvas;
        this.addPopupMenuItem(new JMenuItem(canvas.undoAction));
        this.addPopupMenuItem(new JMenuItem(canvas.redoAction));
    }

    public void changeCase() {
        String data = null;
        Sequence[] seqList = null;
        UndoMulti result = new UndoMulti();
        if (!this.isEmptySelection()) {
            for (Sequence seq : seqList = this.getData()) {
                data = seq.get((Object)"sequence").toString();
                if (data.length() < 0) continue;
                if (Character.isUpperCase(data.charAt(0))) {
                    seq.put("sequence", (Object)data.toLowerCase());
                    continue;
                }
                seq.put("sequence", (Object)data.toUpperCase());
            }
            result.addUndo(this.udeleteSelection());
            result.addUndo(this.uinsert(this.column, this.row, seqList));
            this.canvas.addUndo(result);
        }
    }

    public void cut() {
        if (!this.isEmptySelection()) {
            this.copy();
            this.canvas.addUndo(this.updeleteSelection());
        }
    }

    public void paste() {
        UndoMulti paste = new UndoMulti();
        paste.addUndo(this.updeleteSelection());
        paste.addUndo(this.uinsert(this.column, this.row, BLMain.getClipboard()));
        this.canvas.addUndo(paste);
    }

    public void keyTyped(KeyEvent event) {
        if ("true".equalsIgnoreCase(BLMain.getProperty((String)"undo"))) {
            boolean canInsert = true;
            Undoable returnedUndo = null;
            UndoMulti resultUndo = new UndoMulti();
            try {
                switch (event.getKeyChar()) {
                    case '\b': 
                    case '\u007f': {
                        break;
                    }
                    case '\n': {
                        if (this.row + 1 < BLMain.getSeqDoc().getLineCount()) {
                            this.changePosition(Math.min(BLMain.getSeqDoc().getLineLength(this.row + 1), this.column), this.row + 1);
                            this.resetSelection();
                        }
                        break;
                    }
                    default: {
                        if (!this.isEmptySelection()) {
                            resultUndo.addUndo(this.udeleteSelection());
                        } else if (this.insertMode && BLMain.getSeqDoc().getLineCount() > 0 && BLMain.getSeqDoc().getLineLength(0) > 0) {
                            returnedUndo = this.udelete(this.column, this.row, 1, 0);
                        }
                        if (this.isEmptySelection() || !this.insertMode || returnedUndo != null) {
                            resultUndo.addUndo(returnedUndo);
                            resultUndo.addUndo(this.uinsert(this.column, this.row, "" + event.getKeyChar()));
                            resultUndo.addUndo(this.uchangePosition(this.column + 1, this.row));
                        }
                        break;
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (!resultUndo.isEmpty()) {
                this.canvas.addUndo(resultUndo);
            }
        } else {
            super.keyTyped(event);
        }
    }

    public void keyPressed(KeyEvent event) {
        if ("true".equalsIgnoreCase(BLMain.getProperty((String)"undo"))) {
            int backspacecol = 0;
            boolean moved = false;
            UndoMulti result = new UndoMulti();
            Undoable tempResult = null;
            try {
                switch (event.getKeyChar()) {
                    case '\b': {
                        if (!this.isEmptySelection()) {
                            result.addUndo(this.udeleteSelection());
                            break;
                        }
                        if (this.row > 0 || this.column > 0) {
                            if (this.column <= 0 && this.row > 0) {
                                backspacecol = BLMain.getSeqDoc().getLineLength(this.row - 1);
                            }
                            if (this.column - 1 >= 0 && (tempResult = this.udelete(this.column - 1, this.row, 1, 0)) != null) {
                                result.addUndo(tempResult);
                                if (this.column <= 0 && this.row > 0) {
                                    result.addUndo(this.uchangePosition(backspacecol, this.row - 1));
                                    break;
                                }
                                result.addUndo(this.uchangePosition(this.column - 1, this.row));
                            }
                        }
                        break;
                    }
                    case '\u007f': {
                        if (!this.isEmptySelection()) {
                            result.addUndo(this.udeleteSelection());
                            break;
                        }
                        if (BLMain.getSeqDoc().getLineCount() > 0 && BLMain.getSeqDoc().getLineLength(0) > 0) {
                            result.addUndo(this.udelete(this.column, this.row, 1, 0));
                        }
                        break;
                    }
                    default: {
                        super.keyPressed(event);
                        break;
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (!result.isEmpty()) {
                this.canvas.addUndo(result);
            }
        } else {
            super.keyTyped(event);
        }
    }

    public Undoable uinsert(int x, int y, String text) {
        return this.insert(x, y, text) ? new UndoInsert(this, x, y, text.length()) : null;
    }

    public Undoable uinsert(int x, int y, Sequence[] sequences) {
        UndoMulti result = null;
        if (this.insert(x, y, sequences)) {
            for (int count = 0; count < sequences.length; ++count) {
                result.addUndo(new UndoInsert(this, x, y + count, sequences[count].get((Object)"sequnce").toString().length()));
            }
        }
        return result;
    }

    public Undoable udelete(int x, int y, int w, int h) {
        UndoMulti result = new UndoMulti();
        Object current = null;
        for (int count = y; count <= y + h; ++count) {
            LinkedList group;
            if (current.get((Object)"group") instanceof Integer && (group = Sequence.getgroup((Integer)((Integer)current.get((Object)"group")))) != null) {
                result = new UndoMulti();
                for (Sequence seq : group) {
                    int gln = BLMain.getSeqDoc().indexOf(seq);
                    if ((gln < y || gln > y + h) && gln < BLMain.getSeqDoc().getLineCount()) {
                        result.addUndo(this.updelete(x, gln, w, 0));
                        continue;
                    }
                    BLMain.error((String)("Invalid row number: " + y), (String)"boolean UndoableGDETextArea.insert (char)");
                }
                continue;
            }
            result.addUndo(this.updelete(x, y, w, 0));
        }
        return result;
    }

    public Undoable updelete(int x, int y, int w, int h) {
        String current = null;
        UndoMulti result = new UndoMulti();
        for (int count = 0; count <= h; ++count) {
            current = BLMain.getSeqDoc().getLine(count).get((Object)"sequence").toString().substring(x, x + w);
            if (!this.pdelete(x, y + count, w, 0)) continue;
            result.addUndo(new UndoDelete(this, x, y + count, current));
        }
        return result;
    }

    public Undoable updeleteSelection() {
        int x = this.getMinSX();
        int y = this.getMinSY();
        int w = this.getMaxSX() - x;
        int h = this.getMaxSY() - y;
        Undoable resultDelete = null;
        UndoMulti resultFunction = new UndoMulti();
        if (!this.isEmptySelection() && (resultDelete = this.updelete(x, y, w, h)) != null) {
            resultFunction.addUndo(resultDelete);
            resultFunction.addUndo(this.uchangePosition(x, y));
            resultFunction.addUndo(this.umoveSelection(0, 0));
            resultFunction.addUndo(this.ustretchSelection(0, 0));
        }
        return resultFunction;
    }

    public Undoable udeleteSelection() {
        int x = this.getMinSX();
        int y = this.getMinSY();
        int w = this.getMaxSX() - x;
        int h = this.getMaxSY() - y;
        Undoable resultDelete = null;
        UndoMulti resultFunction = new UndoMulti();
        if (!this.isEmptySelection() && (resultDelete = this.udelete(x, y, w, h)) != null) {
            resultFunction.addUndo(resultDelete);
            resultFunction.addUndo(this.uchangePosition(x, y));
            resultFunction.addUndo(this.umoveSelection(0, 0));
            resultFunction.addUndo(this.ustretchSelection(0, 0));
        }
        return resultFunction;
    }

    public Undoable umoveSelection(int newx, int newy) {
        int oldx = this.getSX1();
        int oldy = this.getSY1();
        this.moveSelection(newx, newy);
        return new UndoMoveSelection(this, oldx, oldy);
    }

    public Undoable ustretchSelection(int newx, int newy) {
        int oldx = this.getSX2();
        int oldy = this.getSY2();
        this.stretchSelection(newx, newy);
        return new UndoStretchSelection(this, oldx, oldy);
    }

    public Undoable uchangePosition(int newColumn, int newRow) {
        int oldRow = this.row;
        int oldColumn = this.column;
        super.changePosition(newColumn, newRow);
        return new UndoChangePosition(this, oldColumn, oldRow);
    }
}

