/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Frame;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class Calculator {
    private String sequence;
    private String selection;
    private final char[] notRNA = new char[]{'B', 'D', 'E', 'F', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Y', 'Z'};
    private final char[] notDNA = new char[]{'B', 'D', 'E', 'F', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private final char[] notProtein = new char[]{'B', 'J', 'O', 'U', 'X'};
    private static float AMP = 329.23f;
    private static float GMP = 345.23f;
    private static float CMP = 305.21f;
    private static float UMP = 306.19f;
    private static float dAMP = 313.23f;
    private static float dGMP = 329.23f;
    private static float dCMP = 289.21f;
    private static float dTMP = 304.23f;
    private static float POP = 160.0f;
    private static float Ala = 71.08f;
    private static float Arg = 156.2f;
    private static float Asn = 114.11f;
    private static float Asp = 115.09f;
    private static float Cys = 103.14f;
    private static float Gln = 128.14f;
    private static float Glu = 129.12f;
    private static float Gly = 57.06f;
    private static float His = 137.15f;
    private static float Ile = 113.17f;
    private static float Leu = 113.17f;
    private static float Lys = 128.18f;
    private static float Met = 131.21f;
    private static float Phe = 147.18f;
    private static float Pro = 97.12f;
    private static float Ser = 87.08f;
    private static float Thr = 101.11f;
    private static float Trp = 186.21f;
    private static float Tyr = 163.18f;
    private static float Val = 99.14f;
    private static float H2O = 18.0f;
    private long aCount;
    private long gCount;
    private long cCount;
    private long uCount;
    private long tCount;
    private int ACount;
    private int CCount;
    private int DCount;
    private int ECount;
    private int FCount;
    private int GCount;
    private int HCount;
    private int ICount;
    private int KCount;
    private int LCount;
    private int MCount;
    private int NCount;
    private int PCount;
    private int QCount;
    private int RCount;
    private int SCount;
    private int TCount;
    private int VCount;
    private int WCount;
    private int YCount;
    private long numUnits;
    private long badCharacter;
    private float GC;

    public Calculator(String string) {
        this.selection = string;
        if (this.selection.equals("RNA") || this.selection.equals("DNA")) {
            this.newNASequence();
        }
        if (this.selection.equals("Protein")) {
            this.newProtSequence();
        }
    }

    private void newNASequence() {
        this.aCount = 0L;
        this.gCount = 0L;
        this.cCount = 0L;
        this.uCount = 0L;
        this.tCount = 0L;
        this.numUnits = 0L;
        this.badCharacter = 0L;
        this.GC = 0.0f;
    }

    private void newProtSequence() {
        this.ACount = 0;
        this.CCount = 0;
        this.DCount = 0;
        this.ECount = 0;
        this.FCount = 0;
        this.GCount = 0;
        this.HCount = 0;
        this.ICount = 0;
        this.KCount = 0;
        this.LCount = 0;
        this.MCount = 0;
        this.NCount = 0;
        this.PCount = 0;
        this.QCount = 0;
        this.RCount = 0;
        this.SCount = 0;
        this.TCount = 0;
        this.VCount = 0;
        this.WCount = 0;
        this.YCount = 0;
        this.numUnits = 0L;
        this.badCharacter = 0L;
    }

    String count(String string) {
        this.sequence = string;
        int n = string.length();
        if (n == 0) {
            this.displayAlert("No input sequence was provided.");
            return "     No calculation was done";
        }
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        if (this.selection.equals("RNA")) {
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                if (c == 'A') {
                    ++this.aCount;
                } else if (c == 'G') {
                    ++this.gCount;
                } else if (c == 'C') {
                    ++this.cCount;
                } else if (c == 'U') {
                    ++this.uCount;
                } else {
                    int n3 = 0;
                    while (n3 < this.notRNA.length) {
                        if (c == this.notRNA[n3]) {
                            ++this.badCharacter;
                        }
                        ++n3;
                    }
                }
                this.numUnits = this.aCount + this.gCount + this.cCount + this.uCount;
                ++n2;
            }
            if (this.numUnits == 0L) {
                this.displayAlert("The input sequence provided is not a valid RNA sequence.");
                return "     No calculation was done";
            }
            if (this.badCharacter != 0L) {
                this.displayAlert("Character(s) other than A, G, C, or U were found.");
                this.newNASequence();
                return "     No calculation was done";
            }
            this.GC = (float)(this.gCount + this.cCount) / (float)this.numUnits * 100.0f;
            long l = Math.round(this.GC * 100.0f);
            this.GC = (float)l / 100.0f;
            return "     " + decimalFormat.format(this.aCount) + " As, " + decimalFormat.format(this.gCount) + " Gs, " + decimalFormat.format(this.cCount) + " Cs, " + decimalFormat.format(this.uCount) + " Us (" + decimalFormat.format(this.numUnits) + " bases in total; " + this.GC + "% GC content)";
        }
        if (this.selection.equals("DNA")) {
            int n4 = 0;
            while (n4 < n) {
                char c = string.charAt(n4);
                if (c == 'A') {
                    ++this.aCount;
                } else if (c == 'G') {
                    ++this.gCount;
                } else if (c == 'C') {
                    ++this.cCount;
                } else if (c == 'T') {
                    ++this.tCount;
                } else {
                    int n5 = 0;
                    while (n5 < this.notDNA.length) {
                        if (c == this.notDNA[n5]) {
                            ++this.badCharacter;
                        }
                        ++n5;
                    }
                }
                this.numUnits = this.aCount + this.gCount + this.cCount + this.tCount;
                ++n4;
            }
            if (this.numUnits == 0L) {
                this.displayAlert("The input sequence provided is not a valid DNA sequence.");
                return "     No calculation was done";
            }
            if (this.badCharacter != 0L) {
                this.displayAlert("Character(s) other than A, G, C, or T were found.");
                this.newNASequence();
                return "     No calculation was done";
            }
            this.GC = (float)(this.gCount + this.cCount) / (float)this.numUnits * 100.0f;
            long l = Math.round(this.GC * 100.0f);
            this.GC = (float)l / 100.0f;
            return "     " + decimalFormat.format(this.aCount) + " As, " + decimalFormat.format(this.gCount) + " Gs, " + decimalFormat.format(this.cCount) + " Cs, " + decimalFormat.format(this.tCount) + " Ts (" + decimalFormat.format(this.numUnits) + " bases in total; " + this.GC + "% GC content)";
        }
        if (this.selection.equals("Protein")) {
            int n6 = 0;
            while (n6 < n) {
                char c = string.charAt(n6);
                if (c == 'A') {
                    ++this.ACount;
                } else if (c == 'C') {
                    ++this.CCount;
                } else if (c == 'D') {
                    ++this.DCount;
                } else if (c == 'E') {
                    ++this.ECount;
                } else if (c == 'F') {
                    ++this.FCount;
                } else if (c == 'G') {
                    ++this.GCount;
                } else if (c == 'H') {
                    ++this.HCount;
                } else if (c == 'I') {
                    ++this.ICount;
                } else if (c == 'K') {
                    ++this.KCount;
                } else if (c == 'L') {
                    ++this.LCount;
                } else if (c == 'M') {
                    ++this.MCount;
                } else if (c == 'N') {
                    ++this.NCount;
                } else if (c == 'P') {
                    ++this.PCount;
                } else if (c == 'Q') {
                    ++this.QCount;
                } else if (c == 'R') {
                    ++this.RCount;
                } else if (c == 'S') {
                    ++this.SCount;
                } else if (c == 'T') {
                    ++this.TCount;
                } else if (c == 'V') {
                    ++this.VCount;
                } else if (c == 'W') {
                    ++this.WCount;
                } else if (c == 'Y') {
                    ++this.YCount;
                } else {
                    int n7 = 0;
                    while (n7 < this.notProtein.length) {
                        if (c == this.notProtein[n7]) {
                            ++this.badCharacter;
                        }
                        ++n7;
                    }
                }
                this.numUnits = this.ACount + this.CCount + this.DCount + this.ECount + this.FCount + this.GCount + this.HCount + this.ICount + this.KCount + this.LCount + this.MCount + this.NCount + this.PCount + this.QCount + this.RCount + this.SCount + this.TCount + this.VCount + this.WCount + this.YCount;
                ++n6;
            }
            if (this.numUnits == 0L) {
                this.displayAlert("The input sequence provided is not a valid Protein sequence.");
                return "     No calculation was done";
            }
            if (this.badCharacter != 0L) {
                this.displayAlert("Character(s) other than the standard one-letter amino acid code were found.");
                this.newProtSequence();
                return "     No calculation was done";
            }
            return "Alanine:       " + decimalFormat.format(this.ACount) + "\tLeucine:       " + decimalFormat.format(this.LCount) + "\r" + "Arginine:      " + decimalFormat.format(this.RCount) + "\tLysine:        " + decimalFormat.format(this.KCount) + "\r" + "Asparagine:    " + decimalFormat.format(this.NCount) + "\tMethionine:    " + decimalFormat.format(this.MCount) + "\r" + "Aspartic Acid: " + decimalFormat.format(this.DCount) + "\tPhenylalanine: " + decimalFormat.format(this.FCount) + "\r" + "Cysteine:      " + decimalFormat.format(this.CCount) + "\tProline:       " + decimalFormat.format(this.PCount) + "\r" + "Glutamic Acid: " + decimalFormat.format(this.ECount) + "\tSerine:        " + decimalFormat.format(this.SCount) + "\r" + "Glutamine:     " + decimalFormat.format(this.QCount) + "\tThreonine:     " + decimalFormat.format(this.TCount) + "\r" + "Glycine:       " + decimalFormat.format(this.GCount) + "\tTryptophan:    " + decimalFormat.format(this.WCount) + "\r" + "Histidine:     " + decimalFormat.format(this.HCount) + "\tTyrosine:      " + decimalFormat.format(this.YCount) + "\r" + "Isoleucine:    " + decimalFormat.format(this.ICount) + "\tValine:        " + decimalFormat.format(this.VCount) + "\r" + "\r" + decimalFormat.format(this.numUnits) + " amino acids in total";
        }
        return "     No calculation was done";
    }

    String calculate(boolean bl) {
        if (this.numUnits == 0L || this.badCharacter != 0L) {
            if (!this.selection.equals("Protein")) {
                this.newNASequence();
            } else {
                this.newProtSequence();
            }
            return "     No calculation was done";
        }
        double d = 0.0;
        double d2 = 0.0;
        if (this.selection.equals("RNA")) {
            d = (float)this.aCount * AMP + (float)this.gCount * GMP + (float)this.cCount * CMP + (float)this.uCount * UMP + POP;
        }
        if (this.selection.equals("DNA")) {
            d = (float)this.aCount * dAMP + (float)this.gCount * dGMP + (float)this.cCount * dCMP + (float)this.tCount * dTMP + POP;
        }
        if (this.selection.equals("Protein")) {
            d = (float)this.ACount * Ala + (float)this.CCount * Cys + (float)this.DCount * Asp + (float)this.ECount * Glu + (float)this.FCount * Phe + (float)this.GCount * Gly + (float)this.HCount * His + (float)this.ICount * Ile + (float)this.KCount * Lys + (float)this.LCount * Leu + (float)this.MCount * Met + (float)this.NCount * Asn + (float)this.PCount * Pro + (float)this.QCount * Gln + (float)this.RCount * Arg + (float)this.SCount * Ser + (float)this.TCount * Thr + (float)this.VCount * Val + (float)this.WCount * Trp + (float)this.YCount * Tyr + H2O;
        }
        if (bl) {
            if (this.selection.equals("RNA")) {
                d2 = (float)this.aCount * UMP + (float)this.gCount * CMP + (float)this.cCount * GMP + (float)this.uCount * AMP + POP;
            }
            if (this.selection.equals("DNA")) {
                d2 = (float)this.aCount * dTMP + (float)this.gCount * dCMP + (float)this.cCount * dGMP + (float)this.tCount * dAMP + POP;
            }
        }
        long l = Math.round((d += d2) * 100.0);
        d = (double)l / 100.0;
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        if (!this.selection.equals("Protein")) {
            return "     " + decimalFormat.format(d);
        }
        return "     " + decimalFormat.format(d) + "  (" + decimalFormat.format(this.numUnits) + " aas)";
    }

    void allDone() {
        if (!this.selection.equals("Protein")) {
            this.newNASequence();
            return;
        }
        this.newProtSequence();
    }

    void displayAlert(String string) {
        new MWDialog(new Frame(), "Alert!", string);
    }
}

