/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class MWCalculator
extends Frame
implements ActionListener,
ItemListener {
    private Checkbox RNA;
    private Checkbox DNA;
    private Checkbox Protein;
    private String selection = "";
    static int howMany;
    static Vector freePos;
    static Font dia;
    static boolean macOS;

    public MWCalculator() {
        macOS = System.getProperty("os.name").equals("Mac OS");
        ((Component)this).setFont(dia);
        FontMetrics fontMetrics = this.getFontMetrics(dia);
        howMany = 0;
        freePos = new Vector();
        this.setTitle("Molecular Weight Calculator");
        String string = "  Determine the molecular weight of:";
        if (macOS) {
            ((Component)this).setBounds(25, 10, Math.round((float)fontMetrics.stringWidth(string) * 1.6f), fontMetrics.getHeight() * 2 * 5);
        } else {
            ((Component)this).setBounds(25, 35, Math.round((float)fontMetrics.stringWidth(string) * 1.6f), fontMetrics.getHeight() * 13);
        }
        this.setLayout(new GridLayout(5, 1));
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(0));
        Panel panel3 = new Panel();
        panel3.setLayout(new FlowLayout(1));
        Panel panel4 = new Panel();
        panel4.setLayout(new FlowLayout(1));
        Panel panel5 = new Panel();
        panel2.add(new Label(string, 0));
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.RNA = new Checkbox("RNA", checkboxGroup, false);
        this.RNA.addItemListener(this);
        panel3.add(this.RNA);
        this.DNA = new Checkbox("DNA", checkboxGroup, false);
        this.DNA.addItemListener(this);
        panel3.add(this.DNA);
        this.Protein = new Checkbox("Protein", checkboxGroup, false);
        this.Protein.addItemListener(this);
        panel3.add(this.Protein);
        Button button = new Button("Go...");
        button.addActionListener(this);
        panel4.add(button);
        this.add(panel);
        this.add(panel2);
        this.add(panel3);
        this.add(panel4);
        this.add(panel5);
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        menuBar.add(menu);
        MenuItem menuItem = new MenuItem("Quit", new MenuShortcut(113));
        menuItem.addActionListener(this);
        menu.add(menuItem);
        Menu menu2 = new Menu("Help");
        menuBar.add(menu2);
        MenuItem menuItem2 = new MenuItem("Instructions", new MenuShortcut(105));
        menuItem2.addActionListener(this);
        menu2.add(menuItem2);
        MenuItem menuItem3 = new MenuItem("About..", new MenuShortcut(97));
        menuItem3.addActionListener(this);
        menu2.add(menuItem3);
        this.setMenuBar(menuBar);
        this.addWindowListener(new 1());
        this.invalidate();
        this.validate();
        this.doLayout();
        ((Component)this).setVisible(true);
    }

    public static void main(String[] stringArray) {
        new MWCalculator();
    }

    private void exitMWCalculator() {
        this.dispose();
        System.exit(0);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.RNA.getState()) {
            this.selection = "RNA";
        }
        if (this.DNA.getState()) {
            this.selection = "DNA";
        }
        if (this.Protein.getState()) {
            this.selection = "Protein";
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Go...")) {
            if (this.selection.equals("")) {
                return;
            }
            new SeqInput(this.selection);
            return;
        }
        if (string.equals("Instructions")) {
            new Instructions(this);
            return;
        }
        if (string.equals("About..")) {
            new MWDialog((Frame)this, "About", "");
            return;
        }
        if (string.equals("Quit")) {
            this.exitMWCalculator();
            return;
        }
        new MWDialog((Frame)this, "Alert!", "Please inform me how this happened.");
    }

    static {
        dia = new Font("Dialog", 0, 12);
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            new MWDialog(new Frame(), "Alert!", "Quit Molecular Weight Calculator?");
        }

        /* synthetic */ 1() {
        }
    }
}

