/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.PrintJob;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileReader;
import java.io.IOException;
import javax.accessibility.Accessible;

public class SeqInput
extends Frame
implements ActionListener,
ItemListener {
    private Label inputFile = new Label("    Input file is: none", 0);
    private Label RNAnucContent = new Label("     0 As, 0 Gs, 0 Cs, 0 Us", 0);
    private Label DNAnucContent = new Label("     0 As, 0 Gs, 0 Cs, 0 Ts", 0);
    private Label molWeight = new Label("     ", 0);
    private TextField SeqName;
    private TextField tf;
    private TextArea ta;
    private Panel centerBottom1;
    private int freePosElement;
    private String sequence;
    private String TFSequence;
    private String TASequence;
    private String FRSequence;
    private String selection;
    private boolean doubleStrand = false;
    private Button bcalc1;
    private Button bcalc2;
    private Checkbox doubleStranded;
    private String prevFileName = "";
    private String fileName = "";
    private Calculator calc;
    private AACompDisplay AACDisplay;

    public SeqInput(String string) {
        Accessible accessible;
        Accessible accessible2;
        this.selection = string;
        this.calc = new Calculator(this.selection);
        this.setTitle(String.valueOf(this.selection) + " Molecular Weight Calculator");
        ((Component)this).setFont(MWCalculator.dia);
        Font font = new Font("Courier", 1, 12);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        if (!MWCalculator.freePos.isEmpty() && MWCalculator.freePos.contains(Boolean.TRUE)) {
            this.freePosElement = MWCalculator.freePos.indexOf(Boolean.TRUE);
            MWCalculator.freePos.setElementAt(Boolean.FALSE, this.freePosElement);
        } else {
            MWCalculator.freePos.addElement(Boolean.FALSE);
            this.freePosElement = MWCalculator.howMany++;
        }
        if (MWCalculator.macOS) {
            if (!this.selection.equals("Protein")) {
                ((Component)this).setBounds(40 + this.freePosElement * 20, 30 + this.freePosElement * 12, fontMetrics.charWidth('a') * 75, fontMetrics.getHeight() * 33);
            } else {
                ((Component)this).setBounds(40 + this.freePosElement * 20, 30 + this.freePosElement * 12, fontMetrics.charWidth('a') * 75, fontMetrics.getHeight() * 30);
            }
        } else if (!this.selection.equals("Protein")) {
            ((Component)this).setBounds(40 + this.freePosElement * 20, 45 + this.freePosElement * 12, fontMetrics.charWidth('a') * 75, fontMetrics.getHeight() * 34);
        } else {
            ((Component)this).setBounds(40 + this.freePosElement * 20, 45 + this.freePosElement * 12, fontMetrics.charWidth('a') * 75, fontMetrics.getHeight() * 32);
        }
        if (this.freePosElement * 20 + 80 >= this.getToolkit().getScreenSize().width || this.freePosElement * 12 + 60 >= this.getToolkit().getScreenSize().height) {
            MWCalculator.howMany = 0;
        }
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        Panel panel3 = new Panel();
        panel.setLayout(new GridLayout(3, 1));
        Panel panel4 = new Panel();
        panel4.setLayout(new GridLayout(1, 3));
        panel4.add(new Label("  Sequence name (optional):", 0));
        Panel panel5 = new Panel();
        panel5.setLayout(new BorderLayout());
        panel4.add(panel5);
        panel5.add("North", new Panel());
        panel5.add("South", new Panel());
        panel5.add("West", new Panel());
        panel5.add("East", new Panel());
        this.SeqName = new TextField();
        panel5.add("Center", this.SeqName);
        panel4.add(new Panel());
        panel.add(panel4);
        Panel panel6 = new Panel();
        panel6.setLayout(new BorderLayout());
        panel6.add("West", new Label("  Input field for short sequences:", 0));
        Panel panel7 = new Panel();
        panel7.setLayout(new BorderLayout());
        panel7.add("North", new Panel());
        panel7.add("South", new Panel());
        panel7.add("West", new Panel());
        panel7.add("East", new Panel());
        this.tf = new TextField();
        this.tf.setFont(font);
        this.tf.addActionListener(new 1());
        this.tf.addKeyListener(new 2());
        panel7.add("Center", this.tf);
        panel6.add("Center", panel7);
        panel.add(panel6);
        Panel panel8 = new Panel();
        this.bcalc1 = new Button("Calculate");
        this.bcalc1.addActionListener(this);
        panel8.setLayout(new FlowLayout());
        panel8.add(this.bcalc1);
        panel.add(panel8);
        panel2.setLayout(new BorderLayout());
        this.bcalc2 = new Button("Calculate");
        this.bcalc2.addActionListener(this);
        Panel panel9 = new Panel();
        panel9.setLayout(new FlowLayout(0));
        panel9.add(new Label("  Input field for long sequences:", 0));
        Panel panel10 = new Panel();
        this.ta = new TextArea(7, 60);
        this.ta.setFont(font);
        this.ta.addTextListener(new 3());
        panel10.add(this.ta);
        Panel panel11 = new Panel();
        panel11.setLayout(new GridLayout(2, 1));
        this.centerBottom1 = new Panel();
        panel11.add(this.centerBottom1);
        this.centerBottom1.setLayout(new FlowLayout(0));
        this.centerBottom1.add(new Label(" Import sequence from file:", 0));
        Button button = new Button("Open File");
        button.addActionListener(this);
        this.centerBottom1.add(button);
        this.centerBottom1.add(this.inputFile);
        Panel panel12 = new Panel();
        panel11.add(panel12);
        panel12.setLayout(new FlowLayout());
        panel12.add(this.bcalc2);
        panel2.add("North", panel9);
        panel2.add("Center", panel10);
        panel2.add("South", panel11);
        if (!this.selection.equals("Protein")) {
            if (MWCalculator.macOS) {
                panel3.setLayout(new GridLayout(4, 1));
            } else {
                panel3.setLayout(new GridLayout(5, 1));
            }
        } else {
            panel3.setLayout(new GridLayout(2, 1));
        }
        if (!this.selection.equals("Protein")) {
            panel3.add(new Label("  Nucleotide content:", 0));
        }
        if (this.selection.equals("RNA")) {
            panel3.add(this.RNAnucContent);
        }
        if (this.selection.equals("DNA")) {
            panel3.add(this.DNAnucContent);
        }
        panel3.add(new Label("  Molecular Weight:", 0));
        Panel panel13 = new Panel();
        panel13.setLayout(new GridLayout(1, 2));
        panel13.add(this.molWeight);
        if (!this.selection.equals("Protein")) {
            this.doubleStranded = new Checkbox("  double stranded?", false);
            this.doubleStranded.addItemListener(this);
            this.doubleStrand = false;
            panel13.add(this.doubleStranded);
        } else {
            accessible2 = new Panel();
            ((Container)((Object)accessible2)).setLayout(new FlowLayout());
            accessible = new Button("Show Amino Acid Composition");
            ((Button)accessible).addActionListener(this);
            ((Container)((Object)accessible2)).add((Component)((Object)accessible));
            panel13.add((Component)((Object)accessible2));
        }
        panel3.add(panel13);
        this.add("North", panel);
        this.add("Center", panel2);
        this.add("South", panel3);
        accessible2 = new MenuBar();
        accessible = new Menu("File");
        ((MenuBar)accessible2).add((Menu)accessible);
        MenuItem menuItem = new MenuItem("Close Window", new MenuShortcut(119));
        menuItem.addActionListener(this);
        MenuItem menuItem2 = new MenuItem("Print Screen", new MenuShortcut(112));
        menuItem2.addActionListener(this);
        MenuItem menuItem3 = new MenuItem("Quit", new MenuShortcut(113));
        menuItem3.addActionListener(this);
        ((Menu)accessible).add(menuItem);
        ((Menu)accessible).add(menuItem2);
        ((Menu)accessible).add(menuItem3);
        Menu menu = new Menu("Help");
        ((MenuBar)accessible2).add(menu);
        MenuItem menuItem4 = new MenuItem("Instructions", new MenuShortcut(105));
        menuItem4.addActionListener(this);
        menu.add(menuItem4);
        MenuItem menuItem5 = new MenuItem("About..", new MenuShortcut(97));
        menuItem5.addActionListener(this);
        menu.add(menuItem5);
        this.setMenuBar((MenuBar)accessible2);
        this.addWindowListener(new 4());
        ((Component)this).setVisible(true);
    }

    private void exitMWCalculator() {
        this.dispose();
        System.exit(0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Calculate")) {
            if (actionEvent.getSource().equals(this.bcalc1)) {
                this.TFSequence = this.tf.getText();
                if (this.TFSequence.equals("")) {
                    this.calc.displayAlert("The text field is empty.");
                    return;
                }
                this.sequence = this.TFSequence.toUpperCase();
            }
            if (actionEvent.getSource().equals(this.bcalc2)) {
                try {
                    if (this.TASequence.equals("")) {
                        this.calc.displayAlert("The text area is empty.");
                        return;
                    }
                    this.sequence = this.TASequence;
                }
                catch (NullPointerException nullPointerException) {
                    this.calc.displayAlert("The text area is empty.");
                    return;
                }
            }
            if (this.selection.equals("RNA")) {
                this.RNAnucContent.setText(this.calc.count(this.sequence));
            }
            if (this.selection.equals("DNA")) {
                this.DNAnucContent.setText(this.calc.count(this.sequence));
            }
            if (this.selection.equals("Protein")) {
                String string2 = this.calc.calculate(this.doubleStrand);
                this.AACDisplay = new AACompDisplay(new Frame(), this.calc.count(this.sequence), this.SeqName.getText(), string2);
                this.molWeight.setText(string2);
            }
            if (!this.selection.equals("Protein")) {
                this.molWeight.setText(this.calc.calculate(this.doubleStrand));
            }
            this.calc.allDone();
            return;
        }
        if (string.equals("Open File")) {
            FileDialog fileDialog = new FileDialog((Frame)this, "Open a File", 0);
            ((Component)fileDialog).setVisible(true);
            this.fileName = fileDialog.getFile();
            try {
                if (this.fileName.equals("null")) {
                    return;
                }
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
            this.prevFileName = this.fileName;
            String string3 = String.valueOf(fileDialog.getDirectory()) + this.fileName;
            try {
                FileReader fileReader = new FileReader(string3);
                int n = 0;
                StringBuffer stringBuffer = new StringBuffer();
                while (n != -1) {
                    n = fileReader.read();
                    if (n == -1) break;
                    char c = (char)n;
                    stringBuffer.append(c);
                }
                this.ta.setText(stringBuffer.toString());
                this.FRSequence = stringBuffer.toString().toUpperCase();
            }
            catch (IOException iOException) {
                new MWDialog((Frame)this, "Alert!", "IO error: " + iOException);
            }
            this.inputFile.setText("    Input file is: " + this.fileName);
            this.inputFile.setSize(this.getFontMetrics(MWCalculator.dia).stringWidth("     Input file is: " + this.fileName), this.inputFile.getSize().height);
            this.centerBottom1.doLayout();
            return;
        }
        if (string.equals("Show Amino Acid Composition")) {
            if (this.molWeight.getText().startsWith("     No ")) {
                return;
            }
            ((Component)this.AACDisplay).setVisible(true);
            return;
        }
        if (string.equals("Instructions")) {
            Instructions instructions = new Instructions(this);
            ((Component)instructions).setVisible(true);
            return;
        }
        if (string.equals("Print Screen")) {
            this.printScreen();
            return;
        }
        if (string.equals("About..")) {
            MWDialog mWDialog = new MWDialog((Frame)this, "About", "");
            ((Component)mWDialog).setVisible(true);
            return;
        }
        if (string.equals("Close Window")) {
            MWCalculator.freePos.setElementAt(Boolean.TRUE, this.freePosElement);
            this.dispose();
            try {
                if (this.selection.equals("Protein")) {
                    this.AACDisplay.dispose();
                    return;
                }
            }
            catch (NullPointerException nullPointerException) {}
            return;
        }
        if (string.equals("Quit")) {
            this.exitMWCalculator();
            return;
        }
        new MWDialog((Frame)this, "Alert!", "Please inform me how this happened.");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.doubleStrand = this.doubleStranded.getState();
        if (this.selection.equals("RNA")) {
            this.RNAnucContent.setText(this.calc.count(this.sequence));
        }
        if (this.selection.equals("DNA")) {
            this.DNAnucContent.setText(this.calc.count(this.sequence));
        }
        this.molWeight.setText(this.calc.calculate(this.doubleStrand));
        this.calc.allDone();
    }

    private void printScreen() {
        Graphics graphics;
        PrintJob printJob;
        Toolkit toolkit = this.getToolkit();
        try {
            printJob = toolkit.getPrintJob(this, "Print Screen", null);
        }
        catch (UnknownError unknownError) {
            return;
        }
        try {
            graphics = printJob.getGraphics();
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        this.printAll(graphics);
        graphics.dispose();
        printJob.end();
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SeqInput.this.TFSequence = SeqInput.this.sequence = actionEvent.getActionCommand().toUpperCase();
            if (SeqInput.this.selection.equals("RNA")) {
                SeqInput.this.RNAnucContent.setText(SeqInput.this.calc.count(SeqInput.this.sequence));
            }
            if (SeqInput.this.selection.equals("DNA")) {
                SeqInput.this.DNAnucContent.setText(SeqInput.this.calc.count(SeqInput.this.sequence));
            }
            if (SeqInput.this.selection.equals("Protein")) {
                String string = SeqInput.this.calc.calculate(SeqInput.this.doubleStrand);
                SeqInput.this.AACDisplay = new AACompDisplay(new Frame(), SeqInput.this.calc.count(SeqInput.this.sequence), SeqInput.this.SeqName.getText(), string);
                SeqInput.this.molWeight.setText(string);
            }
            if (!SeqInput.this.selection.equals("Protein")) {
                SeqInput.this.molWeight.setText(SeqInput.this.calc.calculate(SeqInput.this.doubleStrand));
            }
            SeqInput.this.calc.allDone();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (SeqInput.this.selection.equals("RNA") && c != 'A' && c != 'G' && c != 'C' && c != 'U' && c != 'a' && c != 'g' && c != 'c' && c != 'u' && c != '\n' && c != '\r' && c != '\b') {
                keyEvent.consume();
            }
            if (SeqInput.this.selection.equals("DNA") && c != 'A' && c != 'G' && c != 'C' && c != 'T' && c != 'a' && c != 'g' && c != 'c' && c != 't' && c != '\n' && c != '\r' && c != '\b') {
                keyEvent.consume();
            }
            if (SeqInput.this.selection.equals("Protein") && c != 'A' && c != 'a' && c != 'C' && c != 'c' && c != 'D' && c != 'd' && c != 'E' && c != 'e' && c != 'F' && c != 'f' && c != 'G' && c != 'g' && c != 'H' && c != 'h' && c != 'I' && c != 'i' && c != 'K' && c != 'k' && c != 'L' && c != 'l' && c != 'M' && c != 'm' && c != 'N' && c != 'n' && c != 'P' && c != 'p' && c != 'Q' && c != 'q' && c != 'R' && c != 'r' && c != 'S' && c != 's' && c != 'T' && c != 't' && c != 'V' && c != 'v' && c != 'W' && c != 'w' && c != 'Y' && c != 'y' && c != 'Z' && c != 'z' && c != '*' && c != '\n' && c != '\r' && c != '\b') {
                keyEvent.consume();
            }
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements TextListener {
        public void textValueChanged(TextEvent textEvent) {
            SeqInput.this.TASequence = SeqInput.this.ta.getText().toUpperCase();
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            MWCalculator.freePos.setElementAt(Boolean.TRUE, SeqInput.this.freePosElement);
            SeqInput.this.dispose();
            if (SeqInput.this.selection.equals("Protein")) {
                SeqInput.this.AACDisplay.dispose();
            }
        }

        /* synthetic */ 4() {
        }
    }
}

