/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.menu;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.JMenuItem;
import org.biolegato.core.main.BLMain;
import org.biolegato.core.plugintypes.DataFormat;
import org.biolegato.ezmenu.ActionThread;
import org.biolegato.ezmenu.EZMenuItem;
import org.biolegato.ezmenu.EZMenuType;

public class GDEMenu
extends EZMenuType {
    public static void loadMenu() {
        if (!"true".equalsIgnoreCase(BLMain.getProperty((String)"GDE.menu.disable"))) {
            if (System.getenv("GDE_HELP_DIR") != null) {
                GDEMenu.readGDEMenuFile(new File(System.getenv("GDE_HELP_DIR") + File.separator + ".GDEmenus"));
            } else {
                BLMain.warning((String)"GDE_HELP_DIR not set!", (String)"GDEMenu plugin");
            }
            GDEMenu.readGDEMenuFile(new File(BLMain.PROGRAM_DIR + File.separator + ".GDEmenus"));
            try {
                if (System.getProperty("user.home") != null) {
                    GDEMenu.readGDEMenuFile(new File(System.getProperty("user.home") + File.separator + ".GDEmenus"));
                } else {
                    BLMain.warning((String)"HOME not set!", (String)"GDEMenu plugin");
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static void readGDEMenuFile(File file) {
        String line = "";
        String menuName = "File";
        String fname = "";
        String fvalue = "";
        String itemName = "";
        BufferedReader reader = null;
        JMenuItem jmitemp = null;
        EZMenuItem currentItem = null;
        LinkedList<String> orderChoices = new LinkedList<String>();
        HashMap<String, String> choices = new HashMap<String, String>();
        HashMap<String, Object> infile = new HashMap<String, Object>();
        HashMap<String, Object> outfile = new HashMap<String, Object>();
        HashMap<String, Object> arg = new HashMap<String, Object>();
        if (file.exists() && file.isFile() && file.canRead()) {
            try {
                reader = new BufferedReader(new FileReader(file));
                do {
                    fname = "";
                    fvalue = "";
                    line = reader.readLine();
                    if (!(line == null || "".equals(line) || line.indexOf(58) < 0 || !line.startsWith("#@") && line.startsWith("#"))) {
                        if (line.startsWith("#@")) {
                            line = line.substring(2);
                        }
                        fname = line.substring(0, line.indexOf(58)).trim().toLowerCase();
                        fvalue = line.substring(line.indexOf(58) + 1).trim();
                    }
                    if (currentItem != null) {
                        if ((line == null || "item".equals(fname) || "arg".equals(fname) || "in".equals(fname) || "menu".equals(fname)) && infile.containsKey("name")) {
                            infile.put("type", "tempfile");
                            infile.put("input", Boolean.TRUE);
                            currentItem.addVariable(infile);
                            infile = new HashMap();
                        }
                        if ((line == null || "item".equals(fname) || "arg".equals(fname) || "out".equals(fname) || "menu".equals(fname)) && outfile.containsKey("name")) {
                            outfile.put("type", "tempfile");
                            outfile.put("output", Boolean.TRUE);
                            currentItem.addVariable(outfile);
                            outfile = new HashMap();
                        }
                        if ((line == null || "item".equals(fname) || "arg".equals(fname) || "menu".equals(fname)) && arg.containsKey("name")) {
                            if (!choices.isEmpty() && arg.containsKey("default")) {
                                if (!orderChoices.isEmpty() && BLMain.testNumber((char[])arg.get("default").toString().toCharArray())) {
                                    try {
                                        arg.put("default", choices.get(orderChoices.get(Integer.parseInt((String)arg.get("default")))));
                                    }
                                    catch (Throwable nfe) {}
                                } else {
                                    arg.put("default", choices.get((String)arg.get("default")));
                                }
                            }
                            arg.put("choices", choices);
                            arg.put("choiceorder", orderChoices.toArray(new String[0]));
                            if (arg.containsKey("name") && arg.containsKey("type")) {
                                currentItem.addVariable(new HashMap<String, Object>(arg));
                            }
                            orderChoices.clear();
                            choices = new HashMap();
                            arg = new HashMap();
                        }
                    }
                    if ("".equals(fname)) continue;
                    if ("menu".equals(fname)) {
                        menuName = fvalue;
                        BLMain.addMenuHeading((String)menuName);
                        continue;
                    }
                    if ("item".equals(fname)) {
                        itemName = fvalue;
                        currentItem = new EZMenuItem(itemName);
                        jmitemp = new JMenuItem(itemName);
                        jmitemp.addActionListener(currentItem);
                        BLMain.addMenuItem((String)menuName, (JMenuItem)jmitemp);
                        continue;
                    }
                    if (currentItem != null) {
                        if ("itemmeta".equals(fname) && fvalue.length() >= 1) {
                            if (fvalue.charAt(0) >= 'a' && fvalue.charAt(0) <= 'z' || fvalue.charAt(0) < 'A' || fvalue.charAt(0) > 'Z') continue;
                            continue;
                        }
                        if ("itemlabel".equals(fname) || "itemopen".equals(fname)) continue;
                        if ("itemhelp".equals(fname)) {
                            final String helpCommand = BLMain.getProperty((String)"GDE.help.viewer") + " " + BLMain.envreplace((String)BLMain.getProperty((String)"GDE.help.path")) + File.separator + fvalue;
                            currentItem.addButton(new ActionThread("Help", new Runnable(){

                                public void run() {
                                    try {
                                        BLMain.shellCommand((String)helpCommand, (String)"");
                                    }
                                    catch (Throwable e) {
                                        e.printStackTrace();
                                    }
                                }
                            }));
                            continue;
                        }
                        if ("itemmethod".equals(fname)) {
                            currentItem.setCommand(fvalue);
                            continue;
                        }
                        if ("arg".equals(fname)) {
                            arg.put("name", fvalue);
                            continue;
                        }
                        if ("argtype".equals(fname)) {
                            arg.put("type", fvalue);
                            continue;
                        }
                        if ("arglabel".equals(fname)) {
                            arg.put("description", fvalue);
                            continue;
                        }
                        if ("argmin".equals(fname)) {
                            try {
                                arg.put("minimum", Integer.parseInt(fvalue));
                            }
                            catch (NumberFormatException nfe) {
                                BLMain.error((String)("Invalid GDE field value (item: " + itemName + "): " + fname + " = " + fvalue), (String)"GDEMenu plugin");
                            }
                            continue;
                        }
                        if ("argmax".equals(fname)) {
                            try {
                                arg.put("maximum", Integer.parseInt(fvalue));
                            }
                            catch (NumberFormatException nfe) {
                                BLMain.error((String)("Invalid GDE field value (item: " + itemName + "): " + fname + " = " + fvalue), (String)"GDEMenu plugin");
                            }
                            continue;
                        }
                        if ("argvalue".equals(fname) || "argtext".equals(fname)) {
                            arg.put("default", fvalue);
                            continue;
                        }
                        if ("argchoice".equals(fname)) {
                            if (fvalue.indexOf(58) >= 0) {
                                choices.put(fvalue.substring(0, fvalue.indexOf(58)), fvalue.substring(fvalue.indexOf(58) + 1));
                                orderChoices.add(fvalue.substring(0, fvalue.indexOf(58)));
                                continue;
                            }
                            choices.put(fvalue, "");
                            orderChoices.add(fvalue);
                            BLMain.warning((String)("Badly formed argchoice field: " + fvalue), (String)"GDEMenu");
                            continue;
                        }
                        if ("in".equals(fname)) {
                            infile.put("name", fvalue);
                            continue;
                        }
                        if ("informat".equals(fname)) {
                            infile.put("format", DataFormat.getFormat((String)fvalue));
                            continue;
                        }
                        if ("inmask".equals(fname)) {
                            infile.put("mask", Boolean.TRUE);
                            continue;
                        }
                        if ("insave".equals(fname)) {
                            infile.put("save", Boolean.TRUE);
                            continue;
                        }
                        if ("out".equals(fname)) {
                            outfile.put("name", fvalue);
                            continue;
                        }
                        if ("outformat".equals(fname)) {
                            outfile.put("format", DataFormat.getFormat((String)fvalue));
                            continue;
                        }
                        if ("outsave".equals(fname)) {
                            outfile.put("save", Boolean.TRUE);
                            continue;
                        }
                        if ("outoverwrite".equals(fname)) {
                            outfile.put("overwrite", Boolean.TRUE);
                            continue;
                        }
                        BLMain.error((String)("Invalid GDE field (item: " + itemName + "): " + fname + " = " + fvalue), (String)"GDEMenu plugin");
                        continue;
                    }
                    BLMain.error((String)("Invalid GDE location or field value (item: " + itemName + "): " + fname + " = " + fvalue), (String)"GDEMenu plugin");
                } while (line != null);
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

