/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;

class Mol2Reader
extends AtomSetCollectionReader {
    int nAtoms = 0;
    int atomCount = 0;

    Mol2Reader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("mol2");
        this.setFractionalCoordinates(false);
        this.readLine();
        this.modelNumber = 0;
        while (this.line != null) {
            if (this.line.equals("@<TRIPOS>MOLECULE") && (++this.modelNumber == this.desiredModelNumber || this.desiredModelNumber <= 0)) {
                try {
                    this.processMolecule();
                }
                catch (Exception e) {
                    Logger.error("Could not read file at line: " + this.line, e);
                }
                if (this.desiredModelNumber <= 0) continue;
                break;
            }
            this.readLine();
        }
        return this.atomSetCollection;
    }

    void processMolecule() throws Exception {
        boolean iHaveCharges;
        String thisDataSetName = this.readLineTrimmed();
        this.readLine();
        this.line = this.line + " 0 0 0 0 0 0";
        this.atomCount = this.parseInt(this.line);
        int bondCount = this.parseInt(this.line, this.ichNextParse);
        int resCount = this.parseInt(this.line, this.ichNextParse);
        this.readLine();
        this.readLine();
        boolean bl = iHaveCharges = this.line.indexOf("NO_CHARGES") != 0;
        if (this.readLine() != null && (this.line.length() == 0 || this.line.charAt(0) != '@') && this.readLine() != null && this.line.length() != 0 && this.line.charAt(0) != '@') {
            thisDataSetName = thisDataSetName + ": " + this.readLineTrimmed();
            this.readLine();
        }
        this.newAtomSet(thisDataSetName);
        while (this.line != null && !this.line.equals("@<TRIPOS>MOLECULE")) {
            if (this.line.equals("@<TRIPOS>ATOM")) {
                this.readAtoms(this.atomCount, iHaveCharges);
                this.atomSetCollection.setAtomSetName(thisDataSetName);
            } else if (this.line.equals("@<TRIPOS>BOND")) {
                this.readBonds(bondCount);
            } else if (this.line.equals("@<TRIPOS>SUBSTRUCTURE")) {
                this.readResInfo(resCount);
            } else if (this.line.equals("@<TRIPOS>CRYSIN")) {
                this.readCrystalInfo();
            }
            this.readLine();
        }
        this.nAtoms += this.atomCount;
        this.applySymmetry();
    }

    void readAtoms(int atomCount, boolean iHaveCharges) throws Exception {
        for (int i = 0; i < atomCount; ++i) {
            Atom atom = this.atomSetCollection.addNewAtom();
            String[] tokens = this.getTokens(this.readLine());
            atom.atomName = tokens[1];
            this.setAtomCoord(atom, this.parseFloat(tokens[2]), this.parseFloat(tokens[3]), this.parseFloat(tokens[4]));
            String elementSymbol = tokens[5];
            if (elementSymbol.length() > 1 && elementSymbol.charAt(1) == '.') {
                elementSymbol = elementSymbol.substring(0, 1);
            }
            if (elementSymbol.length() > 2) {
                elementSymbol = elementSymbol.substring(0, 2);
            }
            atom.elementSymbol = elementSymbol;
            if (tokens.length <= 8) continue;
            atom.partialCharge = this.parseFloat(tokens[8]);
        }
    }

    void readBonds(int bondCount) throws Exception {
        for (int i = 0; i < bondCount; ++i) {
            String[] tokens = this.getTokens(this.readLine());
            int atomIndex1 = this.parseInt(tokens[1]);
            int atomIndex2 = this.parseInt(tokens[2]);
            int order = this.parseInt(tokens[3]);
            if (order == Integer.MIN_VALUE) {
                order = tokens[3].equals("ar") ? 4 : 1;
            }
            this.atomSetCollection.addBond(new Bond(this.nAtoms + atomIndex1 - 1, this.nAtoms + atomIndex2 - 1, order));
        }
    }

    void readResInfo(int resCount) throws Exception {
        for (int i = 0; i < resCount; ++i) {
            this.readLine();
        }
    }

    void readCrystalInfo() throws Exception {
        int i;
        this.readLine();
        this.ichNextParse = 0;
        for (i = 0; i < 6; ++i) {
            float f = this.parseFloat(this.line, this.ichNextParse);
            if (Float.isNaN(f)) {
                return;
            }
            this.setUnitCellItem(i, f);
        }
        this.setSpaceGroupName("P1");
        for (i = 0; i < this.atomCount; ++i) {
            this.setAtomCoord(this.atomSetCollection.atoms[this.nAtoms + i]);
        }
    }
}

