/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.Hashtable;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.JmolAdapter;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Logger;

class PdbReader
extends AtomSetCollectionReader {
    int lineLength;
    int[] serialMap = new int[512];
    boolean isNMRdata;
    final Hashtable htFormul = new Hashtable();
    Hashtable htHetero = null;
    String currentGroup3;
    Hashtable htElementsInCurrentGroup;

    PdbReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("pdb");
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("isPDB", Boolean.TRUE);
        this.setFractionalCoordinates(false);
        this.htFormul.clear();
        this.currentGroup3 = null;
        this.isNMRdata = false;
        boolean iHaveModel = false;
        boolean iHaveModelStatement = false;
        while (this.readLine() != null) {
            this.lineLength = this.line.length();
            if (this.line.startsWith("MODEL ")) {
                iHaveModelStatement = true;
                if (++this.modelNumber != this.desiredModelNumber && this.desiredModelNumber > 0) {
                    if (!iHaveModel) continue;
                    break;
                }
                iHaveModel = true;
                this.applySymmetry();
                this.model();
                continue;
            }
            if (this.line.startsWith("HELIX ") || this.line.startsWith("SHEET ") || this.line.startsWith("TURN  ")) {
                this.structure();
                continue;
            }
            if (this.line.startsWith("HET   ")) {
                this.het();
                continue;
            }
            if (this.line.startsWith("HETNAM")) {
                this.hetnam();
                continue;
            }
            if (this.line.startsWith("CRYST1")) {
                this.cryst1();
                continue;
            }
            if (this.line.startsWith("SCALE1")) {
                this.scale(1);
                continue;
            }
            if (this.line.startsWith("SCALE2")) {
                this.scale(2);
                continue;
            }
            if (this.line.startsWith("SCALE3")) {
                this.scale(3);
                continue;
            }
            if (this.line.startsWith("EXPDTA")) {
                this.expdta();
                continue;
            }
            if (this.line.startsWith("FORMUL")) {
                this.formul();
                continue;
            }
            if (this.line.startsWith("REMARK")) {
                Logger.debug(this.line);
                this.checkLineForScript();
                continue;
            }
            if (this.line.startsWith("HEADER") && this.lineLength >= 66) {
                this.atomSetCollection.setCollectionName(this.line.substring(62, 66));
                continue;
            }
            if (iHaveModelStatement && !iHaveModel) continue;
            if (this.line.startsWith("ATOM  ") || this.line.startsWith("HETATM")) {
                this.atom();
                continue;
            }
            if (!this.line.startsWith("CONECT")) continue;
            this.conect();
        }
        this.serialMap = null;
        if (!this.isNMRdata) {
            this.applySymmetry();
        }
        return this.atomSetCollection;
    }

    void atom() {
        boolean isHetero = this.line.startsWith("HETATM");
        try {
            char charAlternateLocation = this.line.charAt(16);
            int serial = this.parseInt(this.line, 6, 11);
            char chainID = this.line.charAt(21);
            int sequenceNumber = this.parseInt(this.line, 22, 26);
            char insertionCode = this.line.charAt(26);
            String group3 = this.parseToken(this.line, 17, 20);
            if (group3 == null) {
                this.currentGroup3 = group3;
                this.htElementsInCurrentGroup = null;
            } else if (!group3.equals(this.currentGroup3)) {
                this.currentGroup3 = group3;
                this.htElementsInCurrentGroup = (Hashtable)this.htFormul.get(group3);
            }
            String elementSymbol = this.deduceElementSymbol();
            String rawAtomName = this.line.substring(12, 16);
            String atomName = rawAtomName.trim();
            int charge = 0;
            if (this.lineLength >= 80) {
                char chMagnitude = this.line.charAt(78);
                char chSign = this.line.charAt(79);
                if (chSign >= '0' && chSign <= '7') {
                    char chT = chSign;
                    chSign = chMagnitude;
                    chMagnitude = chT;
                }
                if ((chSign == '+' || chSign == '-' || chSign == ' ') && chMagnitude >= '0' && chMagnitude <= '7') {
                    charge = chMagnitude - 48;
                    if (chSign == '-') {
                        charge = -charge;
                    }
                }
            }
            float bfactor = this.parseFloat(this.line, 60, 66);
            int occupancy = 100;
            float floatOccupancy = this.parseFloat(this.line, 54, 60);
            if (floatOccupancy != Float.NaN) {
                occupancy = (int)(floatOccupancy * 100.0f);
            }
            float x = this.parseFloat(this.line, 30, 38);
            float y = this.parseFloat(this.line, 38, 46);
            float z = this.parseFloat(this.line, 46, 54);
            if (serial >= this.serialMap.length) {
                this.serialMap = ArrayUtil.setLength(this.serialMap, serial + 500);
            }
            Atom atom = new Atom();
            atom.elementSymbol = elementSymbol;
            atom.atomName = atomName;
            if (charAlternateLocation != ' ') {
                atom.alternateLocationID = charAlternateLocation;
            }
            atom.formalCharge = charge;
            atom.occupancy = occupancy;
            atom.bfactor = bfactor;
            this.setAtomCoord(atom, x, y, z);
            atom.isHetero = isHetero;
            atom.chainID = chainID;
            atom.atomSerial = serial;
            atom.group3 = this.currentGroup3;
            atom.sequenceNumber = sequenceNumber;
            atom.insertionCode = JmolAdapter.canonizeInsertionCode(insertionCode);
            this.atomSetCollection.addAtom(atom);
            this.serialMap[serial] = this.atomSetCollection.atomCount;
            if (isHetero && this.htHetero != null) {
                this.atomSetCollection.setAtomSetAuxiliaryInfo("hetNames", this.htHetero);
                this.htHetero = null;
            }
        }
        catch (NumberFormatException e) {
            this.logger.log("bad record", "" + this.line);
        }
    }

    String deduceElementSymbol() {
        if (this.lineLength >= 78) {
            char ch76 = this.line.charAt(76);
            char ch77 = this.line.charAt(77);
            if (ch76 == ' ' && Atom.isValidElementSymbol(ch77)) {
                return "" + ch77;
            }
            if (Atom.isValidElementSymbolNoCaseSecondChar(ch76, ch77)) {
                return "" + ch76 + ch77;
            }
        }
        char ch12 = this.line.charAt(12);
        char ch13 = this.line.charAt(13);
        if ((this.htElementsInCurrentGroup == null || this.htElementsInCurrentGroup.get(this.line.substring(12, 14)) != null) && Atom.isValidElementSymbolNoCaseSecondChar(ch12, ch13)) {
            return "" + ch12 + ch13;
        }
        if ((this.htElementsInCurrentGroup == null || this.htElementsInCurrentGroup.get("" + ch13) != null) && Atom.isValidElementSymbol(ch13)) {
            return "" + ch13;
        }
        if ((this.htElementsInCurrentGroup == null || this.htElementsInCurrentGroup.get("" + ch12) != null) && Atom.isValidElementSymbol(ch12)) {
            return "" + ch12;
        }
        return "Xx";
    }

    void conect() {
        int sourceSerial = -1;
        int sourceIndex = -1;
        try {
            sourceSerial = this.parseInt(this.line, 6, 11);
            sourceIndex = this.serialMap[sourceSerial] - 1;
            if (sourceIndex < 0) {
                return;
            }
            for (int i = 0; i < 9; i += i == 5 ? 2 : 1) {
                int targetIndex;
                int targetSerial = this.getTargetSerial(i);
                if (targetSerial < 0 || (targetIndex = this.serialMap[targetSerial] - 1) < 0) continue;
                if (this.atomSetCollection.bondCount > 0) {
                    Bond bond = this.atomSetCollection.bonds[this.atomSetCollection.bondCount - 1];
                    if (i < 4 && bond.atomIndex1 == sourceIndex && bond.atomIndex2 == targetIndex) {
                        ++bond.order;
                        continue;
                    }
                }
                this.atomSetCollection.addBond(new Bond(sourceIndex, targetIndex, i < 4 ? 1 : 64));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    int getTargetSerial(int i) {
        int offset = i * 5 + 11;
        int offsetEnd = offset + 5;
        if (offsetEnd <= this.lineLength) {
            return this.parseInt(this.line, offset, offsetEnd);
        }
        return Integer.MIN_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    void structure() {
        void var4_4;
        void var3_3;
        void var2_2;
        void var5_5;
        int endIndex;
        int endChainIDIndex;
        int startIndex;
        int startChainIDIndex;
        String structureType = "none";
        if (this.line.startsWith("HELIX ")) {
            structureType = "helix";
            startChainIDIndex = 19;
            startIndex = 21;
            endChainIDIndex = 31;
            endIndex = 33;
        } else if (this.line.startsWith("SHEET ")) {
            structureType = "sheet";
            startChainIDIndex = 21;
            startIndex = 22;
            endChainIDIndex = 32;
            endIndex = 33;
        } else if (this.line.startsWith("TURN  ")) {
            structureType = "turn";
            startChainIDIndex = 19;
            startIndex = 20;
            endChainIDIndex = 30;
            endIndex = 31;
        } else {
            return;
        }
        if (this.lineLength < var5_5 + 4) {
            return;
        }
        char startChainID = this.line.charAt((int)var2_2);
        int startSequenceNumber = this.parseInt(this.line, (int)var3_3, (int)(var3_3 + 4));
        char startInsertionCode = this.line.charAt((int)(var3_3 + 4));
        char endChainID = this.line.charAt((int)var4_4);
        int endSequenceNumber = this.parseInt(this.line, (int)var5_5, (int)(var5_5 + 4));
        char endInsertionCode = ' ';
        if (this.lineLength > var5_5 + 4) {
            endInsertionCode = this.line.charAt((int)(var5_5 + 4));
        }
        Structure structure = new Structure(0, structureType, startChainID, startSequenceNumber, startInsertionCode, endChainID, endSequenceNumber, endInsertionCode);
        this.atomSetCollection.addStructure(structure);
    }

    void model() {
        try {
            int startModelColumn = 6;
            int endModelColumn = 14;
            if (endModelColumn > this.lineLength) {
                endModelColumn = this.lineLength;
            }
            int modelNumber = this.parseInt(this.line, startModelColumn, endModelColumn);
            this.atomSetCollection.newAtomSet();
            this.atomSetCollection.setAtomSetNumber(modelNumber);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    void cryst1() {
        try {
            this.setUnitCell(this.getFloat(6, 9), this.getFloat(15, 9), this.getFloat(24, 9), this.getFloat(33, 7), this.getFloat(40, 7), this.getFloat(47, 7));
            this.setSpaceGroupName(this.parseTrimmed(this.line, 55, 66));
        }
        catch (Exception e) {
            Logger.error("error in cryst1 line");
            return;
        }
    }

    float getFloat(int ich, int cch) throws Exception {
        return this.parseFloat(this.line, ich, ich + cch);
    }

    void scale(int n) throws Exception {
        int pt = n * 4 + 2;
        this.setUnitCellItem(pt++, this.getFloat(10, 10));
        this.setUnitCellItem(pt++, this.getFloat(20, 10));
        this.setUnitCellItem(pt++, this.getFloat(30, 10));
        this.setUnitCellItem(pt++, this.getFloat(45, 10));
    }

    void expdta() {
        String technique = this.parseTrimmed(this.line, 10).toLowerCase();
        if (technique.regionMatches(true, 0, "nmr", 0, 3)) {
            this.isNMRdata = true;
        }
    }

    void formul() {
        String elementWithCount;
        Hashtable<String, Boolean> htElementsInGroup;
        String groupName = this.parseToken(this.line, 12, 15);
        String formula = this.parseTrimmed(this.line, 19, 70);
        int ichLeftParen = formula.indexOf(40);
        if (ichLeftParen >= 0) {
            int ichRightParen = formula.indexOf(41);
            if (ichRightParen < 0 || ichLeftParen >= ichRightParen || ichLeftParen + 1 == ichRightParen) {
                return;
            }
            formula = this.parseTrimmed(formula, ichLeftParen + 1, ichRightParen);
        }
        if ((htElementsInGroup = (Hashtable<String, Boolean>)this.htFormul.get(groupName)) == null) {
            htElementsInGroup = new Hashtable<String, Boolean>();
            this.htFormul.put(groupName, htElementsInGroup);
        }
        this.ichNextParse = 0;
        while ((elementWithCount = this.parseToken(formula, this.ichNextParse)) != null) {
            char chSecond;
            if (elementWithCount.length() < 2) continue;
            char chFirst = elementWithCount.charAt(0);
            if (Atom.isValidElementSymbolNoCaseSecondChar(chFirst, chSecond = elementWithCount.charAt(1))) {
                htElementsInGroup.put("" + chFirst + chSecond, Boolean.TRUE);
                continue;
            }
            if (!Atom.isValidElementSymbol(chFirst)) continue;
            htElementsInGroup.put("" + chFirst, Boolean.TRUE);
        }
    }

    void het() {
        if (this.htHetero == null) {
            this.htHetero = new Hashtable();
        }
        String groupName = this.parseToken(this.line, 7, 10);
        String hetName = this.line.substring(30, 70).trim();
        String htName = (String)this.htHetero.get(groupName);
        if (htName != null) {
            return;
        }
        this.htHetero.put(groupName, hetName);
        this.logger.log("het: " + groupName);
    }

    void hetnam() {
        if (this.htHetero == null) {
            this.htHetero = new Hashtable();
        }
        String groupName = this.parseToken(this.line, 11, 14);
        String hetName = this.parseTrimmed(this.line, 15, 70);
        String htName = (String)this.htHetero.get(groupName);
        if (htName != null) {
            hetName = htName + hetName;
        }
        this.htHetero.put(groupName, hetName);
        this.logger.log("hetero: " + groupName + " " + hetName);
    }

    void applySymmetry() {
        if (this.needToApplySymmetry && this.spaceGroup.indexOf(":") < 0) {
            this.spaceGroup = this.spaceGroup + ":?";
        }
        super.applySymmetry();
    }
}

