/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

public class IntInt2ObjHash {
    int entryCount;
    Entry[] entries;

    public IntInt2ObjHash(int initialCapacity) {
        this.entries = new Entry[initialCapacity];
    }

    public IntInt2ObjHash() {
        this(256);
    }

    public synchronized Object get(int key1, int key2) {
        Entry[] entries = this.entries;
        int k = (key1 ^ key2 >> 1) & Integer.MAX_VALUE;
        int hash = k % entries.length;
        Entry e = entries[hash];
        while (e != null) {
            if (e.key1 == key1 && e.key2 == key2) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public synchronized void put(int key1, int key2, Object value) {
        Entry[] entries = this.entries;
        int k = (key1 ^ key2 >> 1) & Integer.MAX_VALUE;
        int hash = k % entries.length;
        Entry e = entries[hash];
        while (e != null) {
            if (e.key1 == key1 && e.key2 == key2) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        if (this.entryCount > entries.length) {
            this.rehash();
        }
        entries = this.entries;
        hash = k % entries.length;
        entries[hash] = new Entry(key1, key2, value, entries[hash]);
        ++this.entryCount;
    }

    private void rehash() {
        Entry[] oldEntries = this.entries;
        int oldSize = oldEntries.length;
        int newSize = oldSize * 2 + 1;
        this.entries = new Entry[newSize];
        Entry[] newEntries = this.entries;
        int i = oldSize;
        while (--i >= 0) {
            Entry e = oldEntries[i];
            while (e != null) {
                Entry t = e;
                e = e.next;
                int k = (t.key1 ^ t.key2 >> 1) & Integer.MAX_VALUE;
                int hash = k % newSize;
                t.next = newEntries[hash];
                newEntries[hash] = t;
            }
        }
    }

    static class Entry {
        int key1;
        int key2;
        Object value;
        Entry next;

        Entry(int key1, int key2, Object value, Entry next) {
            this.key1 = key1;
            this.key2 = key2;
            this.value = value;
            this.next = next;
        }
    }
}

