/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.ArrayUtil;
import org.jmol.viewer.Atom;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Shape;

class AtomShape
extends Shape {
    short[] mads;
    short[] colixes;
    byte[] paletteIDs;
    BitSet bsSizeSet;
    BitSet bsColixSet;
    int atomCount;
    Atom[] atoms;
    boolean isActive;

    AtomShape() {
    }

    void initShape() {
        this.atomCount = this.frame.atomCount;
        this.atoms = this.frame.atoms;
    }

    void setSize(int size, BitSet bsSelected) {
        this.isActive = true;
        if (this.bsSizeSet == null) {
            this.bsSizeSet = new BitSet();
        }
        boolean isVisible = size != 0;
        int i = this.atomCount;
        while (--i >= 0) {
            if (!bsSelected.get(i)) continue;
            if (this.mads == null) {
                this.mads = new short[this.atomCount];
            }
            Atom atom = this.atoms[i];
            this.mads[i] = atom.convertEncodedMad(size);
            this.bsSizeSet.set(i, isVisible);
            atom.setShapeVisibility(this.myVisibilityFlag, isVisible);
        }
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        if ("color" == propertyName) {
            this.isActive = true;
            short colix = Graphics3D.getColix(value);
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            byte pid = JmolConstants.pidOf(value);
            int i = this.atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                this.setColixAndPalette(colix, pid, i);
            }
            return;
        }
        if ("translucency" == propertyName) {
            boolean isTranslucent;
            this.isActive = true;
            boolean bl = isTranslucent = "translucent" == value;
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            int i = this.atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                if (this.colixes == null) {
                    this.colixes = new short[this.atomCount];
                    this.paletteIDs = new byte[this.atomCount];
                }
                this.colixes[i] = Graphics3D.getColixTranslucent(this.colixes[i], isTranslucent);
                if (!isTranslucent) continue;
                this.bsColixSet.set(i);
            }
            return;
        }
    }

    void setColixAndPalette(short colix, byte paletteID, int atomIndex) {
        if (this.colixes == null || atomIndex >= this.colixes.length) {
            if (colix == 0) {
                return;
            }
            this.colixes = ArrayUtil.ensureLength(this.colixes, atomIndex + 1);
            this.paletteIDs = ArrayUtil.ensureLength(this.paletteIDs, atomIndex + 1);
        }
        if (this.bsColixSet == null) {
            this.bsColixSet = new BitSet();
        }
        this.colixes[atomIndex] = colix = this.setColix(colix, paletteID, atomIndex);
        this.bsColixSet.set(atomIndex, colix != 0);
        this.paletteIDs[atomIndex] = paletteID;
    }

    void setModelClickability() {
        if (!this.isActive) {
            return;
        }
        int i = this.atomCount;
        while (--i >= 0) {
            Atom atom = this.atoms[i];
            if ((atom.shapeVisibilityFlags & this.myVisibilityFlag) == 0 || this.frame.bsHidden.get(i)) continue;
            atom.clickabilityFlags |= this.myVisibilityFlag;
        }
    }

    String getShapeState() {
        if (!this.isActive) {
            return "";
        }
        Hashtable temp = new Hashtable();
        Hashtable temp2 = new Hashtable();
        String type = JmolConstants.shapeClassBases[this.shapeID];
        int i = this.atomCount;
        while (--i >= 0) {
            if (this.bsSizeSet != null && this.bsSizeSet.get(i)) {
                Shape.setStateInfo(temp, i, type + " " + (float)this.mads[i] / 2000.0f);
            }
            if (this.bsColixSet == null || !this.bsColixSet.get(i)) continue;
            Shape.setStateInfo(temp2, i, this.getColorCommand(type, this.paletteIDs[i], this.colixes[i]));
        }
        return Shape.getShapeCommands(temp, temp2, this.atomCount);
    }
}

