/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.AtomShape;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Shape;

class Balls
extends AtomShape {
    Balls() {
    }

    void setSize(int size, BitSet bsSelected) {
        int bsLength;
        short mad = (short)size;
        this.isActive = true;
        if (this.bsSizeSet == null) {
            this.bsSizeSet = new BitSet();
        }
        int i = bsLength = bsSelected.length();
        while (--i >= 0) {
            if (!bsSelected.get(i)) continue;
            Atom atom = this.atoms[i];
            atom.setMadAtom(mad);
            this.bsSizeSet.set(i);
        }
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        if ("color" == propertyName) {
            short colix = Graphics3D.getColix(value);
            if (colix == 0) {
                colix = 2;
            }
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            byte pid = JmolConstants.pidOf(value);
            int i = this.atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                Atom atom = this.atoms[i];
                atom.setColixAtom(this.setColix(colix, pid, atom));
                this.bsColixSet.set(i, colix != 2 || pid != 0);
                atom.setPaletteID(pid);
            }
            return;
        }
        if ("translucency" == propertyName) {
            boolean isTranslucent = ((String)value).equals("translucent");
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            int i = this.atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                this.atoms[i].setTranslucent(isTranslucent);
                if (!isTranslucent) continue;
                this.bsColixSet.set(i);
            }
            return;
        }
    }

    void setModelClickability() {
        int i = this.atomCount;
        while (--i >= 0) {
            Atom atom = this.atoms[i];
            atom.clickabilityFlags = 0;
            if ((atom.shapeVisibilityFlags & this.myVisibilityFlag) == 0 || this.frame.bsHidden.get(i)) continue;
            atom.clickabilityFlags |= this.myVisibilityFlag;
        }
    }

    void setVisibilityFlags(BitSet bs) {
        int displayModelIndex = this.viewer.getDisplayModelIndex();
        boolean isOneFrame = displayModelIndex >= 0;
        boolean showHydrogens = this.viewer.getShowHydrogens();
        int i = this.atomCount;
        while (--i >= 0) {
            Atom atom = this.atoms[i];
            atom.shapeVisibilityFlags &= 0xFFFFFFFE & ~this.myVisibilityFlag;
            if (atom.madAtom == Short.MIN_VALUE || !showHydrogens && atom.getElementNumber() == 1 || (isOneFrame || !bs.get(atom.modelIndex)) && atom.modelIndex != displayModelIndex) continue;
            atom.shapeVisibilityFlags |= 1;
            if (atom.madAtom == 0 || this.frame.bsHidden.get(i)) continue;
            atom.shapeVisibilityFlags |= this.myVisibilityFlag;
        }
    }

    String getShapeState() {
        Hashtable temp = new Hashtable();
        for (int i = 0; i < this.atomCount; ++i) {
            byte pid;
            if (this.bsSizeSet != null && this.bsSizeSet.get(i)) {
                Shape.setStateInfo(temp, i, "Spacefill " + (float)this.atoms[i].madAtom / 2000.0f);
            }
            if (this.bsColixSet == null || !this.bsColixSet.get(i) || (pid = this.atoms[i].getPaletteID()) == 1) continue;
            Shape.setStateInfo(temp, i, this.getColorCommand("atoms", pid, this.atoms[i].colixAtom));
        }
        return Shape.getShapeCommands(temp, null, this.atomCount);
    }
}

