/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.g3d.Graphics3D;
import org.jmol.util.Logger;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Frame;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

class ColorManager {
    Viewer viewer;
    Graphics3D g3d;
    int[] argbsCpk;
    int[] altArgbsCpk;
    boolean isDefaultColorRasmol;
    short colixRubberband = (short)22;
    short colixBackgroundContrast;

    ColorManager(Viewer viewer, Graphics3D g3d) {
        this.viewer = viewer;
        this.g3d = g3d;
        this.argbsCpk = JmolConstants.argbsCpk;
        this.altArgbsCpk = new int[JmolConstants.altArgbsCpk.length];
        int i = JmolConstants.altArgbsCpk.length;
        while (--i >= 0) {
            this.altArgbsCpk[i] = JmolConstants.altArgbsCpk[i];
        }
    }

    boolean getDefaultColorRasmol() {
        return this.isDefaultColorRasmol;
    }

    void resetElementColors() {
        this.setDefaultColors("Jmol");
    }

    void setDefaultColors(String colorScheme) {
        if (colorScheme.equalsIgnoreCase("Jmol")) {
            this.isDefaultColorRasmol = false;
            this.argbsCpk = JmolConstants.argbsCpk;
        } else if (colorScheme.equalsIgnoreCase("RasMol")) {
            this.isDefaultColorRasmol = true;
            this.copyArgbsCpk();
            int argb = JmolConstants.argbsCpkRasmol[0] | 0xFF000000;
            int i = this.argbsCpk.length;
            while (--i >= 0) {
                this.argbsCpk[i] = argb;
            }
            i = JmolConstants.argbsCpkRasmol.length;
            while (--i >= 0) {
                argb = JmolConstants.argbsCpkRasmol[i];
                int atomNo = argb >> 24;
                this.argbsCpk[atomNo] = argb |= 0xFF000000;
            }
        } else {
            Logger.error("unrecognized color scheme");
            return;
        }
        int i = JmolConstants.argbsCpk.length;
        while (--i >= 0) {
            this.g3d.changeColixArgb((short)i, this.argbsCpk[i]);
        }
        i = JmolConstants.altArgbsCpk.length;
        while (--i >= 0) {
            this.g3d.changeColixArgb((short)(JmolConstants.elementNumberMax + i), this.altArgbsCpk[i]);
        }
    }

    void copyArgbsCpk() {
        this.argbsCpk = new int[JmolConstants.argbsCpk.length];
        int i = JmolConstants.argbsCpk.length;
        while (--i >= 0) {
            this.argbsCpk[i] = JmolConstants.argbsCpk[i];
        }
        this.altArgbsCpk = new int[JmolConstants.altArgbsCpk.length];
        i = JmolConstants.altArgbsCpk.length;
        while (--i >= 0) {
            this.altArgbsCpk[i] = JmolConstants.altArgbsCpk[i];
        }
    }

    void setRubberbandArgb(int argb) {
        this.colixRubberband = argb == 0 ? (short)0 : Graphics3D.getColix(argb);
    }

    void setColixBackgroundContrast(int argb) {
        this.colixBackgroundContrast = (short)((Graphics3D.calcGreyscaleRgbFromRgb(argb) & 0xFF) < 128 ? 8 : 4);
    }

    short getColixBackgroundContrast() {
        return this.colixBackgroundContrast;
    }

    short getColixAtomPalette(Atom atom, byte pid) {
        int argb = 0;
        switch (pid) {
            case 16: {
                short id = atom.getAtomicAndIsotopeNumber();
                argb = this.getJmolOrRasmolArgb(id, 16430);
                break;
            }
            case 17: {
                short id = atom.getAtomicAndIsotopeNumber();
                argb = this.getJmolOrRasmolArgb(id, 16392);
                break;
            }
            case 0: 
            case 1: {
                short id = atom.getAtomicAndIsotopeNumber();
                if (id < 256) {
                    return this.g3d.getChangableColix(id, this.argbsCpk[id]);
                }
                id = (short)JmolConstants.altElementIndexFromNumber(id);
                return this.g3d.getChangableColix((short)(JmolConstants.elementNumberMax + id), this.altArgbsCpk[id]);
            }
            case 2: {
                int index = this.quantize(atom.getPartialCharge(), -1.0f, 1.0f, 31);
                return this.g3d.getChangableColix((short)(JmolConstants.PARTIAL_CHARGE_COLIX_RED + index), JmolConstants.argbsRwbScale[index]);
            }
            case 3: {
                int index = atom.getFormalCharge() - -4;
                return this.g3d.getChangableColix((short)(JmolConstants.FORMAL_CHARGE_COLIX_RED + index), JmolConstants.argbsFormalCharge[index]);
            }
            case 5: 
            case 68: {
                float hi;
                float lo;
                if (pid == 68) {
                    Frame frame = this.viewer.getFrame();
                    lo = frame.getBfactor100Lo();
                    hi = frame.getBfactor100Hi();
                } else {
                    lo = 0.0f;
                    hi = 10000.0f;
                }
                int index = this.quantize(atom.getBfactor100(), lo, hi, JmolConstants.argbsRwbScale.length);
                index = JmolConstants.argbsRwbScale.length - 1 - index;
                argb = JmolConstants.argbsRwbScale[index];
                break;
            }
            case 70: {
                float hi = this.viewer.getFrame().getSurfaceDistanceMax();
                int index = this.quantize(atom.getSurfaceDistance100(), 0.0f, hi, JmolConstants.argbsRwbScale.length);
                argb = JmolConstants.argbsRwbScale[index];
                break;
            }
            case 7: {
                argb = JmolConstants.argbsStructure[atom.getProteinStructureType()];
                break;
            }
            case 8: {
                short index = atom.getGroupID();
                if (index < 0 || index >= 23) {
                    index = 0;
                }
                argb = JmolConstants.argbsAmino[index];
                break;
            }
            case 9: {
                short index = atom.getGroupID();
                if (index < 0 || index >= 36) {
                    index = 0;
                }
                argb = JmolConstants.argbsShapely[index];
                break;
            }
            case 10: {
                int chain = atom.getChainID() & 0x1F;
                if (chain < 0) {
                    chain = 0;
                }
                if (chain >= JmolConstants.argbsChainAtom.length) {
                    chain %= JmolConstants.argbsChainAtom.length;
                }
                argb = (atom.isHetero() ? JmolConstants.argbsChainHetero : JmolConstants.argbsChainAtom)[chain];
                break;
            }
            case 75: {
                int index = this.quantize(atom.getSelectedGroupIndexWithinChain(), 0.0f, atom.getSelectedGroupCountWithinChain() - 1, JmolConstants.argbsRoygbScale.length);
                index = JmolConstants.argbsRoygbScale.length - 1 - index;
                argb = JmolConstants.argbsRoygbScale[index];
                break;
            }
            case 76: {
                int index = this.quantize(atom.getSelectedMonomerIndexWithinPolymer(), 0.0f, atom.getSelectedMonomerCountWithinPolymer() - 1, JmolConstants.argbsRoygbScale.length);
                index = JmolConstants.argbsRoygbScale.length - 1 - index;
                argb = JmolConstants.argbsRoygbScale[index];
                break;
            }
            case 77: {
                Frame frame = this.viewer.getFrame();
                int index = this.quantize(frame.getMoleculeIndex(atom.atomIndex), 0.0f, frame.getMoleculeCountInModel(atom.modelIndex) - 1, JmolConstants.argbsRoygbScale.length);
                argb = JmolConstants.argbsRoygbScale[index];
                break;
            }
            case 14: {
                Frame frame = this.viewer.getFrame();
                int index = this.quantize(frame.getAltLocIndexInModel(atom.modelIndex, (char)atom.alternateLocationID), 0.0f, frame.getAltLocCountInModel(atom.modelIndex), JmolConstants.argbsRoygbScale.length);
                argb = JmolConstants.argbsRoygbScale[index];
                break;
            }
            case 15: {
                Frame frame = this.viewer.getFrame();
                int index = this.quantize(frame.getInsertionCodeIndexInModel(atom.modelIndex, atom.getInsertionCode()), 0.0f, frame.getInsertionCountInModel(atom.modelIndex), JmolConstants.argbsRoygbScale.length);
                argb = JmolConstants.argbsRoygbScale[index];
            }
        }
        return argb == 0 ? (short)22 : (short)Graphics3D.getColix(argb);
    }

    int quantize(float val, float lo, float hi, int segmentCount) {
        float range = hi - lo;
        if (range <= 0.0f || Float.isNaN(val)) {
            return segmentCount / 2;
        }
        float t = val - lo;
        if (t <= 0.0f) {
            return 0;
        }
        float quanta = range / (float)segmentCount;
        int q = (int)(t / quanta + 1.0E-4f);
        if (q >= segmentCount) {
            q = segmentCount - 1;
        }
        return q;
    }

    short getColixFromPalette(float val, float lo, float hi, String palette) {
        if (palette.equals("rwb")) {
            int index = this.quantize(val, lo, hi, JmolConstants.argbsRwbScale.length);
            return Graphics3D.getColix(JmolConstants.argbsRwbScale[index]);
        }
        if (palette.equals("roygb")) {
            int index = this.quantize(val, lo, hi, JmolConstants.argbsRoygbScale.length);
            return Graphics3D.getColix(JmolConstants.argbsRoygbScale[index]);
        }
        int ihalf = JmolConstants.argbsRoygbScale.length / 2;
        if (palette.equals("low")) {
            int index = this.quantize(val, lo, hi, ihalf);
            return Graphics3D.getColix(JmolConstants.argbsRoygbScale[index]);
        }
        if (palette.equals("high")) {
            int index = this.quantize(val, lo, hi, ihalf);
            return Graphics3D.getColix(JmolConstants.argbsRoygbScale[ihalf + index]);
        }
        return 12;
    }

    short getColixHbondType(short order) {
        int argbIndex = (order & 0x3C0) >> 6;
        return Graphics3D.getColix(JmolConstants.argbsHbondType[argbIndex]);
    }

    void flushCachedColors() {
    }

    private void flushCaches() {
        this.g3d.flushShadesAndImageCaches();
    }

    void setSpecular(boolean specular) {
        this.g3d.setSpecular(specular);
        this.flushCaches();
    }

    boolean getSpecular() {
        return this.g3d.getSpecular();
    }

    void setSpecularPower(int specularPower) {
        this.g3d.setSpecularPower(specularPower);
        this.flushCaches();
    }

    void setAmbientPercent(int ambientPercent) {
        this.g3d.setAmbientPercent(ambientPercent);
        this.flushCaches();
    }

    void setDiffusePercent(int diffusePercent) {
        this.g3d.setDiffusePercent(diffusePercent);
        this.flushCaches();
    }

    void setSpecularPercent(int specularPercent) {
        this.g3d.setSpecularPercent(specularPercent);
        this.flushCaches();
    }

    int getAmbientPercent() {
        return this.g3d.getAmbientPercent();
    }

    int getSpecularPercent() {
        return this.g3d.getSpecularPercent();
    }

    int getDiffusePercent() {
        return this.g3d.getDiffusePercent();
    }

    void setLightsourceZ(float dist) {
        this.g3d.setLightsourceZ(dist);
        this.flushCaches();
    }

    int getJmolOrRasmolArgb(int id, int argb) {
        if (argb == 16430) {
            return id < 256 ? JmolConstants.argbsCpk[id] : JmolConstants.altArgbsCpk[JmolConstants.altElementIndexFromNumber(id)];
        }
        if (argb == 16392) {
            if (id >= 256) {
                return JmolConstants.altArgbsCpk[JmolConstants.altElementIndexFromNumber(id)];
            }
            argb = JmolConstants.argbsCpk[id];
            int i = JmolConstants.argbsCpkRasmol.length;
            while (--i >= 0) {
                int argbRasmol = JmolConstants.argbsCpkRasmol[i];
                int atomNo = argbRasmol >> 24;
                if (atomNo != id) continue;
                argb = argbRasmol | 0xFF000000;
                break;
            }
            return argb;
        }
        return argb |= 0xFF000000;
    }

    void setElementArgb(int id, int argb) {
        if (argb == 16430 && this.argbsCpk == JmolConstants.argbsCpk) {
            return;
        }
        argb = this.getJmolOrRasmolArgb(id, argb);
        if (this.argbsCpk == JmolConstants.argbsCpk) {
            this.copyArgbsCpk();
        }
        if (id < 256) {
            this.argbsCpk[id] = argb;
            this.g3d.changeColixArgb((short)id, argb);
            return;
        }
        id = JmolConstants.altElementIndexFromNumber(id);
        this.altArgbsCpk[JmolConstants.altElementIndexFromNumber((int)id)] = argb;
        this.g3d.changeColixArgb((short)(JmolConstants.elementNumberMax + id), argb);
    }
}

