/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Dipole;
import org.jmol.viewer.Dipoles;
import org.jmol.viewer.ShapeRenderer;

class DipolesRenderer
extends ShapeRenderer {
    float dipoleVectorScale;
    final Vector3f offset = new Vector3f();
    final Point3i[] screens = new Point3i[6];
    final Point3f[] points = new Point3f[6];
    Point3f cross0;
    Point3f cross1;
    static final int cylinderBase = 0;
    static final int cross = 1;
    static final int crossEnd = 2;
    static final int center = 3;
    static final int arrowHeadBase = 4;
    static final int arrowHeadTip = 5;
    int diameter;
    int headWidthPixels;
    int crossWidthPixels;
    static final float arrowHeadOffset = 0.8f;
    static final float arrowHeadWidthFactor = 4.0f;
    static final float crossOffset = 0.1f;
    static final float crossWidth = 0.04f;

    DipolesRenderer() {
        for (int i = 0; i < 6; ++i) {
            this.screens[i] = new Point3i();
            this.points[i] = new Point3f();
        }
        this.cross0 = new Point3f();
        this.cross1 = new Point3f();
    }

    void render() {
        Dipoles dipoles = (Dipoles)this.shape;
        this.dipoleVectorScale = dipoles.dipoleVectorScale;
        int i = dipoles.dipoleCount;
        while (--i >= 0) {
            Dipole dipole = dipoles.dipoles[i];
            if (dipole.visibilityFlags == 0 || !this.transform(dipole)) continue;
            this.renderDipoleVector(dipole);
        }
    }

    boolean transform(Dipole dipole) {
        int i;
        Vector3f vector = dipole.vector;
        this.offset.set(vector);
        if (dipole.center == null) {
            this.offset.scale(dipole.offsetAngstroms / dipole.dipoleValue);
            if (this.dipoleVectorScale < 0.0f) {
                this.offset.add(vector);
            }
            this.points[0].set(dipole.origin);
            this.points[0].add(this.offset);
        } else {
            this.offset.scale(-0.5f * this.dipoleVectorScale);
            this.points[0].set(dipole.center);
            this.points[0].add(this.offset);
            if (dipole.offsetAngstroms != 0.0f) {
                this.offset.set(vector);
                this.offset.scale(dipole.offsetAngstroms / dipole.dipoleValue);
                this.points[0].add(this.offset);
            }
        }
        this.points[1].scaleAdd(this.dipoleVectorScale * 0.1f, vector, this.points[0]);
        this.points[2].scaleAdd(this.dipoleVectorScale * 0.14f, vector, this.points[0]);
        this.points[3].scaleAdd(this.dipoleVectorScale / 2.0f, vector, this.points[0]);
        this.points[4].scaleAdd(this.dipoleVectorScale * 0.8f, vector, this.points[0]);
        this.points[5].scaleAdd(this.dipoleVectorScale, vector, this.points[0]);
        if (dipole.atoms[0] != null) {
            if (this.frame.bsHidden.get(dipole.atoms[0].atomIndex)) {
                return false;
            }
            this.offset.set(this.points[3]);
            this.offset.cross(this.offset, vector);
            if (this.offset.length() == 0.0f) {
                this.offset.set(this.points[3].x + 0.2345f, this.points[3].y + 0.1234f, this.points[3].z + 0.4321f);
                this.offset.cross(this.offset, vector);
            }
            this.offset.scale(dipole.offsetSide / this.offset.length());
            for (i = 0; i < 6; ++i) {
                this.points[i].add(this.offset);
            }
        }
        for (i = 0; i < 6; ++i) {
            this.viewer.transformPoint(this.points[i], this.screens[i]);
        }
        this.viewer.transformPoint(this.points[1], this.cross0);
        this.viewer.transformPoint(this.points[2], this.cross1);
        short mad = dipole.mad;
        this.diameter = this.viewer.scaleToScreen(this.screens[3].z, mad);
        this.headWidthPixels = (int)((float)this.diameter * 4.0f);
        if (this.headWidthPixels < this.diameter + 10) {
            this.headWidthPixels = this.diameter + 10;
        }
        this.crossWidthPixels = this.headWidthPixels;
        return true;
    }

    void renderDipoleVector(Dipole dipole) {
        short colixA;
        short colixB = colixA = dipole.bond == null ? dipole.colix : Graphics3D.getColixInherited(dipole.colix, dipole.bond.colix);
        if (dipole.atoms[0] != null) {
            colixA = Graphics3D.getColixInherited(colixA, dipole.atoms[0].colixAtom);
            colixB = Graphics3D.getColixInherited(colixB, dipole.atoms[1].colixAtom);
        }
        if (colixA == 0) {
            colixA = 5;
        }
        if (colixB == 0) {
            colixB = 5;
        }
        if (this.dipoleVectorScale < 0.0f) {
            short c = colixA;
            colixA = colixB;
            colixB = c;
        }
        this.g3d.fillCylinder(colixA, (byte)1, this.diameter, this.screens[0], this.screens[3]);
        this.g3d.fillCylinder(colixB, (byte)1, this.diameter, this.screens[3], this.screens[4]);
        if (!dipole.noCross) {
            this.g3d.fillCylinderBits(colixA, (byte)2, this.crossWidthPixels, this.cross0, this.cross1);
        }
        this.g3d.fillCone(colixB, (byte)2, this.headWidthPixels, this.screens[4], this.screens[5]);
    }
}

