/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

class Mesh {
    Viewer viewer;
    String[] title = null;
    String thisID;
    boolean isValid = true;
    String scriptCommand;
    String jvxlFileHeader;
    String jvxlExtraLine;
    int jvxlCompressionRatio;
    String jvxlSurfaceData;
    String jvxlEdgeData;
    String jvxlColorData;
    boolean isJvxlPrecisionColor;
    Point4f jvxlPlane;
    String jvxlDefinitionLine;
    boolean isContoured;
    boolean isBicolorMap;
    float mappedDataMin;
    float mappedDataMax;
    float valueMappedToRed;
    float valueMappedToBlue;
    float cutoff;
    int nBytes;
    int nContours;
    boolean hasGridPoints;
    boolean hideBackground;
    BitSet[] surfaceSet;
    int firstViewableVertex;
    int lastViewableVertex;
    boolean visible = true;
    short colix;
    short[] vertexColixes;
    Graphics3D g3d;
    int vertexCount;
    Point3f[] vertices;
    float[] vertexValues;
    short[] normixes;
    int polygonCount;
    int[][] polygonIndexes = null;
    int drawVertexCount;
    int[] drawVertexCounts;
    float scale = 1.0f;
    int diameter;
    Point3f ptCenter = new Point3f(0.0f, 0.0f, 0.0f);
    Point3f[] ptCenters;
    Vector3f axis = new Vector3f(1.0f, 0.0f, 0.0f);
    Vector3f[] axes;
    String meshType = null;
    static final int DRAW_MULTIPLE = -1;
    static final int DRAW_NONE = 0;
    static final int DRAW_ARROW = 1;
    static final int DRAW_CIRCLE = 2;
    static final int DRAW_CURVE = 3;
    static final int DRAW_LINE = 4;
    static final int DRAW_PLANE = 5;
    static final int DRAW_POINT = 6;
    static final int DRAW_TRIANGLE = 7;
    int drawType = 7;
    int[] drawTypes;
    int atomIndex = -1;
    int modelIndex = -1;
    int visibilityFlags;
    int[] modelFlags = null;
    boolean showPoints = false;
    boolean drawTriangles = false;
    boolean fillTriangles = true;
    static int SEED_COUNT = 25;
    final Vector3f vAB = new Vector3f();
    final Vector3f vAC = new Vector3f();

    String getDrawType() {
        switch (this.drawType) {
            case -1: {
                return "multiple";
            }
            case 1: {
                return "arrow";
            }
            case 2: {
                return "circle";
            }
            case 3: {
                return "curve";
            }
            case 6: {
                return "point";
            }
            case 4: {
                return "line";
            }
            case 7: {
                return "triangle";
            }
            case 5: {
                return "plane";
            }
        }
        return "type is not identified in mesh.getDrawType()";
    }

    Mesh(Viewer viewer, String thisID, Graphics3D g3d, short colix) {
        this.viewer = viewer;
        this.thisID = thisID;
        this.g3d = g3d;
        this.colix = colix;
    }

    void clear(String meshType) {
        this.polygonCount = 0;
        this.vertexCount = 0;
        this.scale = 1.0f;
        this.vertices = null;
        this.vertexColixes = null;
        this.polygonIndexes = null;
        this.meshType = meshType;
    }

    void initialize() {
        this.initialize(true);
    }

    void initialize(boolean use2Sided) {
        Vector3f[] vectorSums = new Vector3f[this.vertexCount];
        int i = this.vertexCount;
        while (--i >= 0) {
            vectorSums[i] = new Vector3f();
        }
        this.sumVertexNormals(vectorSums);
        this.normixes = new short[this.vertexCount];
        if (use2Sided) {
            i = this.vertexCount;
            while (--i >= 0) {
                this.normixes[i] = this.g3d.get2SidedNormix(vectorSums[i]);
            }
        } else {
            i = this.vertexCount;
            while (--i >= 0) {
                this.normixes[i] = this.g3d.getNormix(vectorSums[i]);
            }
        }
    }

    void offset(Vector3f offset) {
        int i = this.vertexCount;
        while (--i >= 0) {
            this.vertices[i].add(offset);
        }
    }

    void allocVertexColixes() {
        if (this.vertexColixes == null) {
            this.vertexColixes = new short[this.vertexCount];
            int i = this.vertexCount;
            while (--i >= 0) {
                this.vertexColixes[i] = this.colix;
            }
        }
    }

    void setTranslucent(boolean isTranslucent) {
        this.colix = Graphics3D.getColixTranslucent(this.colix, isTranslucent);
        if (this.vertexColixes != null) {
            int i = this.vertexCount;
            while (--i >= 0) {
                this.vertexColixes[i] = Graphics3D.getColixTranslucent(this.vertexColixes[i], isTranslucent);
            }
        }
    }

    void sumVertexNormals(Vector3f[] vectorSums) {
        Vector3f vNormalizedNormal = new Vector3f();
        int i = this.polygonCount;
        while (--i >= 0) {
            int[] pi = this.polygonIndexes[i];
            try {
                if (pi == null) continue;
                Graphics3D.calcNormalizedNormal(this.vertices[pi[0]], this.vertices[pi[1]], this.vertices[pi[2]], vNormalizedNormal, this.vAB, this.vAC);
                float l = vNormalizedNormal.length();
                if (!((double)l > 0.9) || !((double)l < 1.1)) continue;
                int j = pi.length;
                while (--j >= 0) {
                    int k = pi[j];
                    vectorSums[k].add(vNormalizedNormal);
                }
            }
            catch (Exception e) {
            }
        }
    }

    void setVertexCount(int vertexCount) {
        this.vertexCount = vertexCount;
        this.vertices = new Point3f[vertexCount];
        this.vertexValues = new float[vertexCount];
    }

    void setPolygonCount(int polygonCount) {
        this.polygonCount = polygonCount;
        if (polygonCount < 0) {
            return;
        }
        if (this.polygonIndexes == null || polygonCount > this.polygonIndexes.length) {
            this.polygonIndexes = new int[polygonCount][];
        }
    }

    int addVertexCopy(Point3f vertex, float value) {
        if (this.vertexCount == 0) {
            this.vertexValues = new float[SEED_COUNT];
        } else if (this.vertexCount >= this.vertexValues.length) {
            this.vertexValues = ArrayUtil.doubleLength(this.vertexValues);
        }
        this.vertexValues[this.vertexCount] = value;
        return this.addVertexCopy(vertex);
    }

    int addVertexCopy(Point3f vertex) {
        if (this.vertexCount == 0) {
            this.vertices = new Point3f[SEED_COUNT];
        } else if (this.vertexCount == this.vertices.length) {
            this.vertices = (Point3f[])ArrayUtil.doubleLength(this.vertices);
        }
        this.vertices[this.vertexCount] = new Point3f(vertex);
        return this.vertexCount++;
    }

    void invalidateVertex(int vertex) {
    }

    void addTriangle(int vertexA, int vertexB, int vertexC) {
        if (this.vertexValues != null && (Float.isNaN(this.vertexValues[vertexA]) || Float.isNaN(this.vertexValues[vertexB]) || Float.isNaN(this.vertexValues[vertexC]))) {
            return;
        }
        if (Float.isNaN(this.vertices[vertexA].x) || Float.isNaN(this.vertices[vertexB].x) || Float.isNaN(this.vertices[vertexC].x)) {
            return;
        }
        if (this.polygonCount == 0) {
            this.polygonIndexes = new int[SEED_COUNT][];
        } else if (this.polygonCount == this.polygonIndexes.length) {
            this.polygonIndexes = (int[][])ArrayUtil.doubleLength(this.polygonIndexes);
        }
        this.polygonIndexes[this.polygonCount++] = new int[]{vertexA, vertexB, vertexC};
    }

    void addQuad(int vertexA, int vertexB, int vertexC, int vertexD) {
        if (this.polygonCount == 0) {
            this.polygonIndexes = new int[SEED_COUNT][];
        } else if (this.polygonCount == this.polygonIndexes.length) {
            this.polygonIndexes = (int[][])ArrayUtil.doubleLength(this.polygonIndexes);
        }
        this.polygonIndexes[this.polygonCount++] = new int[]{vertexA, vertexB, vertexC, vertexD};
    }

    void setColix(short colix) {
        this.colix = colix;
    }

    void checkForDuplicatePoints(float cutoff) {
        float cutoff2 = cutoff * cutoff;
        int i = this.vertexCount;
        while (--i >= 0) {
            int j = i;
            while (--j >= 0) {
                float dist2 = this.vertices[i].distanceSquared(this.vertices[j]);
                if (!(dist2 < cutoff2)) continue;
                Logger.debug("Mesh.checkForDuplicates " + this.vertices[i] + "<->" + this.vertices[j] + " : " + Math.sqrt(dist2));
            }
        }
    }

    Hashtable getShapeDetail() {
        return null;
    }

    final boolean isPolygonDisplayable(int index) {
        return this.polygonIndexes[index].length > 0 && (this.modelIndex == index || this.modelFlags == null || this.modelFlags[index] != 0);
    }

    final void setCenter(int iModel) {
        Point3f center = new Point3f(0.0f, 0.0f, 0.0f);
        int iptlast = -1;
        int ipt = 0;
        int n = 0;
        int i = this.polygonCount;
        while (--i >= 0) {
            if (iModel >= 0 && i != iModel) continue;
            iptlast = -1;
            int iV = this.polygonIndexes[i].length;
            while (--iV >= 0) {
                ipt = this.polygonIndexes[i][iV];
                if (ipt == iptlast) continue;
                iptlast = ipt;
                center.add(this.vertices[ipt]);
                ++n;
            }
            if (n <= 0 || i != iModel && i != 0) continue;
            center.scale(1.0f / (float)n);
            break;
        }
        if (iModel < 0) {
            this.ptCenter = center;
        } else {
            this.ptCenters[iModel] = center;
        }
    }
}

