/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.FontMetrics;
import javax.vecmath.Point3f;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Shape;
import org.jmol.viewer.StateManager;

class Text {
    static final int POINTER_NONE = 0;
    static final int POINTER_ON = 1;
    static final int POINTER_BACKGROUND = 2;
    static final String[] hAlignNames = new String[]{"", "left", "center", "right", ""};
    static final int XY = 0;
    static final int LEFT = 1;
    static final int CENTER = 2;
    static final int RIGHT = 3;
    static final int XYZ = 4;
    static final String[] vAlignNames = new String[]{"xy", "top", "bottom", "middle"};
    static final int TOP = 1;
    static final int BOTTOM = 2;
    static final int MIDDLE = 3;
    boolean atomBased;
    Graphics3D g3d;
    Point3f xyz;
    String target;
    String text;
    String[] lines;
    int align;
    int valign;
    int pointer;
    int movableX;
    int movableY;
    int movableXPercent = Integer.MAX_VALUE;
    int movableYPercent = Integer.MAX_VALUE;
    int offsetX;
    int offsetY;
    int z;
    int zSlab;
    int windowWidth;
    int windowHeight;
    boolean adjustForWindow;
    int boxX;
    int boxY;
    int boxWidth;
    int boxHeight;
    Font3D font;
    FontMetrics fm;
    byte fid;
    int ascent;
    int descent;
    int lineHeight;
    short colix;
    short bgcolix;
    int[] widths;
    int textWidth;
    int textHeight;

    Text(Graphics3D g3d, Font3D font, String text, short colix, short bgcolix, int offsetX, int offsetY, int z, int zSlab, int textAlign) {
        this.windowWidth = g3d.getRenderWidth();
        this.windowHeight = g3d.getRenderHeight();
        this.atomBased = true;
        this.g3d = g3d;
        this.text = this.fixText(text);
        this.colix = colix;
        this.bgcolix = bgcolix;
        this.setXYZs(offsetX, offsetY, z, zSlab);
        this.align = textAlign;
        this.setFont(font);
    }

    Text(Graphics3D g3d, Font3D font, String target, short colix, int valign, int align) {
        this.windowWidth = g3d.getRenderWidth();
        this.windowHeight = g3d.getRenderHeight();
        this.atomBased = false;
        this.g3d = g3d;
        this.target = target;
        if (target.equals("error")) {
            valign = 1;
        }
        this.align = align;
        this.valign = valign;
        this.font = font;
        this.colix = colix;
        this.z = 2;
        this.zSlab = Integer.MIN_VALUE;
        this.getFontMetrics();
    }

    void getFontMetrics() {
        this.fm = this.font.fontMetrics;
        this.descent = this.fm.getDescent();
        this.ascent = this.fm.getAscent();
        this.lineHeight = this.ascent + this.descent;
    }

    void setFid(byte fid) {
        if (this.fid == fid) {
            return;
        }
        this.fid = fid;
        this.recalc();
    }

    void setXYZ(Point3f xyz) {
        this.valign = 4;
        this.xyz = xyz;
    }

    void setAdjustForWindow(boolean TF) {
        this.adjustForWindow = TF;
    }

    void setColix(short colix) {
        this.colix = colix;
    }

    void setColix(Object value) {
        this.colix = Graphics3D.getColix(value);
    }

    void setBgColix(short colix) {
        this.bgcolix = colix;
    }

    void setBgColix(Object value) {
        this.bgcolix = value == null ? (short)0 : Graphics3D.getColix(value);
    }

    void setMovableX(int x) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableX = x;
        this.movableXPercent = Integer.MAX_VALUE;
    }

    void setMovableY(int y) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableY = y;
        this.movableYPercent = Integer.MAX_VALUE;
    }

    void setMovableXPercent(int x) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableX = Integer.MAX_VALUE;
        this.movableXPercent = x;
    }

    void setMovableYPercent(int y) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableY = Integer.MAX_VALUE;
        this.movableYPercent = y;
    }

    void setXY(int x, int y) {
        this.setMovableX(x);
        this.setMovableY(y);
    }

    void setZs(int z, int zSlab) {
        this.z = z;
        this.zSlab = zSlab;
    }

    void setXYZs(int x, int y, int z, int zSlab) {
        this.setMovableX(x);
        this.setMovableY(y);
        this.setZs(z, zSlab);
    }

    void setPositions() {
        int xLeft;
        int xRight;
        int xCenter;
        if (this.valign == 0 || this.valign == 4) {
            int x = this.movableXPercent == Integer.MAX_VALUE ? this.movableX : this.movableXPercent * this.windowWidth / 100;
            xRight = xCenter = x + this.offsetX;
            xLeft = xCenter;
        } else {
            xLeft = 5;
            xCenter = this.windowWidth / 2;
            xRight = this.windowWidth - 5;
        }
        this.boxX = xLeft;
        switch (this.align) {
            case 2: {
                this.boxX = xCenter - this.boxWidth / 2;
                break;
            }
            case 3: {
                this.boxX = xRight - this.boxWidth;
            }
        }
        this.boxY = 0;
        switch (this.valign) {
            case 1: {
                break;
            }
            case 3: {
                this.boxY = this.windowHeight / 2;
                break;
            }
            case 2: {
                this.boxY = this.windowHeight;
                break;
            }
            default: {
                int y = this.movableYPercent == Integer.MAX_VALUE ? this.movableY : this.movableYPercent * this.windowHeight / 100;
                this.boxY = (this.atomBased || this.xyz != null ? y : this.windowHeight - y) + this.offsetY;
            }
        }
        this.setBoxOffsetsInWindow();
    }

    void setOffset(int offset) {
        this.offsetX = Text.getXOffset(offset);
        this.offsetY = Text.getYOffset(offset);
        this.valign = 0;
    }

    static final int getXOffset(int offset) {
        switch (offset) {
            case 0: {
                return 4;
            }
            case 32767: {
                return 0;
            }
        }
        return (byte)(offset >> 8);
    }

    static final int getYOffset(int offset) {
        switch (offset) {
            case 0: {
                return -4;
            }
            case 32767: {
                return 0;
            }
        }
        return -((byte)(offset & 0xFF));
    }

    void setText(String text) {
        text = this.fixText(text);
        if (this.text != null && this.text.equals(text)) {
            return;
        }
        this.text = text;
        this.recalc();
    }

    void setFont(Font3D f3d) {
        this.font = f3d;
        this.getFontMetrics();
        this.recalc();
    }

    boolean setAlignment(String align) {
        if ("left".equals(align)) {
            return this.setAlignment(1);
        }
        if ("center".equals(align)) {
            return this.setAlignment(2);
        }
        if ("right".equals(align)) {
            return this.setAlignment(3);
        }
        return false;
    }

    static String getAlignment(int align) {
        return hAlignNames[align & 3];
    }

    boolean setAlignment(int align) {
        this.align = align;
        this.recalc();
        return true;
    }

    void setPointer(int pointer) {
        this.pointer = pointer;
    }

    static String getPointer(int pointer) {
        return (pointer & 1) == 0 ? "" : ((pointer & 2) > 0 ? "background" : "on");
    }

    String fixText(String text) {
        int pt;
        if (text == null) {
            return null;
        }
        while ((pt = text.indexOf("\n")) >= 0) {
            text = text.substring(0, pt) + "|" + text.substring(pt + 1);
        }
        return text;
    }

    void recalc() {
        if (this.text == null) {
            this.text = null;
            this.lines = null;
            this.widths = null;
            return;
        }
        if (this.fm == null) {
            return;
        }
        this.lines = this.split(this.text, '|');
        this.textWidth = 0;
        this.widths = new int[this.lines.length];
        int i = this.lines.length;
        while (--i >= 0) {
            this.widths[i] = this.fm.stringWidth(this.lines[i]);
            this.textWidth = Math.max(this.textWidth, this.widths[i]);
        }
        this.textHeight = this.lines.length * this.lineHeight;
        this.boxWidth = this.textWidth + 8;
        this.boxHeight = this.textHeight + 8;
    }

    void render() {
        if (this.text == null) {
            return;
        }
        this.setPositions();
        if (this.bgcolix != 0) {
            this.drawBox();
        }
        int x0 = this.boxX + 4;
        switch (this.align) {
            case 2: {
                x0 = this.boxX + this.boxWidth / 2;
                break;
            }
            case 3: {
                x0 = this.boxX + this.boxWidth - 4;
            }
        }
        int x = x0;
        int y = this.boxY + this.ascent + 4;
        for (int i = 0; i < this.lines.length; ++i) {
            switch (this.align) {
                case 2: {
                    x = x0 - this.widths[i] / 2;
                    break;
                }
                case 3: {
                    x = x0 - this.widths[i];
                }
            }
            this.g3d.drawString(this.lines[i], this.font, this.colix, x, y, this.z, this.zSlab);
            y += this.lineHeight;
        }
        if ((this.pointer & 1) != 0) {
            short pointerColix;
            short s = pointerColix = (this.pointer & 2) != 0 && this.bgcolix != 0 ? this.bgcolix : this.colix;
            if (this.boxX > this.movableX) {
                this.g3d.drawLine(pointerColix, this.movableX, this.movableY, this.zSlab, this.boxX, this.boxY + this.boxHeight / 2, this.zSlab);
            } else if (this.boxX + this.boxWidth < this.movableX) {
                this.g3d.drawLine(pointerColix, this.movableX, this.movableY, this.zSlab, this.boxX + this.boxWidth, this.boxY + this.boxHeight / 2, this.zSlab);
            }
        }
    }

    private void drawBox() {
        this.g3d.fillRect(this.bgcolix, this.boxX, this.boxY, this.z + 2, this.zSlab, this.boxWidth, this.boxHeight);
        this.g3d.drawRect(this.colix, this.boxX + 1, this.boxY + 1, this.z + 1, this.zSlab, this.boxWidth - 2, this.boxHeight - 2);
    }

    void setBoxOffsetsInWindow() {
        int y0;
        int y;
        if (!this.adjustForWindow) {
            this.boxY -= this.lineHeight;
        }
        if (this.atomBased && this.align == 0) {
            this.boxX += 4;
            this.boxY -= 8;
        }
        if (this.valign == 4) {
            this.boxY += this.ascent / 2;
        }
        if (!this.adjustForWindow) {
            return;
        }
        this.boxY -= this.textHeight;
        int x = this.boxX;
        if (x + this.boxWidth + 5 > this.windowWidth) {
            x = this.windowWidth - this.boxWidth - 5;
        }
        if (x < 5) {
            x = 5;
        }
        if ((y = this.boxY) + this.boxHeight > this.windowHeight) {
            y = this.windowHeight - this.boxHeight;
        }
        int n = y0 = this.atomBased ? 16 + this.lineHeight : 0;
        if (y < y0) {
            y = y0;
        }
        this.boxX = x;
        this.boxY = y;
    }

    static final void renderSimple(Graphics3D g3d, Font3D font, String strLabel, short colix, short bgcolix, int x, int y, int z, int zSlab, int xOffset, int yOffset, int ascent, int descent, boolean doPointer, short pointerColix) {
        int xBoxOffset;
        if (strLabel == null || strLabel.length() == 0) {
            return;
        }
        int x0 = x;
        int y0 = y;
        int boxWidth = font.fontMetrics.stringWidth(strLabel) + 8;
        int boxHeight = ascent + descent + 8;
        if (xOffset > 0) {
            xBoxOffset = xOffset;
        } else {
            xBoxOffset = -boxWidth;
            xBoxOffset = xOffset == 0 ? (xBoxOffset /= 2) : (xBoxOffset += xOffset);
        }
        int yBoxOffset = yOffset > 0 ? yOffset : (yOffset == 0 ? -boxHeight / 2 - 2 : -boxHeight + yOffset);
        x += xBoxOffset;
        y += yBoxOffset;
        if (bgcolix != 0) {
            g3d.fillRect(bgcolix, x, y, z, zSlab, boxWidth, boxHeight);
            g3d.drawRect(colix, x + 1, y + 1, z - 1, zSlab, boxWidth - 2, boxHeight - 2);
        }
        if (doPointer) {
            if (xOffset > 0) {
                g3d.drawLine(pointerColix, x0, y0, zSlab, x, y + boxHeight / 2, zSlab);
            } else if (xOffset < 0) {
                g3d.drawLine(pointerColix, x0, y0, zSlab, x + boxWidth, y + boxHeight / 2, zSlab);
            }
        }
        g3d.drawString(strLabel, font, colix, x + 4, y + 4 + ascent, z - 1, zSlab);
    }

    String[] split(String text, char ch) {
        int n = 1;
        int i = text.indexOf(ch);
        if (i < 0) {
            String[] lines = new String[]{text};
            return lines;
        }
        int len = text.length();
        while (i < len) {
            if (text.charAt(i) == ch) {
                ++n;
            }
            ++i;
        }
        String[] lines = new String[n];
        i = 0;
        len = 0;
        int pt = 0;
        while ((len = text.indexOf(ch, i)) >= 0) {
            lines[pt++] = text.substring(i, len);
            i = len + 1;
        }
        lines[pt] = text.substring(i, text.length());
        return lines;
    }

    String getState(boolean isDefine) {
        StringBuffer s = new StringBuffer();
        if (this.text == null || this.atomBased || this.target.equals("error")) {
            return "";
        }
        if (isDefine) {
            String strOff = null;
            switch (this.valign) {
                case 0: {
                    strOff = this.movableXPercent == Integer.MAX_VALUE ? this.movableX + " " : this.movableXPercent + "% ";
                    strOff = strOff + (this.movableYPercent == Integer.MAX_VALUE ? this.movableY + "" : this.movableYPercent + "%");
                }
                case 4: {
                    if (strOff == null) {
                        strOff = StateManager.escape(this.xyz);
                    }
                    s.append("set echo " + this.target + " " + strOff);
                    if (this.align == 1) break;
                    s.append("set echo " + this.target + " " + hAlignNames[this.align]);
                    break;
                }
                default: {
                    s.append("set echo " + vAlignNames[this.valign] + " " + hAlignNames[this.align]);
                }
            }
            s.append(";echo " + StateManager.escape(this.text) + ";\n");
        }
        if (isDefine != this.target.equals("top")) {
            return s.toString();
        }
        s.append(Shape.getFontCommand("echo", this.font) + ";\n");
        s.append("color echo [x" + this.g3d.getHexColorFromIndex(this.colix) + "]");
        if (this.bgcolix != 0) {
            s.append(";background echo [x" + this.g3d.getHexColorFromIndex(this.bgcolix) + "]");
        }
        s.append(";\n");
        return s.toString();
    }
}

