/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.coa;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.util.FloatMatrix;

public class COA2DViewer
extends JPanel
implements IViewer,
Serializable {
    public static final long serialVersionUID = 202022030001L;
    private static final String SAVE_CMD = "save-cmd";
    private static final String SAVE_GENE_CLUSTER_CMD = "save-genes-cmd";
    private static final String SAVE_EXPT_CLUSTER_CMD = "save-expts-cmd";
    private static final String SHOW_TEXT_CMD = "show-text-cmd";
    private static final String SHOW_TICK_LABELS_CMD = "show-tick-labels-cmd";
    private static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    private static final String STORE_GENE_CLUSTER_CMD = "store-gene-cluster-cmd";
    private static final String STORE_EXPT_CLUSTER_CMD = "store-expt-cluster-cmd";
    private static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    private static final String LAUNCH_NEW_GENE_SESSION_CMD = "launch-new-gene-session-cmd";
    private static final String LAUNCH_NEW_EXPT_SESSION_CMD = "launch-new-expt-session-cmd";
    private static final String DISPLAY_EXPT_NAMES_CMD = "display-expt-names-cmd";
    private static final String SHOW_LARGER_POINTS_CMD = "show-larger-points-cmd";
    private float[] yArray;
    private float[] xArray;
    private int geneOrExpt;
    private int axis1;
    private int axis2;
    private FloatMatrix UMatrix;
    private FloatMatrix geneUMatrix;
    private FloatMatrix exptUMatrix;
    private FloatMatrix scaledGeneUMatrix;
    private FloatMatrix scaledExptUMatrix;
    private Experiment experiment;
    private IFramework framework;
    private Frame frame;
    private IData data;
    private JPopupMenu popup;
    private Ellipse2D.Double ellipse;
    private boolean displayExptNames;
    private boolean showLargePoints;
    private boolean showTickLabels;
    Rectangle currentRect = null;
    Rectangle rectToDraw = null;
    Rectangle previousRectDrawn = new Rectangle();

    public COA2DViewer(Experiment experiment, float[] fArray, float[] fArray2, int n, int n2, int n3) {
        this.yArray = fArray2;
        this.xArray = fArray;
        this.displayExptNames = false;
        this.showLargePoints = false;
        this.showTickLabels = true;
        this.geneOrExpt = n;
        this.axis1 = n2;
        this.axis2 = n3;
        this.experiment = experiment;
        this.ellipse = new Ellipse2D.Double();
        this.setBackground(Color.white);
        this.popup = this.createJPopupMenu();
        GraphListener graphListener = new GraphListener();
        this.addMouseListener(graphListener);
        this.addMouseMotionListener(graphListener);
    }

    public COA2DViewer(Experiment experiment, FloatMatrix floatMatrix, int n, int n2, int n3) {
        this.UMatrix = floatMatrix;
        this.axis1 = n2;
        this.axis2 = n3;
        this.xArray = this.getFloatArray(floatMatrix, n2);
        this.yArray = this.getFloatArray(floatMatrix, n3);
        this.displayExptNames = false;
        this.showLargePoints = false;
        this.showTickLabels = true;
        this.geneOrExpt = n;
        this.experiment = experiment;
        this.ellipse = new Ellipse2D.Double();
        this.setBackground(Color.white);
        this.popup = this.createJPopupMenu();
        GraphListener graphListener = new GraphListener();
        this.addMouseListener(graphListener);
        this.addMouseMotionListener(graphListener);
    }

    public COA2DViewer(Experiment experiment, FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n, int n2, int n3) {
        this.geneUMatrix = floatMatrix;
        this.exptUMatrix = floatMatrix2;
        this.scaledGeneUMatrix = (FloatMatrix)floatMatrix.clone();
        this.scaledExptUMatrix = (FloatMatrix)floatMatrix2.clone();
        this.UMatrix = this.combineMatrices(this.scaledGeneUMatrix, this.scaledExptUMatrix);
        this.axis1 = n2;
        this.axis2 = n3;
        this.xArray = this.getFloatArray(this.UMatrix, n2);
        this.yArray = this.getFloatArray(this.UMatrix, n3);
        this.displayExptNames = false;
        this.showLargePoints = false;
        this.showTickLabels = true;
        this.geneOrExpt = n;
        this.experiment = experiment;
        this.ellipse = new Ellipse2D.Double();
        this.setBackground(Color.white);
        this.popup = this.createJPopupMenu();
        GraphListener graphListener = new GraphListener();
        this.addMouseListener(graphListener);
        this.addMouseMotionListener(graphListener);
    }

    private void scaleMatrices(FloatMatrix floatMatrix, FloatMatrix floatMatrix2) {
        float f = 0.0f;
        float f2 = 0.0f;
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix2.getRowDimension();
        int n3 = n;
        while (--n3 >= 0) {
            f = Math.max(f, Math.max(Math.max(Math.abs(floatMatrix.get(n3, 0)), Math.abs(floatMatrix.get(n3, 1))), Math.abs(floatMatrix.get(n3, 2))));
        }
        n3 = n2;
        while (--n3 >= 0) {
            f2 = Math.max(f2, Math.max(Math.max(Math.abs(floatMatrix2.get(n3, 0)), Math.abs(floatMatrix2.get(n3, 1))), Math.abs(floatMatrix2.get(n3, 2))));
        }
        float f3 = Math.max(f, f2);
        if (f == f2) {
            this.scaledGeneUMatrix = (FloatMatrix)this.geneUMatrix.clone();
            this.scaledExptUMatrix = (FloatMatrix)this.exptUMatrix.clone();
        } else if (f > f2) {
            this.scaledGeneUMatrix = (FloatMatrix)this.geneUMatrix.clone();
            float f4 = f / f2;
            this.scaledExptUMatrix = this.exptUMatrix.times(f4);
        } else {
            this.scaledExptUMatrix = (FloatMatrix)this.exptUMatrix.clone();
            float f5 = f2 / f;
            this.scaledGeneUMatrix = this.geneUMatrix.times(f5);
        }
    }

    private FloatMatrix combineMatrices(FloatMatrix floatMatrix, FloatMatrix floatMatrix2) {
        int n;
        int n2;
        FloatMatrix floatMatrix3 = new FloatMatrix(floatMatrix.getRowDimension() + floatMatrix2.getRowDimension(), floatMatrix.getColumnDimension());
        for (n2 = 0; n2 < floatMatrix.getRowDimension(); ++n2) {
            for (n = 0; n < floatMatrix.getColumnDimension(); ++n) {
                floatMatrix3.A[n2][n] = floatMatrix.A[n2][n];
            }
        }
        n2 = floatMatrix.getRowDimension();
        for (n = 0; n < floatMatrix2.getRowDimension(); ++n) {
            for (int i = 0; i < floatMatrix2.getColumnDimension(); ++i) {
                floatMatrix3.A[n2 + n][i] = floatMatrix2.A[n][i];
            }
        }
        return floatMatrix3;
    }

    private float[] getFloatArray(FloatMatrix floatMatrix, int n) {
        float[] fArray = new float[floatMatrix.getRowDimension()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = floatMatrix.A[i][n];
        }
        return fArray;
    }

    public void paint(Graphics graphics) {
        String string;
        double d;
        double[] dArray;
        int n;
        double d2;
        int n2;
        int n3;
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n4 = this.getWidth();
        int n5 = this.getHeight();
        int n6 = (int)Math.round((double)(this.getWidth() / 2));
        int n7 = (int)Math.round((double)(this.getHeight() / 2));
        double d3 = this.getMax(this.xArray);
        double d4 = this.getMax(this.yArray);
        double d5 = this.getMin(this.xArray);
        double d6 = this.getMin(this.yArray);
        double d7 = this.getXScalingFactor(d3, d5);
        double d8 = this.getYScalingFactor(d4, d6);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.drawLine(0, (int)Math.round((double)(this.getHeight() / 2)), this.getWidth(), (int)Math.round((double)(this.getHeight() / 2)));
        graphics2D.drawLine((int)Math.round((double)(this.getWidth() / 2)), 0, (int)Math.round((double)(this.getWidth() / 2)), this.getHeight());
        double[] dArray2 = new double[6];
        double[] dArray3 = new double[6];
        double d9 = 0.0;
        double d10 = 0.0;
        d9 = Math.abs(d3) > Math.abs(d5) ? Math.abs(d3 / 5.0) : Math.abs(d5 / 5.0);
        d10 = Math.abs(d4) > Math.abs(d6) ? Math.abs(d4 / 5.0) : Math.abs(d6 / 5.0);
        double d11 = 0.0;
        double d12 = 0.0;
        for (n3 = 0; n3 < dArray2.length; ++n3) {
            dArray2[n3] = d11;
            d11 += d9;
            dArray3[n3] = d12;
            d12 += d10;
        }
        if (this.showTickLabels) {
            double d13;
            for (n3 = 1; n3 < dArray2.length; ++n3) {
                graphics2D.drawLine((int)Math.round(dArray2[n3] * d7) + this.getWidth() / 2, this.getHeight() / 2 - 5, (int)Math.round(dArray2[n3] * d7) + this.getWidth() / 2, this.getHeight() / 2 + 5);
            }
            for (n3 = 1; n3 < dArray2.length; ++n3) {
                graphics2D.drawLine(this.getWidth() / 2 - (int)Math.round(dArray2[n3] * d7), this.getHeight() / 2 - 5, this.getWidth() / 2 - (int)Math.round(dArray2[n3] * d7), this.getHeight() / 2 + 5);
            }
            for (n3 = 1; n3 < dArray3.length; ++n3) {
                graphics2D.drawLine(this.getWidth() / 2 - 5, this.getHeight() / 2 + (int)Math.round(dArray3[n3] * d8), this.getWidth() / 2 + 5, this.getHeight() / 2 + (int)Math.round(dArray3[n3] * d8));
            }
            for (n3 = 1; n3 < dArray3.length; ++n3) {
                graphics2D.drawLine(this.getWidth() / 2 - 5, this.getHeight() / 2 - (int)Math.round(dArray3[n3] * d8), this.getWidth() / 2 + 5, this.getHeight() / 2 - (int)Math.round(dArray3[n3] * d8));
            }
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.setColor(Color.black);
            DecimalFormat decimalFormat = new DecimalFormat();
            for (n2 = 1; n2 < dArray2.length; ++n2) {
                d13 = graphics2D.getFontMetrics().stringWidth(decimalFormat.format(dArray2[n2]));
                graphics2D.drawString(decimalFormat.format(dArray2[n2]), (int)Math.round(dArray2[n2] * d7) + this.getWidth() / 2 - (int)Math.round(0.5 * d13), this.getHeight() / 2 + 20);
            }
            for (n2 = 1; n2 < dArray2.length; ++n2) {
                d13 = graphics2D.getFontMetrics().stringWidth("-" + decimalFormat.format(dArray2[n2]));
                graphics2D.drawString("-" + decimalFormat.format(dArray2[n2]), this.getWidth() / 2 - (int)Math.round(dArray2[n2] * d7) - (int)Math.round(0.5 * d13), this.getHeight() / 2 + 20);
            }
            for (n2 = 1; n2 < dArray3.length; ++n2) {
                graphics2D.drawString(decimalFormat.format(dArray3[n2]), this.getWidth() / 2 + 10, this.getHeight() / 2 - (int)Math.round(dArray3[n2] * d8));
            }
            for (n2 = 1; n2 < dArray3.length; ++n2) {
                graphics2D.drawString("-" + decimalFormat.format(dArray3[n2]), this.getWidth() / 2 + 10, this.getHeight() / 2 + (int)Math.round(dArray3[n2] * d8));
            }
        }
        if (this.geneOrExpt == 1 || this.geneOrExpt == 2) {
            for (n3 = 0; n3 < this.xArray.length; ++n3) {
                Color color = Color.black;
                if (this.geneOrExpt == 1) {
                    color = this.data.getProbeColor(this.experiment.getGeneIndexMappedToData(n3));
                    if (color == null) {
                        color = Color.black;
                    }
                } else if (this.geneOrExpt == 2 && (color = this.data.getExperimentColor(n3)) == null) {
                    color = Color.black;
                }
                graphics2D.setColor(color);
                if (this.showLargePoints) {
                    this.drawRectPoint(graphics2D, this.xArray[n3], this.yArray[n3], this.getXScalingFactor(d3, d5), this.getYScalingFactor(d4, d6), 8);
                } else {
                    this.drawPoint(graphics2D, this.xArray[n3], this.yArray[n3], this.getXScalingFactor(d3, d5), this.getYScalingFactor(d4, d6), 5);
                }
                graphics2D.setColor(Color.black);
            }
            graphics2D.drawString("X axis = " + (this.axis1 + 1) + ", Y axis = " + (this.axis2 + 1), this.getWidth() / 2 + 25, this.getHeight() - 25);
        } else {
            Color color = Color.black;
            for (n2 = 0; n2 < this.geneUMatrix.getRowDimension(); ++n2) {
                color = this.data.getProbeColor(this.experiment.getGeneIndexMappedToData(n2));
                if (color == null) {
                    color = Color.gray;
                }
                graphics2D.setColor(color);
                this.drawPoint(graphics2D, this.xArray[n2], this.yArray[n2], this.getXScalingFactor(d3, d5), this.getYScalingFactor(d4, d6), 5);
                graphics2D.setColor(Color.gray);
            }
            for (n2 = this.geneUMatrix.getRowDimension(); n2 < this.xArray.length; ++n2) {
                color = this.data.getExperimentColor(n2 - this.geneUMatrix.getRowDimension());
                if (color == null) {
                    color = Color.black;
                }
                graphics2D.setColor(color);
                this.drawRectPoint(graphics2D, this.xArray[n2], this.yArray[n2], this.getXScalingFactor(d3, d5), this.getYScalingFactor(d4, d6), 8);
                graphics2D.setColor(Color.black);
            }
            graphics2D.setColor(Color.black);
            graphics2D.drawString("X axis = " + (this.axis1 + 1) + ", Y axis = " + (this.axis2 + 1), this.getWidth() / 2 + 25, this.getHeight() - 25);
        }
        if (this.geneOrExpt == 2 && this.displayExptNames) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(graphics2D.getFont());
            double d14 = fontMetrics.getAscent();
            d2 = fontMetrics.getMaxAdvance();
            for (n = 0; n < this.xArray.length; ++n) {
                dArray = this.getCoords(this.xArray[n], this.yArray[n]);
                if (dArray[0] + 0.5 * d2 + (d = (double)fontMetrics.stringWidth(string = this.data.getSampleName(n))) > (double)this.getWidth()) {
                    graphics2D.drawString(string, (float)(dArray[0] - d - 0.25 * d2), (float)(dArray[1] + 0.5 * d14));
                    continue;
                }
                graphics2D.drawString(string, (float)(dArray[0] + 0.5 * d2), (float)(dArray[1] + 0.5 * d14));
            }
        }
        if (this.geneOrExpt == 3 && this.displayExptNames) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(graphics2D.getFont());
            double d15 = fontMetrics.getAscent();
            d2 = fontMetrics.getMaxAdvance();
            for (n = this.geneUMatrix.getRowDimension(); n < this.xArray.length; ++n) {
                dArray = this.getCoords(this.xArray[n], this.yArray[n]);
                if (dArray[0] + 0.5 * d2 + (d = (double)fontMetrics.stringWidth(string = this.data.getSampleName(n - this.geneUMatrix.getRowDimension()))) > (double)this.getWidth()) {
                    graphics2D.drawString(string, (float)(dArray[0] - d - 0.25 * d2), (float)(dArray[1] + 0.5 * d15));
                    continue;
                }
                graphics2D.drawString(string, (float)(dArray[0] + 0.5 * d2), (float)(dArray[1] + 0.5 * d15));
            }
        }
        if (this.currentRect != null) {
            graphics2D.setXORMode(Color.white);
            graphics2D.draw(this.ellipse);
        }
    }

    private void drawPoint(Graphics2D graphics2D, double d, double d2, double d3, double d4, int n) {
        int n2 = (int)Math.round(d * d3);
        int n3 = (int)Math.round(d2 * d4);
        int n4 = (int)Math.round((double)(this.getWidth() / 2)) + n2;
        int n5 = (int)Math.round((double)(this.getHeight() / 2)) - n3;
        graphics2D.fillOval(n4, n5, n, n);
    }

    private void drawRectPoint(Graphics2D graphics2D, double d, double d2, double d3, double d4, int n) {
        int n2 = (int)Math.round(d * d3);
        int n3 = (int)Math.round(d2 * d4);
        int n4 = (int)Math.round((double)(this.getWidth() / 2)) + n2;
        int n5 = (int)Math.round((double)(this.getHeight() / 2)) - n3;
        graphics2D.fillRect(n4, n5, n, n);
    }

    private double getMax(float[] fArray) {
        float f = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < fArray.length; ++i) {
            if (!(f < fArray[i])) continue;
            f = fArray[i];
        }
        return f;
    }

    private double getMin(float[] fArray) {
        float f = Float.POSITIVE_INFINITY;
        for (int i = 0; i < fArray.length; ++i) {
            if (!(f > fArray[i])) continue;
            f = fArray[i];
        }
        return f;
    }

    private double getXScalingFactor(double d, double d2) {
        double d3 = 1.0;
        if (d > 0.0 && d2 > 0.0) {
            d3 = d;
        } else if (d > 0.0 && d2 < 0.0) {
            d3 = d > Math.abs(d2) ? d : Math.abs(d2);
        } else if (d <= 0.0) {
            d3 = Math.abs(d2);
        } else if (d2 == 0.0) {
            d3 = d;
        }
        double d4 = 0.0;
        d4 = (double)(this.getWidth() / 2 - 50) / d3;
        return d4;
    }

    private double getYScalingFactor(double d, double d2) {
        double d3 = 1.0;
        if (d > 0.0 && d2 > 0.0) {
            d3 = d;
        } else if (d > 0.0 && d2 < 0.0) {
            d3 = d > Math.abs(d2) ? d : Math.abs(d2);
        } else if (d <= 0.0) {
            d3 = Math.abs(d2);
        } else if (d2 == 0.0) {
            d3 = d;
        }
        double d4 = 0.0;
        d4 = (double)(this.getHeight() / 2 - 50) / d3;
        return d4;
    }

    public int[][] getClusters() {
        return null;
    }

    public int[] getSelectedPoints() {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this.UMatrix.getRowDimension(); ++i) {
            double[] dArray = this.getCoords(this.xArray[i], this.yArray[i]);
            if (!this.ellipse.contains(dArray[0], dArray[1])) continue;
            if (this.geneOrExpt == 1) {
                vector.add(new Integer(this.experiment.getGeneIndexMappedToData(i)));
                continue;
            }
            if (this.geneOrExpt != 2) continue;
            vector.add(new Integer(this.experiment.getSampleIndex(i)));
        }
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    public int[] getSelectedGenesFromBoth() {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this.geneUMatrix.getRowDimension(); ++i) {
            double[] dArray = this.getCoords(this.xArray[i], this.yArray[i]);
            if (!this.ellipse.contains(dArray[0], dArray[1])) continue;
            vector.add(new Integer(this.experiment.getGeneIndexMappedToData(i)));
        }
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    public int[] getSelectedExptsFromBoth() {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = this.geneUMatrix.getRowDimension(); i < this.UMatrix.getRowDimension(); ++i) {
            double[] dArray = this.getCoords(this.xArray[i], this.yArray[i]);
            if (!this.ellipse.contains(dArray[0], dArray[1])) continue;
            vector.add(new Integer(this.experiment.getSampleIndex(i - this.geneUMatrix.getRowDimension())));
        }
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    private double[] getCoords(double d, double d2) {
        double d3 = this.getMax(this.xArray);
        double d4 = this.getMax(this.yArray);
        double d5 = this.getMin(this.xArray);
        double d6 = this.getMin(this.yArray);
        double d7 = this.getXScalingFactor(d3, d5);
        double d8 = this.getYScalingFactor(d4, d6);
        double d9 = Math.round(d * d7);
        double d10 = Math.round(d2 * d8);
        double d11 = (double)Math.round((double)(this.getWidth() / 2)) + d9;
        double d12 = (double)Math.round((double)(this.getHeight() / 2)) - d10;
        double[] dArray = new double[]{d11, d12};
        return dArray;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getCornerComponent(int n) {
        return null;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public BufferedImage getImage() {
        return null;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public int getViewerType() {
        return -1;
    }

    public void onClosed() {
    }

    public void onDataChanged(IData iData) {
        this.setData(iData);
    }

    public void onDeselected() {
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
    }

    public void onSelected(IFramework iFramework) {
        this.framework = iFramework;
        this.frame = iFramework.getFrame();
        this.setData(iFramework.getData());
        if (this.popup == null) {
            this.popup = this.createJPopupMenu();
            DefaultMutableTreeNode defaultMutableTreeNode = iFramework.getCurrentNode();
            if (defaultMutableTreeNode != null && defaultMutableTreeNode.getUserObject() instanceof LeafInfo) {
                LeafInfo leafInfo = (LeafInfo)defaultMutableTreeNode.getUserObject();
                leafInfo.setPopupMenu(this.popup);
            }
        }
    }

    public void setData(IData iData) {
        this.data = iData;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.experiment);
        objectOutputStream.writeInt(this.geneOrExpt);
        if (this.geneOrExpt == 3) {
            objectOutputStream.writeObject(this.geneUMatrix);
            objectOutputStream.writeObject(this.exptUMatrix);
        }
        objectOutputStream.writeObject(this.UMatrix);
        objectOutputStream.writeInt(this.axis1);
        objectOutputStream.writeInt(this.axis2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.experiment = (Experiment)objectInputStream.readObject();
        this.geneOrExpt = objectInputStream.readInt();
        if (this.geneOrExpt == 3) {
            this.geneUMatrix = (FloatMatrix)objectInputStream.readObject();
            this.exptUMatrix = (FloatMatrix)objectInputStream.readObject();
        }
        this.UMatrix = (FloatMatrix)objectInputStream.readObject();
        this.axis1 = objectInputStream.readInt();
        this.axis2 = objectInputStream.readInt();
        this.xArray = this.getFloatArray(this.UMatrix, this.axis1);
        this.yArray = this.getFloatArray(this.UMatrix, this.axis2);
        this.displayExptNames = false;
        this.showLargePoints = false;
        this.showTickLabels = true;
        this.ellipse = new Ellipse2D.Double();
        this.setBackground(Color.white);
        this.currentRect = null;
        this.rectToDraw = null;
        this.previousRectDrawn = new Rectangle();
        GraphListener graphListener = new GraphListener();
        this.addMouseListener(graphListener);
        this.addMouseMotionListener(graphListener);
    }

    public JPopupMenu getJPopupMenu() {
        return this.popup;
    }

    private JPopupMenu createJPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenuItems(jPopupMenu);
        return jPopupMenu;
    }

    private void addMenuItems(JPopupMenu jPopupMenu) {
        JMenuItem jMenuItem;
        Listener listener = new Listener();
        if (this.geneOrExpt == 3) {
            jMenuItem = new JMenuItem("Store gene cluster...", GUIFactory.getIcon("new16.gif"));
            jMenuItem.setEnabled(false);
            jMenuItem.setActionCommand(STORE_GENE_CLUSTER_CMD);
            jMenuItem.addActionListener(listener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Launch new session with selected genes", GUIFactory.getIcon("launch_new_mav.gif"));
            jMenuItem.setEnabled(false);
            jMenuItem.setActionCommand(LAUNCH_NEW_GENE_SESSION_CMD);
            jMenuItem.addActionListener(listener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Save gene cluster...", GUIFactory.getIcon("save16.gif"));
            jMenuItem.setEnabled(false);
            jMenuItem.setActionCommand(SAVE_GENE_CLUSTER_CMD);
            jMenuItem.addActionListener(listener);
            jPopupMenu.add(jMenuItem);
            jPopupMenu.addSeparator();
            jMenuItem = new JMenuItem("Store sample cluster...", GUIFactory.getIcon("new16.gif"));
            jMenuItem.setEnabled(false);
            jMenuItem.setActionCommand(STORE_EXPT_CLUSTER_CMD);
            jMenuItem.addActionListener(listener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Launch new session with selected samples", GUIFactory.getIcon("launch_new_mav.gif"));
            jMenuItem.setEnabled(false);
            jMenuItem.setActionCommand(LAUNCH_NEW_EXPT_SESSION_CMD);
            jMenuItem.addActionListener(listener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Save sample cluster...", GUIFactory.getIcon("save16.gif"));
            jMenuItem.setEnabled(false);
            jMenuItem.setActionCommand(SAVE_EXPT_CLUSTER_CMD);
            jMenuItem.addActionListener(listener);
            jPopupMenu.add(jMenuItem);
        } else {
            jMenuItem = new JMenuItem("Store cluster...", GUIFactory.getIcon("new16.gif"));
            jMenuItem.setEnabled(false);
            jMenuItem.setActionCommand(STORE_CLUSTER_CMD);
            jMenuItem.addActionListener(listener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Launch new session", GUIFactory.getIcon("launch_new_mav.gif"));
            jMenuItem.setEnabled(false);
            jMenuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
            jMenuItem.addActionListener(listener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon("save16.gif"));
            jMenuItem.setEnabled(false);
            jMenuItem.setActionCommand(SAVE_CMD);
            jMenuItem.addActionListener(listener);
            jPopupMenu.add(jMenuItem);
        }
        if (this.geneOrExpt == 2 || this.geneOrExpt == 3) {
            jPopupMenu.addSeparator();
            jMenuItem = new JCheckBoxMenuItem("Show sample names");
            jMenuItem.setEnabled(true);
            jMenuItem.setActionCommand(DISPLAY_EXPT_NAMES_CMD);
            jMenuItem.addActionListener(listener);
            jPopupMenu.add(jMenuItem);
        }
        if (this.geneOrExpt == 2 || this.geneOrExpt == 1) {
            jMenuItem = new JCheckBoxMenuItem("Larger point size");
            jMenuItem.setEnabled(true);
            jMenuItem.setActionCommand(SHOW_LARGER_POINTS_CMD);
            jMenuItem.addActionListener(listener);
            jPopupMenu.add(jMenuItem);
        }
        jMenuItem = new JCheckBoxMenuItem("Show tick marks and labels");
        jMenuItem.setEnabled(true);
        jMenuItem.setSelected(true);
        jMenuItem.setActionCommand(SHOW_TICK_LABELS_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
    }

    private JMenuItem getJMenuItem(String string) {
        Component[] componentArray = this.popup.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JMenuItem) || !((JMenuItem)componentArray[i]).getActionCommand().equals(string)) continue;
            return (JMenuItem)componentArray[i];
        }
        return null;
    }

    private void setEnableMenuItem(String string, boolean bl) {
        JMenuItem jMenuItem = this.getJMenuItem(string);
        if (jMenuItem == null) {
            return;
        }
        jMenuItem.setEnabled(bl);
    }

    private void onSave() {
        try {
            if (this.geneOrExpt == 1) {
                ExperimentUtil.saveExperiment((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.getSelectedPoints());
            } else if (this.geneOrExpt == 2) {
                ExperimentUtil.saveExperimentCluster((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.getSelectedPoints());
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.frame, "Can not save matrix!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSaveGenesFromBoth() {
        try {
            ExperimentUtil.saveExperiment((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.getSelectedGenesFromBoth());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.frame, "Can not save matrix!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSaveExptsFromBoth() {
        try {
            ExperimentUtil.saveExperimentCluster((Frame)this.frame, (Experiment)this.experiment, (IData)this.data, (int[])this.getSelectedExptsFromBoth());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.frame, "Can not save matrix!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void storeCluster() {
        if (this.geneOrExpt == 1) {
            this.framework.storeSubCluster(this.getSelectedPoints(), this.experiment, 0);
        } else if (this.geneOrExpt == 2) {
            this.framework.storeSubCluster(this.getSelectedPoints(), this.experiment, 1);
        }
        this.onDataChanged(this.data);
        this.repaint();
    }

    private void storeGeneClusterFromBoth() {
        this.framework.storeSubCluster(this.getSelectedGenesFromBoth(), this.experiment, 0);
        this.onDataChanged(this.data);
        this.repaint();
    }

    private void storeExptClusterFromBoth() {
        this.framework.storeSubCluster(this.getSelectedExptsFromBoth(), this.experiment, 1);
        this.onDataChanged(this.data);
        this.repaint();
    }

    private void launchNewSession() {
        if (this.geneOrExpt == 1) {
            this.framework.launchNewMAV(this.getSelectedPoints(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 0);
        } else if (this.geneOrExpt == 2) {
            this.framework.launchNewMAV(this.getSelectedPoints(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 1);
        }
    }

    private void launchNewGeneSessionFromBoth() {
        this.framework.launchNewMAV(this.getSelectedGenesFromBoth(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 0);
    }

    private void launchNewExptSessionFromBoth() {
        this.framework.launchNewMAV(this.getSelectedExptsFromBoth(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 1);
    }

    private void onShowSelection() {
        if (this.geneOrExpt == 1 || this.geneOrExpt == 2) {
            JMenuItem jMenuItem = this.getJMenuItem(SAVE_CMD);
            JMenuItem jMenuItem2 = this.getJMenuItem(STORE_CLUSTER_CMD);
            JMenuItem jMenuItem3 = this.getJMenuItem(LAUNCH_NEW_SESSION_CMD);
            if (!this.ellipse.isEmpty()) {
                jMenuItem.setEnabled(true);
                jMenuItem2.setEnabled(true);
                jMenuItem3.setEnabled(true);
            } else {
                jMenuItem.setEnabled(false);
                jMenuItem2.setEnabled(false);
                jMenuItem3.setEnabled(false);
            }
        } else {
            JMenuItem jMenuItem = this.getJMenuItem(SAVE_GENE_CLUSTER_CMD);
            JMenuItem jMenuItem4 = this.getJMenuItem(STORE_GENE_CLUSTER_CMD);
            JMenuItem jMenuItem5 = this.getJMenuItem(LAUNCH_NEW_GENE_SESSION_CMD);
            JMenuItem jMenuItem6 = this.getJMenuItem(SAVE_EXPT_CLUSTER_CMD);
            JMenuItem jMenuItem7 = this.getJMenuItem(STORE_EXPT_CLUSTER_CMD);
            JMenuItem jMenuItem8 = this.getJMenuItem(LAUNCH_NEW_EXPT_SESSION_CMD);
            if (!this.ellipse.isEmpty()) {
                jMenuItem.setEnabled(true);
                jMenuItem6.setEnabled(true);
                jMenuItem4.setEnabled(true);
                jMenuItem7.setEnabled(true);
                jMenuItem5.setEnabled(true);
                jMenuItem8.setEnabled(true);
            } else {
                jMenuItem.setEnabled(false);
                jMenuItem6.setEnabled(false);
                jMenuItem4.setEnabled(false);
                jMenuItem7.setEnabled(false);
                jMenuItem5.setEnabled(false);
                jMenuItem8.setEnabled(false);
            }
        }
    }

    private void showExptNames() {
        this.displayExptNames = !this.displayExptNames;
        this.repaint();
    }

    private void displayLargePoints() {
        this.showLargePoints = !this.showLargePoints;
        this.repaint();
    }

    private void displayTickLabels() {
        this.showTickLabels = !this.showTickLabels;
        this.repaint();
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(COA2DViewer.SAVE_GENE_CLUSTER_CMD)) {
                COA2DViewer.this.onSaveGenesFromBoth();
            } else if (string.equals(COA2DViewer.SAVE_EXPT_CLUSTER_CMD)) {
                COA2DViewer.this.onSaveExptsFromBoth();
            } else if (string.equals(COA2DViewer.SAVE_CMD)) {
                COA2DViewer.this.onSave();
            } else if (string.equals(COA2DViewer.STORE_CLUSTER_CMD)) {
                COA2DViewer.this.storeCluster();
            } else if (string.equals(COA2DViewer.STORE_GENE_CLUSTER_CMD)) {
                COA2DViewer.this.storeGeneClusterFromBoth();
            } else if (string.equals(COA2DViewer.STORE_EXPT_CLUSTER_CMD)) {
                COA2DViewer.this.storeExptClusterFromBoth();
            } else if (string.equals(COA2DViewer.LAUNCH_NEW_SESSION_CMD)) {
                COA2DViewer.this.launchNewSession();
            } else if (string.equals(COA2DViewer.LAUNCH_NEW_GENE_SESSION_CMD)) {
                COA2DViewer.this.launchNewGeneSessionFromBoth();
            } else if (string.equals(COA2DViewer.LAUNCH_NEW_EXPT_SESSION_CMD)) {
                COA2DViewer.this.launchNewExptSessionFromBoth();
            } else if (string.equals(COA2DViewer.DISPLAY_EXPT_NAMES_CMD)) {
                COA2DViewer.this.showExptNames();
            } else if (string.equals(COA2DViewer.SHOW_LARGER_POINTS_CMD)) {
                COA2DViewer.this.displayLargePoints();
            } else if (string.equals(COA2DViewer.SHOW_TICK_LABELS_CMD)) {
                COA2DViewer.this.displayTickLabels();
            }
        }
    }

    private class GraphListener
    extends MouseInputAdapter {
        private GraphListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            COA2DViewer.this.currentRect = new Rectangle(n, n2, 0, 0);
            this.updateDrawableRect(COA2DViewer.this.getWidth(), COA2DViewer.this.getHeight());
            COA2DViewer.this.repaint();
            COA2DViewer.this.onShowSelection();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.updateSize(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.updateSize(mouseEvent);
        }

        void updateSize(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            COA2DViewer.this.currentRect.setSize(n - COA2DViewer.this.currentRect.x, n2 - COA2DViewer.this.currentRect.y);
            this.updateDrawableRect(COA2DViewer.this.getWidth(), COA2DViewer.this.getHeight());
            Rectangle rectangle = COA2DViewer.this.rectToDraw.union(COA2DViewer.this.previousRectDrawn);
            COA2DViewer.this.ellipse.setFrame(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
            COA2DViewer.this.repaint();
            COA2DViewer.this.onShowSelection();
        }

        private void updateDrawableRect(int n, int n2) {
            int n3 = COA2DViewer.this.currentRect.x;
            int n4 = COA2DViewer.this.currentRect.y;
            int n5 = COA2DViewer.this.currentRect.width;
            int n6 = COA2DViewer.this.currentRect.height;
            if (n5 < 0 && (n3 = n3 - (n5 = 0 - n5) + 1) < 0) {
                n5 += n3;
                n3 = 0;
            }
            if (n6 < 0 && (n4 = n4 - (n6 = 0 - n6) + 1) < 0) {
                n6 += n4;
                n4 = 0;
            }
            if (n3 + n5 > n) {
                n5 = n - n3;
            }
            if (n4 + n6 > n2) {
                n6 = n2 - n4;
            }
            if (COA2DViewer.this.rectToDraw != null) {
                COA2DViewer.this.previousRectDrawn.setBounds(COA2DViewer.this.rectToDraw.x, COA2DViewer.this.rectToDraw.y, COA2DViewer.this.rectToDraw.width, COA2DViewer.this.rectToDraw.height);
                COA2DViewer.this.rectToDraw.setBounds(n3, n4, n5, n6);
            } else {
                COA2DViewer.this.rectToDraw = new Rectangle(n3, n4, n5, n6);
            }
        }
    }
}

