/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.coa;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;

public class COAAdditional3DAxesDialog
extends AlgorithmDialog {
    boolean okPressed = false;
    private int numAxes;
    private JComboBox xAxisBox;
    private JComboBox yAxisBox;
    private JComboBox zAxisBox;

    public COAAdditional3DAxesDialog(JFrame jFrame, boolean bl, int n) {
        super(jFrame, "Select new projection axes", bl);
        this.numAxes = n;
        this.setBounds(0, 0, 500, 200);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setBorder(new EtchedBorder());
        jPanel.setLayout(gridBagLayout);
        String[] stringArray = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = String.valueOf(i + 1);
        }
        this.xAxisBox = new JComboBox<String>(stringArray);
        this.yAxisBox = new JComboBox<String>(stringArray);
        this.zAxisBox = new JComboBox<String>(stringArray);
        this.xAxisBox.setSelectedIndex(0);
        this.yAxisBox.setSelectedIndex(1);
        this.zAxisBox.setSelectedIndex(2);
        JLabel jLabel = new JLabel("Select components to plot: ");
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 40, 100);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 20, 0);
        gridBagLayout.setConstraints(this.xAxisBox, gridBagConstraints);
        jPanel.add(this.xAxisBox);
        this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 20, 0);
        gridBagLayout.setConstraints(this.yAxisBox, gridBagConstraints);
        jPanel.add(this.yAxisBox);
        this.buildConstraints(gridBagConstraints, 3, 0, 1, 1, 20, 0);
        gridBagLayout.setConstraints(this.zAxisBox, gridBagConstraints);
        jPanel.add(this.zAxisBox);
        this.addContent(jPanel);
        EventListener eventListener = new EventListener();
        this.setActionListeners(eventListener);
        this.addWindowListener(eventListener);
    }

    public void setVisible(boolean bl) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        super.setVisible(bl);
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public int getXAxis() {
        return this.xAxisBox.getSelectedIndex();
    }

    public int getYAxis() {
        return this.yAxisBox.getSelectedIndex();
    }

    public int getZAxis() {
        return this.zAxisBox.getSelectedIndex();
    }

    public void setZBoxInvisible(boolean bl) {
        this.zAxisBox.setEnabled(!bl);
        this.zAxisBox.setVisible(!bl);
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public static void main(String[] stringArray) {
        COAAdditional3DAxesDialog cOAAdditional3DAxesDialog = new COAAdditional3DAxesDialog(new JFrame(), true, 10);
        cOAAdditional3DAxesDialog.setVisible(true);
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                int n = COAAdditional3DAxesDialog.this.getXAxis();
                int n2 = COAAdditional3DAxesDialog.this.getYAxis();
                int n3 = COAAdditional3DAxesDialog.this.getZAxis();
                if (!COAAdditional3DAxesDialog.this.zAxisBox.isVisible()) {
                    if (n == n2) {
                        JOptionPane.showMessageDialog(null, "Both axes cannot be the same", "Error", 0);
                        return;
                    }
                } else if (n == n2 || n2 == n3 || n == n3) {
                    JOptionPane.showMessageDialog(null, "No two axes can be the same", "Error", 0);
                    return;
                }
                COAAdditional3DAxesDialog.this.okPressed = true;
                COAAdditional3DAxesDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                COAAdditional3DAxesDialog.this.xAxisBox.setSelectedIndex(0);
                COAAdditional3DAxesDialog.this.yAxisBox.setSelectedIndex(1);
                COAAdditional3DAxesDialog.this.zAxisBox.setSelectedIndex(2);
            } else if (string.equals("cancel-command")) {
                COAAdditional3DAxesDialog.this.okPressed = false;
                COAAdditional3DAxesDialog.this.dispose();
            } else if (string.equals("info-command")) {
                // empty if block
            }
        }
    }
}

