/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.coa;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.impl.coa.COA2DViewer;
import org.tigr.microarray.mev.cluster.gui.impl.coa.COA3DViewer;
import org.tigr.microarray.mev.cluster.gui.impl.coa.COAAdditional3DAxesDialog;
import org.tigr.microarray.mev.cluster.gui.impl.coa.COADummyViewer;
import org.tigr.microarray.mev.cluster.gui.impl.coa.COAInertiaValsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.coa.COAInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Logger;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class COAGUI
implements IClusterGUI,
IScriptGUI {
    private static final String ADD_NEW_3D_CMD = "add-new-3d-cmd";
    private static final String ADD_NEW_2D_CMD = "add-new-2d-cmd";
    public static final int GENES = 1;
    public static final int EXPTS = 2;
    public static final int BOTH = 3;
    private Algorithm algorithm;
    private Logger logger;
    private IData data;
    private Experiment experiment;
    private FloatMatrix geneUMatrix;
    private FloatMatrix exptUMatrix;
    private FloatMatrix lambdaValues;
    private IFramework currFramework;
    private DefaultMutableTreeNode projectionNode;
    private double[] lambdaArray;
    private double[] inertiaVals;
    private double[] cumulativeInertiaVals;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        DefaultMutableTreeNode defaultMutableTreeNode;
        block5: {
            this.experiment = iFramework.getData().getExperiment();
            this.data = iFramework.getData();
            int n = this.experiment.getNumberOfSamples();
            int n2 = this.experiment.getNumberOfGenes();
            COAInitDialog cOAInitDialog = new COAInitDialog((JFrame)iFramework.getFrame(), true);
            cOAInitDialog.setVisible(true);
            if (!cOAInitDialog.isOkPressed()) {
                return null;
            }
            int n3 = cOAInitDialog.getNumNeighbors();
            Listener listener = new Listener();
            try {
                this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("COA");
                this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
                this.logger = new Logger(iFramework.getFrame(), "COA Log Window", listener);
                this.logger.show();
                this.logger.append("Starting SVD calculation\n");
                this.currFramework = iFramework;
                AlgorithmData algorithmData = new AlgorithmData();
                algorithmData.addMatrix("experiment", this.experiment.getMatrix());
                algorithmData.addParam("numNeighbors", String.valueOf(n3));
                long l = System.currentTimeMillis();
                AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
                long l2 = System.currentTimeMillis() - l;
                this.geneUMatrix = algorithmData2.getMatrix("gene");
                this.exptUMatrix = algorithmData2.getMatrix("expt");
                this.lambdaValues = algorithmData2.getMatrix("lambdaValues");
                this.calculateInertiaVals();
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("COA");
                this.addResultNodes(iFramework.getFrame(), defaultMutableTreeNode2, l2, this.experiment);
                defaultMutableTreeNode = defaultMutableTreeNode2;
                Object var16_13 = null;
                if (this.algorithm == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var16_14 = null;
                    if (this.algorithm != null) {
                        this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
                    }
                    if (this.logger == null) break block6;
                    this.logger.dispose();
                }
                throw throwable;
            }
            this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
        }
        if (this.logger != null) {
            this.logger.dispose();
        }
        return defaultMutableTreeNode;
    }

    private void calculateInertiaVals() {
        int n;
        this.lambdaArray = new double[this.lambdaValues.getRowDimension()];
        for (int i = 0; i < this.lambdaArray.length; ++i) {
            this.lambdaArray[i] = this.lambdaValues.get(i, 0);
        }
        double d = 0.0;
        for (n = 0; n < this.lambdaArray.length; ++n) {
            d += Math.pow(this.lambdaArray[n], 2.0);
        }
        this.inertiaVals = new double[this.lambdaArray.length];
        this.cumulativeInertiaVals = new double[this.lambdaArray.length];
        for (n = 0; n < this.inertiaVals.length; ++n) {
            this.inertiaVals[n] = Math.pow(this.lambdaArray[n], 2.0) * 100.0 / d;
        }
        this.cumulativeInertiaVals[0] = this.inertiaVals[0];
        for (n = 1; n < this.cumulativeInertiaVals.length; ++n) {
            double d2 = 0.0;
            for (int i = 0; i <= n; ++i) {
                d2 += this.inertiaVals[i];
            }
            this.cumulativeInertiaVals[n] = d2;
        }
    }

    private void addResultNodes(Frame frame, DefaultMutableTreeNode defaultMutableTreeNode, long l, Experiment experiment) {
        Listener listener = new Listener();
        COADummyViewer cOADummyViewer = new COADummyViewer(this.geneUMatrix, this.exptUMatrix);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Components 1, 2, 3");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("3D Views");
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("2D Views");
        this.add3DViewNode(frame, defaultMutableTreeNode3, experiment, 0, 1, 2);
        this.add2DViewNode(defaultMutableTreeNode4, experiment, 0, 1, 2);
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode2.add(defaultMutableTreeNode4);
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Add new 3-axis projections");
        jMenuItem.setActionCommand(ADD_NEW_3D_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Add new 2-axis projections");
        jMenuItem.setActionCommand(ADD_NEW_2D_CMD);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        this.projectionNode = new DefaultMutableTreeNode(new LeafInfo("Projections on COA axes", (IViewer)cOADummyViewer, cOADummyViewer.getJPopupMenu()));
        this.projectionNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(this.projectionNode);
        this.addCOAInertiaViewer(defaultMutableTreeNode);
    }

    private void addCOAInertiaViewer(DefaultMutableTreeNode defaultMutableTreeNode) {
        COAInertiaValsViewer cOAInertiaValsViewer = new COAInertiaValsViewer(this.inertiaVals, this.cumulativeInertiaVals);
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Inertia values", (IViewer)cOAInertiaValsViewer)));
    }

    private void add3DViewNode(Frame frame, DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment) {
        COA3DViewer cOA3DViewer = new COA3DViewer(frame, this.geneUMatrix, experiment, 1, 0, 1, 2);
        COA3DViewer cOA3DViewer2 = new COA3DViewer(frame, this.exptUMatrix, experiment, 2, 0, 1, 2);
        COA3DViewer cOA3DViewer3 = new COA3DViewer(frame, this.geneUMatrix, this.exptUMatrix, experiment, 3, 0, 1, 2);
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("3D view - genes", (IViewer)cOA3DViewer, cOA3DViewer.getJPopupMenu())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("3D view - expts", (IViewer)cOA3DViewer2, cOA3DViewer2.getJPopupMenu())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("3D view - both", (IViewer)cOA3DViewer3, cOA3DViewer3.getJPopupMenu())));
    }

    private void add3DViewNode(Frame frame, DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment, int n, int n2, int n3) {
        COA3DViewer cOA3DViewer = new COA3DViewer(frame, this.geneUMatrix, experiment, 1, n, n2, n3);
        COA3DViewer cOA3DViewer2 = new COA3DViewer(frame, this.exptUMatrix, experiment, 2, n, n2, n3);
        COA3DViewer cOA3DViewer3 = new COA3DViewer(frame, this.geneUMatrix, this.exptUMatrix, experiment, 3, n, n2, n3);
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("3D view - genes", (IViewer)cOA3DViewer, cOA3DViewer.getJPopupMenu())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("3D view - expts", (IViewer)cOA3DViewer2, cOA3DViewer2.getJPopupMenu())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("3D view - both", (IViewer)cOA3DViewer3, cOA3DViewer3.getJPopupMenu())));
    }

    private void add2DViewNode(DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("2D views - genes");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("2D views - expts");
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("2D views - both");
        COA2DViewer cOA2DViewer = new COA2DViewer(experiment, this.geneUMatrix, 1, 0, 1);
        COA2DViewer cOA2DViewer2 = new COA2DViewer(experiment, this.geneUMatrix, 1, 1, 2);
        COA2DViewer cOA2DViewer3 = new COA2DViewer(experiment, this.geneUMatrix, 1, 0, 2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("1, 2", (IViewer)cOA2DViewer, cOA2DViewer.getJPopupMenu())));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("2, 3", (IViewer)cOA2DViewer2, cOA2DViewer2.getJPopupMenu())));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("1, 3", (IViewer)cOA2DViewer3, cOA2DViewer3.getJPopupMenu())));
        COA2DViewer cOA2DViewer4 = new COA2DViewer(experiment, this.exptUMatrix, 2, 0, 1);
        COA2DViewer cOA2DViewer5 = new COA2DViewer(experiment, this.exptUMatrix, 2, 1, 2);
        COA2DViewer cOA2DViewer6 = new COA2DViewer(experiment, this.exptUMatrix, 2, 0, 2);
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("1, 2", (IViewer)cOA2DViewer4, cOA2DViewer4.getJPopupMenu())));
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("2, 3", (IViewer)cOA2DViewer5, cOA2DViewer5.getJPopupMenu())));
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("1, 3", (IViewer)cOA2DViewer6, cOA2DViewer6.getJPopupMenu())));
        COA2DViewer cOA2DViewer7 = new COA2DViewer(experiment, this.geneUMatrix, this.exptUMatrix, 3, 0, 1);
        COA2DViewer cOA2DViewer8 = new COA2DViewer(experiment, this.geneUMatrix, this.exptUMatrix, 3, 1, 2);
        COA2DViewer cOA2DViewer9 = new COA2DViewer(experiment, this.geneUMatrix, this.exptUMatrix, 3, 0, 2);
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode(new LeafInfo("1, 2", (IViewer)cOA2DViewer7, cOA2DViewer7.getJPopupMenu())));
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode(new LeafInfo("2, 3", (IViewer)cOA2DViewer8, cOA2DViewer8.getJPopupMenu())));
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode(new LeafInfo("1, 3", (IViewer)cOA2DViewer9, cOA2DViewer9.getJPopupMenu())));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
    }

    private void add2DViewNode(DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment, int n, int n2, int n3) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("2D views - genes");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("2D views - expts");
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("2D views - both");
        COA2DViewer cOA2DViewer = new COA2DViewer(experiment, this.geneUMatrix, 1, n, n2);
        COA2DViewer cOA2DViewer2 = new COA2DViewer(experiment, this.geneUMatrix, 1, n2, n3);
        COA2DViewer cOA2DViewer3 = new COA2DViewer(experiment, this.geneUMatrix, 1, n, n3);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("" + (n + 1) + ", " + (n2 + 1), (IViewer)cOA2DViewer, cOA2DViewer.getJPopupMenu())));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("" + (n2 + 1) + ", " + (n3 + 1), (IViewer)cOA2DViewer2, cOA2DViewer2.getJPopupMenu())));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("" + (n + 1) + ", " + (n3 + 1), (IViewer)cOA2DViewer3, cOA2DViewer3.getJPopupMenu())));
        COA2DViewer cOA2DViewer4 = new COA2DViewer(experiment, this.exptUMatrix, 2, n, n2);
        COA2DViewer cOA2DViewer5 = new COA2DViewer(experiment, this.exptUMatrix, 2, n2, n3);
        COA2DViewer cOA2DViewer6 = new COA2DViewer(experiment, this.exptUMatrix, 2, n, n3);
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("" + (n + 1) + ", " + (n2 + 1), (IViewer)cOA2DViewer4, cOA2DViewer4.getJPopupMenu())));
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("" + (n2 + 1) + ", " + (n3 + 1), (IViewer)cOA2DViewer5, cOA2DViewer5.getJPopupMenu())));
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("" + (n + 1) + ", " + (n3 + 1), (IViewer)cOA2DViewer6, cOA2DViewer6.getJPopupMenu())));
        COA2DViewer cOA2DViewer7 = new COA2DViewer(experiment, this.geneUMatrix, this.exptUMatrix, 3, n, n2);
        COA2DViewer cOA2DViewer8 = new COA2DViewer(experiment, this.geneUMatrix, this.exptUMatrix, 3, n2, n3);
        COA2DViewer cOA2DViewer9 = new COA2DViewer(experiment, this.geneUMatrix, this.exptUMatrix, 3, n, n3);
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode(new LeafInfo("" + (n + 1) + ", " + (n2 + 1), (IViewer)cOA2DViewer7, cOA2DViewer7.getJPopupMenu())));
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode(new LeafInfo("" + (n2 + 1) + ", " + (n3 + 1), (IViewer)cOA2DViewer8, cOA2DViewer8.getJPopupMenu())));
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode(new LeafInfo("" + (n + 1) + ", " + (n3 + 1), (IViewer)cOA2DViewer9, cOA2DViewer9.getJPopupMenu())));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
    }

    private float[] getFloatArray(FloatMatrix floatMatrix, int n) {
        float[] fArray = new float[floatMatrix.getRowDimension()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = floatMatrix.A[i][n];
        }
        return fArray;
    }

    public void addNew3DNode() {
        COAAdditional3DAxesDialog cOAAdditional3DAxesDialog = new COAAdditional3DAxesDialog((JFrame)this.currFramework.getFrame(), true, this.geneUMatrix.getColumnDimension());
        cOAAdditional3DAxesDialog.setVisible(true);
        if (!cOAAdditional3DAxesDialog.isOkPressed()) {
            return;
        }
        int n = cOAAdditional3DAxesDialog.getXAxis();
        int n2 = cOAAdditional3DAxesDialog.getYAxis();
        int n3 = cOAAdditional3DAxesDialog.getZAxis();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Components " + (n + 1) + ", " + (n2 + 1) + ", " + (n3 + 1));
        this.add3DViewNode(this.currFramework.getFrame(), defaultMutableTreeNode, this.currFramework.getData().getExperiment(), n, n2, n3);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("2D Views");
        this.add2DViewNode(defaultMutableTreeNode2, this.currFramework.getData().getExperiment(), n, n2, n3);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        this.currFramework.addNode(this.projectionNode, defaultMutableTreeNode);
    }

    public void addNew2DNode() {
        COAAdditional3DAxesDialog cOAAdditional3DAxesDialog = new COAAdditional3DAxesDialog((JFrame)this.currFramework.getFrame(), true, this.geneUMatrix.getColumnDimension());
        cOAAdditional3DAxesDialog.setZBoxInvisible(true);
        cOAAdditional3DAxesDialog.setVisible(true);
        if (!cOAAdditional3DAxesDialog.isOkPressed()) {
            return;
        }
        int n = cOAAdditional3DAxesDialog.getXAxis();
        int n2 = cOAAdditional3DAxesDialog.getYAxis();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Components " + (n + 1) + ", " + (n2 + 1));
        COA2DViewer cOA2DViewer = new COA2DViewer(this.experiment, this.geneUMatrix, 1, n, n2);
        COA2DViewer cOA2DViewer2 = new COA2DViewer(this.experiment, this.exptUMatrix, 2, n, n2);
        COA2DViewer cOA2DViewer3 = new COA2DViewer(this.experiment, this.geneUMatrix, this.exptUMatrix, 3, n, n2);
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Genes", (IViewer)cOA2DViewer, cOA2DViewer.getJPopupMenu())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Expts", (IViewer)cOA2DViewer2, cOA2DViewer2.getJPopupMenu())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Both", (IViewer)cOA2DViewer3, cOA2DViewer3.getJPopupMenu())));
        this.currFramework.addNode(this.projectionNode, defaultMutableTreeNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework iFramework, AlgorithmData algorithmData, Experiment experiment) throws AlgorithmException {
        DefaultMutableTreeNode defaultMutableTreeNode;
        block4: {
            Listener listener = new Listener();
            try {
                this.algorithm = iFramework.getAlgorithmFactory().getAlgorithm("COA");
                this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
                this.logger = new Logger(iFramework.getFrame(), "COA Log Window", listener);
                this.logger.show();
                this.logger.append("Starting SVD calculation\n");
                this.currFramework = iFramework;
                AlgorithmParameters algorithmParameters = algorithmData.getParams();
                int n = algorithmParameters.getInt("numNeighbors");
                algorithmData.addMatrix("experiment", experiment.getMatrix());
                long l = System.currentTimeMillis();
                AlgorithmData algorithmData2 = this.algorithm.execute(algorithmData);
                long l2 = System.currentTimeMillis() - l;
                this.geneUMatrix = algorithmData2.getMatrix("gene");
                this.exptUMatrix = algorithmData2.getMatrix("expt");
                this.lambdaValues = algorithmData2.getMatrix("lambdaValues");
                this.calculateInertiaVals();
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("COA");
                this.addResultNodes(iFramework.getFrame(), defaultMutableTreeNode2, l2, experiment);
                defaultMutableTreeNode = defaultMutableTreeNode2;
                Object var15_12 = null;
                if (this.algorithm == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var15_13 = null;
                    if (this.algorithm != null) {
                        this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
                    }
                    if (this.logger == null) break block5;
                    this.logger.dispose();
                }
                throw throwable;
            }
            this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
        }
        if (this.logger != null) {
            this.logger.dispose();
        }
        return defaultMutableTreeNode;
    }

    public AlgorithmData getScriptParameters(IFramework iFramework) {
        this.experiment = iFramework.getData().getExperiment();
        this.data = iFramework.getData();
        int n = this.experiment.getNumberOfSamples();
        int n2 = this.experiment.getNumberOfGenes();
        COAInitDialog cOAInitDialog = new COAInitDialog((JFrame)iFramework.getFrame(), true);
        cOAInitDialog.setVisible(true);
        if (!cOAInitDialog.isOkPressed()) {
            return null;
        }
        int n3 = cOAInitDialog.getNumNeighbors();
        AlgorithmData algorithmData = new AlgorithmData();
        algorithmData.addParam("numNeighbors", String.valueOf(n3));
        algorithmData.addParam("name", "COA");
        algorithmData.addParam("alg-type", "data-visualization");
        algorithmData.addParam("output-class", "single-output");
        String[] stringArray = new String[]{"Data Visualization"};
        algorithmData.addStringArray("output-nodes", stringArray);
        return algorithmData;
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
            COAGUI.this.logger.append(algorithmEvent.getDescription());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                COAGUI.this.algorithm.abort();
                COAGUI.this.logger.dispose();
            } else if (string.equals(COAGUI.ADD_NEW_3D_CMD)) {
                COAGUI.this.addNew3DNode();
            } else if (string.equals(COAGUI.ADD_NEW_2D_CMD)) {
                COAGUI.this.addNew2DNode();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            COAGUI.this.algorithm.abort();
            COAGUI.this.logger.dispose();
        }
    }
}

