/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.dam;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dam.DAMGUI;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.SampleSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class DAMInitDialog
extends AlgorithmDialog {
    int result = 2;
    boolean skipGeneScreeningStep = false;
    boolean skipCrossValidationStep = false;
    private SampleSelectionPanel sampleSelectionPanel;
    private JPanel assessPanel;
    private JPanel classPanel;
    private JPanel paramPanel;
    private JPanel processPanel;
    private JPanel assessSelectionPanel;
    private JCheckBox geneScreenBox;
    private JCheckBox validationCheckBox;
    private JRadioButton A0button;
    private JRadioButton A1button;
    private JRadioButton A2button;
    private JRadioButton PDAbutton;
    private JRadioButton QDAbutton;
    private JTextField numClassesField;
    private JTextField kValueField;
    private JTextField alphaValueField;
    private ButtonGroup assessSelection;
    private ButtonGroup classSelection;
    private JLabel alphaValueLabel;
    private Listener listener = new Listener();

    public DAMInitDialog(Frame frame, boolean bl) {
        super(frame, "DAM Initialization", bl);
        this.initComponents();
        this.okButton.setText("Next");
        this.sampleSelectionPanel.setButtonText("Classify Genes", "Classify Experiments");
        this.sampleSelectionPanel.setClusterGenesSelected(true);
        this.setActionListeners(this.listener);
        this.pack();
        this.setResizable(false);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBackground(Color.white);
        this.assessPanel = new JPanel();
        this.paramPanel = new JPanel();
        this.assessSelectionPanel = new JPanel();
        this.A0button = new JRadioButton();
        this.A1button = new JRadioButton();
        this.A2button = new JRadioButton();
        this.setBackground(Color.lightGray);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DAMInitDialog.this.closeDialog(windowEvent);
            }
        });
        this.sampleSelectionPanel = new SampleSelectionPanel(Color.white, UIManager.getColor("Label.foreground"), true, "Classification Selection");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        jPanel.add((Component)this.sampleSelectionPanel, gridBagConstraints);
        this.processPanel = new JPanel(new GridBagLayout());
        this.processPanel.setBorder(new TitledBorder(new EtchedBorder(0), "Data Screening", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.processPanel.setBackground(Color.white);
        this.geneScreenBox = new JCheckBox("Enable Data Screening Step (ANOVA)", true);
        this.geneScreenBox.setHorizontalAlignment(0);
        this.geneScreenBox.setFocusPainted(false);
        this.geneScreenBox.setBackground(Color.white);
        this.geneScreenBox.setForeground(UIManager.getColor("Label.foreground"));
        this.geneScreenBox.setActionCommand("screen-data-command");
        this.geneScreenBox.addActionListener(this.listener);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.weightx = 1.0;
        this.processPanel.add((Component)this.geneScreenBox, gridBagConstraints2);
        this.alphaValueLabel = new JLabel("Alpha Value");
        this.alphaValueLabel.setHorizontalAlignment(4);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints2.weightx = 1.0;
        this.processPanel.add((Component)this.alphaValueLabel, gridBagConstraints2);
        this.alphaValueField = new JTextField("0.05", 8);
        this.alphaValueField.setHorizontalAlignment(2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 10, 40);
        gridBagConstraints2.weightx = 1.0;
        this.processPanel.add((Component)this.alphaValueField, gridBagConstraints2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.processPanel, gridBagConstraints);
        this.classSelection = new ButtonGroup();
        this.classPanel = new JPanel();
        this.PDAbutton = new JRadioButton();
        this.QDAbutton = new JRadioButton();
        this.classPanel.setLayout(new GridBagLayout());
        this.classPanel.setBorder(new TitledBorder(new EtchedBorder(0), "Classification Algorithm Selection", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.classPanel.setBackground(Color.white);
        this.PDAbutton.setToolTipText("Polychotomous Discrimination Algorithm");
        this.PDAbutton.setSelected(true);
        this.PDAbutton.setText("PDA");
        this.PDAbutton.setBackground(Color.white);
        this.PDAbutton.setHorizontalAlignment(0);
        this.classSelection.add(this.PDAbutton);
        this.PDAbutton.setForeground(UIManager.getColor("Label.foreground"));
        this.PDAbutton.setFocusPainted(false);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints3.weightx = 1.0;
        this.classPanel.add((Component)this.PDAbutton, gridBagConstraints3);
        this.QDAbutton.setToolTipText("Quadratic Discriminant Analysis Algorithm");
        this.QDAbutton.setText("QDA");
        this.QDAbutton.setBackground(Color.white);
        this.QDAbutton.setForeground(UIManager.getColor("Label.foreground"));
        this.QDAbutton.setHorizontalAlignment(0);
        this.classSelection.add(this.QDAbutton);
        this.QDAbutton.setFocusPainted(false);
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints3.weightx = 1.0;
        this.classPanel.add((Component)this.QDAbutton, gridBagConstraints3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.classPanel, gridBagConstraints);
        this.paramPanel.setLayout(new GridBagLayout());
        this.paramPanel.setBorder(new TitledBorder(new EtchedBorder(0), "DAM Classification Parameters", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.paramPanel.setBackground(Color.white);
        JLabel jLabel = new JLabel("Number of Classes");
        jLabel.setHorizontalAlignment(4);
        this.paramPanel.add(jLabel);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints4.weightx = 1.0;
        this.paramPanel.add((Component)jLabel, gridBagConstraints4);
        this.numClassesField = new JTextField("3", 8);
        this.paramPanel.add(this.numClassesField);
        gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.insets = new Insets(0, 0, 0, 40);
        gridBagConstraints4.weightx = 1.0;
        this.paramPanel.add((Component)this.numClassesField, gridBagConstraints4);
        JLabel jLabel2 = new JLabel("Number Of Components");
        jLabel2.setHorizontalAlignment(4);
        gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints4.weightx = 1.0;
        this.paramPanel.add((Component)jLabel2, gridBagConstraints4);
        this.kValueField = new JTextField("3", 8);
        this.kValueField.setHorizontalAlignment(2);
        gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.insets = new Insets(10, 0, 10, 40);
        gridBagConstraints4.weightx = 1.0;
        this.paramPanel.add((Component)this.kValueField, gridBagConstraints4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.paramPanel, gridBagConstraints);
        this.assessSelection = new ButtonGroup();
        this.assessSelectionPanel.setLayout(new GridBagLayout());
        this.assessSelectionPanel.setBackground(Color.white);
        this.validationCheckBox = new JCheckBox("Enable Validation", false);
        this.validationCheckBox.setOpaque(true);
        this.validationCheckBox.setBackground(Color.white);
        this.validationCheckBox.setFocusPainted(false);
        this.validationCheckBox.setHorizontalAlignment(0);
        this.validationCheckBox.setActionCommand("validation-command");
        this.validationCheckBox.addActionListener(this.listener);
        this.assessSelectionPanel.add((Component)this.validationCheckBox, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        this.A0button.setToolTipText("A0 Assessment Algorithm");
        this.A0button.setSelected(true);
        this.A0button.setEnabled(false);
        this.A0button.setText("A0");
        this.A0button.setBackground(Color.white);
        this.assessSelection.add(this.A0button);
        this.A0button.setForeground(UIManager.getColor("Label.foreground"));
        this.A0button.setFocusPainted(false);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 1;
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.insets = new Insets(0, 40, 10, 0);
        gridBagConstraints5.gridwidth = 1;
        gridBagConstraints5.gridheight = 1;
        gridBagConstraints5.weightx = 1.0;
        this.assessSelectionPanel.add((Component)this.A0button, gridBagConstraints5);
        this.A1button.setToolTipText("A1 Assessment Algorithm");
        this.A1button.setText("A1");
        this.A1button.setEnabled(false);
        this.A1button.setBackground(Color.white);
        this.assessSelection.add(this.A1button);
        this.A1button.setForeground(UIManager.getColor("Label.foreground"));
        this.A1button.setFocusPainted(false);
        gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 1;
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.insets = new Insets(0, 30, 10, 0);
        gridBagConstraints5.gridwidth = 1;
        gridBagConstraints5.gridheight = 1;
        gridBagConstraints5.weightx = 1.0;
        this.assessSelectionPanel.add((Component)this.A1button, gridBagConstraints5);
        this.A2button.setToolTipText("A2 Assessment Algorithm");
        this.A2button.setText("A2");
        this.A2button.setEnabled(false);
        this.A2button.setBackground(Color.white);
        this.assessSelection.add(this.A2button);
        this.A2button.setForeground(UIManager.getColor("Label.foreground"));
        this.A2button.setFocusPainted(false);
        gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 2;
        gridBagConstraints5.gridy = 1;
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.insets = new Insets(0, 30, 10, 0);
        gridBagConstraints5.gridwidth = 1;
        gridBagConstraints5.gridheight = 1;
        gridBagConstraints5.weightx = 1.0;
        this.assessSelectionPanel.add((Component)this.A2button, gridBagConstraints5);
        this.assessPanel.setLayout(new GridBagLayout());
        this.assessPanel.setBorder(new TitledBorder(new EtchedBorder(0), "Validation Selection", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.assessPanel.setBackground(Color.white);
        this.assessSelectionPanel.setBackground(Color.white);
        this.assessSelectionPanel.setForeground(UIManager.getColor("Label.foreground"));
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 0;
        gridBagConstraints6.fill = 1;
        gridBagConstraints6.weightx = 1.0;
        this.assessPanel.add((Component)this.assessSelectionPanel, gridBagConstraints6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.assessPanel, gridBagConstraints);
        this.addContent(jPanel);
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public boolean isEvaluateGenesSelected() {
        return this.sampleSelectionPanel.isClusterGenesSelected();
    }

    public int getAssessmentSelection() {
        if (!this.validationCheckBox.isSelected()) {
            return DAMGUI.A3;
        }
        if (this.A2button.isSelected()) {
            return DAMGUI.A2;
        }
        if (this.A1button.isSelected()) {
            return DAMGUI.A1;
        }
        if (this.A0button.isSelected()) {
            return DAMGUI.A0;
        }
        return DAMGUI.A3;
    }

    public boolean isPDASelected() {
        return this.PDAbutton.isSelected();
    }

    public int getNumClasses() {
        String string = this.numClassesField.getText();
        return Integer.parseInt(string);
    }

    public int getKValue() {
        String string = this.kValueField.getText();
        return Integer.parseInt(string);
    }

    public double getAlphaValue() {
        String string = this.alphaValueField.getText();
        return Double.parseDouble(string);
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public void resetControls() {
        this.geneScreenBox.setSelected(true);
        this.alphaValueLabel.setEnabled(true);
        this.alphaValueField.setEnabled(true);
        this.sampleSelectionPanel.setClusterGenesSelected(true);
        this.validationCheckBox.setSelected(false);
        this.A0button.setEnabled(false);
        this.A1button.setEnabled(false);
        this.A2button.setEnabled(false);
        this.PDAbutton.setSelected(true);
        this.numClassesField.setText("3");
        this.kValueField.setText("3");
        this.alphaValueField.setText("0.05");
        this.skipGeneScreeningStep = false;
        this.skipCrossValidationStep = false;
        this.geneScreenBox.setSelected(true);
    }

    public static void main(String[] stringArray) {
        new DAMInitDialog((Frame)new JFrame(), true).show();
        System.exit(0);
    }

    public boolean getSkipGeneSelectionValue() {
        return !this.geneScreenBox.isSelected();
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                DAMInitDialog.this.result = 0;
                DAMInitDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                DAMInitDialog.this.result = 2;
                DAMInitDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                DAMInitDialog.this.resetControls();
            } else if (string.equals("screen-data-command")) {
                DAMInitDialog.this.alphaValueField.setEnabled(DAMInitDialog.this.geneScreenBox.isSelected());
                DAMInitDialog.this.alphaValueLabel.setEnabled(DAMInitDialog.this.geneScreenBox.isSelected());
            } else if (string.equals("validation-command")) {
                DAMInitDialog.this.A0button.setEnabled(DAMInitDialog.this.validationCheckBox.isSelected());
                DAMInitDialog.this.A1button.setEnabled(DAMInitDialog.this.validationCheckBox.isSelected());
                DAMInitDialog.this.A2button.setEnabled(DAMInitDialog.this.validationCheckBox.isSelected());
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow(DAMInitDialog.this, "DAM Initialization Dialog");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 650);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            DAMInitDialog.this.result = -1;
            DAMInitDialog.this.dispose();
        }
    }
}

