/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.fom;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class FOMGraph
extends JPanel
implements Serializable {
    public static final long serialVersionUID = 202003060001L;
    private float[] values;
    private float[][] iValues;
    private float[] variances;
    private String[] xItems;
    private String[] yItems;
    private String title;
    private String xLabel;
    private String yLabel;
    private Insets insets;
    private boolean isAntiAliasing = false;
    private int maxXItem;
    private int maxYItem;
    private float maxYValue = 1.0f;
    private Color pointColor = Color.red;
    private Color valuesLineColor = Color.blue;
    private Color iterationLineColor = Color.lightGray;
    private Color sdLineColor = Color.darkGray;
    private Color mouseLineColor = Color.magenta;
    private Color gridLineColor = Color.yellow;
    private Color axisLineColor = Color.black;
    private int pointSize = 5;
    private boolean haveIValues;
    private boolean showVariance;
    private boolean showIValues;
    private JPopupMenu menu;
    private JCheckBoxMenuItem menuItem;
    private MouseHandler mouseHandler;

    public FOMGraph(float[] fArray, float[] fArray2, String string, String string2, String string3, boolean bl) {
        if (fArray == null) {
            throw new IllegalArgumentException("values == null");
        }
        this.setBackground(Color.white);
        this.insets = new Insets(60, 60, 60, 60);
        this.showVariance = bl;
        this.values = fArray;
        this.variances = fArray2;
        this.title = string;
        this.xLabel = string2;
        this.yLabel = string3;
        this.mouseHandler = new MouseHandler();
        this.addMouseMotionListener(this.mouseHandler);
        this.addMouseListener(this.mouseHandler);
    }

    public void setItems(String[] stringArray, String[] stringArray2) {
        this.xItems = stringArray;
        this.yItems = stringArray2;
        this.maxXItem = this.getMaxWidth(stringArray);
        this.maxYItem = this.getMaxWidth(stringArray2);
    }

    public void setFOMIterationValues(float[][] fArray) {
        this.iValues = fArray;
        if (this.iValues != null) {
            this.haveIValues = true;
            this.showIValues = false;
            this.createJPopupMenu();
        }
    }

    public void createJPopupMenu() {
        MouseHandler mouseHandler = new MouseHandler();
        this.menuItem = new JCheckBoxMenuItem("Show Iteration Values", false);
        this.menuItem.addActionListener(mouseHandler);
        this.menuItem.setFocusPainted(false);
        this.menu = new JPopupMenu();
        this.menu.add(this.menuItem);
    }

    public void setMaxYValue(float f) {
        this.maxYValue = f;
    }

    public BufferedImage getImage() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 5);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        this.paint(graphics2D);
        return bufferedImage;
    }

    public void setAntiAliasing(boolean bl) {
        this.isAntiAliasing = bl;
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        float f;
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n5 = fontMetrics.getDescent();
        if (this.isAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        Dimension dimension = this.getSize();
        int n6 = this.insets.left + this.maxYItem;
        int n7 = this.insets.top;
        int n8 = dimension.width - n6 - this.insets.right;
        int n9 = dimension.height - this.insets.bottom - n7 - this.maxXItem;
        float f2 = (float)n8 / (float)(this.values.length - 1);
        float f3 = (float)n9 / this.maxYValue;
        int n10 = fontMetrics.stringWidth(this.title);
        graphics2D.drawString(this.title, n6 + (n8 - n10) / 2, (this.insets.top + n5) / 2);
        n10 = fontMetrics.stringWidth(this.xLabel);
        graphics2D.drawString(this.xLabel, n6 + (n8 - n10) / 2, this.insets.top + n9 + this.maxXItem + (this.insets.top + n5) / 2);
        n10 = fontMetrics.stringWidth(this.yLabel);
        graphics2D.rotate(-1.5707963267948966);
        graphics2D.drawString(this.yLabel, -(this.insets.top + (n9 + n10) / 2), (this.insets.left + n5) / 2);
        graphics2D.rotate(1.5707963267948966);
        graphics2D.setColor(this.gridLineColor);
        if (this.yItems != null) {
            f = (float)n9 / (float)(this.yItems.length - 1);
            for (n4 = 0; n4 < this.yItems.length; ++n4) {
                if (this.yItems[this.yItems.length - n4 - 1] == null) continue;
                graphics2D.drawLine(n6, n7 + Math.round((float)n4 * f), n6 + n8, n7 + Math.round((float)n4 * f));
            }
        }
        if (this.xItems != null) {
            f = (float)n8 / (float)(this.xItems.length - 1);
            for (n4 = 0; n4 < this.xItems.length; ++n4) {
                if (this.xItems[n4] == null) continue;
                graphics2D.drawLine(n6 + Math.round((float)n4 * f), n7, n6 + Math.round((float)n4 * f), n7 + n9);
            }
        }
        graphics2D.setColor(this.axisLineColor);
        graphics2D.drawLine(n6, n7, n6, n7 + n9);
        if (this.yItems != null) {
            f = (float)n9 / (float)(this.yItems.length - 1);
            for (n4 = 0; n4 < this.yItems.length; ++n4) {
                graphics2D.drawLine(n6 - 5, n7 + Math.round((float)n4 * f), n6 + 5, n7 + Math.round((float)n4 * f));
                if (this.yItems[this.yItems.length - n4 - 1] == null) continue;
                graphics2D.drawString(this.yItems[this.yItems.length - n4 - 1], n6 - 7 - fontMetrics.stringWidth(this.yItems[this.yItems.length - n4 - 1]), n7 + Math.round((float)n4 * f) + n5);
            }
        }
        if (this.xItems != null) {
            f = (float)n8 / (float)(this.xItems.length - 1);
            for (n4 = 0; n4 < this.xItems.length; ++n4) {
                graphics2D.drawLine(n6 + Math.round((float)n4 * f), n7 + n9 - 5, n6 + Math.round((float)n4 * f), n7 + n9 + 5);
            }
            graphics2D.rotate(-1.5707963267948966);
            n4 = n7 + n9 + 7;
            for (n3 = 0; n3 < this.xItems.length; ++n3) {
                if (this.xItems[n3] == null) continue;
                graphics2D.drawString(this.xItems[n3], -(n4 + fontMetrics.stringWidth(this.xItems[n3])), n6 + Math.round((float)n3 * f) + n5);
            }
            graphics2D.rotate(1.5707963267948966);
        }
        graphics2D.drawLine(n6, n7 + n9, n6 + n8, n7 + n9);
        graphics2D.setColor(this.valuesLineColor);
        if (this.showIValues) {
            graphics2D.setColor(this.iterationLineColor);
            for (n2 = 0; n2 < this.iValues.length; ++n2) {
                for (int i = 0; i < this.iValues[n2].length - 1; ++i) {
                    int n11 = n6 + Math.round((float)i * f2);
                    n4 = n7 + n9 - Math.round(this.iValues[n2][i] * f3);
                    n3 = n6 + Math.round((float)(i + 1) * f2);
                    n = n7 + n9 - Math.round(this.iValues[n2][i + 1] * f3);
                    graphics2D.drawLine(n11, n4, n3, n);
                }
            }
        }
        for (n2 = 0; n2 < this.values.length - 1; ++n2) {
            graphics2D.setColor(this.valuesLineColor);
            int n12 = n6 + Math.round((float)n2 * f2);
            n4 = n7 + n9 - Math.round(this.values[n2] * f3);
            n3 = n6 + Math.round((float)(n2 + 1) * f2);
            n = n7 + n9 - Math.round(this.values[n2 + 1] * f3);
            graphics2D.drawLine(n12, n4, n3, n);
            graphics2D.drawLine(n12, n4 - 1, n3, n - 1);
            if (!this.showVariance) continue;
            graphics2D.setColor(this.sdLineColor);
            int n13 = n3;
            int n14 = n;
            n12 = n6 + Math.round((float)(n2 + 1) * f2) - 3;
            n4 = n7 + n9 - Math.round((this.values[n2 + 1] + this.variances[n2 + 1]) * f3);
            n = n7 + n9 - Math.round((this.values[n2 + 1] - this.variances[n2 + 1]) * f3);
            graphics2D.drawLine(n12, n4, n3 += 3, n4);
            graphics2D.drawLine(n12, n, n3, n);
            graphics2D.drawLine(n13, n14, n13, n4);
            graphics2D.drawLine(n13, n14, n13, n);
        }
        graphics2D.setColor(this.pointColor);
        for (n2 = 0; n2 < this.values.length; ++n2) {
            graphics2D.fillOval(n6 + Math.round((float)n2 * f2) - this.pointSize / 2, n7 + n9 - Math.round(this.values[n2] * f3) - this.pointSize / 2, this.pointSize, this.pointSize);
        }
        this.mouseHandler.validate();
    }

    private int getMaxWidth(String[] stringArray) {
        if (stringArray == null) {
            return 0;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            n = Math.max(n, fontMetrics.stringWidth(stringArray[i]));
        }
        return n;
    }

    private void drawMouseCross(int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        graphics2D.setColor(this.mouseLineColor);
        graphics2D.setXORMode(this.getBackground());
        Dimension dimension = this.getSize();
        int n3 = this.insets.left + this.maxYItem;
        int n4 = dimension.width - this.insets.right;
        int n5 = this.insets.top;
        int n6 = dimension.height - this.insets.bottom - this.maxXItem;
        graphics2D.drawLine(n, n5, n, n6);
        graphics2D.drawLine(n3, n2, n4, n2);
        graphics2D.setPaintMode();
        graphics2D.dispose();
    }

    private class MouseHandler
    extends MouseMotionAdapter
    implements ActionListener,
    MouseListener,
    Serializable {
        private Point prevCoords = new Point(-1, -1);

        private MouseHandler() {
        }

        public void validate() {
            if (this.isCoordsValid(this.prevCoords.x, this.prevCoords.y)) {
                FOMGraph.this.drawMouseCross(this.prevCoords.x, this.prevCoords.y);
            }
            this.prevCoords.setLocation(-1, -1);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (this.isCoordsValid(this.prevCoords.x, this.prevCoords.y)) {
                FOMGraph.this.drawMouseCross(this.prevCoords.x, this.prevCoords.y);
            }
            if (this.isCoordsValid(n, n2)) {
                FOMGraph.this.drawMouseCross(n, n2);
            }
            this.prevCoords.setLocation(n, n2);
        }

        private boolean isCoordsValid(int n, int n2) {
            Dimension dimension = FOMGraph.this.getSize();
            int n3 = ((FOMGraph)FOMGraph.this).insets.left + FOMGraph.this.maxYItem;
            int n4 = ((FOMGraph)FOMGraph.this).insets.top;
            int n5 = dimension.width - ((FOMGraph)FOMGraph.this).insets.right;
            int n6 = dimension.height - ((FOMGraph)FOMGraph.this).insets.bottom - FOMGraph.this.maxXItem;
            return n3 < n && n < n5 && n4 < n2 && n2 < n6;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (FOMGraph.this.menu != null && mouseEvent.isPopupTrigger()) {
                FOMGraph.this.menu.show(FOMGraph.this, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (FOMGraph.this.menu != null && mouseEvent.isPopupTrigger()) {
                FOMGraph.this.menu.show(FOMGraph.this, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (FOMGraph.this.menuItem.isSelected()) {
                FOMGraph.this.showIValues = true;
                FOMGraph.this.repaint();
            } else {
                FOMGraph.this.showIValues = false;
                FOMGraph.this.repaint();
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

