/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.util.FloatMatrix;
import org.tigr.util.awt.ActionInfoDialog;
import org.tigr.util.awt.GBA;

public class GDMExpSpotInfoDisplay
extends ActionInfoDialog {
    private int col;
    private int row;
    private FloatMatrix expDistMatrix;
    private FloatMatrix rawMatrix;
    private int LINEAR = 0;
    private int LOG = 1;
    private String distanceMetric;
    private int vectorSize = 0;
    private int rowMissingValues = 0;
    private int colMissingValues = 0;
    private int distanceBasedOn = 0;
    private IData expData;
    private Experiment experiment;
    private Color rowExperimentColor;
    private Color colExperimentColor;
    public static Color zeroColor = Color.black;
    public static Color NaNColor = Color.gray;
    public static Color diagColor = Color.white;
    private boolean haveColor = true;

    public GDMExpSpotInfoDisplay(JFrame jFrame, IData iData, FloatMatrix floatMatrix, FloatMatrix floatMatrix2, String string, int n, int n2) {
        super(jFrame, true);
        this.expData = iData;
        this.experiment = iData.getExperiment();
        this.expDistMatrix = floatMatrix;
        this.rawMatrix = floatMatrix2;
        this.col = n;
        this.row = n2;
        this.distanceMetric = string;
        this.vectorSize = this.expData.getFeaturesSize();
        this.colExperimentColor = iData.getExperimentColor(n);
        this.rowExperimentColor = iData.getExperimentColor(n2);
        if (this.colExperimentColor == null && this.rowExperimentColor == null) {
            this.haveColor = false;
        } else {
            if (this.rowExperimentColor == null) {
                this.rowExperimentColor = new Color(Integer.parseInt("FFFFCC", 16));
            }
            if (this.colExperimentColor == null) {
                this.colExperimentColor = new Color(Integer.parseInt("FFFFCC", 16));
            }
        }
        this.setValues(n, n2);
        this.init();
    }

    private void init() {
        Font font = new Font("monospaced", 0, 10);
        JLabel jLabel = new JLabel(GUIFactory.getIcon("spot.gif"));
        EventListener eventListener = new EventListener();
        JTextPane jTextPane = new JTextPane();
        jTextPane.setContentType("text/html");
        jTextPane.setFont(font);
        jTextPane.setEditable(false);
        jTextPane.setBackground(new Color(Integer.parseInt("FFFFCC", 16)));
        jTextPane.setMargin(new Insets(10, 15, 10, 10));
        jTextPane.setText(this.createMessage());
        jTextPane.setCaretPosition(0);
        jTextPane.addKeyListener(eventListener);
        JButton jButton = new JButton("Close");
        jButton.setActionCommand("close");
        jButton.addActionListener(eventListener);
        this.contentPane.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(jTextPane, 20, 30);
        jScrollPane.getViewport().setBackground(Color.white);
        jScrollPane.getViewport().setScrollMode(0);
        jScrollPane.getVerticalScrollBar().setValues(10, 10, 0, 100);
        GBA gBA = new GBA();
        gBA.add(this.contentPane, (Component)jScrollPane, 0, 0, 3, 2, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(this.contentPane, (Component)jButton, 0, 3, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(this.contentPane, (Component)jLabel, 2, 3, 1, 1, 0, 0, 0, 13, new Insets(5, 5, 5, 5), 0, 0);
        this.pack();
        this.setSize(500, 500);
        this.setResizable(true);
        this.setTitle("Sample Distance Spot Information");
        this.setLocation(300, 100);
        this.show();
    }

    private String createMessage() {
        boolean bl = false;
        String string = this.expData.getSampleName(this.row);
        String string2 = this.expData.getSampleName(this.col);
        int n = this.row + 1;
        int n2 = this.col + 1;
        String string3 = "";
        String string4 = "";
        if (this.haveColor) {
            string3 = '#' + Integer.toHexString(this.colExperimentColor.getRGB()).substring(2, 8);
            string4 = '#' + Integer.toHexString(this.rowExperimentColor.getRGB()).substring(2, 8);
        }
        String string5 = "<h3>Experiment Information</h3><table border=2 cellpadding=4 valign=top ><tr><td valign=top></td><td  valign=top><b>Column Experiment</b></td><td  valign=top><b>Row Experiment</b></td></tr><tr><td  valign=top><b>Name</b></td><td  valign=top>" + string2 + "</td><td  valign=top>" + string + "</td></tr>";
        if (this.haveColor) {
            string5 = string5 + "<tr><td  valign=top><b>Experiment Color</b></td><td   valign=top bgcolor=" + string3 + "></td><td  valign=top bgcolor=" + string4 + "></td></tr>";
        }
        string5 = string5 + "</table><h3>Experiment Distance</h3><table border=2 cellpadding=4 valign=top ><tr><td  valign=top><b>GDM Matrix Row </b></td><td width=34% valign=top>" + n + "</td></tr>" + "<tr><td  valign=top><b>GDM Matrix Column </b></td><td width=34% valign=top>" + n2 + "</td></tr>" + "<tr><td  valign=top><b>Scaled Experiment Distance</b></td><td width=34% valign=top>" + this.expDistMatrix.get(this.col, this.row) + "</td></tr>" + "<tr><td  valign=top><b>Actual Experiment Distance</b></td><td width=34% valign=top>" + this.rawMatrix.get(this.col, this.row) + "</td></tr>" + "<tr><td  valign=top><b>Distance Metric</b></td><td width=34% valign=top>" + this.distanceMetric + "</td></tr>" + "<tr><td  valign=top><b>Vector Size</b></td><td width=34% valign=top>" + this.vectorSize + "</td></tr>" + "<tr><td  valign=top><b>Missing Values</b></td><td  valign=top>" + this.colMissingValues + ", " + this.rowMissingValues + "</td></tr>" + "<tr><td  valign=top><b>Distance Based on</b></td><td width=34% valign=top>" + this.distanceBasedOn + "</td></tr>";
        return string5;
    }

    private void setValues(int n, int n2) {
        float f;
        int n3;
        int n4 = this.expData.getFeaturesSize();
        boolean[] blArray = new boolean[n4];
        boolean[] blArray2 = new boolean[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            blArray[n3] = false;
            blArray2[n3] = false;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            f = this.experiment.get(n3, n2);
            if (!Float.isNaN(f)) continue;
            blArray[n3] = true;
            ++this.rowMissingValues;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            f = this.experiment.get(n3, n);
            if (!Float.isNaN(f)) continue;
            blArray2[n3] = true;
            ++this.colMissingValues;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (blArray[n3] || blArray2[n3] || n2 == n) continue;
            ++this.distanceBasedOn;
        }
    }

    private void drawExperimentColor() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            graphics.setColor(this.rowExperimentColor);
            graphics.fillRect(0, 0, 10, 10);
            graphics.setColor(this.colExperimentColor);
            graphics.fillRect(20, 0, 10, 10);
        }
    }

    class EventListener
    implements ActionListener,
    KeyListener {
        EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("close")) {
                GDMExpSpotInfoDisplay.this.dispose();
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                GDMExpSpotInfoDisplay.this.dispose();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

