/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gdm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class GDMInitDialog
extends AlgorithmDialog {
    private int result;
    private JRadioButton genRadio;
    private JRadioButton expRadio;
    private JTextField textField;
    private JLabel displayLabel;

    public GDMInitDialog(Frame frame, boolean bl) {
        super(frame, "Gene Distance Matrix Initialization", true);
        Listener listener = new Listener();
        this.addWindowListener(listener);
        ParameterPanel parameterPanel = new ParameterPanel();
        parameterPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.genRadio = new JRadioButton("Genes");
        this.genRadio.setBackground(Color.white);
        this.genRadio.setFocusPainted(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        parameterPanel.add((Component)this.genRadio, gridBagConstraints);
        this.expRadio = new JRadioButton("Samples");
        this.expRadio.setBackground(Color.white);
        this.expRadio.setFocusPainted(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        parameterPanel.add((Component)this.expRadio, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.genRadio);
        buttonGroup.add(this.expRadio);
        this.genRadio.setActionCommand("gene-radio-command");
        this.genRadio.addActionListener(listener);
        this.expRadio.setActionCommand("gene-radio-command");
        this.expRadio.addActionListener(listener);
        this.genRadio.setEnabled(bl);
        this.genRadio.setSelected(bl);
        this.expRadio.setEnabled(!bl);
        this.expRadio.setSelected(!bl);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        this.displayLabel = new JLabel("  Display Interval  ");
        parameterPanel.add((Component)this.displayLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        this.textField = new JTextField(String.valueOf(1), 7);
        parameterPanel.add((Component)this.textField, gridBagConstraints);
        this.addContent(parameterPanel);
        this.setActionListeners(listener);
        this.pack();
    }

    public GDMInitDialog(Frame frame) {
        super(frame, "Gene Distance Matrix Initialization", true);
        Listener listener = new Listener();
        this.addWindowListener(listener);
        ParameterPanel parameterPanel = new ParameterPanel();
        parameterPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.genRadio = new JRadioButton("Genes");
        this.genRadio.setBackground(Color.white);
        this.genRadio.setFocusPainted(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 0, 25, 20);
        parameterPanel.add((Component)this.genRadio, gridBagConstraints);
        this.expRadio = new JRadioButton("Samples");
        this.expRadio.setBackground(Color.white);
        this.expRadio.setFocusPainted(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 20, 25, 0);
        parameterPanel.add((Component)this.expRadio, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.genRadio);
        buttonGroup.add(this.expRadio);
        this.genRadio.setSelected(true);
        this.genRadio.setActionCommand("gene-radio-command");
        this.genRadio.addActionListener(listener);
        this.expRadio.setActionCommand("gene-radio-command");
        this.expRadio.addActionListener(listener);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        this.displayLabel = new JLabel("  Display Interval  ");
        parameterPanel.add((Component)this.displayLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        this.textField = new JTextField(String.valueOf(1), 7);
        parameterPanel.add((Component)this.textField, gridBagConstraints);
        this.addContent(parameterPanel);
        this.setActionListeners(listener);
        this.pack();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public boolean isUseGenes() {
        return this.genRadio.isSelected();
    }

    public void setGeneSelected(boolean bl) {
        this.genRadio.setSelected(bl);
    }

    public void setExpSelected(boolean bl) {
        this.expRadio.setSelected(bl);
    }

    public int getDisplayInterval() {
        return Integer.parseInt(this.textField.getText());
    }

    public static void main(String[] stringArray) {
        GDMInitDialog gDMInitDialog = new GDMInitDialog(new Frame());
        gDMInitDialog.setDefaultCloseOperation(2);
        gDMInitDialog.showModal();
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("gene-radio-command")) {
                GDMInitDialog.this.displayLabel.setEnabled(GDMInitDialog.this.genRadio.isSelected());
                GDMInitDialog.this.textField.setEnabled(GDMInitDialog.this.genRadio.isSelected());
            } else if (string.equals("ok-command")) {
                try {
                    Integer.parseInt(GDMInitDialog.this.textField.getText());
                    GDMInitDialog.this.result = 0;
                }
                catch (Exception exception) {
                    GDMInitDialog.this.result = 2;
                }
                GDMInitDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                GDMInitDialog.this.result = 2;
                GDMInitDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                if (GDMInitDialog.this.genRadio.isEnabled() && GDMInitDialog.this.expRadio.isEnabled()) {
                    GDMInitDialog.this.genRadio.setSelected(true);
                }
                GDMInitDialog.this.textField.setText("1");
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow(GDMInitDialog.this, "GDM Initialization Dialog");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 650);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            GDMInitDialog.this.result = -1;
            GDMInitDialog.this.dispose();
        }
    }
}

