/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.kmc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DistanceMetricPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.SampleSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class KMCInitDialog
extends AlgorithmDialog {
    private int result;
    private int k;
    private int iter;
    private JTextField textField1;
    private JTextField textField2;
    private JRadioButton calcMeans;
    private JRadioButton calcMedians;
    private ButtonGroup meanMedianGroup;
    private SampleSelectionPanel sampleSelectionPanel;
    private HCLSelectionPanel hclPanel;
    private DistanceMetricPanel metricPanel;

    public KMCInitDialog(JFrame jFrame, int n, int n2, String string, boolean bl) {
        super(jFrame, "KMC: K-Means/K-Medians", true);
        this.k = n;
        this.iter = n2;
        Listener listener = new Listener();
        this.addWindowListener(listener);
        this.sampleSelectionPanel = new SampleSelectionPanel(Color.white, UIManager.getColor("Label.foreground"), true, "Sample Selection");
        this.metricPanel = new DistanceMetricPanel(string, bl, "Euclidean Distance", "KMC", true, true);
        this.meanMedianGroup = new ButtonGroup();
        this.calcMeans = new JRadioButton("Calculate K-Means", true);
        this.calcMeans.setFocusPainted(false);
        this.calcMeans.setBackground(Color.white);
        this.calcMeans.setForeground(UIManager.getColor("Label.foreground"));
        this.calcMedians = new JRadioButton("Calculate K-Medians", false);
        this.calcMedians.setFocusPainted(false);
        this.calcMedians.setBackground(Color.white);
        this.calcMedians.setForeground(UIManager.getColor("Label.foreground"));
        this.meanMedianGroup.add(this.calcMeans);
        this.meanMedianGroup.add(this.calcMedians);
        ParameterPanel parameterPanel = new ParameterPanel();
        parameterPanel.setLayout(new GridBagLayout());
        parameterPanel.add((Component)this.calcMeans, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 10), 0, 0));
        parameterPanel.add((Component)this.calcMedians, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 0, 0), 0, 0));
        parameterPanel.add((Component)new JLabel("Number of clusters"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        parameterPanel.add((Component)new JLabel("Maximum iterations"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        this.textField1 = new JTextField(String.valueOf(n), 7);
        this.textField2 = new JTextField(String.valueOf(n2), 7);
        parameterPanel.add((Component)this.textField1, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(10, 10, 0, 0), 0, 0));
        parameterPanel.add((Component)this.textField2, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 3, new Insets(5, 10, 5, 0), 0, 0));
        this.hclPanel = new HCLSelectionPanel();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        jPanel.add((Component)this.sampleSelectionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.metricPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)parameterPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.hclPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setForeground(Color.white);
        jPanel2.setBorder(BorderFactory.createLineBorder(Color.gray));
        jPanel2.setBackground(Color.white);
        jPanel2.add((Component)jPanel, "Center");
        this.addContent(jPanel2);
        this.okButton.addActionListener(listener);
        this.cancelButton.addActionListener(listener);
        this.resetButton.addActionListener(listener);
        this.infoButton.addActionListener(listener);
        this.validate();
        this.setSize(420, 410);
        this.setResizable(false);
        this.pack();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public int getClusters() {
        return Integer.parseInt(this.textField1.getText());
    }

    public int getIterations() {
        return Integer.parseInt(this.textField2.getText());
    }

    public boolean isHierarchicalTree() {
        return this.hclPanel.isHCLSelected();
    }

    public boolean calculateMeans() {
        return this.calcMeans.isSelected();
    }

    public boolean isClusterGenesSelected() {
        return this.sampleSelectionPanel.isClusterGenesSelected();
    }

    private void onReset() {
        this.textField1.setText(String.valueOf(this.k));
        this.textField2.setText(String.valueOf(this.iter));
        this.sampleSelectionPanel.setClusterGenesSelected(true);
        this.hclPanel.setHCLSelected(false);
        this.calcMeans.setSelected(true);
        this.metricPanel.reset();
    }

    public int getDistanceMetric() {
        return this.metricPanel.getMetricIndex();
    }

    public boolean isAbsoluteDistance() {
        return this.metricPanel.getAbsoluteSelection();
    }

    public static void main(String[] stringArray) {
        KMCInitDialog kMCInitDialog = new KMCInitDialog(new JFrame(), 10, 50, "Pearson Correlation", true);
        kMCInitDialog.showModal();
        System.exit(0);
    }

    protected void disposeDialog() {
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == KMCInitDialog.this.okButton) {
                try {
                    int n = Integer.parseInt(KMCInitDialog.this.textField1.getText());
                    if (n < 1) {
                        KMCInitDialog.this.textField1.requestFocus();
                        KMCInitDialog.this.textField1.selectAll();
                        JOptionPane.showMessageDialog(KMCInitDialog.this, "Number of clusters must be greater than 0!", "Error", 0);
                        return;
                    }
                    int n2 = Integer.parseInt(KMCInitDialog.this.textField2.getText());
                    if (n2 < 1) {
                        KMCInitDialog.this.textField2.requestFocus();
                        KMCInitDialog.this.textField2.selectAll();
                        JOptionPane.showMessageDialog(KMCInitDialog.this, "Number of iterations must be greater than 0!", "Error", 0);
                        return;
                    }
                    KMCInitDialog.this.result = 0;
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(KMCInitDialog.this, "Entry format error.", "Error", 0);
                    KMCInitDialog.this.result = 2;
                    return;
                }
                KMCInitDialog.this.dispose();
            } else if (object == KMCInitDialog.this.cancelButton) {
                KMCInitDialog.this.result = 2;
                KMCInitDialog.this.dispose();
            } else if (object == KMCInitDialog.this.resetButton) {
                KMCInitDialog.this.onReset();
            } else if (object == KMCInitDialog.this.infoButton) {
                HelpWindow helpWindow = new HelpWindow(KMCInitDialog.this, "KMC Initialization Dialog");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 650);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            KMCInitDialog.this.result = -1;
            KMCInitDialog.this.dispose();
        }
    }
}

