/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.knnc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;

public class KNNCInfoViewer
extends ViewerAdapter
implements Serializable {
    public static final long serialVersionUID = 202009010001L;
    private JComponent header = this.createHeader();
    private JTextArea content;
    private boolean clusterGenes;
    private int numClasses;

    public KNNCInfoViewer(int[][] nArray, int n, int n2) {
        this.clusterGenes = true;
        this.numClasses = n2;
        this.content = this.createContent(nArray, n);
        this.setMaxWidth(this.content, this.header);
    }

    public KNNCInfoViewer(int[][] nArray, int n, boolean bl, int n2) {
        this.clusterGenes = bl;
        this.numClasses = n2;
        this.content = this.createContent(nArray, n);
        this.setMaxWidth(this.content, this.header);
    }

    public JComponent getContentComponent() {
        return this.content;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JComponent createHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        jPanel.add((Component)new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Cluster Information</b></font></body></html>"), gridBagConstraints);
        return jPanel;
    }

    private JTextArea createContent(int[][] nArray, int n) {
        JTextArea jTextArea = new JTextArea(nArray.length * 3, 20);
        jTextArea.setEditable(false);
        jTextArea.setMargin(new Insets(0, 10, 0, 0));
        StringBuffer stringBuffer = new StringBuffer(nArray.length * 3 * 10);
        if (this.clusterGenes) {
            for (int i = 2 * this.numClasses; i < 3 * this.numClasses; ++i) {
                stringBuffer.append("Class " + (i + 1 - 2 * this.numClasses));
                stringBuffer.append("\t");
                stringBuffer.append("# of Genes in Class: " + nArray[i].length);
                stringBuffer.append("\n\t");
                stringBuffer.append("% of Genes in Class: " + Math.round((float)nArray[i].length / (float)n * 100.0f) + "%");
                stringBuffer.append("\n\n");
            }
            stringBuffer.append("Unclassified ");
            stringBuffer.append("\t");
            stringBuffer.append("# of Unclassified Genes : " + nArray[4 * this.numClasses].length);
            stringBuffer.append("\n\t");
            stringBuffer.append("% of Genes that are Unclassified: " + Math.round((float)nArray[4 * this.numClasses].length / (float)n * 100.0f) + "%");
            stringBuffer.append("\n\n");
        } else {
            for (int i = 2 * this.numClasses; i < 3 * this.numClasses; ++i) {
                stringBuffer.append("Class " + (i + 1 - 2 * this.numClasses));
                stringBuffer.append("\t");
                stringBuffer.append("# of Experiments in Class: " + nArray[i].length);
                stringBuffer.append("\n\t");
                stringBuffer.append("% of Experiments in Class: " + Math.round((float)nArray[i].length / (float)n * 100.0f) + "%");
                stringBuffer.append("\n\n");
            }
            stringBuffer.append("Unclassified ");
            stringBuffer.append("\t");
            stringBuffer.append("# of Unclassified Experiments : " + nArray[4 * this.numClasses].length);
            stringBuffer.append("\n\t");
            stringBuffer.append("% of Experiments that are Unclassified: " + Math.round((float)nArray[4 * this.numClasses].length / (float)n * 100.0f) + "%");
            stringBuffer.append("\n\n");
        }
        jTextArea.setText(stringBuffer.toString());
        jTextArea.setCaretPosition(0);
        return jTextArea;
    }

    private void setMaxWidth(JComponent jComponent, JComponent jComponent2) {
        int n = jComponent.getPreferredSize().width;
        int n2 = jComponent2.getPreferredSize().width;
        if (n > n2) {
            jComponent2.setPreferredSize(new Dimension(n, jComponent2.getPreferredSize().height));
        } else {
            jComponent.setPreferredSize(new Dimension(n2, jComponent.getPreferredSize().height));
        }
    }
}

