/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ptm;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;
import org.tigr.util.QSort;

public class PTMExpStatsTableViewer
extends ViewerAdapter
implements Serializable {
    public static final long serialVersionUID = 202012020001L;
    private JComponent header;
    private JComponent content;
    private Experiment experiment;
    private int[][] expClusters;
    private boolean sig;
    private int[] cols;
    private JTable pAndRValuesTable;
    private PAndRValuesTableModel pAndRModel;
    private String[] auxTitles;
    private Object[][] auxData;
    private IData data;
    private JPopupMenu popup;
    private Object[][] origData;
    private boolean[] sortedAscending;

    public PTMExpStatsTableViewer(Experiment experiment, int[][] nArray, IData iData, String[] stringArray, Object[][] objectArray, boolean bl) {
        int n;
        int n2;
        this.experiment = experiment;
        this.expClusters = nArray;
        this.data = iData;
        this.auxTitles = stringArray;
        this.auxData = objectArray;
        this.sig = bl;
        this.cols = bl ? nArray[0] : nArray[1];
        this.pAndRModel = new PAndRValuesTableModel();
        this.pAndRValuesTable = new JTable(this.pAndRModel);
        this.origData = new Object[this.pAndRModel.getRowCount()][this.pAndRModel.getColumnCount()];
        for (n2 = 0; n2 < this.origData.length; ++n2) {
            for (n = 0; n < this.origData[n2].length; ++n) {
                this.origData[n2][n] = this.pAndRModel.getValueAt(n2, n);
            }
        }
        this.sortedAscending = new boolean[this.pAndRModel.getColumnCount()];
        for (n2 = 0; n2 < this.sortedAscending.length; ++n2) {
            this.sortedAscending[n2] = false;
        }
        TableColumn tableColumn = null;
        for (n = 0; n < this.pAndRModel.getColumnCount(); ++n) {
            tableColumn = this.pAndRValuesTable.getColumnModel().getColumn(n);
            tableColumn.setMinWidth(30);
        }
        this.addMouseListenerToHeaderInTable(this.pAndRValuesTable);
        this.header = this.pAndRValuesTable.getTableHeader();
        this.setMaxWidth(this.getContentComponent(), this.getHeaderComponent());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.experiment);
        objectOutputStream.writeObject(this.expClusters);
        objectOutputStream.writeObject(this.auxData);
        objectOutputStream.writeObject(this.auxTitles);
        objectOutputStream.writeObject(this.cols);
        objectOutputStream.writeObject(this.pAndRModel);
        objectOutputStream.writeObject(this.origData);
        objectOutputStream.writeObject(this.pAndRValuesTable);
        objectOutputStream.writeObject(this.header);
        objectOutputStream.writeObject(this.sortedAscending);
        objectOutputStream.writeBoolean(this.sig);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.experiment = (Experiment)objectInputStream.readObject();
        this.expClusters = (int[][])objectInputStream.readObject();
        this.auxData = (Object[][])objectInputStream.readObject();
        this.auxTitles = (String[])objectInputStream.readObject();
        this.cols = (int[])objectInputStream.readObject();
        this.pAndRModel = (PAndRValuesTableModel)objectInputStream.readObject();
        this.origData = (Object[][])objectInputStream.readObject();
        this.pAndRValuesTable = (JTable)objectInputStream.readObject();
        this.header = (JComponent)objectInputStream.readObject();
        this.sortedAscending = (boolean[])objectInputStream.readObject();
        this.sig = objectInputStream.readBoolean();
        this.addMouseListenerToHeaderInTable(this.pAndRValuesTable);
        this.header = this.header = this.pAndRValuesTable.getTableHeader();
    }

    public JComponent getContentComponent() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 100);
        gridBagLayout.setConstraints(this.pAndRValuesTable, gridBagConstraints);
        jPanel.add(this.pAndRValuesTable);
        final JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File("Data"));
        jFileChooser.setDialogTitle("Save p and R values");
        this.popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Save p and R values", GUIFactory.getIcon("save16.gif"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = jFileChooser.showSaveDialog(PTMExpStatsTableViewer.this.getHeaderComponent());
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    try {
                        int n2;
                        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                        printWriter.print("Sample\t");
                        for (n2 = 0; n2 < PTMExpStatsTableViewer.this.auxTitles.length; ++n2) {
                            printWriter.print(PTMExpStatsTableViewer.this.auxTitles[n2]);
                            if (n2 >= PTMExpStatsTableViewer.this.auxTitles.length - 1) continue;
                            printWriter.print("\t");
                        }
                        printWriter.println();
                        for (n2 = 0; n2 < PTMExpStatsTableViewer.this.cols.length; ++n2) {
                            printWriter.print(PTMExpStatsTableViewer.this.data.getFullSampleName(PTMExpStatsTableViewer.this.experiment.getSampleIndex(PTMExpStatsTableViewer.this.cols[n2])));
                            for (int i = 0; i < PTMExpStatsTableViewer.this.auxData[PTMExpStatsTableViewer.this.cols[n2]].length; ++i) {
                                printWriter.print("\t" + ((Float)PTMExpStatsTableViewer.this.auxData[PTMExpStatsTableViewer.this.cols[n2]][i]).floatValue());
                            }
                            printWriter.print("\n");
                        }
                        printWriter.println();
                        printWriter.flush();
                        printWriter.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        this.popup.add(jMenuItem);
        this.pAndRValuesTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    PTMExpStatsTableViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        return jPanel;
    }

    public JComponent getHeaderComponent() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 100);
        gridBagLayout.setConstraints(this.header, gridBagConstraints);
        jPanel.add(this.header);
        return jPanel;
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    private void setMaxWidth(JComponent jComponent, JComponent jComponent2) {
        int n = jComponent.getPreferredSize().width;
        int n2 = jComponent2.getPreferredSize().width;
        if (n > n2) {
            jComponent2.setPreferredSize(new Dimension(n, jComponent2.getPreferredSize().height));
        } else {
            jComponent.setPreferredSize(new Dimension(n2, jComponent.getPreferredSize().height));
        }
    }

    public void addMouseListenerToHeaderInTable(JTable jTable) {
        final JTable jTable2 = jTable;
        jTable2.setColumnSelectionAllowed(false);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = jTable2.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = jTable2.convertColumnIndexToModel(n);
                if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                    int n3 = mouseEvent.getModifiers() & 1;
                    int n4 = mouseEvent.getModifiers() & 2;
                    boolean bl = n4 != 0;
                    PTMExpStatsTableViewer.this.sortByColumn(n2, !PTMExpStatsTableViewer.this.sortedAscending[n2], bl);
                    boolean bl2 = ((PTMExpStatsTableViewer)PTMExpStatsTableViewer.this).sortedAscending[n2] = !PTMExpStatsTableViewer.this.sortedAscending[n2];
                    if (bl) {
                        for (int i = 0; i < PTMExpStatsTableViewer.this.pAndRModel.getColumnCount(); ++i) {
                            ((PTMExpStatsTableViewer)PTMExpStatsTableViewer.this).sortedAscending[i] = false;
                        }
                    }
                }
            }
        };
        JTableHeader jTableHeader = jTable2.getTableHeader();
        jTableHeader.addMouseListener(mouseAdapter);
    }

    public void sortByColumn(int n, boolean bl, boolean bl2) {
        int n2;
        int n3;
        int n4;
        if (bl2) {
            for (int i = 0; i < this.pAndRModel.getRowCount(); ++i) {
                for (int j = 0; j < this.pAndRModel.getColumnCount(); ++j) {
                    this.pAndRModel.setValueAt(this.origData[i][j], i, j);
                }
            }
            return;
        }
        Object[][] objectArray = new Object[this.pAndRValuesTable.getRowCount()][this.pAndRValuesTable.getColumnCount()];
        float[] fArray = new float[this.cols.length];
        Object[] objectArray2 = new SortableField[this.cols.length];
        if (n == 0) {
            for (n4 = 0; n4 < objectArray2.length; ++n4) {
                objectArray2[n4] = new SortableField(n4, n);
            }
            Arrays.sort(objectArray2);
        } else {
            for (n4 = 0; n4 < fArray.length; ++n4) {
                fArray[n4] = ((Float)this.auxData[this.cols[n4]][n - 1]).floatValue();
            }
        }
        int[] nArray = new int[this.cols.length];
        if (n > 0) {
            QSort qSort = new QSort(fArray);
            nArray = qSort.getOrigIndx();
        } else if (n == 0) {
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = ((SortableField)objectArray2[i]).getIndex();
            }
        }
        if (!bl) {
            nArray = this.reverse(nArray);
        }
        for (n3 = 0; n3 < objectArray.length; ++n3) {
            for (n2 = 0; n2 < objectArray[n3].length; ++n2) {
                objectArray[n3][n2] = this.origData[nArray[n3]][n2];
            }
        }
        for (n3 = 0; n3 < objectArray.length; ++n3) {
            for (n2 = 0; n2 < objectArray[n3].length; ++n2) {
                this.pAndRModel.setValueAt(objectArray[n3][n2], n3, n2);
            }
        }
    }

    private int[] reverse(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        int n2 = nArray.length - 1;
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[n] = nArray[n2];
            ++n;
            --n2;
        }
        return nArray2;
    }

    private class SortableField
    implements Comparable {
        private String field;
        private int index;

        SortableField(int n, int n2) {
            this.index = n;
            this.field = (String)PTMExpStatsTableViewer.this.origData[n][n2];
        }

        public int compareTo(Object object) {
            SortableField sortableField = (SortableField)object;
            return this.field.compareTo(sortableField.getField());
        }

        public int getIndex() {
            return this.index;
        }

        public String getField() {
            return this.field;
        }
    }

    class PAndRValuesTableModel
    extends AbstractTableModel {
        String[] columnNames;
        Object[][] tableData;

        public PAndRValuesTableModel() {
            int n;
            this.columnNames = new String[1 + PTMExpStatsTableViewer.this.auxTitles.length];
            this.columnNames[0] = "Samples";
            for (n = 1; n < this.columnNames.length; ++n) {
                this.columnNames[n] = PTMExpStatsTableViewer.this.auxTitles[n - 1];
            }
            this.tableData = new Object[PTMExpStatsTableViewer.this.cols.length][this.columnNames.length];
            for (n = 0; n < this.tableData.length; ++n) {
                this.tableData[n][0] = PTMExpStatsTableViewer.this.data.getFullSampleName(PTMExpStatsTableViewer.this.experiment.getSampleIndex(PTMExpStatsTableViewer.this.cols[n]));
                for (int i = 1; i < this.tableData[n].length; ++i) {
                    float f = ((Float)PTMExpStatsTableViewer.this.auxData[PTMExpStatsTableViewer.this.cols[n]][i - 1]).floatValue();
                    this.tableData[n][i] = Float.isNaN(f) ? "N/A" : new Float(f);
                }
            }
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.tableData.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            return this.tableData[n][n2];
        }

        public void setValueAt(Object object, int n, int n2) {
            this.tableData[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
        }
    }
}

