/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.ptm;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;

public class PTMSubCentroidViewer
extends CentroidViewer {
    Vector templateVector;

    public PTMSubCentroidViewer(Experiment experiment, int[][] nArray, Vector vector) {
        super(experiment, nArray);
        this.templateVector = vector;
    }

    public void paint(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle rectangle = new Rectangle(40, 20, this.getWidth() - 80, this.getHeight() - 40 - this.getNamesWidth(fontMetrics));
        this.paint((Graphics2D)graphics, rectangle, true);
    }

    public void paint(Graphics2D graphics2D, Rectangle rectangle, boolean bl) {
        int n;
        Object object;
        int n2;
        int n3;
        int n4;
        super.subPaint(graphics2D, rectangle, bl);
        if (this.isAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        int n5 = rectangle.x;
        int n6 = rectangle.y;
        int n7 = rectangle.width;
        int n8 = rectangle.height;
        if (n7 < 5 || n8 < 5) {
            return;
        }
        int n9 = n6 + Math.round((float)n8 / 2.0f);
        int n10 = this.experiment.getNumberOfSamples();
        if (this.yRangeOption == CentroidViewer.USE_EXPERIMENT_MAX) {
            this.maxYValue = this.maxExperimentValue;
        } else if (this.yRangeOption == CentroidViewer.USE_CLUSTER_MAX) {
            this.maxYValue = this.maxClusterValue;
        }
        if (this.maxYValue == 0.0f) {
            this.maxYValue = 1.0f;
        }
        if (this.maxYValue == 0.0f) {
            this.maxYValue = 1.0f;
        }
        float f = (float)n8 / (2.0f * this.maxYValue);
        float f2 = (float)n7 / (float)(n10 - 1);
        int n11 = (int)this.maxYValue + 1;
        if (this.drawVariances) {
            graphics2D.setColor(bColor);
            for (n4 = 0; n4 < n10; ++n4) {
                if (Float.isNaN(this.means[this.clusterIndex][n4]) || Float.isNaN(this.variances[this.clusterIndex][n4]) || this.variances[this.clusterIndex][n4] < 0.0f) continue;
                graphics2D.drawLine(n5 + Math.round((float)n4 * f2), n9 - Math.round((this.means[this.clusterIndex][n4] - this.variances[this.clusterIndex][n4]) * f), n5 + Math.round((float)n4 * f2), n9 - Math.round((this.means[this.clusterIndex][n4] + this.variances[this.clusterIndex][n4]) * f));
                graphics2D.drawLine(n5 + Math.round((float)n4 * f2) - 3, n9 - Math.round((this.means[this.clusterIndex][n4] - this.variances[this.clusterIndex][n4]) * f), n5 + Math.round((float)n4 * f2) + 3, n9 - Math.round((this.means[this.clusterIndex][n4] - this.variances[this.clusterIndex][n4]) * f));
                graphics2D.drawLine(n5 + Math.round((float)n4 * f2) - 3, n9 - Math.round((this.means[this.clusterIndex][n4] + this.variances[this.clusterIndex][n4]) * f), n5 + Math.round((float)n4 * f2) + 3, n9 - Math.round((this.means[this.clusterIndex][n4] + this.variances[this.clusterIndex][n4]) * f));
            }
        }
        if (this.drawValues) {
            for (n3 = 0; n3 < n10 - 1; ++n3) {
                for (n2 = 0; n2 < this.getCluster().length; ++n2) {
                    float f3 = this.experiment.get(this.getProbe(n2), n3);
                    float f4 = this.experiment.get(this.getProbe(n2), n3 + 1);
                    if (Float.isNaN(f3) || Float.isNaN(f4)) continue;
                    object = this.data.getProbeColor(this.experiment.getGeneIndexMappedToData(this.getProbe(n2)));
                    object = object == null ? DEF_CLUSTER_COLOR : object;
                    graphics2D.setColor((Color)object);
                    graphics2D.drawLine(n5 + Math.round((float)n3 * f2), n9 - Math.round(f3 * f), n5 + Math.round((float)(n3 + 1) * f2), n9 - Math.round(f4 * f));
                }
            }
        }
        if (this.drawCodes && this.codes != null && this.clusters[this.clusterIndex].length > 0) {
            graphics2D.setColor(Color.gray);
            for (n4 = 0; n4 < n10 - 1; ++n4) {
                graphics2D.drawLine(n5 + Math.round((float)n4 * f2), n9 - Math.round(this.codes[this.clusterIndex][n4] * f), n5 + Math.round((float)(n4 + 1) * f2), n9 - Math.round(this.codes[this.clusterIndex][n4 + 1] * f));
            }
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawLine(n5, n9, n5 + n7, n9);
        if (this.getCluster() != null && this.getCluster().length > 0) {
            graphics2D.setColor(Color.magenta);
            for (n4 = 0; n4 < n10 - 1; ++n4) {
                if (Float.isNaN(this.means[this.clusterIndex][n4]) || Float.isNaN(this.means[this.clusterIndex][n4 + 1])) continue;
                graphics2D.drawLine(n5 + Math.round((float)n4 * f2), n9 - Math.round(this.means[this.clusterIndex][n4] * f), n5 + Math.round((float)(n4 + 1) * f2), n9 - Math.round(this.means[this.clusterIndex][n4 + 1] * f));
            }
        }
        float[] fArray = new float[this.templateVector.size()];
        for (n = 0; n < fArray.length; ++n) {
            fArray[n] = ((Float)this.templateVector.get(n)).floatValue();
        }
        for (n = 0; n < fArray.length; ++n) {
            fArray[n] = fArray[n] - 0.5f;
        }
        for (n = 0; n < n10 - 1; ++n) {
            graphics2D.setColor(Color.red);
            if (!Float.isNaN(fArray[n])) {
                graphics2D.fillOval(n5 + Math.round((float)n * f2) - 2, n9 - Math.round(fArray[n] * f) - 2, 5, 5);
            }
            if (!Float.isNaN(fArray[n + 1])) {
                graphics2D.fillOval(n5 + Math.round((float)(n + 1) * f2) - 2, n9 - Math.round(fArray[n + 1] * f) - 2, 5, 5);
            }
            if (Float.isNaN(fArray[n]) || Float.isNaN(fArray[n + 1])) continue;
            graphics2D.setColor(Color.blue);
            graphics2D.drawLine(n5 + Math.round((float)n * f2), n9 - Math.round(fArray[n] * f), n5 + Math.round((float)(n + 1) * f2), n9 - Math.round(fArray[n + 1] * f));
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(n5, n6, n7, n8);
        for (n = 1; n < n10 - 1; ++n) {
            graphics2D.drawLine(n5 + Math.round((float)n * f2), n6 + n8 - 5, n5 + Math.round((float)n * f2), n6 + n8);
        }
        for (n = 1; n < n11; ++n) {
            graphics2D.drawLine(n5, n9 - Math.round((float)n * f), n5 + 5, n9 - Math.round((float)n * f));
            graphics2D.drawLine(n5, n9 + Math.round((float)n * f), n5 + 5, n9 + Math.round((float)n * f));
        }
        graphics2D.setColor(bColor);
        if (bl) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            for (n2 = 1; n2 < n11; ++n2) {
                object = String.valueOf(n2);
                n3 = fontMetrics.stringWidth((String)object);
                graphics2D.drawString((String)object, n5 - 10 - n3, n9 + 5 - Math.round((float)n2 * f));
                object = String.valueOf(-n2);
                n3 = fontMetrics.stringWidth((String)object);
                graphics2D.drawString((String)object, n5 - 10 - n3, n9 + 5 + Math.round((float)n2 * f));
            }
            graphics2D.rotate(-1.5707963267948966);
            n2 = this.getNamesWidth(fontMetrics);
            for (int i = 0; i < n10; ++i) {
                graphics2D.drawString(this.data.getSampleName(this.experiment.getSampleIndex(i)), -n8 - n6 - 10 - n2, n5 + Math.round((float)i * f2) + 3);
            }
            graphics2D.rotate(1.5707963267948966);
        }
        if (this.getCluster() != null && this.getCluster().length > 0 && this.drawVariances) {
            graphics2D.setColor(bColor);
            for (int i = 0; i < n10; ++i) {
                if (Float.isNaN(this.means[this.clusterIndex][i])) continue;
                graphics2D.fillOval(n5 + Math.round((float)i * f2) - 3, n9 - Math.round(this.means[this.clusterIndex][i] * f) - 3, 6, 6);
            }
        }
        graphics2D.setColor(bColor);
        if (this.getCluster() == null || this.getCluster().length == 0) {
            graphics2D.drawString("No Genes", n5 + 10, n6 + 20);
        } else {
            graphics2D.drawString(this.getCluster().length + " Genes", n5 + 10, n6 + 20);
        }
    }
}

