/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.rn;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;

public class RelNetSelectionDlg
extends JDialog {
    public static final int DEGREE_TYPE = 0;
    public static final int GENEID_TYPE = 1;
    public static final String CONDITION_GREATER_THAN = "Greater than";
    public static final String CONDITION_EQUAL_TO = "Equal to";
    public static final String CONDITION_LESS_THAN = "Less than";
    public static final String CONDITION_LIKE = "Like";
    public static final String CONDITION_BETWEEN = "Between";
    private int result;
    private int type;
    private JComboBox conditionCombo;
    private JPanel degreePanel;
    private JComboBox degreeCombo_1;
    private JComboBox degreeCombo_2;
    private JTextField geneidField;

    public RelNetSelectionDlg(Frame frame, int n) {
        super(frame, "Select Nodes", true);
        this.type = n;
        Listener listener = new Listener();
        this.degreeCombo_1 = this.createDegreeCombo_1();
        this.degreeCombo_2 = this.createDegreeCombo_2();
        JPanel jPanel = this.createSelectionPanel(listener, n);
        JPanel jPanel2 = this.createBtnsPanel(listener);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        container.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        container.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(4, 8, 4, 8), 0, 0));
        this.addWindowListener(listener);
        this.pack();
    }

    private JPanel createSelectionPanel(ActionListener actionListener, int n) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new BevelBorder(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)new JLabel("Condition:"), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        switch (n) {
            case 0: {
                jPanel.add((Component)new JLabel("Degree:"), gridBagConstraints);
                break;
            }
            case 1: {
                jPanel.add((Component)new JLabel("Element ID:"), gridBagConstraints);
            }
        }
        this.conditionCombo = this.createConditionCombo(actionListener, n);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.conditionCombo, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        switch (n) {
            case 0: {
                this.degreePanel = this.createDegreePanel();
                jPanel.add((Component)this.degreePanel, gridBagConstraints);
                break;
            }
            case 1: {
                this.geneidField = new JTextField();
                jPanel.add((Component)this.geneidField, gridBagConstraints);
            }
        }
        return jPanel;
    }

    private JComboBox createConditionCombo(ActionListener actionListener, int n) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        switch (n) {
            case 0: {
                jComboBox.addItem(CONDITION_GREATER_THAN);
                jComboBox.addItem(CONDITION_EQUAL_TO);
                jComboBox.addItem(CONDITION_LESS_THAN);
                jComboBox.addItem(CONDITION_BETWEEN);
                break;
            }
            case 1: {
                jComboBox.addItem(CONDITION_EQUAL_TO);
                jComboBox.addItem(CONDITION_LIKE);
            }
        }
        jComboBox.setActionCommand("condition-changed");
        jComboBox.addActionListener(actionListener);
        return jComboBox;
    }

    private JComboBox createDegreeCombo_1() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setEditable(true);
        for (int i = 0; i < 10; ++i) {
            jComboBox.addItem(String.valueOf(i));
        }
        return jComboBox;
    }

    private JComboBox createDegreeCombo_2() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setEditable(true);
        int n = 10;
        while (--n >= 0) {
            jComboBox.addItem(String.valueOf(n));
        }
        return jComboBox;
    }

    private JPanel createDegreePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.degreeCombo_1, gridBagConstraints);
        return jPanel;
    }

    private void updateDegreePanel(boolean bl) {
        this.degreePanel.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        if (bl) {
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.5;
            this.degreePanel.add((Component)this.degreeCombo_1, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets.left = 5;
            this.degreePanel.add((Component)this.degreeCombo_2, gridBagConstraints);
        } else {
            gridBagConstraints.weightx = 1.0;
            this.degreePanel.add((Component)this.degreeCombo_1, gridBagConstraints);
        }
        this.degreePanel.validate();
        this.degreePanel.repaint();
    }

    private JPanel createBtnsPanel(ActionListener actionListener) {
        GridLayout gridLayout = new GridLayout();
        JPanel jPanel = new JPanel(gridLayout);
        JButton jButton = new JButton("OK");
        jButton.setActionCommand("ok-command");
        jButton.addActionListener(actionListener);
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setActionCommand("cancel-command");
        jButton2.addActionListener(actionListener);
        gridLayout.setHgap(4);
        jPanel.add(jButton2);
        this.getRootPane().setDefaultButton(jButton);
        return jPanel;
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public String getCondition() {
        return (String)this.conditionCombo.getSelectedItem();
    }

    public String getGeneID() {
        return this.geneidField.getText();
    }

    private int getDegree() {
        return Integer.parseInt((String)this.degreeCombo_1.getSelectedItem());
    }

    public int getMinDegree() {
        if (!this.getCondition().equals(CONDITION_BETWEEN)) {
            return this.getDegree();
        }
        return Math.min(Integer.parseInt((String)this.degreeCombo_1.getSelectedItem()), Integer.parseInt((String)this.degreeCombo_2.getSelectedItem()));
    }

    public int getMaxDegree() {
        if (!this.getCondition().equals(CONDITION_BETWEEN)) {
            return this.getDegree();
        }
        return Math.max(Integer.parseInt((String)this.degreeCombo_1.getSelectedItem()), Integer.parseInt((String)this.degreeCombo_2.getSelectedItem()));
    }

    private void onConditionChanged() {
        if (this.type == 0) {
            if (this.getCondition().equals(CONDITION_BETWEEN)) {
                this.updateDegreePanel(true);
            } else {
                this.updateDegreePanel(false);
            }
        }
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                try {
                    switch (RelNetSelectionDlg.this.type) {
                        case 0: {
                            Integer.parseInt((String)RelNetSelectionDlg.this.degreeCombo_1.getSelectedItem());
                            if (!RelNetSelectionDlg.this.getCondition().equals(RelNetSelectionDlg.CONDITION_BETWEEN)) break;
                            Integer.parseInt((String)RelNetSelectionDlg.this.degreeCombo_2.getSelectedItem());
                        }
                    }
                    RelNetSelectionDlg.this.result = 0;
                }
                catch (Exception exception) {
                    RelNetSelectionDlg.this.result = 2;
                }
                RelNetSelectionDlg.this.dispose();
            } else if (string.equals("cancel-command")) {
                RelNetSelectionDlg.this.result = 2;
                RelNetSelectionDlg.this.dispose();
            } else if (string.equals("condition-changed")) {
                RelNetSelectionDlg.this.onConditionChanged();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            RelNetSelectionDlg.this.result = -1;
            RelNetSelectionDlg.this.dispose();
        }
    }
}

