/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.terrain;

import java.util.Enumeration;
import javax.media.j3d.Alpha;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.Interpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class DriftInterpolator
extends Interpolator {
    private static final int POST_ID = 0;
    private TransformGroup target;
    private float min_distance = 0.15f;
    private Vector3d start_v3d = new Vector3d();
    private Point3d start_eye_p3d = new Point3d();
    private Vector3d start_up_v3d = new Vector3d();
    private Point3d finish_p3d = new Point3d();
    private Point3d lookat_p3d = new Point3d();

    public DriftInterpolator(TransformGroup transformGroup, BoundingLeaf boundingLeaf) {
        super(new Alpha(1, 3000L));
        this.target = transformGroup;
        this.setSchedulingBoundingLeaf(boundingLeaf);
    }

    public void setMinDistance(float f) {
        this.min_distance = f;
    }

    public float getMinDistance() {
        return this.min_distance;
    }

    public void initialize() {
        this.wakeupOn((WakeupCondition)new WakeupOnBehaviorPost((Behavior)this, 0));
    }

    public void processStimulus(Enumeration enumeration) {
        Alpha alpha = this.getAlpha();
        this.doDrifting(alpha);
        if (alpha.finished()) {
            this.wakeupOn((WakeupCondition)new WakeupOnBehaviorPost((Behavior)this, 0));
        } else {
            this.wakeupOn((WakeupCondition)this.defaultWakeupCriterion);
        }
    }

    public void drift(Point3d point3d, Vector3f vector3f) {
        Transform3D transform3D = new Transform3D();
        this.target.getTransform(transform3D);
        transform3D.get(this.start_v3d);
        Matrix3d matrix3d = new Matrix3d();
        transform3D.getRotationScale(matrix3d);
        Vector3d vector3d = new Vector3d();
        matrix3d.getColumn(2, vector3d);
        this.start_up_v3d.set(-matrix3d.m10 / matrix3d.m22, matrix3d.m00 / matrix3d.m22, 0.0);
        this.start_up_v3d.normalize();
        this.lookat_p3d.set((Tuple3d)point3d);
        this.finish_p3d.x = point3d.x + (double)(this.min_distance * vector3f.x);
        this.finish_p3d.y = point3d.y + (double)(this.min_distance * vector3f.y);
        this.finish_p3d.z = point3d.z + (double)(this.min_distance * vector3f.z);
        Transform3D transform3D2 = new Transform3D();
        Vector3d vector3d2 = new Vector3d(0.0, 0.0, -1.0);
        transform3D2.set(vector3d2);
        transform3D.mul(transform3D2);
        transform3D.get(vector3d2);
        this.start_eye_p3d.set((Tuple3d)vector3d2);
        this.getAlpha().setStartTime(System.currentTimeMillis());
        this.postId(0);
    }

    private void doDrifting(Alpha alpha) {
        Transform3D transform3D = new Transform3D();
        this.target.getTransform(transform3D);
        this.move(transform3D, alpha);
        this.rotate(transform3D, alpha);
        this.target.setTransform(transform3D);
    }

    private void move(Transform3D transform3D, Alpha alpha) {
        Vector3d vector3d = new Vector3d();
        transform3D.get(vector3d);
        Matrix3d matrix3d = new Matrix3d();
        transform3D.getRotationScale(matrix3d);
        Vector3d vector3d2 = new Vector3d((Tuple3d)this.finish_p3d);
        Matrix3d matrix3d2 = new Matrix3d();
        matrix3d2.m00 = vector3d2.x - vector3d.x;
        matrix3d2.m10 = vector3d2.y - vector3d.y;
        matrix3d2.m20 = vector3d2.z - vector3d.z;
        matrix3d.transpose();
        matrix3d.mul(matrix3d2);
        Vector3d vector3d3 = new Vector3d();
        matrix3d.getColumn(0, vector3d3);
        double d = this.distance(this.start_v3d, vector3d2) * (double)(1.0f - alpha.value());
        if (d < 1.0E-6) {
            return;
        }
        double d2 = this.distance(vector3d, vector3d2);
        vector3d3.scale(1.0 - d / d2);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.set(vector3d3);
        transform3D.mul(transform3D2);
    }

    private void rotate(Transform3D transform3D, Alpha alpha) {
        Point3d point3d = new Point3d();
        point3d.sub((Tuple3d)this.lookat_p3d, (Tuple3d)this.start_eye_p3d);
        point3d.scale((double)alpha.value());
        Point3d point3d2 = new Point3d();
        point3d2.add((Tuple3d)this.start_eye_p3d, (Tuple3d)point3d);
        Matrix3d matrix3d = new Matrix3d();
        transform3D.getRotationScale(matrix3d);
        double d = this.start_up_v3d.y + (1.0 - this.start_up_v3d.y) * (double)alpha.value();
        double d2 = Math.sqrt(1.0 - d * d);
        d2 = matrix3d.m10 < 0.0 && matrix3d.m22 < 0.0 || matrix3d.m10 > 0.0 && matrix3d.m22 > 0.0 ? -d2 : d2;
        Vector3d vector3d = new Vector3d(d2, d, 0.0);
        Vector3d vector3d2 = new Vector3d();
        transform3D.get(vector3d2);
        if (vector3d2.x == point3d2.x) {
            point3d2.x -= 1.0E-6;
        }
        if (vector3d2.y == point3d2.y) {
            point3d2.y -= 1.0E-6;
        }
        if (vector3d2.z == point3d2.z) {
            point3d2.z -= 1.0E-6;
        }
        Transform3D transform3D2 = new Transform3D();
        transform3D2.lookAt(new Point3d((Tuple3d)vector3d2), point3d2, vector3d);
        transform3D2.invert();
        transform3D.set(transform3D2);
    }

    private final double distance(Vector3d vector3d, Vector3d vector3d2) {
        double d = vector3d.x - vector3d2.x;
        double d2 = vector3d.y - vector3d2.y;
        double d3 = vector3d.z - vector3d2.z;
        return Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }
}

