/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.graph;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.tigr.graph.GraphBar;
import org.tigr.graph.GraphElement;
import org.tigr.graph.GraphLine;
import org.tigr.graph.GraphPoint;
import org.tigr.graph.GraphTick;
import org.tigr.util.awt.ActionInfoEvent;
import org.tigr.util.awt.ActionInfoListener;
import org.tigr.util.awt.BoundariesDialog;
import org.tigr.util.awt.Drawable;
import org.tigr.util.awt.GBA;
import org.tigr.util.awt.Viewer;

public class GraphViewer
extends Viewer {
    public static final long serialVersionUID = 1000101030001L;
    public static final int SYSTEM_QUADRANT1_ONLY = 1000;
    public static final int SYSTEM_QUADRANT12_ONLY = 1001;
    public static final int SYSTEM_ALL_QUADRANTS = 1002;
    public static final int SYSTEM_BOUNDS = 1100;
    public static final int HISTOGRAM_BAR_OUTLINE = 2000;
    public static final int HISTOGRAM_BAR_SOLID = 2001;
    public static final int GRAPH_POINTS_SEPERATE = 3000;
    public static final int GRAPH_POINTS_CONNECT = 3001;
    protected int startx;
    protected int stopx;
    protected int starty;
    protected int stopy;
    protected double graphstartx;
    protected double graphstopx;
    protected double graphstarty;
    protected double graphstopy;
    protected int preXSpacing;
    protected int postXSpacing;
    protected int preYSpacing;
    protected int postYSpacing;
    protected double xAxisValue = 0.0;
    protected double yAxisValue = 0.0;
    protected int pointSize;
    protected Font tickFont;
    protected Font labelFont;
    protected Font titleFont;
    protected int tickFontHeight;
    protected int tickFontWidth;
    protected int labelFontHeight;
    protected int labelFontWidth;
    protected int titleFontHeight;
    protected int titleFontWidth;
    protected String title;
    protected String xLabel;
    protected String yLabel;
    protected String subTitle;
    protected JScrollPane scrollPane;
    protected JMenuBar menuBar;
    protected Drawable canvas;
    protected EventListener eventListener;
    protected GBA gba;
    protected boolean referenceLinesOn = true;
    private boolean redrawCachedImage = true;
    private BufferedImage cachedImage;
    protected Vector graphElements;
    protected JPopupMenu popup;
    protected boolean showCoordinates = false;
    protected DecimalFormat coordinateFormat;
    protected FontMetrics metrics;

    public GraphViewer(JFrame jFrame, int n, int n2, int n3, int n4, double d, double d2, double d3, double d4, int n5, int n6, int n7, int n8, String string, String string2, String string3) {
        super(jFrame);
        this.startx = n;
        this.stopx = n2;
        this.starty = n3;
        this.stopy = n4;
        this.graphstartx = d;
        this.graphstopx = d2;
        this.graphstarty = d3;
        this.graphstopy = d4;
        this.preXSpacing = n5;
        this.postXSpacing = n6;
        this.preYSpacing = n7;
        this.postYSpacing = n8;
        this.title = string;
        this.xLabel = string2;
        this.yLabel = string3;
        this.initializeViewer();
        this.initializeCanvas();
        if (jFrame != null) {
            this.initializeFrame();
        }
        this.initializePopupMenu();
    }

    public void setSubTitle(String string) {
        this.subTitle = string;
    }

    private void initializeViewer() {
        this.setLayout(new GridBagLayout());
        this.eventListener = new EventListener();
        this.gba = new GBA();
        this.graphElements = new Vector();
        this.setBackground(Color.white);
        this.setTickFont("SansSerif", 1, 10);
        this.setLabelFont("SansSerif", 1, 12);
        this.setTitleFont("SansSerif", 1, 16);
        this.setSize(this.stopx - this.startx + this.preXSpacing + this.postXSpacing, this.stopy - this.starty + this.preYSpacing + this.postYSpacing);
        this.coordinateFormat = new DecimalFormat();
        this.coordinateFormat.setMaximumFractionDigits(3);
    }

    private void initializeCanvas() {
        this.canvas = new Drawable(this.startx, this.stopx, this.starty, this.stopy){

            public void controlPaint(Graphics graphics) {
                GraphViewer.this.display(graphics);
            }
        };
        this.canvas.setBackground(Color.white);
        this.canvas.addMouseListener(this.eventListener);
        this.canvas.addMouseMotionListener(this.eventListener);
        this.scrollPane = new JScrollPane(this.canvas, 22, 32);
        this.scrollPane.getViewport().setBackground(Color.white);
        this.gba.add(this, this.scrollPane, 0, 0, 1, 1, 1, 1, 1, 10);
    }

    private void initializeFrame() {
        this.frame.getContentPane().setLayout(new GridBagLayout());
        this.frame.setResizable(true);
        this.frame.setBackground(Color.white);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GraphViewer.this.close();
            }
        });
        this.initializeMenuBar(this.frame);
        this.gba.add(this.frame.getContentPane(), this, 0, 0, 1, 1, 1, 1, 1, 10);
        this.frame.pack();
    }

    private void initializeMenuBar(JFrame jFrame) {
        this.menuBar = new JMenuBar();
        jFrame.setJMenuBar(this.menuBar);
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Close");
        jMenuItem.addActionListener(this.eventListener);
        jMenu.add(jMenuItem);
        JMenu jMenu2 = new JMenu("Control");
        JMenuItem jMenuItem2 = new JMenuItem("Set Boundaries");
        jMenuItem2.addActionListener(this.eventListener);
        jMenu2.add(jMenuItem2);
        jMenuItem2.setEnabled(false);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Reference Lines");
        jCheckBoxMenuItem.addActionListener(this.eventListener);
        jMenu2.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem.setSelected(true);
        this.menuBar.add(jMenu);
        this.menuBar.add(jMenu2);
    }

    protected void initializePopupMenu() {
        this.popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Set Bounds");
        jMenuItem.setActionCommand("Set Boundaries");
        jMenuItem.addActionListener(this.eventListener);
        this.popup.add(jMenuItem);
        this.popup.addSeparator();
        jMenuItem = new JMenuItem("Reference Lines");
        jMenuItem.setActionCommand("Reference Lines");
        jMenuItem.addActionListener(this.eventListener);
        this.popup.add(jMenuItem);
    }

    public void display(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.metrics = graphics2D.getFontMetrics();
        this.drawGraph(graphics2D);
    }

    public void drawGraph(Graphics2D graphics2D) {
        int n;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.drawSystem(graphics2D, 1100);
        for (n = 0; n < this.graphElements.size(); ++n) {
            GraphElement graphElement = (GraphElement)this.graphElements.elementAt(n);
            if (graphElement instanceof GraphPoint) {
                this.drawPoint(graphics2D, (GraphPoint)graphElement);
                continue;
            }
            if (graphElement instanceof GraphBar) {
                this.drawBar(graphics2D, (GraphBar)graphElement);
                continue;
            }
            if (graphElement instanceof GraphTick) {
                this.drawTick(graphics2D, (GraphTick)graphElement);
                continue;
            }
            if (!(graphElement instanceof GraphLine)) continue;
            this.drawLine(graphics2D, (GraphLine)graphElement);
        }
        if (this.referenceLinesOn) {
            boolean bl;
            n = this.getXOldEvent();
            int n2 = this.getYOldEvent();
            double d = 0.0;
            double d2 = 0.0;
            boolean bl2 = bl = n <= this.convertX(this.graphstopx) && n >= this.convertX(this.graphstartx) && n2 >= this.convertY(this.graphstopy) && n2 <= this.convertY(this.graphstarty);
            if (bl) {
                this.setCursor(1);
                d = (double)(n - this.convertX(this.graphstartx)) / this.getXScale() + this.graphstartx;
                d2 = (double)(this.convertY(this.graphstarty) - n2) / this.getYScale() + this.graphstarty;
                graphics2D.setColor(Color.magenta);
                graphics2D.drawLine(n, this.convertY(this.graphstarty), n, this.convertY(this.graphstopy));
                graphics2D.drawLine(this.convertX(this.graphstartx), n2, this.convertX(this.graphstopx), n2);
                if (this.showCoordinates) {
                    int n3 = this.metrics.stringWidth(this.coordinateFormat.format(d) + ", " + this.coordinateFormat.format(d2));
                    Composite composite = graphics2D.getComposite();
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 0.2f));
                    graphics2D.setColor(Color.blue);
                    graphics2D.fillRect(n, n2 - 15, n3 + 10, 15);
                    graphics2D.setComposite(composite);
                    graphics2D.setColor(Color.black);
                    graphics2D.drawString(this.coordinateFormat.format(d) + ", " + this.coordinateFormat.format(d2), n + 5, n2 - 3);
                }
            } else {
                this.setCursor(0);
            }
        }
        this.drawXLabel(graphics2D, this.xLabel, Color.black);
        this.drawYLabel(graphics2D, this.yLabel, Color.black);
        this.drawTitle(graphics2D, this.title, Color.black);
    }

    public void constructImage() {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        BufferedImage bufferedImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(this.canvas.getSize().width, this.canvas.getSize().height);
        graphics2D = bufferedImage.createGraphics();
        this.drawGraph(graphics2D);
        this.cachedImage = bufferedImage;
    }

    public void drawImage(Graphics2D graphics2D) {
        graphics2D.drawImage((Image)this.cachedImage, 0, 0, this);
    }

    public void addGraphElement(GraphElement graphElement) {
        this.graphElements.addElement(graphElement);
    }

    public void setGraphStartX(double d) {
        this.graphstartx = d;
    }

    public double getGraphStartX() {
        return this.graphstartx;
    }

    public void setGraphStopX(double d) {
        this.graphstopx = d;
    }

    public double getGraphStopX() {
        return this.graphstopx;
    }

    public void setGraphStartY(double d) {
        this.graphstarty = d;
    }

    public double getGraphStartY() {
        return this.graphstarty;
    }

    public void setGraphStopY(double d) {
        this.graphstopy = d;
    }

    public double getGraphStopY() {
        return this.graphstopy;
    }

    public void setXAxisValue(double d) {
        this.xAxisValue = d;
    }

    public double getXAxisValue() {
        return this.xAxisValue;
    }

    public void setYAxisValue(double d) {
        this.yAxisValue = d;
    }

    public double getYAxisValue() {
        return this.yAxisValue;
    }

    public void setPreXSpacing(int n) {
        this.preXSpacing = n;
    }

    public int getPreXSpacing() {
        return this.preXSpacing;
    }

    public void setPreYSpacing(int n) {
        this.preYSpacing = n;
    }

    public int getPreYSpacing() {
        return this.preYSpacing;
    }

    public void setPostYSpacing(int n) {
        this.postYSpacing = n;
    }

    public String getXLabel() {
        return this.xLabel;
    }

    public String getYLabel() {
        return this.yLabel;
    }

    public void setTickFont(String string, int n, int n2) {
        this.tickFont = new Font(string, n, n2);
        this.tickFontWidth = (int)(0.6 * (double)n2);
        this.tickFontHeight = n2;
    }

    public void setLabelFont(String string, int n, int n2) {
        this.labelFont = new Font(string, n, n2);
        this.labelFontWidth = (int)(0.6 * (double)n2);
        this.labelFontHeight = n2;
    }

    public void setTitleFont(String string, int n, int n2) {
        this.titleFont = new Font(string, n, n2);
        this.titleFontWidth = (int)(0.6 * (double)n2);
        this.titleFontHeight = n2;
    }

    public void setPointSize(int n) {
        this.pointSize = n;
    }

    public int getPointSize() {
        return this.pointSize;
    }

    public void showAll() {
        this.canvas.repaint();
    }

    public void clearAll(Graphics2D graphics2D) {
        this.canvas.fillRect(graphics2D, this.startx, this.starty, this.getSize().width, this.getSize().height, Color.white);
    }

    public void drawSystem(Graphics2D graphics2D, int n) {
        switch (n) {
            case 1000: {
                graphics2D.drawLine(this.startx + this.preXSpacing, this.stopy - this.postYSpacing, this.stopx - this.postXSpacing, this.stopy - this.postYSpacing);
                graphics2D.drawLine(this.startx + this.preXSpacing, this.stopy - this.postYSpacing, this.startx + this.preXSpacing, this.starty + this.preYSpacing);
                break;
            }
            case 1001: {
                graphics2D.drawLine(this.startx + this.preXSpacing, this.stopy - this.postYSpacing, this.stopx - this.postXSpacing, this.stopy - this.postYSpacing);
                graphics2D.drawLine(this.startx + this.preXSpacing, this.stopy - this.postYSpacing, this.startx + this.preXSpacing, this.starty + this.preYSpacing);
                graphics2D.drawLine((this.stopx - this.postXSpacing - this.startx + this.preXSpacing) / 2, this.stopy - this.postYSpacing, (this.stopx - this.postXSpacing - this.startx + this.preXSpacing) / 2, this.starty + this.preYSpacing);
                break;
            }
            case 1100: {
                this.drawLine(graphics2D, new GraphPoint(this.graphstartx, this.xAxisValue), new GraphPoint(this.graphstopx, this.xAxisValue), Color.black);
                this.drawLine(graphics2D, new GraphPoint(this.yAxisValue, this.graphstarty), new GraphPoint(this.yAxisValue, this.graphstopy), Color.black);
                break;
            }
        }
    }

    protected double getXScale() {
        return (double)(this.canvas.getSize().width - this.preXSpacing - this.postXSpacing) / (this.graphstopx - this.graphstartx);
    }

    protected double getYScale() {
        return (double)(this.canvas.getSize().height - this.preYSpacing - this.postYSpacing) / (this.graphstopy - this.graphstarty);
    }

    protected int convertX(double d) {
        return (int)((d - this.graphstartx) * this.getXScale() + (double)this.preXSpacing);
    }

    protected int convertY(double d) {
        return (int)((this.graphstopy - d) * this.getYScale() + (double)this.preYSpacing);
    }

    public void drawTick(Graphics2D graphics2D, GraphTick graphTick) {
        if (graphTick.getOrientation() == 0) {
            if (graphTick.getLabel() != "") {
                this.drawVerticalTick(graphics2D, graphTick.getLocation(), graphTick.getHeight(), graphTick.getAlignment(), graphTick.getColor(), graphTick.getLabel(), graphTick.getLabelColor());
            } else {
                this.drawVerticalTick(graphics2D, graphTick.getLocation(), graphTick.getHeight(), graphTick.getAlignment(), graphTick.getColor());
            }
        } else if (graphTick.getOrientation() == 1) {
            if (graphTick.getLabel() != "") {
                this.drawHorizontalTick(graphics2D, graphTick.getLocation(), graphTick.getHeight(), graphTick.getAlignment(), graphTick.getColor(), graphTick.getLabel(), graphTick.getLabelColor());
            } else {
                this.drawHorizontalTick(graphics2D, graphTick.getLocation(), graphTick.getHeight(), graphTick.getAlignment(), graphTick.getColor());
            }
        }
    }

    public void drawVerticalTick(Graphics2D graphics2D, double d, int n, int n2, Color color) {
        if (!(d < this.graphstartx) && !(d > this.graphstopx) && n <= this.postYSpacing) {
            switch (n2) {
                case 0: {
                    this.canvas.drawLine(graphics2D, this.convertX(d), this.convertY(this.xAxisValue) - n / 2, this.convertX(d), this.convertY(this.xAxisValue) + n / 2, color);
                    break;
                }
                case 1: {
                    this.canvas.drawLine(graphics2D, this.convertX(d), this.convertY(this.xAxisValue), this.convertX(d), this.convertY(this.xAxisValue) - n, color);
                    break;
                }
                case 5: {
                    this.canvas.drawLine(graphics2D, this.convertX(d), this.convertY(this.xAxisValue), this.convertX(d), this.convertY(this.xAxisValue) + n, color);
                }
            }
        }
    }

    public void drawVerticalTick(Graphics2D graphics2D, double d, int n, int n2, Color color, String string, Color color2) {
        this.drawVerticalTick(graphics2D, d, n, n2, color);
        graphics2D.rotate(-1.5707963267948966);
        this.canvas.drawString(graphics2D, string, -this.canvas.getSize().height + this.postYSpacing - string.length() * this.tickFontWidth - n, this.convertX(d) + this.tickFontHeight / 2, color2, this.tickFont);
        graphics2D.rotate(1.5707963267948966);
    }

    public void drawHorizontalTick(Graphics2D graphics2D, double d, int n, int n2, Color color) {
        if (!(d < this.graphstarty) && !(d > this.graphstopy) && n <= this.preXSpacing) {
            switch (n2) {
                case 0: {
                    this.canvas.drawLine(graphics2D, this.convertX(this.yAxisValue) - n / 2, this.convertY(d), this.convertX(this.yAxisValue) + n / 2, this.convertY(d), color);
                    break;
                }
                case 3: {
                    this.canvas.drawLine(graphics2D, this.convertX(this.yAxisValue), this.convertY(d), this.convertX(this.yAxisValue) + n, this.convertY(d), color);
                    break;
                }
                case 7: {
                    this.canvas.drawLine(graphics2D, this.convertX(this.yAxisValue), this.convertY(d), this.convertX(this.yAxisValue) - n, this.convertY(d), color);
                }
            }
        }
    }

    public void drawHorizontalTick(Graphics2D graphics2D, double d, int n, int n2, Color color, String string, Color color2) {
        this.drawHorizontalTick(graphics2D, d, n, n2, color);
        this.canvas.drawString(graphics2D, string, this.startx + this.preXSpacing - n - string.length() * this.tickFontWidth, this.convertY(d) + this.tickFontHeight / 2, color2, this.tickFont);
    }

    public void enforceGraphBounds(Graphics2D graphics2D) {
        this.enforceGraphBounds(graphics2D, Color.white);
    }

    public void enforceGraphBounds(Graphics2D graphics2D, Color color) {
        int n = this.canvas.getSize().height;
        int n2 = this.canvas.getSize().width;
        this.canvas.fillRect(graphics2D, 0, 0, n2, this.preYSpacing, color);
        this.canvas.fillRect(graphics2D, 0, n - this.postYSpacing, n2, this.postYSpacing, color);
        this.canvas.fillRect(graphics2D, 0, 0, this.preXSpacing, n, color);
        this.canvas.fillRect(graphics2D, n2 - this.postXSpacing, 0, this.postXSpacing, n, color);
    }

    public void drawTitle(Graphics2D graphics2D, String string, Color color) {
        if (this.subTitle == null) {
            this.canvas.drawString(graphics2D, string, this.canvas.getSize().width / 2 - string.length() * this.titleFontWidth / 2, this.titleFontHeight * 2, color, this.titleFont);
        } else {
            this.canvas.drawString(graphics2D, string, this.canvas.getSize().width / 2 - string.length() * this.titleFontWidth / 2, (int)((double)this.titleFontHeight * 1.5), color, this.titleFont);
            this.canvas.drawString(graphics2D, this.subTitle, this.canvas.getSize().width / 2 - this.subTitle.length() * this.titleFontWidth / 2, this.titleFontHeight * 3, color, this.titleFont);
        }
    }

    public void drawXLabel(Graphics2D graphics2D, String string, Color color) {
        this.canvas.drawString(graphics2D, string, this.canvas.getSize().width / 2 - string.length() * this.labelFontWidth / 2, this.convertY(this.graphstarty) + this.postYSpacing - this.labelFontHeight, color, this.labelFont);
    }

    public void drawYLabel(Graphics2D graphics2D, String string, Color color) {
        graphics2D.rotate(-1.5707963267948966);
        this.canvas.drawString(graphics2D, string, this.startx - this.postYSpacing + this.preXSpacing - this.canvas.getSize().height / 2 - string.length() * this.labelFontWidth / 2, this.labelFontHeight, color, this.labelFont);
        graphics2D.rotate(1.5707963267948966);
    }

    public void drawPoint(Graphics2D graphics2D, GraphPoint graphPoint) {
        this.drawPointAt(graphics2D, graphPoint.getX(), graphPoint.getY(), graphPoint.getColor(), graphPoint.getPointSize());
    }

    public void drawPointAt(Graphics2D graphics2D, double d, double d2, Color color, int n) {
        if (!(d < this.graphstartx || d > this.graphstopx || d2 < this.graphstarty || d2 > this.graphstopy)) {
            this.canvas.fillRect(graphics2D, this.convertX(d) - n / 2, this.convertY(d2) - n / 2, n, n, color);
        }
    }

    public void drawPoints(Graphics2D graphics2D, Vector vector, int n) {
        GraphPoint graphPoint = null;
        switch (n) {
            case 3000: {
                for (int i = 0; i < vector.size(); ++i) {
                    GraphPoint graphPoint2 = (GraphPoint)vector.elementAt(i);
                    this.drawPoint(graphics2D, graphPoint2);
                }
                break;
            }
            case 3001: {
                for (int i = 0; i < vector.size(); ++i) {
                    GraphPoint graphPoint3 = (GraphPoint)vector.elementAt(i);
                    if (i == 0) {
                        graphPoint = graphPoint3;
                    }
                    this.drawLine(graphics2D, graphPoint, graphPoint3, Color.black);
                    this.drawPoint(graphics2D, graphPoint);
                    this.drawPoint(graphics2D, graphPoint3);
                    graphPoint = graphPoint3;
                }
                break;
            }
        }
    }

    public void drawLine(Graphics2D graphics2D, GraphLine graphLine) {
        if (!(graphLine.getX1() < this.graphstartx || graphLine.getX1() > this.graphstopx || graphLine.getY1() < this.graphstarty || graphLine.getY1() > this.graphstopy || graphLine.getX2() < this.graphstartx || graphLine.getX2() > this.graphstopx || graphLine.getY2() < this.graphstarty || graphLine.getY2() > this.graphstopy)) {
            this.canvas.drawLine(graphics2D, this.convertX(graphLine.getX1()), this.convertY(graphLine.getY1()), this.convertX(graphLine.getX2()), this.convertY(graphLine.getY2()), graphLine.getColor());
        }
    }

    public void drawLine(Graphics2D graphics2D, GraphPoint graphPoint, GraphPoint graphPoint2, Color color) {
        this.canvas.drawLine(graphics2D, this.convertX(graphPoint.getX()), this.convertY(graphPoint.getY()), this.convertX(graphPoint2.getX()), this.convertY(graphPoint2.getY()), color);
    }

    public void drawBar(Graphics2D graphics2D, GraphBar graphBar) {
        if (graphBar.getStyle() == 0) {
            this.drawVerticalHistogramBar(graphics2D, graphBar.getLower(), graphBar.getUpper(), graphBar.getValue(), graphBar.getColor(), graphBar.getStyle());
        } else if (graphBar.getStyle() == 1) {
            // empty if block
        }
    }

    public void drawVerticalHistogramBar(Graphics2D graphics2D, double d, double d2, double d3, Color color, int n) {
        if (!(d < this.graphstartx || d > this.graphstopx || d2 < this.graphstartx || d2 > this.graphstopx || d3 < this.graphstarty || d3 > this.graphstopy)) {
            if (n == 1) {
                this.canvas.drawRect(graphics2D, this.convertX(d), this.convertY(d3), (int)((d2 - d) * this.getXScale()), (int)(d3 * this.getYScale()) - 1, color);
            } else if (n == 0) {
                this.canvas.fillRect(graphics2D, this.convertX(d), this.convertY(d3), (int)((d2 - d) * this.getXScale()) + 1, (int)(d3 * this.getYScale()) + 1, color);
            }
        }
    }

    public void close() {
        if (this.hasFrame()) {
            this.frame.dispose();
        }
    }

    public void toggleReferenceLines() {
        this.referenceLinesOn = !this.referenceLinesOn;
    }

    public void setShowCoordinates(boolean bl) {
        this.showCoordinates = bl;
    }

    private class EventListener
    implements ActionListener,
    KeyListener,
    MouseListener,
    MouseMotionListener,
    Serializable {
        private EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GraphViewer.this.popup.setVisible(false);
            if (actionEvent.getActionCommand() == "Close") {
                GraphViewer.this.getFrame().dispose();
            } else if (actionEvent.getActionCommand() == "Set Boundaries") {
                BoundariesDialog boundariesDialog = new BoundariesDialog(GraphViewer.this.getFrame(), GraphViewer.this.graphstartx, GraphViewer.this.graphstopx, GraphViewer.this.graphstarty, GraphViewer.this.graphstopy);
                boundariesDialog.addActionInfoListener(new ActionInfoListener(this){
                    private final /* synthetic */ EventListener this$1;
                    {
                        this.this$1 = eventListener;
                    }

                    public void actionInfoPerformed(ActionInfoEvent actionInfoEvent) {
                        Hashtable hashtable = actionInfoEvent.getHashtable();
                        EventListener.access$100((EventListener)this.this$1).graphstartx = Double.parseDouble((String)hashtable.get("lowerx"));
                        EventListener.access$100((EventListener)this.this$1).graphstopx = Double.parseDouble((String)hashtable.get("upperx"));
                        EventListener.access$100((EventListener)this.this$1).graphstarty = Double.parseDouble((String)hashtable.get("lowery"));
                        EventListener.access$100((EventListener)this.this$1).graphstopy = Double.parseDouble((String)hashtable.get("uppery"));
                        EventListener.access$100(this.this$1).setXAxisValue(EventListener.access$100((EventListener)this.this$1).graphstarty);
                        EventListener.access$100(this.this$1).setYAxisValue(EventListener.access$100((EventListener)this.this$1).graphstartx);
                        EventListener.access$100(this.this$1).repaint();
                    }
                });
                boundariesDialog.show();
            } else if (actionEvent.getActionCommand() == "Reference Lines") {
                GraphViewer.this.referenceLinesOn = !GraphViewer.this.referenceLinesOn;
                GraphViewer.this.repaint();
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getModifiers() == 4) {
                GraphViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            GraphViewer.this.setXOldEvent(-1);
            GraphViewer.this.setYOldEvent(-1);
            GraphViewer.this.repaint();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            GraphViewer.this.setXOldEvent(n);
            GraphViewer.this.setYOldEvent(n2);
            GraphViewer.this.repaint();
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        static /* synthetic */ GraphViewer access$100(EventListener eventListener) {
            return eventListener.GraphViewer.this;
        }
    }
}

