/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util;

import java.util.Vector;

public class QSort {
    private int[] origIndx;
    private float[] sorted;
    private double[] sortedDouble;
    private int[] NaNIndices;
    private int[] negInfinityIndices;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    private boolean ascending;

    public QSort(float[] fArray) {
        int n;
        float[] fArray2 = new float[fArray.length];
        this.ascending = true;
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        for (n = 0; n < fArray2.length; ++n) {
            fArray2[n] = fArray[n];
            if (Float.isNaN(fArray[n])) {
                vector.add(new Integer(n));
                fArray2[n] = Float.NEGATIVE_INFINITY;
            }
            if (!Float.isInfinite(fArray[n]) || !(fArray[n] < 0.0f)) continue;
            vector2.add(new Integer(n));
        }
        this.NaNIndices = new int[vector.size()];
        for (n = 0; n < this.NaNIndices.length; ++n) {
            this.NaNIndices[n] = (Integer)vector.get(n);
        }
        this.negInfinityIndices = new int[vector2.size()];
        for (n = 0; n < this.negInfinityIndices.length; ++n) {
            this.negInfinityIndices[n] = (Integer)vector2.get(n);
        }
        this.sort(fArray2);
    }

    public QSort(double[] dArray) {
        int n;
        double[] dArray2 = new double[dArray.length];
        this.ascending = true;
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        for (n = 0; n < dArray2.length; ++n) {
            dArray2[n] = dArray[n];
            if (Double.isNaN(dArray[n])) {
                vector.add(new Integer(n));
                dArray2[n] = Double.NEGATIVE_INFINITY;
            }
            if (!Double.isInfinite(dArray[n]) || !(dArray[n] < 0.0)) continue;
            vector2.add(new Integer(n));
        }
        this.NaNIndices = new int[vector.size()];
        for (n = 0; n < this.NaNIndices.length; ++n) {
            this.NaNIndices[n] = (Integer)vector.get(n);
        }
        this.negInfinityIndices = new int[vector2.size()];
        for (n = 0; n < this.negInfinityIndices.length; ++n) {
            this.negInfinityIndices[n] = (Integer)vector2.get(n);
        }
        this.sort(dArray2);
    }

    public QSort(float[] fArray, int n) {
        this(fArray);
        if (n == 1) {
            this.ascending = true;
        } else if (n == 2) {
            this.ascending = false;
        }
    }

    public QSort(double[] dArray, int n) {
        this(dArray);
        if (n == 1) {
            this.ascending = true;
        } else if (n == 2) {
            this.ascending = false;
        }
    }

    public void sort(float[] fArray) {
        this.origIndx = new int[fArray.length];
        for (int i = 0; i <= this.origIndx.length - 1; ++i) {
            this.origIndx[i] = i;
        }
        this.quickSort(fArray, 0, fArray.length - 1);
    }

    public void sort(double[] dArray) {
        this.origIndx = new int[dArray.length];
        for (int i = 0; i <= this.origIndx.length - 1; ++i) {
            this.origIndx[i] = i;
        }
        this.quickSort(dArray, 0, dArray.length - 1);
    }

    void quickSort(float[] fArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            float f = fArray[(n + n2) / 2];
            while (n3 <= n4) {
                while (n3 < n2 && fArray[n3] < f) {
                    ++n3;
                }
                while (n4 > n && fArray[n4] > f) {
                    --n4;
                }
                if (n3 > n4) continue;
                this.swap(fArray, n3, n4);
                ++n3;
                --n4;
            }
            if (n < n4) {
                this.quickSort(fArray, n, n4);
            }
            if (n3 < n2) {
                this.quickSort(fArray, n3, n2);
            }
        }
        this.sorted = fArray;
    }

    void quickSort(double[] dArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            double d = dArray[(n + n2) / 2];
            while (n3 <= n4) {
                while (n3 < n2 && dArray[n3] < d) {
                    ++n3;
                }
                while (n4 > n && dArray[n4] > d) {
                    --n4;
                }
                if (n3 > n4) continue;
                this.swap(dArray, n3, n4);
                ++n3;
                --n4;
            }
            if (n < n4) {
                this.quickSort(dArray, n, n4);
            }
            if (n3 < n2) {
                this.quickSort(dArray, n3, n2);
            }
        }
        this.sortedDouble = dArray;
    }

    private void swap(float[] fArray, int n, int n2) {
        float f = fArray[n];
        fArray[n] = fArray[n2];
        fArray[n2] = f;
        int n3 = this.origIndx[n];
        this.origIndx[n] = this.origIndx[n2];
        this.origIndx[n2] = n3;
    }

    private void swap(double[] dArray, int n, int n2) {
        double d = dArray[n];
        dArray[n] = dArray[n2];
        dArray[n2] = d;
        int n3 = this.origIndx[n];
        this.origIndx[n] = this.origIndx[n2];
        this.origIndx[n2] = n3;
    }

    public float[] getSorted() {
        for (int i = 0; i < this.NaNIndices.length; ++i) {
            this.sorted[i] = Float.NaN;
        }
        if (!this.ascending) {
            float[] fArray = this.reverse(this.sorted);
            return fArray;
        }
        return this.sorted;
    }

    public double[] getSortedDouble() {
        for (int i = 0; i < this.NaNIndices.length; ++i) {
            this.sortedDouble[i] = Double.NaN;
        }
        if (!this.ascending) {
            double[] dArray = this.reverse(this.sortedDouble);
            return dArray;
        }
        return this.sortedDouble;
    }

    public int[] getOrigIndx() {
        int n;
        for (n = 0; n < this.NaNIndices.length; ++n) {
            this.origIndx[n] = this.NaNIndices[n];
        }
        for (n = this.NaNIndices.length; n < this.NaNIndices.length + this.negInfinityIndices.length; ++n) {
            this.origIndx[n] = this.negInfinityIndices[n - this.NaNIndices.length];
        }
        if (!this.ascending) {
            return this.reverse(this.origIndx);
        }
        return this.origIndx;
    }

    private boolean isNaNIndex(int n) {
        for (int i = 0; i < this.NaNIndices.length; ++i) {
            if (n != this.NaNIndices[i]) continue;
            return true;
        }
        return false;
    }

    private int[] reverse(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        int n2 = nArray.length - 1;
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[n] = nArray[n2];
            ++n;
            --n2;
        }
        return nArray2;
    }

    private float[] reverse(float[] fArray) {
        float[] fArray2 = new float[fArray.length];
        int n = 0;
        int n2 = fArray.length - 1;
        for (int i = 0; i < fArray.length; ++i) {
            fArray2[n] = fArray[n2];
            ++n;
            --n2;
        }
        return fArray2;
    }

    private double[] reverse(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        int n = 0;
        int n2 = dArray.length - 1;
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[n] = dArray[n2];
            ++n;
            --n2;
        }
        return dArray2;
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[]{120.0, 0.01, -4.5, Double.NaN, 7.6, -65.0, Double.NEGATIVE_INFINITY, 3.5, -0.95, Double.POSITIVE_INFINITY, 600.0, Double.NaN, 65.0, Double.NEGATIVE_INFINITY, Double.MAX_VALUE};
        QSort qSort = new QSort(dArray, 1);
        double[] dArray2 = qSort.getSortedDouble();
        int[] nArray = qSort.getOrigIndx();
        for (int i = 0; i < dArray2.length; ++i) {
            System.out.println("arr[" + i + "] = " + dArray[i] + ", sortedArr[" + i + "] = " + dArray2[i] + ",  sortedArrIndices[" + i + "] = " + nArray[i]);
        }
    }
}

