/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines.javasound;

import com.sun.j3d.audio.J3DHaeClip;
import com.sun.j3d.audio.J3DHaeMidi;
import com.sun.j3d.audio.J3DHaeStream;
import com.sun.j3d.audioengines.AudioEngine3D;
import com.sun.j3d.audioengines.AuralParameters;
import com.sun.j3d.audioengines.javasound.JSDirectionalSample;
import com.sun.j3d.audioengines.javasound.JSPositionalSample;
import com.sun.j3d.audioengines.javasound.JSSample;
import java.net.URL;
import java.util.ArrayList;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class JavaSoundMixer
extends AudioEngine3D {
    static final boolean debugFlag = false;
    static final boolean internalErrors = false;
    static final int ADD_TO_LIST = 1;
    static final int SET_INTO_LIST = 2;
    static int REFLECTION_COEFF_CHANGED = 1;
    static int REVERB_DELAY_CHANGED = 2;
    static int REVERB_ORDER_CHANGED = 4;
    int reverbDirty = 65535;
    int lastReverbSpeed = 0;
    boolean reverbOn = false;
    int reverbType = 1;

    public JavaSoundMixer(PhysicalEnvironment physicalEnvironment) {
        super(physicalEnvironment);
    }

    void calcReverb(int n, float f, float f2, int n2) {
        JSSample jSSample = (JSSample)this.samples.get(n);
        int n3 = jSSample.getDataType();
        int n4 = jSSample.getSoundType();
        if ((this.reverbDirty & REFLECTION_COEFF_CHANGED) > 0) {
            this.lastReverbSpeed = REFLECTION_COEFF_CHANGED;
        } else if ((this.reverbDirty & REVERB_ORDER_CHANGED) > 0) {
            this.lastReverbSpeed = REVERB_ORDER_CHANGED;
        }
        if ((double)f <= 0.0 || (double)f2 <= 0.0 || n2 <= 0) {
            this.reverbOn = false;
        } else {
            this.reverbOn = true;
            this.reverbType = f2 < 100.0f ? ((this.lastReverbSpeed & REVERB_ORDER_CHANGED) > 0 ? (n2 <= 8 ? 2 : 4) : (f <= 0.9f ? 2 : 4)) : (f2 < 500.0f ? ((this.lastReverbSpeed & REVERB_ORDER_CHANGED) > 0 ? (n2 <= 8 ? 3 : 6) : (f <= 0.9f ? 3 : 6)) : ((this.lastReverbSpeed & REVERB_ORDER_CHANGED) > 0 ? (n2 <= 8 ? 6 : 5) : (f <= 0.9f ? 6 : 5)));
        }
        this.reverbDirty = 0;
    }

    public void clearSound(int n) {
        ArrayList arrayList = this.samples;
        synchronized (arrayList) {
            JSSample jSSample = (JSSample)this.samples.get(n);
            jSSample.clear();
            this.samples.set(n, null);
        }
    }

    public boolean close() {
        return J3DHaeStream.close();
    }

    void debugPrint(String string) {
    }

    void debugPrintln(String string) {
    }

    public int getNumberOfChannelsUsed(int n) {
        JSSample jSSample = (JSSample)this.samples.get(n);
        return this.getNumberOfChannelsUsed(n, jSSample.getMuteFlag());
    }

    public int getNumberOfChannelsUsed(int n, boolean bl) {
        JSSample jSSample = (JSSample)this.samples.get(n);
        int n2 = jSSample.getSoundType();
        int n3 = jSSample.getDataType();
        if (n3 == 3 || n3 == 3) {
            return 1;
        }
        if (n2 == 1) {
            return 1;
        }
        return 3;
    }

    public long getSampleDuration(int n) {
        long l;
        JSSample jSSample = (JSSample)this.samples.get(n);
        int n2 = jSSample.getDataType();
        int n3 = jSSample.getSoundType();
        if (n2 == 1) {
            l = J3DHaeStream.getSampleDuration((int)n);
        } else if (n2 == 2) {
            l = J3DHaeClip.getSampleDuration((int)n);
        } else if (n2 == 3 || n2 == 3) {
            l = J3DHaeMidi.getSampleDuration((int)n);
        } else {
            return -1L;
        }
        return l;
    }

    public long getStartTime(int n) {
        JSSample jSSample = (JSSample)this.samples.get(n);
        int n2 = jSSample.getDataType();
        int n3 = jSSample.getSoundType();
        if (n2 == 1) {
            return J3DHaeStream.getStartTime((int)n);
        }
        if (n2 == 2) {
            return J3DHaeStream.getStartTime((int)n);
        }
        if (n2 == 3 || n2 == 3) {
            return J3DHaeStream.getStartTime((int)n);
        }
        return 0L;
    }

    public int getTotalChannels() {
        return J3DHaeStream.getTotalChannels();
    }

    public boolean initialize() {
        return J3DHaeStream.initialize();
    }

    int loadSound(URL uRL, boolean bl) {
        int n = -1;
        int n2 = J3DHaeStream.initAudioContainer((URL)uRL, (boolean)bl);
        if (n2 < 0) {
            return -1;
        }
        n = J3DHaeStream.getDataType((int)n2);
        if (n == -1) {
            return -1;
        }
        int n3 = n == 2 ? J3DHaeClip.loadSample((URL)uRL, (int)n2) : (n == 1 ? J3DHaeStream.loadSample((URL)uRL, (int)n2) : J3DHaeMidi.loadSample((URL)uRL, (int)n2));
        if (n3 < 0) {
            return -1;
        }
        return n2;
    }

    public void muteSample(int n) {
        JSSample jSSample = (JSSample)this.samples.get(n);
        jSSample.setMuteFlag(true);
    }

    public void pauseSample(int n) {
        JSSample jSSample = (JSSample)this.samples.get(n);
        int n2 = jSSample.getDataType();
        int n3 = jSSample.getSoundType();
        int n4 = 0;
        if (n2 == 1) {
            if (n3 == 3 || n3 == 2) {
                n4 = J3DHaeStream.pauseSamples((int)n, (int)((JSPositionalSample)jSSample).getSecondIndex());
                n4 = J3DHaeStream.pauseSample((int)((JSPositionalSample)jSSample).getReverbIndex());
            } else {
                n4 = J3DHaeStream.pauseSample((int)n);
            }
        } else if (n2 == 2) {
            if (n3 == 3 || n3 == 2) {
                n4 = J3DHaeClip.pauseSamples((int)n, (int)((JSPositionalSample)jSSample).getSecondIndex());
                n4 = J3DHaeClip.pauseSample((int)((JSPositionalSample)jSSample).getReverbIndex());
            } else {
                n4 = J3DHaeClip.pauseSample((int)n);
            }
        } else if (n2 == 3 || n2 == 3) {
            n4 = J3DHaeMidi.pauseSample((int)n);
        }
    }

    public int prepareSound(int n, MediaContainer mediaContainer) {
        URL uRL;
        if (mediaContainer == null) {
            return -1;
        }
        String string = new String(mediaContainer.getURL());
        ArrayList arrayList = this.getSampleList();
        int n2 = 1;
        try {
            uRL = new URL(string);
        }
        catch (Exception exception) {
            return -1;
        }
        int n3 = -1;
        n3 = this.loadSound(uRL, mediaContainer.getCacheEnable());
        if (n3 == -1) {
            return -1;
        }
        int n4 = J3DHaeStream.getDataType((int)n3);
        if (n4 == -1) {
            return -1;
        }
        ArrayList arrayList2 = arrayList;
        synchronized (arrayList2) {
            JSSample jSSample;
            int n5 = arrayList.size();
            if (n3 >= arrayList.size()) {
                arrayList.ensureCapacity(n3 + 1);
                n2 = 1;
                int n6 = n5;
                while (n6 < n3) {
                    arrayList.add(n6, null);
                    ++n6;
                }
            } else {
                n2 = 2;
            }
            if (n == 3) {
                jSSample = new JSDirectionalSample();
                if (n2 == 2) {
                    arrayList.set(n3, jSSample);
                } else {
                    arrayList.add(n3, jSSample);
                }
            } else if (n == 2) {
                jSSample = new JSPositionalSample();
                if (n2 == 2) {
                    arrayList.set(n3, jSSample);
                } else {
                    arrayList.add(n3, jSSample);
                }
            } else {
                jSSample = new JSSample();
                if (n2 == 2) {
                    arrayList.set(n3, jSSample);
                } else {
                    arrayList.add(n3, jSSample);
                }
            }
            if ((n == 2 || n == 3) && n4 != 3 && n4 != 3) {
                int n7;
                int n8 = -1;
                int n9 = -1;
                n8 = this.loadSound(uRL, mediaContainer.getCacheEnable());
                n9 = this.loadSound(uRL, mediaContainer.getCacheEnable());
                if (n8 == -1 || n9 == -1) {
                    this.clearSound(n3);
                    if (n8 != -1) {
                        this.clearSound(n8);
                    }
                    arrayList.set(n3, null);
                    int n10 = -1;
                    Object var11_17 = null;
                    return n10;
                }
                JSPositionalSample jSPositionalSample = (JSPositionalSample)arrayList.get(n3);
                int n11 = -1;
                n11 = n8 < n9 ? n9 : n8;
                if (n11 >= (n7 = arrayList.size())) {
                    arrayList.ensureCapacity(n11 + 1);
                }
                if (n8 >= n7) {
                    n2 = 1;
                    arrayList.add(n8, jSPositionalSample);
                } else {
                    n2 = 2;
                    arrayList.set(n8, jSPositionalSample);
                }
                jSPositionalSample.setSecondIndex(n8);
                if (n9 >= n7) {
                    n2 = 1;
                    arrayList.add(n9, jSPositionalSample);
                } else {
                    n2 = 2;
                    arrayList.set(n9, jSPositionalSample);
                }
                jSPositionalSample.setReverbIndex(n9);
            }
        }
        JSSample jSSample = (JSSample)arrayList.get(n3);
        jSSample.setDirtyFlags(65535);
        jSSample.setSoundType(n);
        jSSample.setSoundData(mediaContainer);
        jSSample.setDataType(n4);
        return n3;
    }

    void scaleSampleRate(int n, float f) {
        JSSample jSSample = (JSSample)this.samples.get(n);
        int n2 = jSSample.getDataType();
        int n3 = jSSample.getSoundType();
        if (n2 == 1) {
            J3DHaeStream.scaleSampleRate((int)n, (float)f);
            if (n3 != 1) {
                J3DHaeStream.scaleSampleRate((int)((JSPositionalSample)jSSample).getSecondIndex(), (float)f);
                J3DHaeStream.scaleSampleRate((int)((JSPositionalSample)jSSample).getReverbIndex(), (float)f);
            }
        } else if (n2 == 2) {
            J3DHaeClip.scaleSampleRate((int)n, (float)f);
            if (n3 != 1) {
                J3DHaeClip.scaleSampleRate((int)((JSPositionalSample)jSSample).getSecondIndex(), (float)f);
                J3DHaeClip.scaleSampleRate((int)((JSPositionalSample)jSSample).getReverbIndex(), (float)f);
            }
        } else if (n2 == 3 || n2 == 3) {
            J3DHaeMidi.scaleSampleRate((int)n, (float)f);
        }
    }

    public void setDirection(int n, Vector3d vector3d) {
        super.setDirection(n, vector3d);
        JSDirectionalSample jSDirectionalSample = (JSDirectionalSample)this.samples.get(n);
        int n2 = jSDirectionalSample.getSoundType();
        if (n2 == 3) {
            jSDirectionalSample.setXformedDirection();
        }
    }

    void setFilter(int n, boolean bl, float f) {
        JSPositionalSample jSPositionalSample = (JSPositionalSample)this.samples.get(n);
        int n2 = jSPositionalSample.getDataType();
        if (n2 == 3 || n2 == 3) {
            return;
        }
        int n3 = jSPositionalSample.getSecondIndex();
        if (n2 == 2) {
            J3DHaeStream.setFiltering((int)n, (boolean)bl, (float)f);
            J3DHaeStream.setFiltering((int)n3, (boolean)bl, (float)f);
        } else {
            J3DHaeStream.setFiltering((int)n, (boolean)bl, (float)f);
            J3DHaeStream.setFiltering((int)n3, (boolean)bl, (float)f);
        }
    }

    public void setLoop(int n, int n2) {
        JSSample jSSample = (JSSample)this.samples.get(n);
        int n3 = jSSample.getDataType();
        if ((n3 == 1 || n3 == 2) && n2 == -1) {
            n2 = 0x7FFFFFF;
        }
        super.setLoop(n, n2);
    }

    public void setPosition(int n, Point3d point3d) {
        super.setPosition(n, point3d);
        JSPositionalSample jSPositionalSample = (JSPositionalSample)this.samples.get(n);
        int n2 = jSPositionalSample.getSoundType();
        if (n2 == 2 || n2 == 3) {
            jSPositionalSample.setXformedPosition();
        }
    }

    public void setReflectionCoefficient(float f) {
        super.setReflectionCoefficient(f);
        this.reverbDirty |= REFLECTION_COEFF_CHANGED;
    }

    void setReverb(int n) {
        JSSample jSSample = (JSSample)this.samples.get(n);
        int n2 = jSSample.getSoundType();
        int n3 = jSSample.getDataType();
        if (n2 == 3 || n2 == 2) {
            int n4 = ((JSPositionalSample)this.samples.get(n)).getReverbIndex();
            if (n3 == 1) {
                J3DHaeStream.setReverb((int)n4, (int)this.reverbType, (boolean)this.reverbOn);
            } else if (n3 == 2) {
                J3DHaeClip.setReverb((int)n4, (int)this.reverbType, (boolean)this.reverbOn);
            } else if (n3 == 3 || n3 == 3) {
                J3DHaeMidi.setReverb((int)n4, (int)this.reverbType, (boolean)this.reverbOn);
            }
        }
    }

    public void setReverbDelay(float f) {
        super.setReverbDelay(f);
        this.reverbDirty |= REVERB_DELAY_CHANGED;
    }

    public void setReverbOrder(int n) {
        super.setReverbOrder(n);
        this.reverbDirty |= REVERB_ORDER_CHANGED;
    }

    void setStereoDelay(int n, int n2, int n3) {
        JSSample jSSample = (JSSample)this.samples.get(n);
        int n4 = jSSample.getDataType();
        int n5 = jSSample.getSoundType();
        if (n4 == 1) {
            if (n5 == 3 || n5 == 2) {
                J3DHaeStream.setSampleDelay((int)n, (int)n2);
                J3DHaeStream.setSampleDelay((int)((JSPositionalSample)jSSample).getSecondIndex(), (int)n3);
            } else {
                J3DHaeStream.setSampleDelay((int)n, (int)0);
            }
        } else if (n4 == 2) {
            if (n5 == 3 || n5 == 2) {
                J3DHaeClip.setSampleDelay((int)n, (int)n2);
                J3DHaeClip.setSampleDelay((int)((JSPositionalSample)jSSample).getSecondIndex(), (int)n3);
            } else {
                J3DHaeClip.setSampleDelay((int)n, (int)0);
            }
        } else if (n4 == 3 || n4 == 3) {
            J3DHaeClip.setSampleDelay((int)n, (int)0);
        } else {
            return;
        }
    }

    void setStereoGain(int n, float f, float f2) {
        JSSample jSSample = (JSSample)this.samples.get(n);
        AuralParameters auralParameters = this.getAuralParameters();
        int n2 = jSSample.getDataType();
        int n3 = jSSample.getSoundType();
        boolean bl = jSSample.getMuteFlag();
        float f3 = 0.0f;
        if (!bl && this.reverbOn) {
            f3 = jSSample.getGain() * auralParameters.getReflectionCoefficient();
        }
        if (n2 == 1) {
            J3DHaeStream.setSampleGain((int)n, (float)f);
            if (n3 == 3 || n3 == 2) {
                J3DHaeStream.setSampleGain((int)((JSPositionalSample)jSSample).getSecondIndex(), (float)f2);
                J3DHaeStream.setSampleGain((int)((JSPositionalSample)jSSample).getReverbIndex(), (float)f3);
            }
        } else if (n2 == 2) {
            J3DHaeClip.setSampleGain((int)n, (float)f);
            if (n3 == 3 || n3 == 2) {
                J3DHaeClip.setSampleGain((int)((JSPositionalSample)jSSample).getSecondIndex(), (float)f2);
                J3DHaeClip.setSampleGain((int)((JSPositionalSample)jSSample).getReverbIndex(), (float)f3);
            }
        } else if (n2 == 3 || n2 == 3) {
            J3DHaeMidi.setSampleGain((int)n, (float)(f + f2));
        } else {
            return;
        }
    }

    public void setVworldXfrm(int n, Transform3D transform3D) {
        super.setVworldXfrm(n, transform3D);
        JSPositionalSample jSPositionalSample = (JSPositionalSample)this.samples.get(n);
        int n2 = jSPositionalSample.getSoundType();
        jSPositionalSample.setVWrldXfrmFlag(true);
        if (n2 == 2 || n2 == 3) {
            jSPositionalSample.setXformedPosition();
        }
        if (n2 == 3) {
            JSDirectionalSample jSDirectionalSample = (JSDirectionalSample)this.samples.get(n);
            jSDirectionalSample.setXformedDirection();
        }
    }

    public int startSample(int n) {
        float f;
        int n2 = -1;
        JSSample jSSample = (JSSample)this.samples.get(n);
        AuralParameters auralParameters = this.getAuralParameters();
        int n3 = jSSample.getSoundType();
        boolean bl = jSSample.getMuteFlag();
        if (bl) {
            jSSample.setLoopCount(0);
            jSSample.leftGain = 0.0f;
            jSSample.rightGain = 0.0f;
            jSSample.leftDelay = 0;
            jSSample.rightDelay = 0;
            if (n3 != 1) {
                this.setFilter(n, false, -1.0f);
            }
        } else {
            jSSample.render(jSSample.getDirtyFlags(), this.getView(), auralParameters);
            this.scaleSampleRate(n, jSSample.rateRatio);
            if (n3 != 1) {
                this.setFilter(n, jSSample.getFilterFlag(), jSSample.getFilterFreq());
            }
        }
        int n4 = jSSample.getDataType();
        int n5 = jSSample.getLoopCount();
        float f2 = jSSample.leftGain;
        float f3 = jSSample.rightGain;
        int n6 = (int)((float)jSSample.leftDelay * auralParameters.getRolloff());
        int n7 = (int)((float)jSSample.rightDelay * auralParameters.getRolloff());
        if (n4 == 1) {
            if (n3 == 1) {
                n2 = J3DHaeStream.startSample((int)n, (int)n5, (float)f2);
            } else {
                n2 = J3DHaeStream.startSamples((int)n, (int)((JSPositionalSample)jSSample).getSecondIndex(), (int)n5, (float)f2, (float)f3, (int)n6, (int)n7);
                f = 0.0f;
                if (!bl && this.reverbOn) {
                    f = jSSample.getGain() * auralParameters.getReflectionCoefficient();
                }
                int n8 = J3DHaeStream.startSample((int)((JSPositionalSample)jSSample).getReverbIndex(), (int)n5, (float)f);
            }
        } else if (n4 == 2) {
            if (n3 == 1) {
                n2 = J3DHaeClip.startSample((int)n, (int)n5, (float)f2);
            } else {
                n2 = J3DHaeClip.startSamples((int)n, (int)((JSPositionalSample)jSSample).getSecondIndex(), (int)n5, (float)f2, (float)f3, (int)n6, (int)n7);
                f = 0.0f;
                if (!bl && this.reverbOn) {
                    f = jSSample.getGain() * auralParameters.getReflectionCoefficient();
                }
                int n9 = J3DHaeClip.startSample((int)((JSPositionalSample)jSSample).getReverbIndex(), (int)n5, (float)f);
            }
        } else if (n4 == 3 || n4 == 3) {
            n2 = n3 == 1 ? J3DHaeMidi.startSample((int)n, (int)n5, (float)f2) : J3DHaeMidi.startSamples((int)n, (int)((JSPositionalSample)jSSample).getSecondIndex(), (int)n5, (float)f2, (float)f3, (int)n6, (int)n7);
        } else {
            return -1;
        }
        if (n2 < 0) {
            return -1;
        }
        if (!bl) {
            if (this.reverbDirty > 0) {
                f = auralParameters.getReverbDelay() * auralParameters.getRolloff();
                this.calcReverb(n, auralParameters.getReflectionCoefficient(), f, auralParameters.getReverbOrder());
            }
            this.setReverb(n);
        }
        return n2;
    }

    public int stopSample(int n) {
        JSSample jSSample = (JSSample)this.samples.get(n);
        int n2 = jSSample.getDataType();
        int n3 = jSSample.getSoundType();
        int n4 = 0;
        if (n2 == 1) {
            if (n3 == 3 || n3 == 2) {
                n4 = J3DHaeStream.stopSamples((int)n, (int)((JSPositionalSample)jSSample).getSecondIndex());
                n4 = J3DHaeStream.stopSample((int)((JSPositionalSample)jSSample).getReverbIndex());
            } else {
                n4 = J3DHaeStream.stopSample((int)n);
            }
        } else if (n2 == 2) {
            if (n3 == 3 || n3 == 2) {
                n4 = J3DHaeClip.stopSamples((int)n, (int)((JSPositionalSample)jSSample).getSecondIndex());
                n4 = J3DHaeClip.stopSample((int)((JSPositionalSample)jSSample).getReverbIndex());
            } else {
                n4 = J3DHaeClip.stopSample((int)n);
            }
        } else if (n2 == 3 || n2 == 3) {
            n4 = J3DHaeMidi.stopSample((int)n);
        } else {
            return -1;
        }
        if (n4 < 0) {
            return -1;
        }
        jSSample.stop();
        return 0;
    }

    public void unmuteSample(int n) {
        JSSample jSSample = (JSSample)this.samples.get(n);
        jSSample.setMuteFlag(false);
        this.reverbDirty = 65535;
        jSSample.setDirtyFlags(65535);
    }

    public void unpauseSample(int n) {
        JSSample jSSample = (JSSample)this.samples.get(n);
        int n2 = jSSample.getDataType();
        int n3 = jSSample.getSoundType();
        int n4 = 0;
        if (n2 == 1) {
            if (n3 == 3 || n3 == 2) {
                n4 = J3DHaeStream.unpauseSamples((int)n, (int)((JSPositionalSample)jSSample).getSecondIndex());
                n4 = J3DHaeStream.unpauseSample((int)((JSPositionalSample)jSSample).getReverbIndex());
            } else {
                n4 = J3DHaeStream.unpauseSample((int)n);
            }
        } else if (n2 == 2) {
            if (n3 == 3 || n3 == 2) {
                n4 = J3DHaeClip.unpauseSamples((int)n, (int)((JSPositionalSample)jSSample).getSecondIndex());
                n4 = J3DHaeClip.unpauseSample((int)((JSPositionalSample)jSSample).getReverbIndex());
            } else {
                n4 = J3DHaeClip.unpauseSample((int)n);
            }
        } else if (n2 == 3 || n2 == 3) {
            n4 = J3DHaeMidi.unpauseSample((int)n);
        }
    }

    public void updateSample(int n) {
        JSSample jSSample = (JSSample)this.samples.get(n);
        int n2 = jSSample.getLoopCount();
        int n3 = jSSample.getSoundType();
        boolean bl = jSSample.getMuteFlag();
        if (bl) {
            float f = jSSample.leftGain;
            float f2 = jSSample.rightGain;
            if (f != 0.0f || f2 != 0.0f) {
                jSSample.rightGain = 0.0f;
                jSSample.leftGain = 0.0f;
                this.setStereoGain(n, 0.0f, 0.0f);
            }
            if (n3 != 1) {
                this.setFilter(n, false, -1.0f);
            }
        } else {
            AuralParameters auralParameters = this.getAuralParameters();
            if (this.reverbDirty > 0) {
                float f = auralParameters.getReverbDelay() * auralParameters.getRolloff();
                this.calcReverb(n, auralParameters.getReflectionCoefficient(), f, auralParameters.getReverbOrder());
            }
            this.setReverb(n);
            jSSample.render(jSSample.getDirtyFlags(), this.getView(), auralParameters);
            if (n3 != 1) {
                this.setFilter(n, jSSample.getFilterFlag(), jSSample.getFilterFreq());
            }
            float f = jSSample.leftGain;
            float f3 = jSSample.rightGain;
            int n4 = (int)((float)jSSample.leftDelay * auralParameters.getRolloff());
            int n5 = (int)((float)jSSample.rightDelay * auralParameters.getRolloff());
            this.scaleSampleRate(n, jSSample.rateRatio);
            this.setStereoGain(n, f, f3);
            this.setStereoDelay(n, n4, n5);
        }
    }
}

