/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.internal.J3dUtilsI18N;
import javax.media.j3d.Alpha;
import javax.media.j3d.Interpolator;

abstract class FloatValueInterpolator
extends Interpolator {
    private float[] knots;
    private int knotsLength;
    protected int currentKnotIndex;
    protected float currentInterpolationRatio;
    protected float[] values;
    protected float currentValue;

    FloatValueInterpolator(Alpha alpha, float[] fArray, float[] fArray2) {
        super(alpha);
        this.knotsLength = fArray.length;
        if ((double)fArray[0] < -1.0E-4 || (double)fArray[0] > 1.0E-4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("FloatValueInterpolator0"));
        }
        if ((double)(fArray[this.knotsLength - 1] - 1.0f) < -1.0E-4 || (double)(fArray[this.knotsLength - 1] - 1.0f) > 1.0E-4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("FloatValueInterpolator1"));
        }
        this.knots = new float[this.knotsLength];
        int n = 0;
        while (n < this.knotsLength) {
            if (n > 0 && fArray[n] < fArray[n - 1]) {
                throw new IllegalArgumentException(J3dUtilsI18N.getString("FloatValueInterpolator2"));
            }
            this.knots[n] = fArray[n];
            ++n;
        }
        if (this.knotsLength != fArray2.length) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("FloatValueInterpolator3"));
        }
        this.values = new float[this.knotsLength];
        int n2 = 0;
        while (n2 < this.knotsLength) {
            this.values[n2] = fArray2[n2];
            ++n2;
        }
    }

    protected void computePathInterpolation() {
        float f = this.getAlpha().value();
        int n = 0;
        while (n < this.knotsLength) {
            if (n == 0 && f <= this.knots[n] || n > 0 && f >= this.knots[n - 1] && f <= this.knots[n]) {
                if (n == 0) {
                    this.currentInterpolationRatio = 0.0f;
                    this.currentKnotIndex = 0;
                    this.currentValue = this.values[0];
                    break;
                }
                this.currentInterpolationRatio = (f - this.knots[n - 1]) / (this.knots[n] - this.knots[n - 1]);
                this.currentKnotIndex = n - 1;
                this.currentValue = this.values[n - 1] + this.currentInterpolationRatio * (this.values[n] - this.values[n - 1]);
                break;
            }
            ++n;
        }
    }

    float getValue(int n) {
        return this.values[n];
    }

    void setValue(int n, float f) {
        this.values[n] = f;
    }
}

