/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.loaders.lw3d.DebugOutput;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

class LWOBFileReader
extends BufferedInputStream {
    static final int TRACE = 1;
    static final int VALUES = 2;
    static final int MISC = 4;
    static final int LINE_TRACE = 8;
    static final int NONE = 0;
    static final int EXCEPTION = 16;
    protected DebugOutput debugPrinter = new DebugOutput(127);
    protected String theFilename;
    protected int marker = 0;

    public LWOBFileReader(String string) throws FileNotFoundException {
        super(new FileInputStream(string));
    }

    protected void debugOutputLn(int n, String string) {
        if (string.equals("")) {
            this.debugPrinter.println(n, string);
        } else {
            this.debugPrinter.println(n, String.valueOf(this.getClass().getName()) + "::" + string);
        }
    }

    public String getFilename() {
        return this.theFilename;
    }

    public float getFloat() {
        return Float.intBitsToFloat(this.getInt());
    }

    public int getInt() {
        try {
            int n = 0;
            int n2 = 0;
            while (n2 < 4) {
                int n3 = this.read();
                if (n3 == -1) {
                    throw new IOException("Unexpected EOF");
                }
                n = n << 8 | n3;
                ++n2;
            }
            return n;
        }
        catch (Exception exception) {
            this.debugOutputLn(16, "getInt: " + exception);
            return 0;
        }
    }

    public int getMarker() {
        return this.marker;
    }

    public int getShortInt() {
        int n = 0;
        try {
            n = this.read();
            n = n << 8 | this.read();
            if ((n & 0x8000) != 0) {
                n |= 0xFFFF0000;
            }
        }
        catch (Exception exception) {
            this.debugOutputLn(16, "getShortInt: " + exception);
        }
        return n;
    }

    public String getString() {
        byte[] byArray = new byte[512];
        try {
            byte by;
            int n = 0;
            do {
                by = (byte)this.read();
                byArray[n++] = by;
            } while (by != 0);
            if (n % 2 != 0) {
                this.read();
            }
        }
        catch (Exception exception) {
            this.debugOutputLn(16, "getString: " + exception);
        }
        return new String(byArray);
    }

    public String getToken() {
        byte[] byArray = new byte[4];
        try {
            int n = this.read(byArray, 0, 4);
            if (n == -1) {
                this.debugOutputLn(8, "no token - returning null");
                return null;
            }
            return new String(byArray);
        }
        catch (Exception exception) {
            this.debugOutputLn(16, "getToken: " + exception);
            return null;
        }
    }

    public void getVerts(float[] fArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            fArray[n2 * 3] = this.getFloat();
            fArray[n2 * 3 + 1] = this.getFloat();
            fArray[n2 * 3 + 2] = -this.getFloat();
            ++n2;
        }
    }

    public int read() throws IOException {
        ++this.marker;
        return super.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 != -1) {
            this.marker += n3;
        }
        return n3;
    }

    public void skipLength(int n) {
        try {
            this.skip(n);
            this.marker += n;
        }
        catch (Exception exception) {
            this.debugOutputLn(16, "skipLength: " + exception);
        }
    }
}

