/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.GeomBuffer;
import com.sun.j3d.utils.geometry.Primitive;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3f;

public class Box
extends Primitive {
    public static final int FRONT = 0;
    public static final int BACK = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 3;
    public static final int TOP = 4;
    public static final int BOTTOM = 5;
    float xDim;
    float yDim;
    float zDim;
    int numTexUnit = 1;
    private static final float[] verts = new float[]{1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f};
    private static final double[] tcoords;
    private static final Vector3f[] normals;

    static {
        double[] dArray = new double[48];
        dArray[0] = 1.0;
        dArray[2] = 1.0;
        dArray[3] = 1.0;
        dArray[5] = 1.0;
        dArray[8] = 1.0;
        dArray[10] = 1.0;
        dArray[11] = 1.0;
        dArray[13] = 1.0;
        dArray[16] = 1.0;
        dArray[18] = 1.0;
        dArray[19] = 1.0;
        dArray[21] = 1.0;
        dArray[24] = 1.0;
        dArray[26] = 1.0;
        dArray[27] = 1.0;
        dArray[29] = 1.0;
        dArray[32] = 1.0;
        dArray[34] = 1.0;
        dArray[35] = 1.0;
        dArray[37] = 1.0;
        dArray[41] = 1.0;
        dArray[44] = 1.0;
        dArray[46] = 1.0;
        dArray[47] = 1.0;
        tcoords = dArray;
        normals = new Vector3f[]{new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f)};
    }

    public Box() {
        this(1.0f, 1.0f, 1.0f, 1, null);
    }

    public Box(float f, float f2, float f3, int n, Appearance appearance) {
        this(f, f2, f3, n, appearance, 1);
    }

    public Box(float f, float f2, float f3, int n, Appearance appearance, int n2) {
        this.xDim = f;
        this.yDim = f2;
        this.zDim = f3;
        this.flags = n;
        double d = (this.flags & 4) != 0 ? -1.0 : 1.0;
        TransformGroup transformGroup = new TransformGroup();
        transformGroup.setCapability(12);
        this.addChild((Node)transformGroup);
        Shape3D[] shape3DArray = new Shape3D[6];
        int n3 = 0;
        while (n3 <= 5) {
            GeomBuffer geomBuffer = new GeomBuffer(4, n2);
            geomBuffer.begin(1);
            int n4 = 0;
            while (n4 < 2) {
                geomBuffer.normal3d((double)Box.normals[n3].x * d, (double)Box.normals[n3].y * d, (double)Box.normals[n3].z * d);
                geomBuffer.texCoord2d(tcoords[n3 * 8 + n4 * 2], tcoords[n3 * 8 + n4 * 2 + 1]);
                geomBuffer.vertex3d((double)verts[n3 * 12 + n4 * 3] * (double)f, (double)verts[n3 * 12 + n4 * 3 + 1] * (double)f2, (double)verts[n3 * 12 + n4 * 3 + 2] * (double)f3);
                ++n4;
            }
            int n5 = 3;
            while (n5 > 1) {
                geomBuffer.normal3d((double)Box.normals[n3].x * d, (double)Box.normals[n3].y * d, (double)Box.normals[n3].z * d);
                geomBuffer.texCoord2d(tcoords[n3 * 8 + n5 * 2], tcoords[n3 * 8 + n5 * 2 + 1]);
                geomBuffer.vertex3d((double)verts[n3 * 12 + n5 * 3] * (double)f, (double)verts[n3 * 12 + n5 * 3 + 1] * (double)f2, (double)verts[n3 * 12 + n5 * 3 + 2] * (double)f3);
                --n5;
            }
            geomBuffer.end();
            shape3DArray[n3] = new Shape3D((Geometry)geomBuffer.getGeom(this.flags));
            this.numVerts = geomBuffer.getNumVerts();
            this.numTris = geomBuffer.getNumTris();
            if ((this.flags & 0x40) != 0) {
                shape3DArray[n3].setCapability(14);
                shape3DArray[n3].setCapability(15);
            }
            transformGroup.addChild((Node)shape3DArray[n3]);
            ++n3;
        }
        if (appearance == null) {
            this.setAppearance();
        } else {
            this.setAppearance(appearance);
        }
    }

    public Box(float f, float f2, float f3, Appearance appearance) {
        this(f, f2, f3, 1, appearance);
    }

    public Node cloneNode(boolean bl) {
        Box box = new Box(this.xDim, this.yDim, this.zDim, this.flags, this.getAppearance());
        box.duplicateNode((Node)this, bl);
        return box;
    }

    public void duplicateNode(Node node, boolean bl) {
        super.duplicateNode(node, bl);
    }

    public Shape3D getShape(int n) {
        if (n >= 0 && n <= 5) {
            return (Shape3D)((Group)this.getChild(0)).getChild(n);
        }
        return null;
    }

    public void setAppearance(Appearance appearance) {
        ((Shape3D)((Group)this.getChild(0)).getChild(4)).setAppearance(appearance);
        ((Shape3D)((Group)this.getChild(0)).getChild(3)).setAppearance(appearance);
        ((Shape3D)((Group)this.getChild(0)).getChild(2)).setAppearance(appearance);
        ((Shape3D)((Group)this.getChild(0)).getChild(0)).setAppearance(appearance);
        ((Shape3D)((Group)this.getChild(0)).getChild(1)).setAppearance(appearance);
        ((Shape3D)((Group)this.getChild(0)).getChild(5)).setAppearance(appearance);
    }
}

