/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.picking;

import com.sun.j3d.internal.Distance;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.picking.PickIntersection;
import java.util.ArrayList;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.CompressedGeometry;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Group;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.IndexedLineArray;
import javax.media.j3d.IndexedLineStripArray;
import javax.media.j3d.IndexedPointArray;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.IndexedTriangleFanArray;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Link;
import javax.media.j3d.Morph;
import javax.media.j3d.Node;
import javax.media.j3d.PickBounds;
import javax.media.j3d.PickCone;
import javax.media.j3d.PickConeRay;
import javax.media.j3d.PickConeSegment;
import javax.media.j3d.PickCylinder;
import javax.media.j3d.PickCylinderRay;
import javax.media.j3d.PickCylinderSegment;
import javax.media.j3d.PickPoint;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickSegment;
import javax.media.j3d.PickShape;
import javax.media.j3d.PointArray;
import javax.media.j3d.QuadArray;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class PickResult {
    public static final int SHAPE3D = 1;
    public static final int MORPH = 2;
    public static final int PRIMITIVE = 4;
    public static final int LINK = 8;
    public static final int GROUP = 16;
    public static final int TRANSFORM_GROUP = 32;
    public static final int BRANCH_GROUP = 64;
    public static final int SWITCH = 128;
    static boolean debug = false;
    boolean firstIntersectOnly = false;
    SceneGraphPath pickedSceneGraphPath = null;
    Node pickedNode = null;
    GeometryArray[] geometryArrays = null;
    Shape3D[] compressGeomShape3Ds = null;
    Transform3D localToVWorld = null;
    PickShape pickShape = null;
    int pickShapeType = -1;
    Vector3d pickShapeDir = new Vector3d();
    Point3d pickShapeStart = new Point3d();
    Point3d pickShapeEnd = new Point3d();
    Bounds pickShapeBounds = null;
    ArrayList intersections = null;
    int[] pntVertIdx = new int[1];
    int[] pntCoordIdx = new int[1];
    Point3d[] point = new Point3d[1];
    int[] lineVertIdx = new int[2];
    int[] lineCoordIdx = new int[2];
    Point3d[] linePts = new Point3d[2];
    int[] triVertIdx = new int[3];
    int[] triCoordIdx = new int[3];
    Point3d[] triPts = new Point3d[3];
    int[] quadVertIdx = new int[4];
    int[] quadCoordIdx = new int[4];
    Point3d[] quadPts = new Point3d[4];
    static final double FUZZ = 1.0E-6;
    static final int PICK_SHAPE_RAY = 1;
    static final int PICK_SHAPE_SEGMENT = 2;
    static final int PICK_SHAPE_POINT = 3;
    static final int PICK_SHAPE_BOUNDING_BOX = 4;
    static final int PICK_SHAPE_BOUNDING_SPHERE = 5;
    static final int PICK_SHAPE_BOUNDING_POLYTOPE = 6;
    static final int PICK_SHAPE_CYLINDER = 7;
    static final int PICK_SHAPE_CONE = 8;

    PickResult() {
    }

    public PickResult(Node node, Transform3D transform3D, PickShape pickShape) {
        if (!(node instanceof Shape3D) && !(node instanceof Morph)) {
            throw new IllegalArgumentException();
        }
        this.pickedNode = node;
        this.localToVWorld = transform3D;
        this.pickShape = pickShape;
        this.initPickShape();
    }

    public PickResult(SceneGraphPath sceneGraphPath, PickShape pickShape) {
        this.pickedSceneGraphPath = sceneGraphPath;
        this.pickedNode = sceneGraphPath.getObject();
        this.localToVWorld = sceneGraphPath.getTransform();
        this.pickShape = pickShape;
        this.initPickShape();
    }

    static double det2D(Point2d point2d, Point2d point2d2, Point2d point2d3) {
        return (point2d3.x - point2d.x) * (point2d.y - point2d2.y) + (point2d.y - point2d3.y) * (point2d.x - point2d2.x);
    }

    static boolean edgeIntersectPlane(Vector3d vector3d, Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4) {
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        vector3d2.set((Tuple3d)point3d);
        double d = vector3d.dot(vector3d2);
        vector3d3.x = point3d3.x - point3d2.x;
        vector3d3.y = point3d3.y - point3d2.y;
        vector3d3.z = point3d3.z - point3d2.z;
        double d2 = vector3d.dot(vector3d3);
        if (d2 == 0.0) {
            return false;
        }
        vector3d2.set((Tuple3d)point3d2);
        double d3 = (d - vector3d.dot(vector3d2)) / d2;
        if (d3 < 0.0 || d3 > 1.0) {
            return false;
        }
        point3d4.x = point3d2.x + d3 * vector3d3.x;
        point3d4.y = point3d2.y + d3 * vector3d3.y;
        point3d4.z = point3d2.z + d3 * vector3d3.z;
        return true;
    }

    static boolean edgeIntersectPolygon2D(Vector3d vector3d, Point3d[] point3dArray, Point3d[] point3dArray2) {
        Point2d[] point2dArray = new Point2d[point3dArray.length];
        Point2d[] point2dArray2 = new Point2d[2];
        double d = Math.abs(vector3d.x);
        double d2 = Math.abs(vector3d.y);
        double d3 = Math.abs(vector3d.z);
        int n = d > d2 ? 0 : 1;
        if (n == 0) {
            if (d < d3) {
                n = 2;
            }
        } else if (n == 1 && d2 < d3) {
            n = 2;
        }
        int n2 = 0;
        while (n2 < point3dArray.length) {
            point2dArray[n2] = new Point2d();
            switch (n) {
                case 0: {
                    point2dArray[n2].x = point3dArray[n2].y;
                    point2dArray[n2].y = point3dArray[n2].z;
                    break;
                }
                case 1: {
                    point2dArray[n2].x = point3dArray[n2].x;
                    point2dArray[n2].y = point3dArray[n2].z;
                    break;
                }
                case 2: {
                    point2dArray[n2].x = point3dArray[n2].x;
                    point2dArray[n2].y = point3dArray[n2].y;
                    break;
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < 2) {
            point2dArray2[n2] = new Point2d();
            switch (n) {
                case 0: {
                    point2dArray2[n2].x = point3dArray2[n2].y;
                    point2dArray2[n2].y = point3dArray2[n2].z;
                    break;
                }
                case 1: {
                    point2dArray2[n2].x = point3dArray2[n2].x;
                    point2dArray2[n2].y = point3dArray2[n2].z;
                    break;
                }
                case 2: {
                    point2dArray2[n2].x = point3dArray2[n2].x;
                    point2dArray2[n2].y = point3dArray2[n2].y;
                    break;
                }
            }
            ++n2;
        }
        boolean[][] blArray = new boolean[2][point3dArray.length];
        int n3 = 0;
        while (n3 < point3dArray.length) {
            n2 = 0;
            while (n2 < 2) {
                blArray[n2][n3] = n3 < point3dArray.length - 1 ? PickResult.det2D(point2dArray[n3], point2dArray[n3 + 1], point2dArray2[n2]) < 0.0 : PickResult.det2D(point2dArray[n3], point2dArray[0], point2dArray2[n2]) < 0.0;
                ++n2;
            }
            if (!blArray[0][n3] && !blArray[1][n3]) {
                return false;
            }
            ++n3;
        }
        boolean bl = true;
        n2 = 0;
        while (n2 < point3dArray.length) {
            if (!blArray[0][n2]) {
                bl = false;
                break;
            }
            ++n2;
        }
        if (bl) {
            return true;
        }
        bl = true;
        n2 = 0;
        while (n2 < point3dArray.length) {
            if (!blArray[1][n2]) {
                bl = false;
                break;
            }
            ++n2;
        }
        if (bl) {
            return true;
        }
        int n4 = 0;
        n2 = 0;
        while (n2 < point3dArray.length) {
            if (PickResult.det2D(point2dArray2[0], point2dArray2[1], point2dArray[n2]) < 0.0) {
                ++n4;
            }
            ++n2;
        }
        return n4 != 0 && n4 != point3dArray.length;
    }

    static boolean edgeIntersectSphere(BoundingSphere boundingSphere, Point3d point3d, Point3d point3d2) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Point3d point3d3 = new Point3d();
        boundingSphere.getCenter(point3d3);
        double d = boundingSphere.getRadius();
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        vector3d2.x = point3d3.x - point3d.x;
        vector3d2.y = point3d3.y - point3d.y;
        vector3d2.z = point3d3.z - point3d.z;
        double d2 = vector3d.dot(vector3d2);
        if (d2 < 0.0) {
            return false;
        }
        double d3 = vector3d.lengthSquared();
        double d4 = d2 * d2 / d3;
        if (d4 < d3) {
            return false;
        }
        double d5 = d * d;
        double d6 = vector3d2.lengthSquared();
        return d6 - d4 <= d5;
    }

    static double generalStandardSimplexSolver(double[][] dArray, double d) {
        boolean bl = false;
        int n = dArray.length;
        int n2 = dArray[0].length;
        boolean bl2 = false;
        boolean bl3 = false;
        if (bl) {
            System.out.println("The number of rows is : " + n);
            System.out.println("The number of columns is : " + n2);
        }
        while (!bl2) {
            double d2;
            if (bl) {
                System.out.println("input problem tableau is:");
                int n3 = 0;
                while (n3 < n) {
                    int n4 = 0;
                    while (n4 < n2) {
                        System.out.println("kth, jth value is:" + n3 + " " + n4 + " : " + dArray[n3][n4]);
                        ++n4;
                    }
                    ++n3;
                }
            }
            int n5 = 0;
            double d3 = 0.0;
            int n6 = -1;
            while (n5 < n2 - 1) {
                d2 = dArray[n - 1][n5];
                if (d2 < d3) {
                    d3 = d2;
                    n6 = n5;
                }
                ++n5;
            }
            if (n6 == -1) {
                bl2 = true;
            }
            if (bl2) continue;
            double d4 = Double.POSITIVE_INFINITY;
            double d5 = 0.0;
            int n7 = -1;
            n5 = 0;
            while (n5 < n - 1) {
                d2 = dArray[n5][n6];
                double d6 = dArray[n5][n2 - 1];
                if (d2 == 0.0) {
                    if (bl) {
                        System.out.println("Division by zero has occurred");
                        System.out.println("Within the linear program solver");
                        System.out.println("Ignoring the zero as a potential pivot");
                    }
                } else if (d2 < 0.0 || d6 < 0.0) {
                    if (bl) {
                        System.out.println("Ignoring cases where element is negative");
                        System.out.println("The value of element is: " + d2);
                        System.out.println("The value of end Element is: " + d6);
                    }
                } else {
                    d5 = d6 / d2;
                    if (bl) {
                        System.out.println("The value of element is: " + d2);
                        System.out.println("The value of endElement is: " + d6);
                        System.out.println("The value of ratio is: " + d5);
                        System.out.println("The value of prevRatio is: " + d4);
                        System.out.println("Value of ratio <= prevRatio is :" + (d5 <= d4));
                    }
                    if (d5 <= d4) {
                        if (bl) {
                            System.out.println("updating prevRatio with ratio");
                        }
                        d4 = d5;
                        n7 = n5;
                    }
                }
                ++n5;
            }
            if (n7 == -1) {
                if (bl) {
                    System.out.println("UNABLE TO FIND SOLUTION");
                    System.out.println("The system is infeasable or unbounded");
                }
                return Double.POSITIVE_INFINITY;
            }
            double d7 = dArray[n7][n6];
            if (bl) {
                System.out.println("The value of row index is: " + n7);
                System.out.println("The value of col index is: " + n6);
                System.out.println("The value of pivotValue is: " + d7);
            }
            n5 = 0;
            while (n5 < n2) {
                dArray[n7][n5] = dArray[n7][n5] / d7;
                ++n5;
            }
            n5 = 0;
            while (n5 < n) {
                if (n5 != n7) {
                    double d8 = dArray[n5][n6];
                    int n8 = 0;
                    while (n8 < n2) {
                        dArray[n5][n8] = dArray[n5][n8] - d8 * dArray[n7][n8];
                        ++n8;
                    }
                }
                ++n5;
            }
        }
        return dArray[n - 1][n2 - 1];
    }

    boolean generateIntersections() {
        if (this.geometryArrays == null) {
            this.storeGeometry();
        }
        this.intersections = new ArrayList();
        int n = 0;
        int n2 = 0;
        while (n2 < this.geometryArrays.length) {
            if (this.intersect(n2, this.firstIntersectOnly)) {
                if (this.firstIntersectOnly) {
                    return true;
                }
                ++n;
            }
            ++n2;
        }
        return n > 0;
    }

    public PickIntersection getClosestIntersection(Point3d point3d) {
        PickIntersection pickIntersection = null;
        PickIntersection pickIntersection2 = null;
        Point3d point3d2 = null;
        double d = Double.MAX_VALUE;
        double d2 = 0.0;
        if (point3d == null) {
            return null;
        }
        if (this.intersections == null) {
            this.generateIntersections();
        }
        int n = 0;
        while (n < this.intersections.size()) {
            pickIntersection2 = this.getIntersection(n);
            if (pickIntersection2 != null && (point3d2 = pickIntersection2.getPointCoordinatesVW()) != null && (d2 = point3d.distance(point3d2)) < d) {
                pickIntersection = pickIntersection2;
                d = d2;
            }
            ++n;
        }
        return pickIntersection;
    }

    public Shape3D[] getCompressedGeometryShape3Ds() {
        if (this.geometryArrays == null) {
            this.storeGeometry();
        }
        if (this.compressGeomShape3Ds == null) {
            return null;
        }
        return this.compressGeomShape3Ds;
    }

    public boolean getFirstPickEnable() {
        return this.firstIntersectOnly;
    }

    public GeometryArray getGeometryArray() {
        if (this.geometryArrays == null) {
            this.storeGeometry();
        }
        return this.geometryArrays[0];
    }

    public GeometryArray[] getGeometryArrays() {
        if (this.geometryArrays == null) {
            this.storeGeometry();
        }
        return this.geometryArrays;
    }

    public PickIntersection getIntersection(int n) {
        if (this.intersections == null) {
            this.generateIntersections();
        }
        return (PickIntersection)this.intersections.get(n);
    }

    public Transform3D getLocalToVworld() {
        return this.localToVWorld;
    }

    public Node getNode(int n) {
        if (this.pickedNode == null) {
            this.storeNode();
        }
        if (this.pickedNode instanceof Shape3D && (n & 1) != 0) {
            if (debug) {
                System.out.println("Shape3D found");
            }
            return this.pickedNode;
        }
        if (this.pickedNode instanceof Morph && (n & 2) != 0) {
            if (debug) {
                System.out.println("Morph found");
            }
            return this.pickedNode;
        }
        if (this.pickedSceneGraphPath == null) {
            return null;
        }
        int n2 = this.pickedSceneGraphPath.nodeCount() - 1;
        while (n2 >= 0) {
            Node node = this.pickedSceneGraphPath.getNode(n2);
            if (debug) {
                System.out.println("looking at node " + node);
            }
            if (node instanceof Primitive && (n & 4) != 0) {
                if (debug) {
                    System.out.println("Primitive found");
                }
                return node;
            }
            if (node instanceof Link && (n & 8) != 0) {
                if (debug) {
                    System.out.println("Link found");
                }
                return node;
            }
            if (node instanceof Switch && (n & 0x80) != 0) {
                if (debug) {
                    System.out.println("Switch found");
                }
                return node;
            }
            if (node instanceof TransformGroup && (n & 0x20) != 0) {
                if (debug) {
                    System.out.println("xform group found");
                }
                return node;
            }
            if (node instanceof BranchGroup && (n & 0x40) != 0) {
                if (debug) {
                    System.out.println("Branch group found");
                }
                return node;
            }
            if (node instanceof Group && (n & 0x10) != 0) {
                if (debug) {
                    System.out.println("Group found");
                }
                return node;
            }
            --n2;
        }
        return null;
    }

    public Node getObject() {
        if (this.pickedNode == null) {
            this.storeNode();
        }
        return this.pickedNode;
    }

    public PickShape getPickShape() {
        return this.pickShape;
    }

    public SceneGraphPath getSceneGraphPath() {
        return this.pickedSceneGraphPath;
    }

    void initPickShape() {
        if (this.pickShape instanceof PickRay) {
            ((PickRay)this.pickShape).get(this.pickShapeStart, this.pickShapeDir);
            this.pickShapeType = 1;
        } else if (this.pickShape instanceof PickSegment) {
            ((PickSegment)this.pickShape).get(this.pickShapeStart, this.pickShapeEnd);
            this.pickShapeDir.set(this.pickShapeEnd.x - this.pickShapeStart.x, this.pickShapeEnd.y - this.pickShapeStart.y, this.pickShapeEnd.z - this.pickShapeStart.z);
            this.pickShapeType = 2;
        } else if (this.pickShape instanceof PickBounds) {
            this.pickShapeBounds = ((PickBounds)this.pickShape).get();
            if (this.pickShapeBounds instanceof BoundingBox) {
                this.pickShapeType = 4;
            } else if (this.pickShapeBounds instanceof BoundingSphere) {
                this.pickShapeType = 5;
            } else if (this.pickShapeBounds instanceof BoundingPolytope) {
                this.pickShapeType = 6;
            }
        } else {
            if (this.pickShape instanceof PickPoint) {
                throw new RuntimeException("PointArray0");
            }
            if (this.pickShape instanceof PickCylinder) {
                this.pickShapeType = 7;
            } else if (this.pickShape instanceof PickCone) {
                this.pickShapeType = 8;
            } else {
                throw new RuntimeException("PickShape not supported for intersection");
            }
        }
    }

    static boolean inside(Point3d[] point3dArray, PickPoint pickPoint, int n) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        double d = 0.0;
        Vector3d vector3d4 = new Vector3d();
        double d2 = 0.0;
        Point3d point3d = new Point3d();
        pickPoint.get(point3d);
        int n2 = 0;
        while (n2 < point3dArray.length - 1) {
            vector3d.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
            vector3d.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
            vector3d.z = point3dArray[n2 + 1].z - point3dArray[n2++].z;
            if (vector3d.length() > 0.0) break;
        }
        int n3 = n2;
        while (n3 < point3dArray.length - 1) {
            vector3d2.x = point3dArray[n3 + 1].x - point3dArray[n3].x;
            vector3d2.y = point3dArray[n3 + 1].y - point3dArray[n3].y;
            vector3d2.z = point3dArray[n3 + 1].z - point3dArray[n3].z;
            if (vector3d2.length() > 0.0) break;
            ++n3;
        }
        if (n3 == point3dArray.length - 1) {
            return false;
        }
        if (n == 1) {
            vector3d3.cross(vector3d, vector3d2);
        } else {
            vector3d3.cross(vector3d2, vector3d);
        }
        if (vector3d3.length() == 0.0) {
            return false;
        }
        vector3d4.set((Tuple3d)point3dArray[0]);
        d = vector3d3.dot(vector3d4);
        vector3d4.set((Tuple3d)point3d);
        return !(d - vector3d3.dot(vector3d4) > 0.0);
    }

    final boolean intersect(int n, boolean bl) {
        int n2;
        GeometryArray geometryArray = this.geometryArrays[n];
        int n3 = geometryArray.getVertexCount();
        double[] dArray = null;
        float[] fArray = null;
        Point3d[] point3dArray = null;
        Point3f[] point3fArray = null;
        int n4 = geometryArray.getVertexFormat();
        if ((n4 & 0x80) == 0) {
            dArray = new double[n3 * 3];
            geometryArray.getCoordinates(0, dArray);
        } else if ((n4 & 0x100) == 0) {
            dArray = geometryArray.getCoordRefDouble();
            if (dArray == null && (fArray = geometryArray.getCoordRefFloat()) == null && (point3fArray = geometryArray.getCoordRef3f()) == null) {
                point3dArray = geometryArray.getCoordRef3d();
            }
        } else {
            fArray = geometryArray.getInterleavedVertices();
        }
        Point3d[] point3dArray2 = new Point3d[n3];
        if (debug) {
            System.out.println("localToVWorld = " + this.localToVWorld);
        }
        if ((n4 & 0x100) == 0) {
            if (dArray != null) {
                int n5 = 0;
                n2 = 0;
                while (n2 < n3) {
                    point3dArray2[n2] = new Point3d(dArray[n5++], dArray[n5++], dArray[n5++]);
                    this.localToVWorld.transform(point3dArray2[n2]);
                    ++n2;
                }
            } else if (fArray != null) {
                int n6 = 0;
                n2 = 0;
                while (n2 < n3) {
                    point3dArray2[n2] = new Point3d((double)fArray[n6++], (double)fArray[n6++], (double)fArray[n6++]);
                    this.localToVWorld.transform(point3dArray2[n2]);
                    ++n2;
                }
            } else if (point3fArray != null) {
                n2 = 0;
                while (n2 < n3) {
                    point3dArray2[n2] = new Point3d((double)point3fArray[n2].x, (double)point3fArray[n2].y, (double)point3fArray[n2].z);
                    this.localToVWorld.transform(point3dArray2[n2]);
                    ++n2;
                }
            } else {
                n2 = 0;
                while (n2 < n3) {
                    point3dArray2[n2] = new Point3d(point3dArray[n2].x, point3dArray[n2].y, point3dArray[n2].z);
                    this.localToVWorld.transform(point3dArray2[n2]);
                    ++n2;
                }
            }
        } else {
            int n7 = 0;
            if ((n4 & 4) == 4) {
                n7 += 3;
            } else if ((n4 & 0xC) == 12) {
                n7 += 4;
            }
            if ((n4 & 2) != 0) {
                n7 += 3;
            }
            if ((n4 & 0x20) == 32) {
                n7 += 2 * geometryArray.getTexCoordSetCount();
            } else if ((n4 & 0x40) == 64) {
                n7 += 3 * geometryArray.getTexCoordSetCount();
            }
            int n8 = n7 + 3;
            n2 = 0;
            while (n2 < n3) {
                point3dArray2[n2] = new Point3d((double)fArray[n7], (double)fArray[n7 + 1], (double)fArray[n7 + 2]);
                this.localToVWorld.transform(point3dArray2[n2]);
                n7 += n8;
                ++n2;
            }
        }
        PickIntersection pickIntersection = new PickIntersection(this, geometryArray);
        if (geometryArray instanceof PointArray) {
            return this.intersectPA((PointArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        }
        if (geometryArray instanceof IndexedPointArray) {
            pickIntersection.iGeom = (IndexedGeometryArray)geometryArray;
            return this.intersectIPA((IndexedPointArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        }
        if (geometryArray instanceof LineArray) {
            return this.intersectLA((LineArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        }
        if (geometryArray instanceof LineStripArray) {
            return this.intersectLSA((LineStripArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        }
        if (geometryArray instanceof IndexedLineArray) {
            pickIntersection.iGeom = (IndexedGeometryArray)geometryArray;
            return this.intersectILA((IndexedLineArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        }
        if (geometryArray instanceof IndexedLineStripArray) {
            pickIntersection.iGeom = (IndexedGeometryArray)geometryArray;
            return this.intersectILSA((IndexedLineStripArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        }
        if (geometryArray instanceof TriangleArray) {
            return this.intersectTA((TriangleArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        }
        if (geometryArray instanceof TriangleStripArray) {
            return this.intersectTSA((TriangleStripArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        }
        if (geometryArray instanceof TriangleFanArray) {
            return this.intersectTFA((TriangleFanArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        }
        if (geometryArray instanceof IndexedTriangleArray) {
            pickIntersection.iGeom = (IndexedGeometryArray)geometryArray;
            return this.intersectITA((IndexedTriangleArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        }
        if (geometryArray instanceof IndexedTriangleStripArray) {
            pickIntersection.iGeom = (IndexedGeometryArray)geometryArray;
            return this.intersectITSA((IndexedTriangleStripArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        }
        if (geometryArray instanceof IndexedTriangleFanArray) {
            pickIntersection.iGeom = (IndexedGeometryArray)geometryArray;
            return this.intersectITFA((IndexedTriangleFanArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        }
        if (geometryArray instanceof QuadArray) {
            return this.intersectQA((QuadArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        }
        if (geometryArray instanceof IndexedQuadArray) {
            pickIntersection.iGeom = (IndexedGeometryArray)geometryArray;
            return this.intersectIQA((IndexedQuadArray)geometryArray, n, point3dArray2, bl, pickIntersection);
        }
        throw new RuntimeException("incorrect class type");
    }

    static boolean intersectBoundingBox(Point3d[] point3dArray, BoundingBox boundingBox) {
        int[] nArray = new int[6];
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        boundingBox.getLower(point3d);
        boundingBox.getUpper(point3d2);
        int n = 0;
        while (n < 6) {
            nArray[n] = 0;
            ++n;
        }
        n = 0;
        while (n < point3dArray.length) {
            if (point3dArray[n].x >= point3d.x && point3dArray[n].x <= point3d2.x && point3dArray[n].y >= point3d.y && point3dArray[n].y <= point3d2.y && point3dArray[n].z >= point3d.z && point3dArray[n].z <= point3d2.z) {
                return true;
            }
            if (point3dArray[n].x < point3d.x) {
                nArray[0] = nArray[0] + 1;
            }
            if (point3dArray[n].y < point3d.y) {
                nArray[1] = nArray[1] + 1;
            }
            if (point3dArray[n].z < point3d.z) {
                nArray[2] = nArray[2] + 1;
            }
            if (point3dArray[n].x > point3d2.x) {
                nArray[3] = nArray[3] + 1;
            }
            if (point3dArray[n].y > point3d2.y) {
                nArray[4] = nArray[4] + 1;
            }
            if (point3dArray[n].z > point3d2.z) {
                nArray[5] = nArray[5] + 1;
            }
            ++n;
        }
        if (nArray[0] == point3dArray.length || nArray[1] == point3dArray.length || nArray[2] == point3dArray.length || nArray[3] == point3dArray.length || nArray[4] == point3dArray.length || nArray[5] == point3dArray.length) {
            return false;
        }
        Point3d[] point3dArray2 = new Point3d[4];
        n = 0;
        while (n < 4) {
            point3dArray2[n] = new Point3d();
            ++n;
        }
        point3dArray2[0].set(point3d.x, point3d.y, point3d.z);
        point3dArray2[1].set(point3d.x, point3d.y, point3d2.z);
        point3dArray2[2].set(point3d.x, point3d2.y, point3d2.z);
        point3dArray2[3].set(point3d.x, point3d2.y, point3d.z);
        if (PickResult.intersectPolygon(point3dArray2, point3dArray, false)) {
            return true;
        }
        point3dArray2[0].set(point3d2.x, point3d.y, point3d.z);
        point3dArray2[1].set(point3d2.x, point3d2.y, point3d.z);
        point3dArray2[2].set(point3d2.x, point3d2.y, point3d2.z);
        point3dArray2[3].set(point3d2.x, point3d.y, point3d2.z);
        if (PickResult.intersectPolygon(point3dArray2, point3dArray, false)) {
            return true;
        }
        point3dArray2[0].set(point3d2.x, point3d.y, point3d2.z);
        point3dArray2[1].set(point3d.x, point3d.y, point3d2.z);
        point3dArray2[2].set(point3d.x, point3d.y, point3d.z);
        point3dArray2[3].set(point3d2.x, point3d.y, point3d.z);
        if (PickResult.intersectPolygon(point3dArray2, point3dArray, false)) {
            return true;
        }
        point3dArray2[0].set(point3d2.x, point3d2.y, point3d2.z);
        point3dArray2[1].set(point3d2.x, point3d2.y, point3d.z);
        point3dArray2[2].set(point3d.x, point3d2.y, point3d.z);
        point3dArray2[3].set(point3d.x, point3d2.y, point3d2.z);
        if (PickResult.intersectPolygon(point3dArray2, point3dArray, false)) {
            return true;
        }
        point3dArray2[0].set(point3d2.x, point3d2.y, point3d2.z);
        point3dArray2[1].set(point3d.x, point3d2.y, point3d2.z);
        point3dArray2[2].set(point3d.x, point3d.y, point3d2.z);
        point3dArray2[3].set(point3d2.x, point3d.y, point3d2.z);
        if (PickResult.intersectPolygon(point3dArray2, point3dArray, false)) {
            return true;
        }
        point3dArray2[0].set(point3d2.x, point3d2.y, point3d.z);
        point3dArray2[1].set(point3d2.x, point3d.y, point3d.z);
        point3dArray2[2].set(point3d.x, point3d.y, point3d.z);
        point3dArray2[3].set(point3d.x, point3d2.y, point3d.z);
        return PickResult.intersectPolygon(point3dArray2, point3dArray, false);
    }

    static boolean intersectBoundingPolytope(Point3d[] point3dArray, BoundingPolytope boundingPolytope) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl = false;
        double d = -1.0;
        Point4d point4d = new Point4d();
        Vector4d[] vector4dArray = new Vector4d[boundingPolytope.getNumPlanes()];
        boundingPolytope.getPlanes(vector4dArray);
        if (point3dArray.length == 2) {
            throw new RuntimeException("TODO: must make polytope.intersect(coordinates[0], coordinates[1], tP4d) public!");
        }
        if (bl) {
            System.out.println("The value of the input vertices are: ");
            int n6 = 0;
            while (n6 < point3dArray.length) {
                System.out.println("The " + n6 + " th vertex is: " + point3dArray[n6]);
                ++n6;
            }
            System.out.println("The value of the input bounding Polytope's planes =");
            n5 = 0;
            while (n5 < vector4dArray.length) {
                System.out.println("The " + n5 + " th plane is: " + vector4dArray[n5]);
                ++n5;
            }
        }
        double[] dArray = new double[]{0.8, 0.9, 1.1, 1.2};
        n5 = 1;
        boolean bl2 = false;
        if (bl2) {
            n4 = 0;
            while (n4 < point3dArray.length) {
                n3 = 0;
                while (n3 < vector4dArray.length) {
                    if (!(vector4dArray[n3].x * point3dArray[n4].x + vector4dArray[n3].y * point3dArray[n4].y + vector4dArray[n3].z * point3dArray[n4].z <= d * vector4dArray[n3].w)) {
                        n5 = 0;
                        break;
                    }
                    n5 = 1;
                    ++n3;
                }
                if (n5 != 0) {
                    return true;
                }
                ++n4;
            }
        }
        n4 = vector4dArray.length + 2 + point3dArray.length + 1;
        n3 = 1 + point3dArray.length;
        double[][] dArray2 = new double[n3][n4];
        int n7 = 0;
        while (n7 < vector4dArray.length) {
            n2 = 0;
            while (n2 < point3dArray.length) {
                dArray2[n2][n7] = -1.0 * (vector4dArray[n7].x * point3dArray[n2].x + vector4dArray[n7].y * point3dArray[n2].y + vector4dArray[n7].z * point3dArray[n2].z);
                ++n2;
            }
            ++n7;
        }
        n2 = 0;
        while (n2 < point3dArray.length) {
            dArray2[n2][vector4dArray.length] = -1.0;
            dArray2[n2][vector4dArray.length + 1] = 1.0;
            n = 0;
            while (n < point3dArray.length) {
                dArray2[n2][n + vector4dArray.length + 2] = n2 == n ? 1.0 : 0.0;
                dArray2[n2][n4 - 1] = dArray[n2];
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < vector4dArray.length) {
            dArray2[n3 - 1][n] = d * vector4dArray[n].w;
            ++n;
        }
        dArray2[n3 - 1][vector4dArray.length] = 1.0;
        dArray2[n3 - 1][vector4dArray.length + 1] = -1.0;
        int n8 = 0;
        while (n8 < point3dArray.length) {
            dArray2[n3 - 1][vector4dArray.length + 2 + n8] = 0.0;
            ++n8;
        }
        if (bl) {
            System.out.println("The value of the problem tableau is: ");
            int n9 = 0;
            while (n9 < dArray2.length) {
                int n10 = 0;
                while (n10 < dArray2[0].length) {
                    System.out.print(String.valueOf(dArray2[n9][n10]) + "  ");
                    ++n10;
                }
                System.out.println();
                ++n9;
            }
        }
        double d2 = PickResult.generalStandardSimplexSolver(dArray2, Double.NEGATIVE_INFINITY);
        if (bl) {
            System.out.println("The value returned by the general standard simplex = " + d2);
        }
        return d2 != Double.POSITIVE_INFINITY;
    }

    static boolean intersectBoundingSphere(Point3d[] point3dArray, BoundingSphere boundingSphere) {
        Vector3d vector3d = new Vector3d();
        Point3d point3d = new Point3d();
        boundingSphere.getCenter(point3d);
        double d = boundingSphere.getRadius();
        int n = 0;
        while (n < point3dArray.length) {
            vector3d.x = point3dArray[n].x - point3d.x;
            vector3d.y = point3dArray[n].y - point3d.y;
            vector3d.z = point3dArray[n].z - point3d.z;
            if (vector3d.length() <= d) {
                return true;
            }
            ++n;
        }
        n = 0;
        while (n < point3dArray.length) {
            boolean bl = n < point3dArray.length - 1 ? PickResult.edgeIntersectSphere(boundingSphere, point3dArray[n], point3dArray[n + 1]) : PickResult.edgeIntersectSphere(boundingSphere, point3dArray[n], point3dArray[0]);
            if (bl) {
                return true;
            }
            ++n;
        }
        if (point3dArray.length < 3) {
            return false;
        }
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        Vector3d vector3d5 = new Vector3d();
        Point3d point3d2 = new Point3d();
        n = 0;
        while (n < point3dArray.length - 1) {
            vector3d2.x = point3dArray[n + 1].x - point3dArray[n].x;
            vector3d2.y = point3dArray[n + 1].y - point3dArray[n].y;
            vector3d2.z = point3dArray[n + 1].z - point3dArray[n++].z;
            if (vector3d2.length() > 0.0) break;
        }
        int n2 = n;
        while (n2 < point3dArray.length - 1) {
            vector3d3.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
            vector3d3.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
            vector3d3.z = point3dArray[n2 + 1].z - point3dArray[n2].z;
            if (vector3d3.length() > 0.0) break;
            ++n2;
        }
        if (n2 == point3dArray.length - 1) {
            return false;
        }
        vector3d4.cross(vector3d2, vector3d3);
        double d2 = vector3d4.lengthSquared();
        if (d2 == 0.0) {
            return false;
        }
        vector3d5.x = point3dArray[0].x - point3d.x;
        vector3d5.y = point3dArray[0].y - point3d.y;
        vector3d5.z = point3dArray[0].z - point3d.z;
        double d3 = vector3d4.dot(vector3d5);
        double d4 = Math.sqrt(d3 * d3 / d2);
        if (d4 > d) {
            return false;
        }
        double d5 = d3 / d2;
        point3d2.x = point3d.x + d5 * vector3d4.x;
        point3d2.y = point3d.y + d5 * vector3d4.y;
        point3d2.z = point3d.z + d5 * vector3d4.z;
        return PickResult.pointIntersectPolygon2D(vector3d4, point3dArray, point3d2);
    }

    static boolean intersectCone(Point3d point3d, PickCone pickCone, PickIntersection pickIntersection) {
        double d;
        Point3d point3d2 = new Point3d();
        Point3d point3d3 = new Point3d();
        Vector3d vector3d = new Vector3d();
        Point3d point3d4 = new Point3d();
        Vector3d vector3d2 = new Vector3d();
        pickCone.getOrigin(point3d2);
        pickCone.getDirection(vector3d);
        if (pickCone instanceof PickConeSegment) {
            ((PickConeSegment)pickCone).getEnd(point3d3);
            d = Distance.pointToSegment(point3d, point3d2, point3d3, point3d4, null);
        } else {
            d = Distance.pointToRay(point3d, point3d2, vector3d, point3d4, null);
        }
        vector3d2.sub((Tuple3d)point3d4, (Tuple3d)point3d2);
        double d2 = vector3d2.length();
        double d3 = Math.tan(pickCone.getSpreadAngle()) * d2;
        if (d <= d3 * d3) {
            pickIntersection.setPointCoordinatesVW(point3d);
            pickIntersection.setDistance(d2);
            return true;
        }
        return false;
    }

    static boolean intersectCone(Point3d[] point3dArray, PickCone pickCone, PickIntersection pickIntersection) {
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Point3d point3d3 = new Point3d();
        Point3d point3d4 = new Point3d();
        Vector3d vector3d3 = new Vector3d();
        pickCone.getOrigin(point3d);
        pickCone.getDirection(vector3d);
        if (pickCone instanceof PickConeSegment) {
            ((PickConeSegment)pickCone).getEnd(point3d2);
        }
        if (point3dArray.length > 2 && (pickCone instanceof PickConeRay ? PickResult.intersectRay(point3dArray, new PickRay(point3d, vector3d), pickIntersection) : PickResult.intersectSegment(point3dArray, new PickSegment(point3d, point3d2), pickIntersection))) {
            return true;
        }
        int n = 0;
        while (n < point3dArray.length - 1) {
            double d = pickCone instanceof PickConeSegment ? Distance.segmentToSegment(point3d, point3d2, point3dArray[n], point3dArray[n + 1], point3d3, point3d4, null) : Distance.rayToSegment(point3d, vector3d, point3dArray[n], point3dArray[n + 1], point3d3, point3d4, null);
            vector3d2.sub((Tuple3d)point3d3, (Tuple3d)point3d);
            double d2 = vector3d2.length();
            double d3 = Math.tan(pickCone.getSpreadAngle()) * d2;
            if (d <= d3 * d3) {
                pickIntersection.setPointCoordinatesVW(point3d4);
                pickIntersection.setDistance(d2);
                return true;
            }
            ++n;
        }
        return false;
    }

    static boolean intersectCylinder(Point3d point3d, PickCylinder pickCylinder, PickIntersection pickIntersection) {
        double d;
        Point3d point3d2 = new Point3d();
        Point3d point3d3 = new Point3d();
        Vector3d vector3d = new Vector3d();
        Point3d point3d4 = new Point3d();
        Vector3d vector3d2 = new Vector3d();
        pickCylinder.getOrigin(point3d2);
        pickCylinder.getDirection(vector3d);
        double d2 = pickCylinder.getRadius();
        if (pickCylinder instanceof PickCylinderSegment) {
            ((PickCylinderSegment)pickCylinder).getEnd(point3d3);
            d = Distance.pointToSegment(point3d, point3d2, point3d3, point3d4, null);
        } else {
            d = Distance.pointToRay(point3d, point3d2, vector3d, point3d4, null);
        }
        if (d <= d2 * d2) {
            pickIntersection.setPointCoordinatesVW(point3d);
            vector3d2.sub((Tuple3d)point3d4, (Tuple3d)point3d2);
            pickIntersection.setDistance(vector3d2.length());
            return true;
        }
        return false;
    }

    static boolean intersectCylinder(Point3d[] point3dArray, PickCylinder pickCylinder, PickIntersection pickIntersection) {
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Vector3d vector3d = new Vector3d();
        Point3d point3d3 = new Point3d();
        Point3d point3d4 = new Point3d();
        Vector3d vector3d2 = new Vector3d();
        pickCylinder.getOrigin(point3d);
        pickCylinder.getDirection(vector3d);
        double d = pickCylinder.getRadius();
        if (pickCylinder instanceof PickCylinderSegment) {
            ((PickCylinderSegment)pickCylinder).getEnd(point3d2);
        }
        if (point3dArray.length > 2 && (pickCylinder instanceof PickCylinderRay ? PickResult.intersectRay(point3dArray, new PickRay(point3d, vector3d), pickIntersection) : PickResult.intersectSegment(point3dArray, new PickSegment(point3d, point3d2), pickIntersection))) {
            return true;
        }
        int n = 0;
        while (n < point3dArray.length - 1) {
            double d2 = pickCylinder instanceof PickCylinderSegment ? Distance.segmentToSegment(point3d, point3d2, point3dArray[n], point3dArray[n + 1], point3d3, point3d4, null) : Distance.rayToSegment(point3d, vector3d, point3dArray[n], point3dArray[n + 1], point3d3, point3d4, null);
            if (d2 <= d * d) {
                pickIntersection.setPointCoordinatesVW(point3d4);
                vector3d2.sub((Tuple3d)point3d3, (Tuple3d)point3d);
                pickIntersection.setDistance(vector3d2.length());
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean intersectILA(IndexedLineArray indexedLineArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        int n2 = 0;
        int n3 = indexedLineArray.getIndexCount();
        if (debug) {
            System.out.println("intersect: IndexedLineArray");
        }
        int n4 = 0;
        while (n4 < n3) {
            this.lineVertIdx[0] = n4;
            this.lineVertIdx[1] = n4 + 1;
            this.lineCoordIdx[0] = indexedLineArray.getCoordinateIndex(n4);
            this.lineCoordIdx[1] = indexedLineArray.getCoordinateIndex(n4 + 1);
            if (this.intersectLine(this.lineVertIdx, this.lineCoordIdx, n, point3dArray, pickIntersection)) {
                ++n2;
                if (bl) {
                    return true;
                }
            }
            n4 += 2;
        }
        return n2 > 0;
    }

    boolean intersectILSA(IndexedLineStripArray indexedLineStripArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        if (debug) {
            System.out.println("intersect: IndexedLineStripArray");
        }
        int n2 = 0;
        int[] nArray = new int[indexedLineStripArray.getNumStrips()];
        indexedLineStripArray.getStripIndexCounts(nArray);
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            this.lineVertIdx[0] = n3;
            this.lineCoordIdx[0] = indexedLineStripArray.getCoordinateIndex(n3);
            int n5 = n3 + nArray[n4];
            int n6 = n3 + 1;
            while (n6 < n5) {
                this.lineVertIdx[1] = n6;
                this.lineCoordIdx[1] = indexedLineStripArray.getCoordinateIndex(n6);
                if (this.intersectLine(this.lineVertIdx, this.lineCoordIdx, n, point3dArray, pickIntersection)) {
                    ++n2;
                    if (bl) {
                        return true;
                    }
                }
                this.lineVertIdx[0] = this.lineVertIdx[1];
                this.lineCoordIdx[0] = this.lineCoordIdx[1];
                ++n6;
            }
            n3 += nArray[n4];
            ++n4;
        }
        return n2 > 0;
    }

    boolean intersectIPA(IndexedPointArray indexedPointArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        if (debug) {
            System.out.println("intersect: IndexedPointArray");
        }
        int n2 = 0;
        int n3 = indexedPointArray.getIndexCount();
        int n4 = 0;
        while (n4 < n3) {
            this.pntVertIdx[0] = n4;
            this.pntCoordIdx[0] = indexedPointArray.getCoordinateIndex(n4);
            if (this.intersectPoint(this.pntVertIdx, this.pntCoordIdx, n, point3dArray, pickIntersection)) {
                ++n2;
                if (bl) {
                    return true;
                }
            }
            ++n4;
        }
        return n2 > 0;
    }

    final boolean intersectIQA(IndexedQuadArray indexedQuadArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        if (debug) {
            System.out.println("intersect: IndexedQuadArray");
        }
        int n2 = 0;
        int n3 = indexedQuadArray.getIndexCount();
        int n4 = 0;
        while (n4 < n3) {
            this.quadVertIdx[0] = n4;
            this.quadVertIdx[1] = n4 + 1;
            this.quadVertIdx[2] = n4 + 2;
            this.quadVertIdx[3] = n4 + 3;
            this.quadCoordIdx[0] = indexedQuadArray.getCoordinateIndex(n4);
            this.quadCoordIdx[1] = indexedQuadArray.getCoordinateIndex(n4 + 1);
            this.quadCoordIdx[2] = indexedQuadArray.getCoordinateIndex(n4 + 2);
            this.quadCoordIdx[3] = indexedQuadArray.getCoordinateIndex(n4 + 3);
            if (this.intersectQuad(this.quadVertIdx, this.quadCoordIdx, n, point3dArray, pickIntersection)) {
                ++n2;
                if (bl) {
                    return true;
                }
            }
            n4 += 4;
        }
        return n2 > 0;
    }

    boolean intersectITA(IndexedTriangleArray indexedTriangleArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        if (debug) {
            System.out.println("intersect: IndexedTriangleArray");
        }
        int n2 = 0;
        int n3 = indexedTriangleArray.getIndexCount();
        int n4 = 0;
        while (n4 < n3) {
            this.triVertIdx[0] = n4;
            this.triVertIdx[1] = n4 + 1;
            this.triVertIdx[2] = n4 + 2;
            this.triCoordIdx[0] = indexedTriangleArray.getCoordinateIndex(n4);
            this.triCoordIdx[1] = indexedTriangleArray.getCoordinateIndex(n4 + 1);
            this.triCoordIdx[2] = indexedTriangleArray.getCoordinateIndex(n4 + 2);
            if (this.intersectTri(this.triVertIdx, this.triCoordIdx, n, point3dArray, pickIntersection)) {
                ++n2;
                if (bl) {
                    return true;
                }
            }
            n4 += 3;
        }
        return n2 > 0;
    }

    boolean intersectITFA(IndexedTriangleFanArray indexedTriangleFanArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        if (debug) {
            System.out.println("intersect: IndexedTriangleFanArray");
        }
        int n2 = 0;
        int[] nArray = new int[indexedTriangleFanArray.getNumStrips()];
        indexedTriangleFanArray.getStripIndexCounts(nArray);
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            this.triVertIdx[0] = n3;
            this.triVertIdx[1] = n3 + 1;
            this.triCoordIdx[0] = indexedTriangleFanArray.getCoordinateIndex(n3);
            this.triCoordIdx[1] = indexedTriangleFanArray.getCoordinateIndex(n3 + 1);
            int n5 = n3 + nArray[n4] - 2;
            int n6 = n3 + 2;
            while (n6 < n5) {
                this.triVertIdx[2] = n6;
                this.triCoordIdx[2] = indexedTriangleFanArray.getCoordinateIndex(n6);
                if (this.intersectTri(this.triVertIdx, this.triCoordIdx, n, point3dArray, pickIntersection)) {
                    ++n2;
                    if (bl) {
                        return true;
                    }
                }
                this.triVertIdx[1] = this.triVertIdx[2];
                this.triCoordIdx[1] = this.triCoordIdx[2];
                ++n6;
            }
            n3 += nArray[n4];
            ++n4;
        }
        return n2 > 0;
    }

    boolean intersectITSA(IndexedTriangleStripArray indexedTriangleStripArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        if (debug) {
            System.out.println("intersect: IndexedTriangleStripArray");
        }
        int n2 = 0;
        int[] nArray = new int[indexedTriangleStripArray.getNumStrips()];
        indexedTriangleStripArray.getStripIndexCounts(nArray);
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            boolean bl2 = true;
            this.triVertIdx[0] = n3;
            this.triVertIdx[1] = n3 + 1;
            this.triCoordIdx[0] = indexedTriangleStripArray.getCoordinateIndex(n3);
            this.triCoordIdx[1] = indexedTriangleStripArray.getCoordinateIndex(n3 + 1);
            int n5 = n3 + nArray[n4] - 2;
            int n6 = n3 + 2;
            while (n6 < n5) {
                if (bl2) {
                    this.triVertIdx[2] = n6;
                    this.triCoordIdx[2] = indexedTriangleStripArray.getCoordinateIndex(n6);
                } else {
                    this.triVertIdx[1] = n6;
                    this.triCoordIdx[1] = indexedTriangleStripArray.getCoordinateIndex(n6);
                }
                if (this.intersectTri(this.triVertIdx, this.triCoordIdx, n, point3dArray, pickIntersection)) {
                    ++n2;
                    if (bl) {
                        return true;
                    }
                }
                if (bl2) {
                    this.triVertIdx[0] = this.triVertIdx[1];
                    this.triCoordIdx[0] = this.triCoordIdx[1];
                    bl2 = false;
                } else {
                    this.triVertIdx[0] = this.triVertIdx[2];
                    this.triCoordIdx[0] = this.triCoordIdx[2];
                    bl2 = true;
                }
                ++n6;
            }
            n3 += nArray[n4];
            ++n4;
        }
        return n2 > 0;
    }

    boolean intersectLA(LineArray lineArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        if (debug) {
            System.out.println("intersect: LineArray");
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < point3dArray.length) {
            this.lineVertIdx[0] = n3;
            this.lineVertIdx[1] = n3 + 1;
            if (this.intersectLine(this.lineVertIdx, this.lineVertIdx, n, point3dArray, pickIntersection)) {
                ++n2;
                if (bl) {
                    return true;
                }
            }
            n3 += 2;
        }
        return n2 > 0;
    }

    boolean intersectLSA(LineStripArray lineStripArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        int n2 = 0;
        int[] nArray = new int[lineStripArray.getNumStrips()];
        lineStripArray.getStripVertexCounts(nArray);
        int n3 = 0;
        if (debug) {
            System.out.println("intersect: LineStripArray");
        }
        int n4 = 0;
        while (n4 < nArray.length) {
            this.lineVertIdx[0] = n3;
            int n5 = n3 + nArray[n4];
            int n6 = n3 + 1;
            while (n6 < n5) {
                this.lineVertIdx[1] = n6;
                if (this.intersectLine(this.lineVertIdx, this.lineVertIdx, n, point3dArray, pickIntersection)) {
                    ++n2;
                    if (bl) {
                        return true;
                    }
                }
                this.lineVertIdx[0] = this.lineVertIdx[1];
                ++n6;
            }
            n3 += nArray[n4];
            ++n4;
        }
        return n2 > 0;
    }

    boolean intersectLine(int[] nArray, int[] nArray2, int n, Point3d[] point3dArray, PickIntersection pickIntersection) {
        this.linePts[0] = point3dArray[nArray2[0]];
        this.linePts[1] = point3dArray[nArray2[1]];
        boolean bl = false;
        switch (this.pickShapeType) {
            case 1: {
                bl = PickResult.intersectLineAndRay(this.linePts[0], this.linePts[1], this.pickShapeStart, this.pickShapeDir, pickIntersection);
                break;
            }
            case 2: {
                if (!PickResult.intersectLineAndRay(this.linePts[0], this.linePts[1], this.pickShapeStart, this.pickShapeDir, pickIntersection) || !(pickIntersection.getDistance() <= 1.0)) break;
                bl = true;
                break;
            }
            case 4: {
                bl = PickResult.intersectBoundingBox(this.linePts, (BoundingBox)this.pickShapeBounds);
                break;
            }
            case 5: {
                bl = PickResult.intersectBoundingSphere(this.linePts, (BoundingSphere)this.pickShapeBounds);
                break;
            }
            case 6: {
                bl = PickResult.intersectBoundingPolytope(this.linePts, (BoundingPolytope)this.pickShapeBounds);
                break;
            }
            case 7: {
                bl = PickResult.intersectCylinder(this.linePts, (PickCylinder)this.pickShape, pickIntersection);
                break;
            }
            case 8: {
                bl = PickResult.intersectCone(this.linePts, (PickCone)this.pickShape, pickIntersection);
                break;
            }
        }
        if (bl) {
            PickIntersection pickIntersection2 = new PickIntersection(this, pickIntersection.geom);
            pickIntersection2.iGeom = pickIntersection.iGeom;
            pickIntersection2.setDistance(pickIntersection.distance);
            pickIntersection2.setPointCoordinatesVW(pickIntersection.getPointCoordinatesVW());
            pickIntersection2.setGeomIndex(n);
            pickIntersection2.setVertexIndices(nArray);
            pickIntersection2.setPrimitiveCoordinatesVW(this.linePts);
            this.intersections.add(pickIntersection2);
            return true;
        }
        return false;
    }

    static boolean intersectLineAndRay(Point3d point3d, Point3d point3d2, Point3d point3d3, Vector3d vector3d, PickIntersection pickIntersection) {
        Vector3d vector3d2 = new Vector3d(point3d2.x - point3d.x, point3d2.y - point3d.y, point3d2.z - point3d.z);
        double d = vector3d2.x;
        double d2 = -vector3d.y;
        double d3 = vector3d2.y;
        double d4 = -vector3d.x;
        double d5 = d * d2 - d3 * d4;
        if (d5 == 0.0) {
            return false;
        }
        double d6 = 1.0 / d5;
        double d7 = d6 * d2;
        double d8 = d6 * -d4;
        double d9 = d6 * -d3;
        double d10 = d6 * d;
        d6 = point3d3.x - point3d.x;
        double d11 = point3d3.y - point3d.y;
        double d12 = d7 * d6 + d8 * d11;
        double d13 = d9 * d6 + d10 * d11;
        if (d13 < 0.0) {
            return false;
        }
        if (d12 < 0.0 || d12 > 1.0) {
            return false;
        }
        d6 = point3d3.z + d13 * vector3d.z;
        d11 = point3d.z + d12 * vector3d2.z;
        if (d6 < d11 - Double.MIN_VALUE || d6 > d11 + Double.MIN_VALUE) {
            return false;
        }
        double d14 = d13;
        pickIntersection.setDistance(d14);
        Point3d point3d4 = new Point3d();
        point3d4.scaleAdd(d13, (Tuple3d)vector3d, (Tuple3d)point3d3);
        pickIntersection.setPointCoordinatesVW(point3d4);
        return true;
    }

    boolean intersectPA(PointArray pointArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        if (debug) {
            System.out.println("intersect: PointArray");
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < point3dArray.length) {
            this.pntVertIdx[0] = n3;
            if (this.intersectPoint(this.pntVertIdx, this.pntVertIdx, n, point3dArray, pickIntersection)) {
                ++n2;
                if (bl) {
                    return true;
                }
            }
            ++n3;
        }
        return n2 > 0;
    }

    static boolean intersectPntAndPnt(Point3d point3d, Point3d point3d2, PickIntersection pickIntersection) {
        if (point3d.x == point3d2.x && point3d.y == point3d2.y && point3d.z == point3d2.z) {
            pickIntersection.setPointCoordinatesVW(point3d);
            pickIntersection.setDistance(0.0);
            return true;
        }
        return false;
    }

    static boolean intersectPntAndRay(Point3d point3d, Point3d point3d2, Vector3d vector3d, PickIntersection pickIntersection) {
        double d;
        double d2;
        int n = 0;
        if (vector3d.x != 0.0) {
            n = 0;
            d2 = (point3d.x - point3d2.x) / vector3d.x;
        } else if (vector3d.y != 0.0) {
            if (point3d.x != point3d2.x) {
                return false;
            }
            n = 1;
            d2 = (point3d.y - point3d2.y) / vector3d.y;
        } else if (vector3d.z != 0.0) {
            if (point3d.x != point3d2.x || point3d.y != point3d2.y) {
                return false;
            }
            n = 2;
            d2 = (point3d.z - point3d2.z) / vector3d.z;
        } else {
            return false;
        }
        if (d2 < 0.0) {
            return false;
        }
        if (n == 0 && (point3d.y < (d = point3d2.y + d2 * vector3d.y) - Double.MIN_VALUE || point3d.y > d + Double.MIN_VALUE)) {
            return false;
        }
        if (n < 2 && (point3d.z < (d = point3d2.z + d2 * vector3d.z) - Double.MIN_VALUE || point3d.z > d + Double.MIN_VALUE)) {
            return false;
        }
        pickIntersection.setPointCoordinatesVW(point3d);
        pickIntersection.setDistance(d2);
        return true;
    }

    boolean intersectPoint(int[] nArray, int[] nArray2, int n, Point3d[] point3dArray, PickIntersection pickIntersection) {
        this.point[0] = point3dArray[nArray2[0]];
        if (debug) {
            System.out.println("intersect point, point = " + this.point[0]);
        }
        boolean bl = false;
        switch (this.pickShapeType) {
            case 1: {
                bl = PickResult.intersectPntAndRay(this.point[0], this.pickShapeStart, this.pickShapeDir, pickIntersection);
                break;
            }
            case 2: {
                if (!PickResult.intersectPntAndRay(this.point[0], this.pickShapeStart, this.pickShapeDir, pickIntersection) || !(pickIntersection.getDistance() <= 1.0)) break;
                bl = true;
                break;
            }
            case 4: {
                bl = ((BoundingBox)this.pickShapeBounds).intersect(this.point[0]);
                break;
            }
            case 5: {
                bl = ((BoundingSphere)this.pickShapeBounds).intersect(this.point[0]);
                break;
            }
            case 6: {
                bl = ((BoundingPolytope)this.pickShapeBounds).intersect(this.point[0]);
                break;
            }
            case 7: {
                bl = PickResult.intersectCylinder(this.point[0], (PickCylinder)this.pickShape, pickIntersection);
                break;
            }
            case 8: {
                bl = PickResult.intersectCone(this.point[0], (PickCone)this.pickShape, pickIntersection);
                break;
            }
        }
        if (bl) {
            PickIntersection pickIntersection2 = new PickIntersection(this, pickIntersection.geom);
            pickIntersection2.iGeom = pickIntersection.iGeom;
            pickIntersection2.setDistance(pickIntersection.distance);
            pickIntersection2.setPointCoordinatesVW(pickIntersection.getPointCoordinatesVW());
            pickIntersection2.setGeomIndex(n);
            pickIntersection2.setVertexIndices(nArray);
            pickIntersection2.setPrimitiveCoordinatesVW(this.point);
            this.intersections.add(pickIntersection2);
            return true;
        }
        return false;
    }

    static boolean intersectPolygon(Point3d[] point3dArray, Point3d[] point3dArray2, boolean bl) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        int n = 0;
        while (n < point3dArray.length - 1) {
            vector3d.x = point3dArray[n + 1].x - point3dArray[n].x;
            vector3d.y = point3dArray[n + 1].y - point3dArray[n].y;
            vector3d.z = point3dArray[n + 1].z - point3dArray[n++].z;
            if (vector3d.length() > 0.0) break;
        }
        int n2 = n;
        while (n2 < point3dArray.length - 1) {
            vector3d2.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
            vector3d2.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
            vector3d2.z = point3dArray[n2 + 1].z - point3dArray[n2].z;
            if (vector3d2.length() > 0.0) break;
            ++n2;
        }
        if (n2 == point3dArray.length - 1) {
            return false;
        }
        vector3d3.cross(vector3d, vector3d2);
        if (vector3d3.length() == 0.0) {
            return false;
        }
        n2 = 0;
        Point3d[] point3dArray3 = new Point3d[]{new Point3d(), new Point3d()};
        n = 0;
        while (n < point3dArray2.length) {
            boolean bl2 = n < point3dArray2.length - 1 ? PickResult.edgeIntersectPlane(vector3d3, point3dArray[0], point3dArray2[n], point3dArray2[n + 1], point3dArray3[n2]) : PickResult.edgeIntersectPlane(vector3d3, point3dArray[0], point3dArray2[n], point3dArray2[0], point3dArray3[n2]);
            if (bl2 && ++n2 > 1) break;
            ++n;
        }
        if (n2 == 0) {
            return false;
        }
        if (point3dArray2.length < 3) {
            return PickResult.pointIntersectPolygon2D(vector3d3, point3dArray, point3dArray3[0]);
        }
        return PickResult.edgeIntersectPolygon2D(vector3d3, point3dArray, point3dArray3);
    }

    boolean intersectQA(QuadArray quadArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        if (debug) {
            System.out.println("intersect: QuadArray");
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < point3dArray.length) {
            this.quadVertIdx[0] = n3;
            this.quadVertIdx[1] = n3 + 1;
            this.quadVertIdx[2] = n3 + 2;
            this.quadVertIdx[3] = n3 + 3;
            if (this.intersectQuad(this.quadVertIdx, this.quadVertIdx, n, point3dArray, pickIntersection)) {
                ++n2;
                if (bl) {
                    return true;
                }
            }
            n3 += 4;
        }
        return n2 > 0;
    }

    boolean intersectQuad(int[] nArray, int[] nArray2, int n, Point3d[] point3dArray, PickIntersection pickIntersection) {
        this.quadPts[0] = point3dArray[nArray2[0]];
        this.quadPts[1] = point3dArray[nArray2[1]];
        this.quadPts[2] = point3dArray[nArray2[2]];
        this.quadPts[3] = point3dArray[nArray2[3]];
        boolean bl = false;
        switch (this.pickShapeType) {
            case 1: {
                bl = PickResult.intersectRay(this.quadPts, (PickRay)this.pickShape, pickIntersection);
                break;
            }
            case 2: {
                bl = PickResult.intersectSegment(this.quadPts, (PickSegment)this.pickShape, pickIntersection);
                break;
            }
            case 4: {
                bl = PickResult.intersectBoundingBox(this.quadPts, (BoundingBox)this.pickShapeBounds);
                break;
            }
            case 5: {
                bl = PickResult.intersectBoundingSphere(this.quadPts, (BoundingSphere)this.pickShapeBounds);
                break;
            }
            case 6: {
                bl = PickResult.intersectBoundingPolytope(this.quadPts, (BoundingPolytope)this.pickShapeBounds);
                break;
            }
            case 7: {
                bl = PickResult.intersectCylinder(this.quadPts, (PickCylinder)this.pickShape, pickIntersection);
                break;
            }
            case 8: {
                bl = PickResult.intersectCone(this.quadPts, (PickCone)this.pickShape, pickIntersection);
                break;
            }
        }
        if (bl) {
            PickIntersection pickIntersection2 = new PickIntersection(this, pickIntersection.geom);
            pickIntersection2.iGeom = pickIntersection.iGeom;
            pickIntersection2.setDistance(pickIntersection.distance);
            pickIntersection2.setPointCoordinatesVW(pickIntersection.getPointCoordinatesVW());
            pickIntersection2.setGeomIndex(n);
            pickIntersection2.setVertexIndices(nArray);
            pickIntersection2.setPrimitiveCoordinatesVW(this.quadPts);
            this.intersections.add(pickIntersection2);
            return true;
        }
        return false;
    }

    static boolean intersectRay(Point3d[] point3dArray, PickRay pickRay, PickIntersection pickIntersection) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        double d = 0.0;
        Vector3d vector3d4 = new Vector3d();
        double d2 = 0.0;
        Point3d point3d = new Point3d();
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        Point3d point3d2 = new Point3d();
        Vector3d vector3d5 = new Vector3d();
        pickRay.get(point3d2, vector3d5);
        int n = 0;
        while (n < point3dArray.length - 1) {
            vector3d.x = point3dArray[n + 1].x - point3dArray[n].x;
            vector3d.y = point3dArray[n + 1].y - point3dArray[n].y;
            vector3d.z = point3dArray[n + 1].z - point3dArray[n++].z;
            if (vector3d.length() > 0.0) break;
        }
        int n2 = n;
        while (n2 < point3dArray.length - 1) {
            vector3d2.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
            vector3d2.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
            vector3d2.z = point3dArray[n2 + 1].z - point3dArray[n2].z;
            if (vector3d2.length() > 0.0) break;
            ++n2;
        }
        if (n2 == point3dArray.length - 1) {
            return false;
        }
        vector3d3.cross(vector3d, vector3d2);
        if (vector3d3.length() == 0.0) {
            return false;
        }
        vector3d4.set((Tuple3d)point3dArray[0]);
        d = vector3d3.dot(vector3d4);
        d2 = vector3d3.dot(vector3d5);
        if (d2 == 0.0) {
            return false;
        }
        vector3d4.set((Tuple3d)point3d2);
        double d3 = (d - vector3d3.dot(vector3d4)) / d2;
        if (d3 < 0.0) {
            return false;
        }
        point3d.x = point3d2.x + vector3d5.x * d3;
        point3d.y = point3d2.y + vector3d5.y * d3;
        point3d.z = point3d2.z + vector3d5.z * d3;
        double d4 = Math.abs(vector3d3.x);
        double d5 = Math.abs(vector3d3.y);
        double d6 = Math.abs(vector3d3.z);
        int n3 = d4 > d5 ? 0 : 1;
        if (n3 == 0) {
            if (d4 < d6) {
                n3 = 2;
            }
        } else if (n3 == 1 && d5 < d6) {
            n3 = 2;
        }
        n = 0;
        while (n < point3dArray.length) {
            switch (n3) {
                case 0: {
                    dArray[n] = point3dArray[n].y - point3d.y;
                    dArray2[n] = point3dArray[n].z - point3d.z;
                    break;
                }
                case 1: {
                    dArray[n] = point3dArray[n].x - point3d.x;
                    dArray2[n] = point3dArray[n].z - point3d.z;
                    break;
                }
                case 2: {
                    dArray[n] = point3dArray[n].x - point3d.x;
                    dArray2[n] = point3dArray[n].y - point3d.y;
                    break;
                }
            }
            ++n;
        }
        int n4 = 0;
        int n5 = dArray2[0] < 0.0 ? -1 : 1;
        n = 0;
        while (n < point3dArray.length) {
            int n6;
            n2 = n + 1;
            if (n2 == point3dArray.length) {
                n2 = 0;
            }
            if (n5 != (n6 = dArray2[n2] < 0.0 ? -1 : 1)) {
                double d7;
                if (dArray[n] > 0.0 && dArray[n2] > 0.0) {
                    ++n4;
                } else if ((dArray[n] > 0.0 || dArray[n2] > 0.0) && (d7 = dArray[n] - dArray2[n] * (dArray[n2] - dArray[n]) / (dArray2[n2] - dArray2[n])) > 0.0) {
                    ++n4;
                }
                n5 = n6;
            }
            ++n;
        }
        if (n4 % 2 == 1) {
            pickIntersection.setDistance(d3 *= vector3d5.length());
            pickIntersection.setPointCoordinatesVW(point3d);
            return true;
        }
        return false;
    }

    static boolean intersectSegment(Point3d[] point3dArray, PickSegment pickSegment, PickIntersection pickIntersection) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        double d = 0.0;
        Vector3d vector3d4 = new Vector3d();
        Vector3d vector3d5 = new Vector3d();
        double d2 = 0.0;
        Point3d point3d = new Point3d();
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        Point3d point3d2 = new Point3d();
        Point3d point3d3 = new Point3d();
        pickSegment.get(point3d2, point3d3);
        int n = 0;
        while (n < point3dArray.length - 1) {
            vector3d.x = point3dArray[n + 1].x - point3dArray[n].x;
            vector3d.y = point3dArray[n + 1].y - point3dArray[n].y;
            vector3d.z = point3dArray[n + 1].z - point3dArray[n++].z;
            if (vector3d.length() > 0.0) break;
        }
        int n2 = n;
        while (n2 < point3dArray.length - 1) {
            vector3d2.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
            vector3d2.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
            vector3d2.z = point3dArray[n2 + 1].z - point3dArray[n2].z;
            if (vector3d2.length() > 0.0) break;
            ++n2;
        }
        if (n2 == point3dArray.length - 1) {
            return false;
        }
        vector3d3.cross(vector3d, vector3d2);
        if (vector3d3.length() == 0.0) {
            return false;
        }
        vector3d4.set((Tuple3d)point3dArray[0]);
        d = vector3d3.dot(vector3d4);
        vector3d5.x = point3d3.x - point3d2.x;
        vector3d5.y = point3d3.y - point3d2.y;
        vector3d5.z = point3d3.z - point3d2.z;
        d2 = vector3d3.dot(vector3d5);
        if (d2 == 0.0) {
            return false;
        }
        vector3d4.set((Tuple3d)point3d2);
        double d3 = (d - vector3d3.dot(vector3d4)) / d2;
        if (d3 < 0.0 || d3 > 1.0) {
            return false;
        }
        point3d.x = point3d2.x + vector3d5.x * d3;
        point3d.y = point3d2.y + vector3d5.y * d3;
        point3d.z = point3d2.z + vector3d5.z * d3;
        double d4 = Math.abs(vector3d3.x);
        double d5 = Math.abs(vector3d3.y);
        double d6 = Math.abs(vector3d3.z);
        int n3 = d4 > d5 ? 0 : 1;
        if (n3 == 0) {
            if (d4 < d6) {
                n3 = 2;
            }
        } else if (n3 == 1 && d5 < d6) {
            n3 = 2;
        }
        n = 0;
        while (n < point3dArray.length) {
            switch (n3) {
                case 0: {
                    dArray[n] = point3dArray[n].y - point3d.y;
                    dArray2[n] = point3dArray[n].z - point3d.z;
                    break;
                }
                case 1: {
                    dArray[n] = point3dArray[n].x - point3d.x;
                    dArray2[n] = point3dArray[n].z - point3d.z;
                    break;
                }
                case 2: {
                    dArray[n] = point3dArray[n].x - point3d.x;
                    dArray2[n] = point3dArray[n].y - point3d.y;
                    break;
                }
            }
            ++n;
        }
        int n4 = 0;
        int n5 = dArray2[0] < 0.0 ? -1 : 1;
        n = 0;
        while (n < point3dArray.length) {
            int n6;
            n2 = n + 1;
            if (n2 == point3dArray.length) {
                n2 = 0;
            }
            if (n5 != (n6 = dArray2[n2] < 0.0 ? -1 : 1)) {
                double d7;
                if (dArray[n] > 0.0 && dArray[n2] > 0.0) {
                    ++n4;
                } else if ((dArray[n] > 0.0 || dArray[n2] > 0.0) && (d7 = dArray[n] - dArray2[n] * (dArray[n2] - dArray[n]) / (dArray2[n2] - dArray2[n])) > 0.0) {
                    ++n4;
                }
                n5 = n6;
            }
            ++n;
        }
        if (n4 % 2 == 1) {
            pickIntersection.setDistance(d3 *= vector3d5.length());
            pickIntersection.setPointCoordinatesVW(point3d);
            return true;
        }
        return false;
    }

    boolean intersectTA(TriangleArray triangleArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        if (debug) {
            System.out.println("intersect: TriangleArray");
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < point3dArray.length) {
            this.triVertIdx[0] = n3;
            this.triVertIdx[1] = n3 + 1;
            this.triVertIdx[2] = n3 + 2;
            if (this.intersectTri(this.triVertIdx, this.triVertIdx, n, point3dArray, pickIntersection)) {
                ++n2;
                if (bl) {
                    return true;
                }
            }
            n3 += 3;
        }
        return n2 > 0;
    }

    boolean intersectTFA(TriangleFanArray triangleFanArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        if (debug) {
            System.out.println("intersect: TriangleFanArray");
        }
        int n2 = 0;
        int[] nArray = new int[triangleFanArray.getNumStrips()];
        triangleFanArray.getStripVertexCounts(nArray);
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            this.triVertIdx[0] = n3;
            this.triVertIdx[1] = n3 + 1;
            int n5 = n3 + nArray[n4] - 2;
            int n6 = n3 + 2;
            while (n6 < n5) {
                this.triVertIdx[2] = n6;
                if (this.intersectTri(this.triVertIdx, this.triVertIdx, n, point3dArray, pickIntersection)) {
                    ++n2;
                    if (bl) {
                        return true;
                    }
                }
                this.triVertIdx[1] = this.triVertIdx[2];
                ++n6;
            }
            n3 += nArray[n4];
            ++n4;
        }
        return n2 > 0;
    }

    boolean intersectTSA(TriangleStripArray triangleStripArray, int n, Point3d[] point3dArray, boolean bl, PickIntersection pickIntersection) {
        if (debug) {
            System.out.println("intersect: TriangleStripArray");
        }
        int n2 = 0;
        int[] nArray = new int[triangleStripArray.getNumStrips()];
        triangleStripArray.getStripVertexCounts(nArray);
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            boolean bl2 = true;
            this.triVertIdx[0] = n3;
            this.triVertIdx[1] = n3 + 1;
            int n5 = n3 + nArray[n4] - 2;
            int n6 = n3 + 2;
            while (n6 < n5) {
                if (bl2) {
                    this.triVertIdx[2] = n6;
                } else {
                    this.triVertIdx[1] = n6;
                }
                if (this.intersectTri(this.triVertIdx, this.triVertIdx, n, point3dArray, pickIntersection)) {
                    ++n2;
                    if (bl) {
                        return true;
                    }
                }
                if (bl2) {
                    this.triVertIdx[0] = this.triVertIdx[1];
                    bl2 = false;
                } else {
                    this.triVertIdx[0] = this.triVertIdx[2];
                    bl2 = true;
                }
                ++n6;
            }
            n3 += nArray[n4];
            ++n4;
        }
        return n2 > 0;
    }

    boolean intersectTri(int[] nArray, int[] nArray2, int n, Point3d[] point3dArray, PickIntersection pickIntersection) {
        this.triPts[0] = point3dArray[nArray2[0]];
        this.triPts[1] = point3dArray[nArray2[1]];
        this.triPts[2] = point3dArray[nArray2[2]];
        boolean bl = false;
        switch (this.pickShapeType) {
            case 1: {
                bl = PickResult.intersectRay(this.triPts, (PickRay)this.pickShape, pickIntersection);
                break;
            }
            case 2: {
                bl = PickResult.intersectSegment(this.triPts, (PickSegment)this.pickShape, pickIntersection);
                break;
            }
            case 4: {
                bl = PickResult.intersectBoundingBox(this.triPts, (BoundingBox)this.pickShapeBounds);
                break;
            }
            case 5: {
                bl = PickResult.intersectBoundingSphere(this.triPts, (BoundingSphere)this.pickShapeBounds);
                break;
            }
            case 6: {
                bl = PickResult.intersectBoundingPolytope(this.triPts, (BoundingPolytope)this.pickShapeBounds);
                break;
            }
            case 7: {
                bl = PickResult.intersectCylinder(this.triPts, (PickCylinder)this.pickShape, pickIntersection);
                break;
            }
            case 8: {
                bl = PickResult.intersectCone(this.triPts, (PickCone)this.pickShape, pickIntersection);
                break;
            }
        }
        if (bl) {
            PickIntersection pickIntersection2 = new PickIntersection(this, pickIntersection.geom);
            pickIntersection2.iGeom = pickIntersection.iGeom;
            pickIntersection2.setDistance(pickIntersection.distance);
            pickIntersection2.setPointCoordinatesVW(pickIntersection.getPointCoordinatesVW());
            pickIntersection2.setGeomIndex(n);
            pickIntersection2.setVertexIndices(nArray);
            pickIntersection2.setPrimitiveCoordinatesVW(this.triPts);
            this.intersections.add(pickIntersection2);
            return true;
        }
        return false;
    }

    public int numCompressedGeometryShape3Ds() {
        if (this.geometryArrays == null) {
            this.storeGeometry();
        }
        if (this.compressGeomShape3Ds == null) {
            return 0;
        }
        return this.compressGeomShape3Ds.length;
    }

    public int numGeometryArrays() {
        if (this.geometryArrays == null) {
            this.storeGeometry();
        }
        return this.geometryArrays.length;
    }

    public int numIntersections() {
        if (this.intersections == null) {
            this.generateIntersections();
        }
        return this.intersections.size();
    }

    static boolean pointIntersectPolygon2D(Vector3d vector3d, Point3d[] point3dArray, Point3d point3d) {
        Point2d[] point2dArray = new Point2d[point3dArray.length];
        Point2d point2d = new Point2d();
        double d = Math.abs(vector3d.x);
        double d2 = Math.abs(vector3d.y);
        double d3 = Math.abs(vector3d.z);
        int n = d > d2 ? 0 : 1;
        if (n == 0) {
            if (d < d3) {
                n = 2;
            }
        } else if (n == 1 && d2 < d3) {
            n = 2;
        }
        int n2 = 0;
        while (n2 < point3dArray.length) {
            point2dArray[n2] = new Point2d();
            switch (n) {
                case 0: {
                    point2dArray[n2].x = point3dArray[n2].y;
                    point2dArray[n2].y = point3dArray[n2].z;
                    break;
                }
                case 1: {
                    point2dArray[n2].x = point3dArray[n2].x;
                    point2dArray[n2].y = point3dArray[n2].z;
                    break;
                }
                case 2: {
                    point2dArray[n2].x = point3dArray[n2].x;
                    point2dArray[n2].y = point3dArray[n2].y;
                    break;
                }
            }
            ++n2;
        }
        switch (n) {
            case 0: {
                point2d.x = point3d.y;
                point2d.y = point3d.z;
                break;
            }
            case 1: {
                point2d.x = point3d.x;
                point2d.y = point3d.z;
                break;
            }
            case 2: {
                point2d.x = point3d.x;
                point2d.y = point3d.y;
                break;
            }
        }
        int n3 = 0;
        while (n3 < point3dArray.length) {
            if (n3 < point3dArray.length - 1 ? !(PickResult.det2D(point2dArray[n3], point2dArray[n3 + 1], point2d) > 0.0) : !(PickResult.det2D(point2dArray[n3], point2dArray[0], point2d) > 0.0)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public void setFirstIntersectOnly(boolean bl) {
        this.firstIntersectOnly = bl;
    }

    void setObject(Node node) {
        this.pickedNode = node;
    }

    private void storeGeometry() {
        Shape3D shape3D;
        if (this.pickedNode instanceof Morph) {
            this.geometryArrays = new GeometryArray[1];
            this.geometryArrays[0] = ((Morph)this.pickedNode).getGeometryArray(0);
        } else if (this.pickedNode instanceof Shape3D) {
            shape3D = (Shape3D)this.pickedNode;
            ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
            int n = 0;
            while (n < shape3D.numGeometries()) {
                Geometry geometry = shape3D.getGeometry(n);
                if (geometry instanceof CompressedGeometry) {
                    int n2;
                    Shape3D[] shape3DArray = ((CompressedGeometry)geometry).decompress();
                    if (shape3DArray != null) {
                        int n3 = 0;
                        while (n3 < shape3DArray.length) {
                            n2 = 0;
                            while (n2 < shape3DArray[n3].numGeometries()) {
                                arrayList.add(shape3DArray[n3].getGeometry(n2));
                                ++n2;
                            }
                            ++n3;
                        }
                    }
                    if (this.compressGeomShape3Ds == null) {
                        this.compressGeomShape3Ds = shape3DArray;
                    } else {
                        Shape3D[] shape3DArray2 = this.compressGeomShape3Ds;
                        n2 = shape3DArray2.length + shape3DArray.length;
                        this.compressGeomShape3Ds = new Shape3D[n2];
                        System.arraycopy(shape3DArray2, 0, this.compressGeomShape3Ds, 0, shape3DArray2.length);
                        System.arraycopy(shape3DArray, 0, this.compressGeomShape3Ds, shape3DArray2.length, shape3DArray.length);
                    }
                } else if (geometry instanceof GeometryArray) {
                    arrayList.add(geometry);
                }
                ++n;
            }
            this.geometryArrays = new GeometryArray[arrayList.size()];
            int n4 = 0;
            while (n4 < arrayList.size()) {
                this.geometryArrays[n4] = (GeometryArray)arrayList.get(n4);
                ++n4;
            }
        }
        if (this.geometryArrays == null) {
            if (this.pickedNode instanceof Shape3D) {
                shape3D = (Shape3D)this.pickedNode;
            }
            throw new RuntimeException("Type of the picked node is not supported");
        }
    }

    void storeNode() {
        if (this.pickedSceneGraphPath == null) {
            throw new RuntimeException("SceneGraphPath missing");
        }
        this.pickedNode = this.pickedSceneGraphPath.getObject();
    }

    public String toString() {
        String string = new String("PickResult: sgp:" + this.pickedSceneGraphPath + "\n");
        if (this.pickedNode != null) {
            string = String.valueOf(string) + " node:" + this.pickedNode;
        }
        if (this.intersections == null) {
            this.generateIntersections();
        }
        if (this.intersections.size() > 0) {
            int n = 0;
            while (n < this.intersections.size()) {
                string = String.valueOf(string) + "\n";
                string = String.valueOf(string) + ((PickIntersection)this.intersections.get(n)).toString2();
                ++n;
            }
        }
        return string;
    }
}

