/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.picking;

import com.sun.j3d.utils.picking.PickResult;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.CompressedGeometry;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.Locale;
import javax.media.j3d.Morph;
import javax.media.j3d.Node;
import javax.media.j3d.PickBounds;
import javax.media.j3d.PickConeRay;
import javax.media.j3d.PickConeSegment;
import javax.media.j3d.PickCylinderRay;
import javax.media.j3d.PickCylinderSegment;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickSegment;
import javax.media.j3d.PickShape;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3D;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class PickTool {
    private final boolean debug = true;
    PickShape pickShape;
    BranchGroup pickRootBG = null;
    Locale pickRootL = null;
    Point3d start = null;
    int mode = 512;
    public static final int BOUNDS = 512;
    public static final int GEOMETRY = 256;
    public static final int GEOMETRY_INTERSECT_INFO = 1024;
    public static final int INTERSECT_TEST = 4097;
    public static final int INTERSECT_COORD = 4098;
    public static final int INTERSECT_FULL = 4100;

    public PickTool(BranchGroup branchGroup) {
        this.pickRootBG = branchGroup;
    }

    public PickTool(Locale locale) {
        this.pickRootL = locale;
    }

    public BranchGroup getBranchGroup() {
        return this.pickRootBG;
    }

    public int getMode() {
        return this.mode;
    }

    public PickShape getPickShape() {
        return this.pickShape;
    }

    public Point3d getStartPosition() {
        return this.start;
    }

    public PickResult[] pickAll() {
        PickResult[] pickResultArray = null;
        switch (this.mode) {
            case 512: {
                pickResultArray = this.pickAll(this.pickShape);
                break;
            }
            case 256: {
                pickResultArray = this.pickGeomAll(this.pickShape);
                break;
            }
            case 1024: {
                pickResultArray = this.pickGeomAllIntersect(this.pickShape);
                break;
            }
            default: {
                throw new InternalError("Invalid pick mode");
            }
        }
        return pickResultArray;
    }

    private PickResult[] pickAll(PickShape pickShape) {
        PickResult[] pickResultArray = null;
        SceneGraphPath[] sceneGraphPathArray = null;
        if (this.pickRootBG != null) {
            sceneGraphPathArray = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPathArray = this.pickRootL.pickAll(pickShape);
        }
        if (sceneGraphPathArray == null) {
            return null;
        }
        pickResultArray = new PickResult[sceneGraphPathArray.length];
        int n = 0;
        while (n < sceneGraphPathArray.length) {
            pickResultArray[n] = new PickResult(sceneGraphPathArray[n], pickShape);
            ++n;
        }
        return pickResultArray;
    }

    public PickResult[] pickAllSorted() {
        PickResult[] pickResultArray = null;
        switch (this.mode) {
            case 512: {
                pickResultArray = this.pickAllSorted(this.pickShape);
                break;
            }
            case 256: {
                pickResultArray = this.pickGeomAllSorted(this.pickShape);
                break;
            }
            case 1024: {
                pickResultArray = this.pickGeomAllSortedIntersect(this.pickShape);
                break;
            }
            default: {
                throw new InternalError("Invalid pick mode");
            }
        }
        return pickResultArray;
    }

    private PickResult[] pickAllSorted(PickShape pickShape) {
        PickResult[] pickResultArray = null;
        SceneGraphPath[] sceneGraphPathArray = null;
        if (this.pickRootBG != null) {
            sceneGraphPathArray = this.pickRootBG.pickAllSorted(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPathArray = this.pickRootL.pickAllSorted(pickShape);
        }
        if (sceneGraphPathArray == null) {
            return null;
        }
        pickResultArray = new PickResult[sceneGraphPathArray.length];
        int n = 0;
        while (n < sceneGraphPathArray.length) {
            pickResultArray[n] = new PickResult(sceneGraphPathArray[n], pickShape);
            ++n;
        }
        return pickResultArray;
    }

    public PickResult pickAny() {
        PickResult pickResult = null;
        switch (this.mode) {
            case 512: {
                pickResult = this.pickAny(this.pickShape);
                break;
            }
            case 256: {
                pickResult = this.pickGeomAny(this.pickShape);
                break;
            }
            case 1024: {
                pickResult = this.pickGeomAnyIntersect(this.pickShape);
                break;
            }
            default: {
                throw new InternalError("Invalid pick mode");
            }
        }
        return pickResult;
    }

    private PickResult pickAny(PickShape pickShape) {
        PickResult pickResult = null;
        SceneGraphPath sceneGraphPath = null;
        if (this.pickRootBG != null) {
            sceneGraphPath = this.pickRootBG.pickAny(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPath = this.pickRootL.pickAny(pickShape);
        }
        if (sceneGraphPath == null) {
            return null;
        }
        pickResult = new PickResult(sceneGraphPath, pickShape);
        return pickResult;
    }

    public PickResult pickClosest() {
        PickResult pickResult = null;
        switch (this.mode) {
            case 512: {
                pickResult = this.pickClosest(this.pickShape);
                break;
            }
            case 256: {
                pickResult = this.pickGeomClosest(this.pickShape);
                break;
            }
            case 1024: {
                pickResult = this.pickGeomClosestIntersect(this.pickShape);
                break;
            }
            default: {
                throw new InternalError("Invalid pick mode");
            }
        }
        return pickResult;
    }

    private PickResult pickClosest(PickShape pickShape) {
        PickResult pickResult = null;
        SceneGraphPath sceneGraphPath = null;
        if (this.pickRootBG != null) {
            sceneGraphPath = this.pickRootBG.pickClosest(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPath = this.pickRootL.pickClosest(pickShape);
        }
        if (sceneGraphPath == null) {
            return null;
        }
        pickResult = new PickResult(sceneGraphPath, pickShape);
        return pickResult;
    }

    private PickResult[] pickGeomAll(PickShape pickShape) {
        SceneGraphPath[] sceneGraphPathArray = null;
        Node[] nodeArray = null;
        int n = 0;
        if (this.pickRootBG != null) {
            sceneGraphPathArray = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPathArray = this.pickRootL.pickAll(pickShape);
        }
        if (sceneGraphPathArray == null) {
            return null;
        }
        boolean[] blArray = new boolean[sceneGraphPathArray.length];
        nodeArray = new Node[sceneGraphPathArray.length];
        PickResult[] pickResultArray = new PickResult[sceneGraphPathArray.length];
        int n2 = 0;
        while (n2 < sceneGraphPathArray.length) {
            nodeArray[n2] = sceneGraphPathArray[n2].getObject();
            pickResultArray[n2] = new PickResult(sceneGraphPathArray[n2], pickShape);
            if (nodeArray[n2] instanceof Shape3D) {
                blArray[n2] = ((Shape3D)nodeArray[n2]).intersect(sceneGraphPathArray[n2], pickShape);
            } else if (nodeArray[n2] instanceof Morph) {
                blArray[n2] = ((Morph)nodeArray[n2]).intersect(sceneGraphPathArray[n2], pickShape);
            }
            if (blArray[n2]) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return null;
        }
        PickResult[] pickResultArray2 = new PickResult[n];
        n = 0;
        n2 = 0;
        while (n2 < sceneGraphPathArray.length) {
            if (blArray[n2]) {
                pickResultArray[n++] = pickResultArray[n2];
            }
            ++n2;
        }
        return pickResultArray;
    }

    private PickResult[] pickGeomAllIntersect(PickShape pickShape) {
        SceneGraphPath[] sceneGraphPathArray = null;
        Object var3_3 = null;
        int n = 0;
        if (this.pickRootBG != null) {
            sceneGraphPathArray = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPathArray = this.pickRootL.pickAll(pickShape);
        }
        if (sceneGraphPathArray == null) {
            return null;
        }
        boolean[] blArray = new boolean[sceneGraphPathArray.length];
        PickResult[] pickResultArray = new PickResult[sceneGraphPathArray.length];
        int n2 = 0;
        while (n2 < sceneGraphPathArray.length) {
            pickResultArray[n2] = new PickResult(sceneGraphPathArray[n2], pickShape);
            if (pickResultArray[n2].numIntersections() > 0) {
                blArray[n2] = true;
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return null;
        }
        PickResult[] pickResultArray2 = new PickResult[n];
        n = 0;
        n2 = 0;
        while (n2 < sceneGraphPathArray.length) {
            if (blArray[n2]) {
                pickResultArray[n++] = pickResultArray[n2];
            }
            ++n2;
        }
        return pickResultArray;
    }

    private PickResult[] pickGeomAllSorted(PickShape pickShape) {
        SceneGraphPath[] sceneGraphPathArray = null;
        Node[] nodeArray = null;
        int n = 0;
        double[] dArray = new double[1];
        if (this.pickRootBG != null) {
            sceneGraphPathArray = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPathArray = this.pickRootL.pickAll(pickShape);
        }
        if (sceneGraphPathArray == null) {
            return null;
        }
        boolean[] blArray = new boolean[sceneGraphPathArray.length];
        double[] dArray2 = new double[sceneGraphPathArray.length];
        nodeArray = new Node[sceneGraphPathArray.length];
        PickResult[] pickResultArray = new PickResult[sceneGraphPathArray.length];
        int n2 = 0;
        while (n2 < sceneGraphPathArray.length) {
            nodeArray[n2] = sceneGraphPathArray[n2].getObject();
            pickResultArray[n2] = new PickResult(sceneGraphPathArray[n2], pickShape);
            if (nodeArray[n2] instanceof Shape3D) {
                if (pickShape instanceof PickRay) {
                    blArray[n2] = ((Shape3D)nodeArray[n2]).intersect(sceneGraphPathArray[n2], (PickRay)pickShape, dArray);
                    dArray2[n2] = dArray[0];
                } else {
                    blArray[n2] = ((Shape3D)nodeArray[n2]).intersect(sceneGraphPathArray[n2], pickShape);
                    dArray2[n2] = 0.0;
                }
            } else if (nodeArray[n2] instanceof Morph) {
                if (pickShape instanceof PickRay) {
                    blArray[n2] = ((Morph)nodeArray[n2]).intersect(sceneGraphPathArray[n2], (PickRay)pickShape, dArray);
                    dArray2[n2] = dArray[0];
                } else {
                    blArray[n2] = ((Morph)nodeArray[n2]).intersect(sceneGraphPathArray[n2], pickShape);
                    dArray2[n2] = 0.0;
                }
            }
            if (blArray[n2]) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return null;
        }
        PickResult[] pickResultArray2 = new PickResult[n];
        double[] dArray3 = new double[n];
        n = 0;
        n2 = 0;
        while (n2 < sceneGraphPathArray.length) {
            if (blArray[n2]) {
                dArray3[n] = dArray2[n2];
                pickResultArray2[n++] = pickResultArray[n2];
            }
            ++n2;
        }
        if (n > 1) {
            return this.sortPickResults(pickResultArray2, dArray3);
        }
        return pickResultArray2;
    }

    private PickResult[] pickGeomAllSortedIntersect(PickShape pickShape) {
        SceneGraphPath[] sceneGraphPathArray = null;
        Object var3_3 = null;
        int n = 0;
        double[] dArray = new double[1];
        if (this.pickRootBG != null) {
            sceneGraphPathArray = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPathArray = this.pickRootL.pickAll(pickShape);
        }
        if (sceneGraphPathArray == null) {
            return null;
        }
        boolean[] blArray = new boolean[sceneGraphPathArray.length];
        double[] dArray2 = new double[sceneGraphPathArray.length];
        PickResult[] pickResultArray = new PickResult[sceneGraphPathArray.length];
        int n2 = 0;
        while (n2 < sceneGraphPathArray.length) {
            pickResultArray[n2] = new PickResult(sceneGraphPathArray[n2], pickShape);
            int n3 = pickResultArray[n2].numIntersections();
            if (n3 > 0) {
                blArray[n2] = true;
                dArray2[n2] = pickResultArray[n2].getIntersection(0).getDistance();
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return null;
        }
        PickResult[] pickResultArray2 = new PickResult[n];
        double[] dArray3 = new double[n];
        n = 0;
        n2 = 0;
        while (n2 < sceneGraphPathArray.length) {
            if (blArray[n2]) {
                dArray3[n] = dArray2[n2];
                pickResultArray2[n++] = pickResultArray[n2];
            }
            ++n2;
        }
        if (n > 1) {
            return this.sortPickResults(pickResultArray2, dArray3);
        }
        return pickResultArray2;
    }

    private PickResult pickGeomAny(PickShape pickShape) {
        Node node = null;
        SceneGraphPath[] sceneGraphPathArray = null;
        if (this.pickRootBG != null) {
            sceneGraphPathArray = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPathArray = this.pickRootL.pickAll(pickShape);
        }
        if (sceneGraphPathArray == null) {
            return null;
        }
        int n = 0;
        while (n < sceneGraphPathArray.length) {
            node = sceneGraphPathArray[n].getObject();
            PickResult pickResult = new PickResult(sceneGraphPathArray[n], pickShape);
            if (node instanceof Shape3D ? ((Shape3D)node).intersect(sceneGraphPathArray[n], pickShape) : node instanceof Morph && ((Morph)node).intersect(sceneGraphPathArray[n], pickShape)) {
                return pickResult;
            }
            ++n;
        }
        return null;
    }

    private PickResult pickGeomAnyIntersect(PickShape pickShape) {
        Object var2_2 = null;
        SceneGraphPath[] sceneGraphPathArray = null;
        if (this.pickRootBG != null) {
            sceneGraphPathArray = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sceneGraphPathArray = this.pickRootL.pickAll(pickShape);
        }
        if (sceneGraphPathArray == null) {
            return null;
        }
        int n = 0;
        while (n < sceneGraphPathArray.length) {
            PickResult pickResult = new PickResult(sceneGraphPathArray[n], pickShape);
            pickResult.setFirstIntersectOnly(true);
            if (pickResult.numIntersections() > 0) {
                return pickResult;
            }
            ++n;
        }
        return null;
    }

    private PickResult pickGeomClosest(PickShape pickShape) {
        PickResult[] pickResultArray = this.pickGeomAllSorted(pickShape);
        if (pickResultArray == null) {
            return null;
        }
        return pickResultArray[0];
    }

    private PickResult pickGeomClosestIntersect(PickShape pickShape) {
        PickResult[] pickResultArray = this.pickGeomAllSortedIntersect(pickShape);
        if (pickResultArray == null) {
            return null;
        }
        return pickResultArray[0];
    }

    private final void quicksort(int n, int n2, double[] dArray, int[] nArray) {
        int n3 = n;
        int n4 = n2;
        double d = dArray[(n + n2) / 2];
        while (true) {
            if (dArray[n3] < d) {
                ++n3;
                continue;
            }
            while (d < dArray[n4]) {
                --n4;
            }
            if (n3 <= n4) {
                double d2 = dArray[n3];
                dArray[n3] = dArray[n4];
                dArray[n4] = d2;
                int n5 = nArray[n3];
                nArray[n3] = nArray[n4];
                nArray[n4] = n5;
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            this.quicksort(n, n4, dArray, nArray);
        }
        if (n < n2) {
            this.quicksort(n3, n2, dArray, nArray);
        }
    }

    public Locale setBranchGroup(Locale locale) {
        return this.pickRootL;
    }

    private static void setCapabilities(CompressedGeometry compressedGeometry, int n) {
        switch (n) {
            case 4098: 
            case 4100: {
                compressedGeometry.setCapability(2);
            }
            case 4097: {
                compressedGeometry.setCapability(18);
                break;
            }
        }
    }

    private static void setCapabilities(GeometryArray geometryArray, int n) {
        switch (n) {
            case 4100: {
                geometryArray.setCapability(2);
                geometryArray.setCapability(4);
                geometryArray.setCapability(6);
            }
            case 4098: {
                geometryArray.setCapability(8);
                geometryArray.setCapability(17);
                geometryArray.setCapability(0);
            }
            case 4097: {
                geometryArray.setCapability(18);
                break;
            }
        }
        if (geometryArray instanceof IndexedGeometryArray) {
            PickTool.setCapabilities((IndexedGeometryArray)geometryArray, n);
        }
    }

    private static void setCapabilities(IndexedGeometryArray indexedGeometryArray, int n) {
        switch (n) {
            case 4100: {
                indexedGeometryArray.setCapability(11);
                indexedGeometryArray.setCapability(13);
                indexedGeometryArray.setCapability(15);
            }
            case 4098: {
                indexedGeometryArray.setCapability(9);
                break;
            }
        }
    }

    public static void setCapabilities(Node node, int n) {
        if (node instanceof Morph) {
            Morph morph = (Morph)node;
            switch (n) {
                case 4098: 
                case 4100: {
                    morph.setCapability(12);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Improper level");
                }
                case 4097: 
            }
            double[] dArray = morph.getWeights();
            int n2 = 0;
            while (n2 < dArray.length) {
                GeometryArray geometryArray = morph.getGeometryArray(n2);
                PickTool.setCapabilities(geometryArray, n);
                ++n2;
            }
        } else if (node instanceof Shape3D) {
            Shape3D shape3D = (Shape3D)node;
            switch (n) {
                case 4098: 
                case 4100: {
                    shape3D.setCapability(12);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Improper level");
                }
                case 4097: 
            }
            int n3 = 0;
            while (n3 < shape3D.numGeometries()) {
                Geometry geometry = shape3D.getGeometry(n3);
                if (geometry instanceof GeometryArray) {
                    PickTool.setCapabilities((GeometryArray)geometry, n);
                } else if (geometry instanceof CompressedGeometry) {
                    PickTool.setCapabilities((CompressedGeometry)geometry, n);
                }
                ++n3;
            }
        } else {
            throw new IllegalArgumentException("Improper node type");
        }
    }

    public void setMode(int n) {
        if (n != 512 && n != 256 && n != 1024) {
            throw new IllegalArgumentException();
        }
        this.mode = n;
    }

    public void setShape(PickShape pickShape, Point3d point3d) {
        this.pickShape = pickShape;
        this.start = point3d;
    }

    public void setShapeBounds(Bounds bounds, Point3d point3d) {
        this.pickShape = new PickBounds(bounds);
        this.start = point3d;
    }

    public void setShapeConeRay(Point3d point3d, Vector3d vector3d, double d) {
        this.pickShape = new PickConeRay(point3d, vector3d, d);
        this.start = point3d;
    }

    public void setShapeConeSegment(Point3d point3d, Point3d point3d2, double d) {
        this.pickShape = new PickConeSegment(point3d, point3d2, d);
        this.start = point3d;
    }

    public void setShapeCylinderRay(Point3d point3d, Vector3d vector3d, double d) {
        this.pickShape = new PickCylinderRay(point3d, vector3d, d);
        this.start = point3d;
    }

    public void setShapeCylinderSegment(Point3d point3d, Point3d point3d2, double d) {
        this.pickShape = new PickCylinderSegment(point3d, point3d2, d);
        this.start = point3d;
    }

    public void setShapeRay(Point3d point3d, Vector3d vector3d) {
        this.pickShape = new PickRay(point3d, vector3d);
        this.start = point3d;
    }

    public void setShapeSegment(Point3d point3d, Point3d point3d2) {
        this.pickShape = new PickSegment(point3d, point3d2);
        this.start = point3d;
    }

    private PickResult[] sortPickResults(PickResult[] pickResultArray, double[] dArray) {
        int[] nArray = new int[pickResultArray.length];
        PickResult[] pickResultArray2 = new PickResult[pickResultArray.length];
        int n = 0;
        while (n < pickResultArray.length) {
            nArray[n] = n;
            ++n;
        }
        this.quicksort(0, dArray.length - 1, dArray, nArray);
        int n2 = 0;
        while (n2 < pickResultArray.length) {
            pickResultArray2[n2] = pickResultArray[nArray[n2]];
            ++n2;
        }
        return pickResultArray2;
    }
}

